/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.NoResolveFileClassesProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!yQ!\u0001\u0007\u0002\u000b\u0001!1-\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u001d\u0011Y\u00012A\u0007\u0005\u0013\tI\u0011\u0001'\u0002\u0019\u0005e1\u0001bA\u0007\u0005\u0013\tI\u0011\u0001'\u0002\u0019\u0005\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/JvmOverloadFilter;", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "()V", "filterPackageMemberOverloads", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overloads"}, moduleName="kotlin-compiler")
public final class JvmOverloadFilter
implements OverloadFilter {
    public static final JvmOverloadFilter INSTANCE;
    public static final JvmOverloadFilter INSTANCE$;

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> filterPackageMemberOverloads(@NotNull Collection<? extends CallableMemberDescriptor> overloads) {
        Intrinsics.checkParameterIsNotNull(overloads, "overloads");
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>();
        HashSet<FqName> sourceClassesFQNs = new HashSet<FqName>();
        for (CallableMemberDescriptor callableMemberDescriptor : overloads) {
            KtFile file;
            if (DescriptorToSourceUtils.getContainingFile(callableMemberDescriptor) == null) {
                continue;
            }
            result2.add(callableMemberDescriptor);
            sourceClassesFQNs.add(FileClasses.getFileClassFqName(NoResolveFileClassesProvider.INSTANCE, file));
        }
        for (CallableMemberDescriptor callableMemberDescriptor : overloads) {
            Name implClassName;
            if (!(callableMemberDescriptor instanceof DeserializedCallableMemberDescriptor)) continue;
            DeclarationDescriptor containingDeclaration = ((DeserializedCallableMemberDescriptor)callableMemberDescriptor).getContainingDeclaration();
            if (!(containingDeclaration instanceof PackageFragmentDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)("Package member expected; got " + callableMemberDescriptor + " with containing declaration " + containingDeclaration)));
            }
            if (JvmFileClassUtil.getImplClassName((DeserializedCallableMemberDescriptor)callableMemberDescriptor) == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No implClassName: " + callableMemberDescriptor)));
            }
            FqName implClassFQN = ((PackageFragmentDescriptor)containingDeclaration).getFqName().child(implClassName);
            if (sourceClassesFQNs.contains(implClassFQN)) continue;
            result2.add(callableMemberDescriptor);
        }
        return result2;
    }

    private JvmOverloadFilter() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new JvmOverloadFilter();
    }
}

