/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.dataClassUtils;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!\u0019!B\u0001\t\f\u0015\u0001Q\u0012\u0003E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001d\u0001+\u0004\u00035E\u0001rA\u0007\u00021\rI2\u0001\u0003\u0003\u000e\u0003a\u0011AkA\u0001\u000e\u0012!%Q\"\u0001\r\u00063\rAY!D\u0001\u0019\u0005Q\u001b\u0011!E\u0005\u0005\u0003\"\u000b\u0001\u0002A\u0007\u00021\u0003\t6!A\u0003\u0001)\u000e\t\u0001"}, strings={"COMPONENT_FUNCTION_NAME_PREFIX", "", "DataClassUtilsKt", "createComponentName", "Lorg/jetbrains/kotlin/name/Name;", "index", "", "getComponentIndex", "componentName", "isComponentLike", "", "name"}, moduleName="kotlin-compiler")
public final class DataClassUtilsKt {
    private static final String COMPONENT_FUNCTION_NAME_PREFIX = "component";

    public static final boolean isComponentLike(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (!StringsKt.startsWith$default(name.asString(), COMPONENT_FUNCTION_NAME_PREFIX, false, 2)) {
            return false;
        }
        try {
            DataClassUtilsKt.getComponentIndex(name);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static final int getComponentIndex(@NotNull Name componentName) {
        Intrinsics.checkParameterIsNotNull(componentName, "componentName");
        return StringsKt.toInt(StringsKt.substring(componentName.asString(), CollectionsKt.length(COMPONENT_FUNCTION_NAME_PREFIX)));
    }

    @NotNull
    public static final Name createComponentName(int index2) {
        Name name = Name.identifier(COMPONENT_FUNCTION_NAME_PREFIX + index2);
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(COMPONEN\u2026TION_NAME_PREFIX + index)");
        return name;
    }

    static {
        COMPONENT_FUNCTION_NAME_PREFIX = COMPONENT_FUNCTION_NAME_PREFIX;
    }
}

