/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.lazy.types.RawSubstitution;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeTag;
import org.jetbrains.kotlin.renderer.CustomFlexibleRendering;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.types.CustomSubstitutionCapability;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeCapabilities;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0005G\u0006a\u0001!G\u0001\u0019\u0002u\tI!BQ\u0004\t\u0005\t6!\u0001\u0005\u0002KO!1\u0002c\u0001\u000e\u00051\u0005AEA\t\u0005\t\u0001A!!F\u0001\u0019\u0006e1\u0001bA\u0007\u0005\u0013\tI\u0011\u0001\n\u0002\u0019\bE\u001b\u0011\u0001\u0003\u0003"}, strings={"Lorg/jetbrains/kotlin/load/java/lazy/types/RawTypeCapabilities;", "Lorg/jetbrains/kotlin/types/TypeCapabilities;", "()V", "getCapability", "T", "Lorg/jetbrains/kotlin/types/TypeCapability;", "capabilityClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/types/TypeCapability;", "RawFlexibleRendering", "RawSubstitutionCapability"}, moduleName="kotlin-compiler")
public final class RawTypeCapabilities
implements TypeCapabilities {
    public static final RawTypeCapabilities INSTANCE;
    public static final RawTypeCapabilities INSTANCE$;

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        TypeCapability typeCapability;
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        Class<T> clazz = capabilityClass;
        if (Intrinsics.areEqual(clazz, CustomSubstitutionCapability.class)) {
            RawSubstitutionCapability rawSubstitutionCapability = RawSubstitutionCapability.INSTANCE;
            if (rawSubstitutionCapability == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawSubstitutionCapability;
        } else if (Intrinsics.areEqual(clazz, CustomFlexibleRendering.class)) {
            RawFlexibleRendering rawFlexibleRendering = RawFlexibleRendering.INSTANCE;
            if (rawFlexibleRendering == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawFlexibleRendering;
        } else if (Intrinsics.areEqual(clazz, RawTypeTag.class)) {
            RawTypeTag rawTypeTag = RawTypeTag.INSTANCE;
            if (rawTypeTag == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawTypeTag;
        } else {
            typeCapability = null;
        }
        return (T)typeCapability;
    }

    private RawTypeCapabilities() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new RawTypeCapabilities();
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\t\u0005\fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!\u000b\u0006\u0005\u0017\"A\u0019!D\u0001\u0019\u0005E\u001bA!\u0002\u0001\u000e\u0005\u0011\u0015\u0001b\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/lazy/types/RawTypeCapabilities$RawSubstitutionCapability;", "Lorg/jetbrains/kotlin/types/CustomSubstitutionCapability;", "()V", "substitution", "Lorg/jetbrains/kotlin/load/java/lazy/types/RawSubstitution;", "getSubstitution", "()Lorg/jetbrains/kotlin/load/java/lazy/types/RawSubstitution;"}, moduleName="kotlin-compiler")
    private static final class RawSubstitutionCapability
    implements CustomSubstitutionCapability {
        @NotNull
        public static final RawSubstitution substitution;
        public static final RawSubstitutionCapability INSTANCE;
        public static final RawSubstitutionCapability INSTANCE$;

        @Override
        @NotNull
        public RawSubstitution getSubstitution() {
            return substitution;
        }

        private RawSubstitutionCapability() {
            INSTANCE = this;
            INSTANCE$ = this;
            substitution = RawSubstitution.INSTANCE;
        }

        static {
            new RawSubstitutionCapability();
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t!\u0015\tA1\u0001\u0003b\u00031\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)C\u0002B\u0001\t\u00045\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u0004KM!1\u0002\u0003\u0003\u000e\u0011%\u0011\u0011\"\u0001\r\u0004\u0013\tI\u0011\u0001G\u0002\r\u0002a%\u0011d\u0001\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001TB\u0013\u000e\t-Aq!\u0004\u0002\r\u0002a\u0019\u0011d\u0001E\b\u001b\u0005A\u0002\"G\u0002\t\r5\t\u0001TBS\u000f\t\u0005A\t\"\u0004\u0003\n\u0005%\t\u0001d\u0001\r\n+\u0005Aj!'\u0003\t\u00145\t\u0001\u0004\u0003)\u0004\u0002\u0015^A!\u0001\u0005\u000b\u001b\u0005A2!F\u0001\u0019\u0007e%\u0001RC\u0007\u00021\r\u00016\u0011\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/lazy/types/RawTypeCapabilities$RawFlexibleRendering;", "Lorg/jetbrains/kotlin/renderer/CustomFlexibleRendering;", "()V", "onlyOutDiffers", "", "first", "", "second", "renderBounds", "Lkotlin/Pair;", "flexibility", "Lorg/jetbrains/kotlin/types/Flexibility;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderInflexible", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "renderArguments", "", "jetType", "replaceArgs", "newArgs"}, moduleName="kotlin-compiler")
    private static final class RawFlexibleRendering
    implements CustomFlexibleRendering {
        public static final RawFlexibleRendering INSTANCE;
        public static final RawFlexibleRendering INSTANCE$;

        /*
         * WARNING - void declaration
         */
        private final List<String> renderArguments(DescriptorRenderer $receiver, KotlinType jetType) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = jetType.getArguments();
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                void var12_9 = destination$iv$iv;
                void v0 = it;
                Intrinsics.checkExpressionValueIsNotNull(v0, "it");
                String string = $receiver.renderTypeProjection((TypeProjection)v0);
                var12_9.add(string);
            }
            return (List)destination$iv$iv;
        }

        private final String replaceArgs(String $receiver, String newArgs) {
            if (!StringsKt.contains$default((CharSequence)$receiver, '<', false, 2)) {
                return $receiver;
            }
            return StringsKt.substringBefore$default($receiver, '<', null, 2) + "<" + newArgs + ">" + StringsKt.substringAfterLast$default($receiver, '>', null, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public String renderInflexible(@NotNull KotlinType type2, @NotNull DescriptorRenderer renderer) {
            void var3_3;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            Intrinsics.checkParameterIsNotNull(renderer, "renderer");
            if (CollectionsKt.isNotEmpty((Collection)type2.getArguments())) {
                return null;
            }
            StringBuilder $receiver$iv$iv = new StringBuilder();
            StringBuilder $receiver = $receiver$iv$iv;
            TypeConstructor typeConstructor2 = type2.getConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "type.constructor");
            $receiver.append(renderer.renderTypeConstructor(typeConstructor2));
            $receiver.append("(raw)");
            if (type2.isMarkedNullable()) {
                $receiver.append('?');
            }
            return ((StringBuilder)var3_3).toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Pair<String, String> renderBounds(@NotNull Flexibility flexibility, @NotNull DescriptorRenderer renderer) {
            boolean bl;
            String newArgs;
            String upperRendered;
            String lowerRendered;
            block3: {
                void $receiver$iv;
                void destination$iv$iv;
                Iterable $receiver$iv$iv;
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull(flexibility, "flexibility");
                Intrinsics.checkParameterIsNotNull(renderer, "renderer");
                List<String> lowerArgs = this.renderArguments(renderer, flexibility.getLowerBound());
                List<String> upperArgs = this.renderArguments(renderer, flexibility.getUpperBound());
                lowerRendered = renderer.renderType(flexibility.getLowerBound());
                upperRendered = renderer.renderType(flexibility.getUpperBound());
                if (!CollectionsKt.isNotEmpty((Collection)upperArgs)) {
                    return null;
                }
                Iterable iterable = lowerArgs;
                void var9_8 = $receiver$iv2;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    void var17_13 = destination$iv$iv;
                    String string2 = "(raw) " + (String)it;
                    var17_13.add(string2);
                }
                newArgs = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, 0, null, null, 62);
                $receiver$iv$iv = CollectionsKt.zip((Iterable)lowerArgs, (Iterable)upperArgs);
                for (Object element$iv : $receiver$iv) {
                    Pair it = (Pair)element$iv;
                    if (INSTANCE.onlyOutDiffers((String)it.getFirst(), (String)it.getSecond())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            String newUpper = bl ? this.replaceArgs(upperRendered, newArgs) : upperRendered;
            return new Pair<String, String>(this.replaceArgs(lowerRendered, newArgs), newUpper);
        }

        private final boolean onlyOutDiffers(String first, String second) {
            return Intrinsics.areEqual(first, StringsKt.removePrefix(second, (CharSequence)"out ")) || Intrinsics.areEqual(second, "*");
        }

        private RawFlexibleRendering() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        static {
            new RawFlexibleRendering();
        }
    }
}

