/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;

public abstract class DiagnosticFactory<D extends Diagnostic> {
    private String name;
    private final Severity severity;

    protected DiagnosticFactory(@NotNull Severity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "<init>"));
        }
        this.name = null;
        this.severity = severity;
    }

    void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "setName"));
        }
        this.name = name;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "getName"));
        }
        return string;
    }

    @NotNull
    public Severity getSeverity() {
        Severity severity = this.severity;
        if (severity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "getSeverity"));
        }
        return severity;
    }

    @NotNull
    public D cast(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "cast"));
        }
        if (diagnostic.getFactory() != this) {
            throw new IllegalArgumentException("Factory mismatch: expected " + this + " but was " + diagnostic.getFactory());
        }
        Diagnostic diagnostic2 = diagnostic;
        if (diagnostic2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "cast"));
        }
        return (D)diagnostic2;
    }

    @NotNull
    public static <D extends Diagnostic> D cast(@NotNull Diagnostic diagnostic, DiagnosticFactory<? extends D> ... factories) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "cast"));
        }
        if (factories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factories", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "cast"));
        }
        D d = DiagnosticFactory.cast(diagnostic, Arrays.asList(factories));
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "cast"));
        }
        return d;
    }

    @NotNull
    public static <D extends Diagnostic> D cast(@NotNull Diagnostic diagnostic, @NotNull Collection<? extends DiagnosticFactory<? extends D>> factories) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "cast"));
        }
        if (factories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factories", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "cast"));
        }
        for (DiagnosticFactory<D> factory : factories) {
            if (diagnostic.getFactory() != factory) continue;
            D d = factory.cast(diagnostic);
            if (d == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticFactory", "cast"));
            }
            return d;
        }
        throw new IllegalArgumentException("Factory mismatch: expected one of " + factories + " but was " + diagnostic.getFactory());
    }

    public String toString() {
        return this.getName();
    }
}

