/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl.messages;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplSystemOutWrapperForIdeKt;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplWriter;
import org.jetbrains.kotlin.cli.jvm.repl.messages.UnescapeUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0011%)\u0001!B\u0001\t\f\u0015\tA\u0001B\u0003\u0002\u0011\u001d)\u0011\u0001B\u0001\u0006\u0003!\tA\u0002A\r\u00021\u0003\t+\"C\u0002\t\u00035\t\u0001\u0014A\u0005\u0004\u0011\u0007i\u0011\u0001\u0007\u0002R\u0007\u0005A)!\n\u0003\u0005\u0003!UQ\"\u0001\r\fK\u0011!1\u0002c\u0006\u000e\u0003a%Q\u0005\u0002\u0003\u0002\u00111i\u0011\u0001'\u0007*\u000f\u0011\tE\u0004C\u0002\u000e\u0003a\u001d\u0011kA\u0001\u0006\u0001%:A!\u0011\u000f\t\t5\t\u0001\u0014B)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B9!)Q\"\u0001M\u0006#\u000e\tQ\u0001A\u0015\u000b\t\u0005C\u0001BB\u0007\u00021\u001ba\u0012%U\u0002\u0004\u001b\t!a\u0001C\u0004*\u000f\u0011\tE\u0004c\u0004\u000e\u0003a5\u0011kA\u0001\u0006\u0001%:A!\u0011\u000f\t\u00115\t\u0001TB)\u0004\u0003\u0015\u0001\u0011f\u0004CD9!EQ\"\u0001M\u00079\r\u00013!U\u0002\b\u000b\u0001i!\u0001\"\u0005\t\u000fE\u0011A!\u0003E\nS\u001d!\u0011\t\b\u0005\u000b\u001b\u0005Aj!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0007i\u0011\u0001\u0007\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0002E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplSystemInWrapper;", "Ljava/io/InputStream;", "stdin", "replWriter", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplWriter;", "(Ljava/io/InputStream;Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplWriter;)V", "byteBuilder", "Ljava/io/ByteArrayOutputStream;", "curBytePos", "", "inputByteArray", "", "isAtBufferEnd", "", "()Z", "isLastByteProcessed", "isReadLineStartSent", "isReplScriptExecuting", "setReplScriptExecuting", "(Z)V", "isXmlIncomplete", "parseInput", "", "read", "resetBufferIfNeeded", ""}, moduleName="kotlin-compiler")
public final class ReplSystemInWrapper
extends InputStream {
    private boolean isXmlIncomplete;
    private boolean isLastByteProcessed;
    private boolean isReadLineStartSent;
    private ByteArrayOutputStream byteBuilder;
    private int curBytePos;
    private byte[] inputByteArray;
    private volatile boolean isReplScriptExecuting;
    private final InputStream stdin;
    private final ReplWriter replWriter;

    /*
     * WARNING - void declaration
     */
    private final boolean isAtBufferEnd() {
        void $receiver$iv;
        byte[] byArray = this.inputByteArray;
        int n = this.curBytePos;
        int n2 = ((void)$receiver$iv).length;
        return n == n2;
    }

    public final boolean isReplScriptExecuting() {
        return this.isReplScriptExecuting;
    }

    public final void setReplScriptExecuting(boolean bl) {
        this.isReplScriptExecuting = bl;
    }

    @Override
    public int read() {
        if (this.isLastByteProcessed) {
            if (this.isReplScriptExecuting) {
                this.isReadLineStartSent = false;
                this.replWriter.notifyReadLineEnd();
            }
            this.isLastByteProcessed = false;
            return -1;
        }
        while (this.isXmlIncomplete) {
            if (!this.isReadLineStartSent && this.isReplScriptExecuting) {
                this.replWriter.notifyReadLineStart();
                this.isReadLineStartSent = true;
            }
            this.byteBuilder.write(this.stdin.read());
            if (!StringsKt.endsWith$default((CharSequence)this.byteBuilder.toString(), '\n', false, 2)) continue;
            this.isXmlIncomplete = false;
            this.isLastByteProcessed = false;
            this.inputByteArray = StringsKt.toByteArray$default(this.parseInput(), null, 1);
        }
        byte nextByte = this.inputByteArray[this.curBytePos++];
        this.resetBufferIfNeeded();
        return nextByte;
    }

    private final String parseInput() {
        String xmlInput;
        String string = xmlInput = this.byteBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "xmlInput");
        String unescapedXml = UnescapeUtilsKt.parseXml(string);
        String resultLine = this.isReplScriptExecuting ? UnescapeUtilsKt.unescapeLineBreaks(unescapedXml) : unescapedXml;
        return resultLine + ReplSystemOutWrapperForIdeKt.getEND_LINE();
    }

    private final void resetBufferIfNeeded() {
        if (this.isAtBufferEnd()) {
            this.isXmlIncomplete = true;
            this.byteBuilder = new ByteArrayOutputStream();
            this.curBytePos = 0;
            this.isLastByteProcessed = true;
        }
    }

    public ReplSystemInWrapper(@NotNull InputStream stdin2, @NotNull ReplWriter replWriter) {
        Intrinsics.checkParameterIsNotNull(stdin2, "stdin");
        Intrinsics.checkParameterIsNotNull(replWriter, "replWriter");
        this.stdin = stdin2;
        this.replWriter = replWriter;
        this.isXmlIncomplete = true;
        this.byteBuilder = new ByteArrayOutputStream();
        this.inputByteArray = new byte[0];
    }
}

