/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.common.modules.ModuleXmlParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.PathUtil;

public class CompileEnvironmentUtil {
    @NotNull
    public static ModuleScriptData loadModuleDescriptions(String moduleDefinitionFile, MessageCollector messageCollector) {
        File file = new File(moduleDefinitionFile);
        if (!file.exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Module definition file does not exist: " + moduleDefinitionFile, CompilerMessageLocation.NO_LOCATION);
            ModuleScriptData moduleScriptData = ModuleScriptData.EMPTY;
            if (moduleScriptData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleDescriptions"));
            }
            return moduleScriptData;
        }
        String extension = FileUtilRt.getExtension(moduleDefinitionFile);
        if ("xml".equalsIgnoreCase(extension)) {
            ModuleScriptData moduleScriptData = ModuleXmlParser.parseModuleScript(moduleDefinitionFile, messageCollector);
            if (moduleScriptData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleDescriptions"));
            }
            return moduleScriptData;
        }
        messageCollector.report(CompilerMessageSeverity.ERROR, "Unknown module definition type: " + moduleDefinitionFile, CompilerMessageLocation.NO_LOCATION);
        ModuleScriptData moduleScriptData = ModuleScriptData.EMPTY;
        if (moduleScriptData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleDescriptions"));
        }
        return moduleScriptData;
    }

    private static void doWriteToJar(ClassFileFactory outputFiles, OutputStream fos, @Nullable FqName mainClass, boolean includeRuntime) {
        try {
            Manifest manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass.asString());
            }
            JarOutputStream stream = new JarOutputStream(fos, manifest);
            for (OutputFile outputFile : outputFiles.asList()) {
                stream.putNextEntry(new JarEntry(outputFile.getRelativePath()));
                stream.write(outputFile.asByteArray());
            }
            if (includeRuntime) {
                CompileEnvironmentUtil.writeRuntimeToJar(stream);
            }
            stream.finish();
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToJar(File jarPath, boolean jarRuntime, FqName mainClass, ClassFileFactory outputFiles) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(jarPath);
            CompileEnvironmentUtil.doWriteToJar(outputFiles, outputStream, mainClass, jarRuntime);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new CompileEnvironmentException("Invalid jar path " + jarPath, e);
                catch (IOException e2) {
                    throw ExceptionUtilsKt.rethrow(e2);
                }
            }
            catch (Throwable throwable) {
                ExceptionUtilsKt.closeQuietly(outputStream);
                throw throwable;
            }
        }
        ExceptionUtilsKt.closeQuietly(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRuntimeToJar(JarOutputStream stream) throws IOException {
        File runtimePath = PathUtil.getKotlinPathsForCompiler().getRuntimePath();
        if (!runtimePath.exists()) {
            throw new CompileEnvironmentException("Couldn't find runtime library");
        }
        JarInputStream jis = new JarInputStream(new FileInputStream(runtimePath));
        try {
            JarEntry e;
            while ((e = jis.getNextJarEntry()) != null) {
                if (!FileUtilRt.extensionEquals(e.getName(), "class")) continue;
                stream.putNextEntry(e);
                FileUtil.copy(jis, stream);
            }
        }
        finally {
            jis.close();
        }
    }

    @NotNull
    public static List<KtFile> getKtFiles(final @NotNull Project project, @NotNull Collection<String> sourceRoots, @NotNull Function1<String, Unit> reportError2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "getKtFiles"));
        }
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "getKtFiles"));
        }
        if (reportError2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportError", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "getKtFiles"));
        }
        final VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        final HashSet processedFiles = Sets.newHashSet();
        final ArrayList<KtFile> result2 = Lists.newArrayList();
        for (String sourceRootPath : sourceRoots) {
            if (sourceRootPath == null) continue;
            VirtualFile vFile = localFileSystem.findFileByPath(sourceRootPath);
            if (vFile == null) {
                reportError2.invoke("Source file or directory not found: " + sourceRootPath);
                continue;
            }
            if (!vFile.isDirectory() && vFile.getFileType() != KotlinFileType.INSTANCE) {
                reportError2.invoke("Source entry is not a Kotlin file: " + sourceRootPath);
                continue;
            }
            FilesKt.recurse(new File(sourceRootPath), (Function1<? super File, Unit>)new Function1<File, Unit>(){

                @Override
                public Unit invoke(File file) {
                    VirtualFile virtualFile;
                    if (file.isFile() && (virtualFile = localFileSystem.findFileByPath(file.getAbsolutePath())) != null && !processedFiles.contains(virtualFile)) {
                        processedFiles.add(virtualFile);
                        PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
                        if (psiFile instanceof KtFile) {
                            result2.add((KtFile)psiFile);
                        }
                    }
                    return Unit.INSTANCE$;
                }
            });
        }
        ArrayList<KtFile> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "getKtFiles"));
        }
        return arrayList;
    }
}

