/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UA)\u0004\u0003!\tQ\u0005\u0006\u0003\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0003\u000e\u0003a1Qe\u0004\u0003\u0002\u0011\u001bi\u0011\u0001\u0007\u0002\u001a\r!9Q\u0002B\u0005\u0003\u0013\u0005A\u0002\u0002g\u0004\u001a\u0007!%Q\"\u0001\r\u0006"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ReifiedTypeParameterAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkTypeParameterDescriptorsAreNotReified", "typeParameterDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;"}, moduleName="kotlin-compiler")
public final class ReifiedTypeParameterAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        if (descriptor2 instanceof CallableDescriptor && !InlineUtil.isInline(descriptor2)) {
            List<TypeParameterDescriptor> list = ((CallableDescriptor)descriptor2).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "descriptor.getTypeParameters()");
            this.checkTypeParameterDescriptorsAreNotReified(list, diagnosticHolder);
        }
        if (descriptor2 instanceof ClassDescriptor) {
            List<TypeParameterDescriptor> list = ((ClassDescriptor)descriptor2).getDeclaredTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "descriptor.declaredTypeParameters");
            this.checkTypeParameterDescriptorsAreNotReified(list, diagnosticHolder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParameterDescriptorsAreNotReified(List<? extends TypeParameterDescriptor> typeParameterDescriptors2, DiagnosticSink diagnosticHolder) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = typeParameterDescriptors2;
        void var6_4 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            if (!it.isReified()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (TypeParameterDescriptor reifiedTypeParameterDescriptor : (List)destination$iv$iv) {
            PsiElement typeParameterDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(reifiedTypeParameterDescriptor);
            if (!(typeParameterDeclaration instanceof KtTypeParameter)) {
                throw (Throwable)((Object)new AssertionError((Object)"JetTypeParameter expected"));
            }
            KtModifierList ktModifierList = ((KtTypeParameter)typeParameterDeclaration).getModifierList();
            if (ktModifierList == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement2 = ktModifierList.getModifier(KtTokens.REIFIED_KEYWORD);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            diagnosticHolder.report(Errors.REIFIED_TYPE_PARAMETER_NO_INLINE.on(psiElement2));
        }
    }
}

