/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.callableReferences.CallableReferencesResolutionUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CandidateResolveMode;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.SubstitutionFilteringInternalResolveAnnotations;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.FunctionPlaceholdersKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"U\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\b\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tAqA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!Q\u0001\u0004\u0001\u001a\u0003a\u0005Q\u0014\u0001\u0017\"4%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011b\u0001\u0005\u0004\u001b\u0005A:!\u0003\u0004\t\t5!\u0011BA\u0005\u00021\u0015AJ!C\u0002\t\f5\t\u0001DB)\u0004\u0003!5Q%\u0006E\n\u001b\rA\"\"K\u0001\u0019\u0001E!A\u0001\u0001E\u000b+\u0005Az!\u0007\u0004\t\u00175!\u0011BA\u0005\u0002I+A\u0002\"G\u0002\t\u00185\t\u0001\u0004D\u0013\u001f\t\u0005AI\"D\u0001\u0019\u001be1\u00012D\u0007\u0005\u0013\tI\u0011\u0001'\b\u0019\u001de1\u0001bD\u0007\u0005\u0013\tI\u0011\u0001g\b\u0019\u001de\u0019\u0001\u0002E\u0007\u00021\u001fI2\u0001#\t\u000e\u0003a\t\u0012d\u0001E\u0012\u001b\u0005A\"#\n\u0006\u0005\u0003!\u0015R\"\u0001\r\u00143\u0015A1\"D\u0002\n\u0003\u0011\r\u0001\u0004C\u0013\u0011\t\u0005A9#D\u0001\u0019)E!A\u0001\u0001E\u000b+\u0005Az!\u0007\u0004\t\u00175!\u0011BA\u0005\u0002I+A\u0002\"J\u0013\u0005\u0003!%Rb\u0001\r\u000bS\u0005A\u0002!\u0005\u0003\u0005\u0001!UQ#\u0001M\b#\u001d!\t\u0001C\u000b\u0016\t%\u0011\u0011\"\u0001\u0013\u00161WIb\u0001C\u0006\u000e\t%\u0011\u0011\"\u0001\u0013\u00161WIb\u0001\u0003\f\u000e\t%\u0011\u0011\"\u0001S\u000b1[I2\u0001c\u0006\u000e\u0003aaQ%\u0003\u0003\u0002\u0011]i!\u0001$\u0001\u00190e\u0019\u0001\u0002G\u0007\u00021\u001f)#\u0002B\u0001\t25\u0011A\u0012\u0001\r\u001a3\u0011A\u0019$\u0004\u0002\r\u0002aQR\u0005\u0007E\u001b\u001b\u0005AR\"\u0005\u0003\u0005\u0001!UQ#\u0001M\b#\u0011!\t\u0001C\u000e\u0016\u0003\u0011V\u0011D\u0002\u0005\f\u001b\u0011I!!C\u0001%\u0016aA\u0011d\u0001E\u001c\u001b\u0005AB$J\f\u0005\u0003!eRB\u0001G\u00011?I2\u0001C\u000f\u000e\u0003am\u0012d\u0001\u0005\u001f\u001b\u0005Az\"G\u0002\t>5\t\u0001tD\r\u0006\u0011-i1!C\u0001\u0005\u0004ayRu\b\u0003B!!}R\"\u0001\r\u000e#\u0011!\u0001\u0001#\u0006\u0016\u0003a=Q\u0003B\u0005\u0003\u0013\u0005!+\u0002\u0007\u0005\u001a!!\u0001S\u0012D\u0005\u0006\u0013\u0011I!!C\u0001%\u0016aA\u0011BA\u0005\u000215A\n%U\u0002\u0002\t\u0005\u00026\u0011A\u0013\t\t\u0005A\u0019%D\u0001\u0019\u001bU\u0019\u0011\"\u0001C\u00021!){\u0004B!\u0011\u0011\tj\u0011\u0001G\u0007\u0012\t\u0011\u0001\u0001RC\u000b\u00021\u001f)B!\u0003\u0002\n\u0003\u0011V\u0001\u0004C\r\u0011\u0011\u0001jI\"C\u0003\n\t%\u0011\u0011\"\u0001S\u000b1!I!!C\u0001\u0019)a\u0005\u0013kA\u0001\u0005CA\u001b\t!\n\u0005\u0005\u0003!\u0015S\"\u0001\r\u000e+\rI\u0011\u0001b\u0001\u0019\u0011\u0015\u001aB!\u0001\u0005$\u001b\u0005AR\"\u0005\u0003\u0005\u0001!UQ#\u0001M\b#\u0011!\t\u0001C\u000e\u0016\u0003\u0011VQ\u0003B\u0005\u0003\u0013\u0005!+\u0002\u0007\u0005&\u0011\u0011\t\u0001rI\u0007\u000215)2!C\u0001\u0005\u0004aAQ\u0005\u0003\u0003\u0002\u0011\u0011j\u0011\u0001G\u0007\u0016\u0007%\tA1\u0001\r\tK;\"\u0011\u0001#\u0013\u000e\u0003a!\u0012\u0003\u0002\u0003\u0001\u0011+)\u0012\u0001g\u0004\u0016\t%\u0011\u0011\"\u0001S\u000b1!Iz\u0001\u0003\f\u000e\t%\u0011\u0011\"\u0001S\u000b1\u0015\u00026\u0011AM\u0006\u0011\u0017j!\u0001$\u0001\u0019MA\u001b\u0011!g\u0003\tN5\u0011A\u0012\u0001\r(!\u000e\r\u0011\u0014\u0002E(\u001b\u0005A2\u0003U\u0002\u00033\u0013A\u0001&D\u0001\u0019'A\u001b)!\n\u0005\u0005\u0003!ES\"\u0001\r\u000e+\rI\u0011\u0001b\u0001\u0019\u0011\u0015*B!\u0001E)\u001b\u0005AR\"F\u0002\n\u0003\u0011\r\u0001\u0004CM\u0006\u0011%j!\u0001$\u0001\u0019MA\u001b\t!g\u0003\tN5\u0011A\u0012\u0001\r(!\u000e\tQ\u0005\u0003\u0003\u0002\u0011'j\u0011\u0001G\u0007\u0016\u0007%\tA1\u0001\r\tK!!\u0011\u0001\u0003\u0016\u000e\u0003aiQcA\u0005\u0002\t\u0007A\u0002\"J\n\u0005\u0003!US\"\u0001\r\u000e#\u0011!\u0001\u0001#\u0006\u0016\u0003a=\u0011\u0003\u0002C\u0001\u0011m)\u0012\u0001*\u0006\u0016\t%\u0011\u0011\"\u0001S\u000b1!)\u0003\u0002B\u0001\tW5\t\u0001$D\u000b\u0004\u0013\u0005!\u0019\u0001\u0007\u0005&\u001d\u0011\t\u0001rK\u0007\u00021M\tB\u0001\u0002\u0001\t\u0016U\t\u0001tB\u000b\u0005\u0013\tI\u0011\u0001*\u0006\u0019\u0011%RA!\u0011\u0005\t\t5!\u0011BA\u0005\u00021\u0015AJ!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A!!D\u0001\u0019\u0006E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002C\u0002\u000e\u0003a\u001d\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\f5\t\u0001DB)\u0004\u0003\u0015\u0001\u0011F\u0004\u0003B\u0011!9Q\"\u0001M\b+\rI\u0011\u0001b\u0001\u0019\u0011q\t\u0013kA\u0002\u000e\u0005\u0011E\u0001\"\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "genericCandidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;", "reflectionTypes", "Lorg/jetbrains/kotlin/builtins/ReflectionTypes;", "additionalTypeCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "smartCastManager", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;Lorg/jetbrains/kotlin/builtins/ReflectionTypes;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;)V", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "getCandidateDescriptor", "(Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkAllValueArguments", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult;", "D", "context", "resolveFunctionArgumentBodies", "Lorg/jetbrains/kotlin/resolve/calls/callResolverUtil/ResolveArgumentsMode;", "checkGenericBoundsInAFunctionCall", "", "jetTypeArguments", "", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "typeArguments", "Lorg/jetbrains/kotlin/types/KotlinType;", "functionDescriptor", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkOuterClassMemberIsAccessible", "", "checkReceivers", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "checkValueArgumentTypes", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "candidateCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "getDeclaringClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "candidate", "getReceiverSuper", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "performResolutionForCandidateCall", "F", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "smartCastValueArgumentTypeIfPossible", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedType", "actualType", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "check", "checker", "Lkotlin/Function1;", "Lkotlin/Extension;", "checkAbstractAndSuper", "checkAndReport", "checkDispatchReceiver", "checkExpectedCallableType", "checkExtensionReceiver", "checkNonExtensionCalledWithReceiver", "checkReceiver", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "isExplicitReceiver", "implicitInvokeCheck", "checkReceiverTypeError", "receiverParameterDescriptor", "checkValueArguments", "checkVisibility", "mapArguments", "processTypeArguments", "shouldContinue", "ValueArgumentsCheckingResult"}, moduleName="kotlin-compiler")
public final class CandidateResolver {
    private final ArgumentTypeResolver argumentTypeResolver;
    private final GenericCandidateResolver genericCandidateResolver;
    private final ReflectionTypes reflectionTypes;
    private final Iterable<AdditionalTypeChecker> additionalTypeCheckers;
    private final SmartCastManager smartCastManager;

    public final <D extends CallableDescriptor, F extends D> void performResolutionForCandidateCall(@NotNull CallCandidateResolutionContext<D> context, @NotNull CheckArgumentTypesMode checkArguments) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)checkArguments, "checkArguments");
        CallCandidateResolutionContext<D> $receiver = context;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (ErrorUtils.isError(this.getCandidateDescriptor($receiver))) {
            $receiver.candidateCall.addStatus(ResolutionStatus.SUCCESS);
            return;
        }
        if (!this.checkOuterClassMemberIsAccessible($receiver)) {
            $receiver.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            return;
        }
        this.checkVisibility($receiver);
        switch (CandidateResolver$WhenMappings.$EnumSwitchMapping$0[checkArguments.ordinal()]) {
            case 1: {
                this.mapArguments($receiver);
                break;
            }
            case 2: {
                this.checkExpectedCallableType($receiver);
            }
        }
        this.checkReceiverTypeError($receiver);
        this.checkExtensionReceiver($receiver);
        this.checkDispatchReceiver($receiver);
        this.processTypeArguments($receiver);
        this.checkValueArguments($receiver);
        this.checkAbstractAndSuper($receiver);
        this.checkNonExtensionCalledWithReceiver($receiver);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkValueArguments(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            void $receiver2;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ResolutionStatus resolutionStatus = $receiver2.call.getTypeArguments().isEmpty() && !this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver2).getTypeParameters().isEmpty() && $receiver2.candidateCall.getKnownTypeParametersSubstitutor() == null ? this.genericCandidateResolver.inferTypeArguments($receiver2) : this.checkAllValueArguments((CallCandidateResolutionContext)$receiver2, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS).getStatus();
            mutableResolvedCall.addStatus(resolutionStatus);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processTypeArguments(CallCandidateResolutionContext<?> $receiver) {
        block11: {
            CallCandidateResolutionContext $receiver2;
            block12: {
                TypeSubstitution substitution;
                int $i$f$size;
                void $receiver$iv22;
                Collection $receiver$iv;
                void $receiver$iv3;
                CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
                CandidateResolver this_$iv = this;
                if (!this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv3)) break block11;
                $receiver2 = (CallCandidateResolutionContext)$receiver$iv3;
                List<KtTypeProjection> jetTypeArguments = $receiver2.call.getTypeArguments();
                if (jetTypeArguments.isEmpty()) break block12;
                ArrayList<Object> typeArguments = new ArrayList<Object>();
                for (KtTypeProjection projection : jetTypeArguments) {
                    Object object;
                    block14: {
                        block13: {
                            object = projection.getTypeReference();
                            if (object == null) break block13;
                            KtTypeReference ktTypeReference = object;
                            KtTypeReference it = (KtTypeReference)((Object)$receiver$iv);
                            object = (KotlinType)$receiver2.trace.getBindingContext().get(BindingContext.TYPE, it);
                            if (object != null) break block14;
                        }
                        object = ErrorUtils.createErrorType("Star projection in a call");
                    }
                    Object type2 = object;
                    typeArguments.add(type2);
                }
                Collection collection = this.getCandidateDescriptor($receiver2).getTypeParameters();
                int expectedTypeArgumentCount = $receiver$iv22.size();
                $receiver$iv = jetTypeArguments;
                int $receiver$iv22 = $receiver$iv.size();
                if ($receiver$iv22 <= ($i$f$size = expectedTypeArgumentCount - 1)) {
                    while (true) {
                        void index2;
                        typeArguments.add(ErrorUtils.createErrorType("Explicit type argument expected for " + this.getCandidateDescriptor($receiver2).getTypeParameters().get((int)index2).getName()));
                        if (index2 == $i$f$size) break;
                        ++index2;
                    }
                }
                CallableDescriptor callableDescriptor = this.getCandidateDescriptor($receiver2);
                if (callableDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                }
                TypeSubstitution typeSubstitution = substitution = FunctionDescriptorUtil.createSubstitution((FunctionDescriptor)callableDescriptor, (List<KotlinType>)typeArguments);
                Intrinsics.checkExpressionValueIsNotNull(typeSubstitution, "substitution");
                TypeSubstitutor substitutor2 = TypeSubstitutor.create(new SubstitutionFilteringInternalResolveAnnotations(typeSubstitution));
                $receiver$iv = jetTypeArguments;
                int n = expectedTypeArgumentCount;
                int n2 = $receiver$iv.size();
                if (n != n2) {
                    $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                    $receiver2.tracing.wrongNumberOfTypeArguments($receiver2.trace, expectedTypeArgumentCount);
                } else {
                    List<KtTypeProjection> list = jetTypeArguments;
                    Intrinsics.checkExpressionValueIsNotNull(list, "jetTypeArguments");
                    List list2 = typeArguments;
                    CallableDescriptor callableDescriptor2 = this.getCandidateDescriptor($receiver2);
                    TypeSubstitutor typeSubstitutor2 = substitutor2;
                    Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor2, "substitutor");
                    BindingTrace bindingTrace = $receiver2.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
                    this.checkGenericBoundsInAFunctionCall(list, list2, callableDescriptor2, typeSubstitutor2, bindingTrace);
                }
                $receiver2.candidateCall.setResultingSubstitutor(substitutor2);
                break block11;
            }
            if ($receiver2.candidateCall.getKnownTypeParametersSubstitutor() != null) {
                MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
                TypeSubstitutor typeSubstitutor3 = $receiver2.candidateCall.getKnownTypeParametersSubstitutor();
                if (typeSubstitutor3 == null) {
                    Intrinsics.throwNpe();
                }
                mutableResolvedCall.setResultingSubstitutor(typeSubstitutor3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor, F extends D> void mapArguments(CallCandidateResolutionContext<D> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            CallCandidateResolutionContext $receiver2 = (CallCandidateResolutionContext)$receiver$iv;
            ValueArgumentsToParametersMapper.Status argumentMappingStatus = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters($receiver2.call, $receiver2.tracing, $receiver2.candidateCall, Sets.newLinkedHashSet());
            if (!argumentMappingStatus.isSuccess()) {
                $receiver2.candidateCall.addStatus(ResolutionStatus.ARGUMENTS_MAPPING_ERROR);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor, F extends D> void checkExpectedCallableType(CallCandidateResolutionContext<D> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            CallCandidateResolutionContext $receiver2 = (CallCandidateResolutionContext)$receiver$iv;
            if (!TypeUtils.noExpectedType($receiver2.expectedType)) {
                Object candidate;
                Object d = candidate = $receiver2.candidateCall.getCandidateDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(d, "candidate");
                KotlinType candidateReflectionType = CallableReferencesResolutionUtilsKt.getReflectionTypeForCandidateDescriptor(d, this.reflectionTypes);
                if (candidateReflectionType != null) {
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(candidateReflectionType, $receiver2.expectedType)) {
                        $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                    }
                } else {
                    $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            ResolutionStatus resolutionStatus;
            void $receiver2;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember($receiver2.candidateCall.getDispatchReceiver(), this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver2), $receiver2.scope.getOwnerDescriptor());
            if (invisibleMember != null) {
                $receiver2.tracing.invisibleMember($receiver2.trace, invisibleMember);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExtensionReceiver(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            ResolutionStatus resolutionStatus;
            void $receiver2;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ReceiverParameterDescriptor receiverParameter = $receiver2.candidateCall.getCandidateDescriptor().getExtensionReceiverParameter();
            Receiver receiverArgument = $receiver2.candidateCall.getExtensionReceiver();
            if (receiverParameter != null && receiverArgument == null) {
                $receiver2.tracing.missingReceiver($receiver2.candidateCall.getTrace(), receiverParameter);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else if (receiverParameter == null && receiverArgument != null) {
                $receiver2.tracing.noReceiverAllowed($receiver2.candidateCall.getTrace());
                resolutionStatus = $receiver2.call.getCalleeExpression() instanceof KtSimpleNameExpression ? ResolutionStatus.RECEIVER_PRESENCE_ERROR : ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDispatchReceiver(CallCandidateResolutionContext<?> $receiver) {
        block8: {
            var3_2 = $receiver;
            this_$iv = this;
            if (!CandidateResolver.access$shouldContinue(this_$iv, (CallCandidateResolutionContext)$receiver$iv)) break block8;
            var4_4 = (CallCandidateResolutionContext)$receiver$iv;
            var13_5 = $receiver$iv.candidateCall;
            candidateDescriptor = this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver);
            dispatchReceiver = $receiver.candidateCall.getDispatchReceiver();
            if (dispatchReceiver == null) ** GOTO lbl-1000
            nestedClass = null;
            if (candidateDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isStaticNestedClass(((ConstructorDescriptor)candidateDescriptor).getContainingDeclaration())) {
                nestedClass = ((ConstructorDescriptor)candidateDescriptor).getContainingDeclaration();
            } else if (candidateDescriptor instanceof FakeCallableDescriptorForObject) {
                nestedClass = ((FakeCallableDescriptorForObject)candidateDescriptor).getReferencedDescriptor();
            }
            if (nestedClass != null) {
                $receiver.tracing.nestedClassAccessViaInstanceReference($receiver.trace, nestedClass, $receiver.candidateCall.getExplicitReceiverKind());
                v0 = ResolutionStatus.OTHER_ERROR;
            } else lbl-1000:
            // 2 sources

            {
                nestedClass = dispatchReceiver != null == ($receiver.candidateCall.getResultingDescriptor().getDispatchReceiverParameter() != null);
                if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                    if (value$iv == false) {
                        message$iv = "Shouldn't happen because of TaskPrioritizer: " + candidateDescriptor;
                        throw (Throwable)new AssertionError((Object)message$iv);
                    }
                    v1 = Unit.INSTANCE;
                } else {
                    v1 = Unit.INSTANCE;
                }
                v0 = ResolutionStatus.SUCCESS;
            }
            var14_11 = v0;
            var13_5.addStatus(var14_11);
        }
    }

    private final boolean checkOuterClassMemberIsAccessible(CallCandidateResolutionContext<?> context) {
        if (context.call.getExplicitReceiver() != null || context.call.getDispatchReceiver() != null) {
            return true;
        }
        Object d = context.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "context.candidateCall.getCandidateDescriptor()");
        ClassDescriptor candidateThis = this.getDeclaringClass((CallableDescriptor)d);
        if (candidateThis == null || candidateThis.getKind().isSingleton()) {
            return true;
        }
        return DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, context.call.getCallElement(), candidateThis);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAbstractAndSuper(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            KtSuperExpression superExtensionReceiver;
            KtSuperExpression superDispatchReceiver;
            Modality modality;
            CallCandidateResolutionContext $receiver2 = (CallCandidateResolutionContext)$receiver$iv;
            CallableDescriptor descriptor2 = this.getCandidateDescriptor($receiver2);
            KtExpression expression = $receiver2.candidateCall.getCall().getCalleeExpression();
            if (expression instanceof KtSimpleNameExpression && descriptor2 instanceof ConstructorDescriptor && Intrinsics.areEqual((Object)(modality = ((ConstructorDescriptor)descriptor2).getContainingDeclaration().getModality()), (Object)Modality.ABSTRACT)) {
                $receiver2.tracing.instantiationOfAbstractClass($receiver2.trace);
            }
            if ((superDispatchReceiver = this.getReceiverSuper($receiver2.candidateCall.getDispatchReceiver())) != null && descriptor2 instanceof MemberDescriptor && Intrinsics.areEqual((Object)((MemberDescriptor)((Object)descriptor2)).getModality(), (Object)Modality.ABSTRACT)) {
                $receiver2.tracing.abstractSuperCall($receiver2.trace);
                $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
            if ((superExtensionReceiver = this.getReceiverSuper($receiver2.candidateCall.getExtensionReceiver())) != null) {
                $receiver2.trace.report(Errors.SUPER_CANT_BE_EXTENSION_RECEIVER.on((KtSuperExpression)((PsiElement)superExtensionReceiver), superExtensionReceiver.getText()));
                $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkNonExtensionCalledWithReceiver(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            ResolutionStatus resolutionStatus;
            void $receiver2;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            Call call = $receiver2.candidateCall.getCall();
            if (call instanceof CallTransformer.CallForImplicitInvoke && $receiver2.candidateCall.getExtensionReceiver() != null && $receiver2.candidateCall.getDispatchReceiver() != null && Intrinsics.areEqual(((CallTransformer.CallForImplicitInvoke)call).getDispatchReceiver(), $receiver2.candidateCall.getDispatchReceiver()) && !KotlinBuiltIns.isExactExtensionFunctionType(((CallTransformer.CallForImplicitInvoke)call).getDispatchReceiver().getType())) {
                $receiver2.tracing.nonExtensionFunctionCalledAsExtension($receiver2.trace);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    private final KtSuperExpression getReceiverSuper(Receiver receiver) {
        KtExpression expression;
        if (receiver instanceof ExpressionReceiver && (expression = ((ExpressionReceiver)receiver).getExpression()) instanceof KtSuperExpression) {
            return (KtSuperExpression)expression;
        }
        return null;
    }

    private final ClassDescriptor getDeclaringClass(CallableDescriptor candidate) {
        ReceiverParameterDescriptor receiverParameterDescriptor = candidate.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor expectedThis = receiverParameterDescriptor;
        DeclarationDescriptor descriptor2 = expectedThis.getContainingDeclaration();
        return descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : (ClassDescriptor)null;
    }

    @NotNull
    public final <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolveArgumentsMode resolveFunctionArgumentBodies) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)resolveFunctionArgumentBodies, "resolveFunctionArgumentBodies");
        CallResolutionContext callResolutionContext = context;
        MutableResolvedCall mutableResolvedCall = context.candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(mutableResolvedCall, "context.candidateCall");
        ValueArgumentsCheckingResult checkingResult = this.checkValueArgumentTypes(callResolutionContext, mutableResolvedCall, resolveFunctionArgumentBodies);
        ResolutionStatus resultStatus = checkingResult.getStatus();
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceivers(context));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(checkReceivers(context))");
        resultStatus = resolutionStatus;
        return new ValueArgumentsCheckingResult(resultStatus, checkingResult.getArgumentTypes());
    }

    private final <D extends CallableDescriptor, C extends CallResolutionContext<C>> ValueArgumentsCheckingResult checkValueArgumentTypes(CallResolutionContext<C> context, MutableResolvedCall<D> candidateCall, ResolveArgumentsMode resolveFunctionArgumentBodies) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ArrayList<KotlinType> argumentTypes = Lists.newArrayList();
        MutableDataFlowInfoForArguments infoForArguments = candidateCall.getDataFlowInfoForArguments();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : CollectionsKt.mutableEntrySet(candidateCall.getValueArguments())) {
            ValueParameterDescriptor parameterDescriptor = CollectionsKt.getKey(entry);
            ResolvedValueArgument resolvedArgument = CollectionsKt.getValue(entry);
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                KtExpression expression;
                if (argument.getArgumentExpression() == null) {
                    continue;
                }
                ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameterDescriptor");
                ValueArgument valueArgument = argument;
                Intrinsics.checkExpressionValueIsNotNull(valueArgument, "argument");
                KotlinType expectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
                CallResolutionContext newContext = (CallResolutionContext)((CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(argument))).replaceExpectedType(expectedType);
                KotlinTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(expression, newContext, resolveFunctionArgumentBodies);
                KotlinType type2 = typeInfoForCall.getType();
                infoForArguments.updateInfo(argument, typeInfoForCall.getDataFlowInfo());
                ArgumentMatchStatus matchStatus = ArgumentMatchStatus.SUCCESS;
                KotlinType resultingType = type2;
                if (type2 == null || type2.isError() && !FunctionPlaceholdersKt.isFunctionPlaceholder(type2)) {
                    matchStatus = ArgumentMatchStatus.ARGUMENT_HAS_NO_TYPE;
                } else if (!TypeUtils.noExpectedType(expectedType)) {
                    DataFlowValue dataFlowValue;
                    SmartCastResult smartCastResult;
                    if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(type2, expectedType)) {
                        KotlinType kotlinType = newContext.expectedType;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "newContext.expectedType");
                        ResolutionContext resolutionContext = newContext;
                        Intrinsics.checkExpressionValueIsNotNull(resolutionContext, "newContext");
                        KotlinType smartCast = this.smartCastValueArgumentTypeIfPossible(expression, kotlinType, type2, resolutionContext);
                        if (smartCast == null) {
                            resultStatus = ResolutionStatus.OTHER_ERROR;
                            matchStatus = ArgumentMatchStatus.TYPE_MISMATCH;
                        } else {
                            resultingType = smartCast;
                        }
                    } else if (ErrorUtils.containsUninferredParameter(expectedType)) {
                        matchStatus = ArgumentMatchStatus.MATCH_MODULO_UNINFERRED_TYPES;
                    }
                    LeafPsiElement spreadElement = argument.getSpreadElement();
                    if (!(spreadElement == null || FlexibleTypesKt.isFlexible(type2) || !type2.isMarkedNullable() || (smartCastResult = SmartCastManager.checkAndRecordPossibleCast(dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, context), expectedType, expression, context, null, false)) != null && smartCastResult.isCorrect())) {
                        context.trace.report(Errors.SPREAD_OF_NULLABLE.on((LeafPsiElement)((PsiElement)spreadElement)));
                    }
                }
                argumentTypes.add(resultingType);
                candidateCall.recordArgumentMatchStatus(argument, matchStatus);
            }
        }
        List list = argumentTypes;
        Intrinsics.checkExpressionValueIsNotNull(list, "argumentTypes");
        return new ValueArgumentsCheckingResult(resultStatus, list);
    }

    private final KotlinType smartCastValueArgumentTypeIfPossible(KtExpression expression, KotlinType expectedType, KotlinType actualType, ResolutionContext<?> context) {
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize(expression);
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "KtPsiUtil.safeDeparenthesize(expression)");
        BindingContext bindingContext2 = context.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "context.trace.bindingContext");
        ExpressionReceiver receiverToCast = ExpressionReceiver.Companion.create(ktExpression, actualType, bindingContext2);
        Collection<KotlinType> variants = this.smartCastManager.getSmartCastVariantsExcludingReceiver(context, receiverToCast);
        for (KotlinType possibleType : variants) {
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleType, expectedType)) continue;
            return possibleType;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReceiverTypeError(CallCandidateResolutionContext<?> $receiver) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            CallCandidateResolutionContext $receiver2 = (CallCandidateResolutionContext)$receiver$iv;
            ReceiverParameterDescriptor extensionReceiver2 = this.getCandidateDescriptor($receiver2).getExtensionReceiverParameter();
            ReceiverParameterDescriptor dispatchReceiver = this.getCandidateDescriptor($receiver2).getDispatchReceiverParameter();
            Call call = $receiver2.call;
            Intrinsics.checkExpressionValueIsNotNull(call, "call");
            if (!CallResolverUtilKt.isInvokeCallOnExpressionWithBothReceivers(call)) {
                Unit unit;
                Receiver callExtensionReceiver;
                Receiver receiver = callExtensionReceiver = $receiver2.candidateCall.getExtensionReceiver();
                boolean bl = receiver != null ? receiver instanceof ReceiverValue : true;
                if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv = "Expected ReceiverValue, got " + callExtensionReceiver;
                        throw (Throwable)((Object)new AssertionError((Object)message$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                this.checkReceiverTypeError($receiver2, extensionReceiver2, (ReceiverValue)callExtensionReceiver);
            }
            this.checkReceiverTypeError($receiver2, dispatchReceiver, $receiver2.candidateCall.getDispatchReceiver());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReceiverTypeError(CallCandidateResolutionContext<?> $receiver, ReceiverParameterDescriptor receiverParameterDescriptor, ReceiverValue receiverArgument) {
        void $receiver$iv;
        void this_$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (((CandidateResolver)this_$iv).shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            void $receiver2;
            KotlinType erasedReceiverType;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ResolutionStatus resolutionStatus = receiverParameterDescriptor == null || receiverArgument == null ? ResolutionStatus.SUCCESS : (!this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, erasedReceiverType = CallResolverUtilKt.getErasedReceiverType(receiverParameterDescriptor, this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver2)), (ResolutionContext)$receiver2) ? ResolutionStatus.RECEIVER_TYPE_ERROR : ResolutionStatus.SUCCESS);
            mutableResolvedCall.addStatus(resolutionStatus);
        }
    }

    private final <D extends CallableDescriptor> ResolutionStatus checkReceivers(CallCandidateResolutionContext<D> context) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        MutableResolvedCall candidateCall = context.candidateCall;
        ResolvedCall resolvedCall = candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall, "candidateCall");
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceiver(context, resolvedCall, candidateCall.getResultingDescriptor().getExtensionReceiverParameter(), (ReceiverValue)candidateCall.getExtensionReceiver(), candidateCall.getExplicitReceiverKind().isExtensionReceiver(), false));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(con\u2026ensionReceiver(), false))");
        resultStatus = resolutionStatus;
        ResolvedCall resolvedCall2 = candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "candidateCall");
        ResolutionStatus resolutionStatus2 = resultStatus.combine(this.checkReceiver(context, resolvedCall2, candidateCall.getResultingDescriptor().getDispatchReceiverParameter(), candidateCall.getDispatchReceiver(), candidateCall.getExplicitReceiverKind().isDispatchReceiver(), context.call instanceof CallTransformer.CallForImplicitInvoke));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus2, "resultStatus.combine(con\u2026s CallForImplicitInvoke))");
        resultStatus = resolutionStatus2;
        return resultStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> ResolutionStatus checkReceiver(CallCandidateResolutionContext<D> $receiver, ResolvedCall<D> candidateCall, ReceiverParameterDescriptor receiverParameter, ReceiverValue receiverArgument, boolean isExplicitReceiver, boolean implicitInvokeCheck) {
        void $receiver$iv;
        Object it;
        KtExpression expression;
        if (receiverParameter == null || receiverArgument == null) {
            return ResolutionStatus.SUCCESS;
        }
        D candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (TypeUtils.dependsOnTypeParameters(receiverParameter.getType(), (Collection<TypeParameterDescriptor>)candidateDescriptor.getTypeParameters())) {
            return ResolutionStatus.SUCCESS;
        }
        boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && CallUtilKt.isExplicitSafeCall(candidateCall.getCall());
        boolean isSubtypeBySmartCastIgnoringNullability = this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, receiverParameter.getType(), $receiver);
        if (!isSubtypeBySmartCastIgnoringNullability) {
            $receiver.tracing.wrongReceiverType($receiver.trace, receiverParameter, receiverArgument);
            return ResolutionStatus.OTHER_ERROR;
        }
        KotlinType expectedReceiverParameterType = safeAccess ? TypeUtils.makeNullable(receiverParameter.getType()) : receiverParameter.getType();
        boolean smartCastNeeded = !ArgumentTypeResolver.isSubtypeOfForArgumentType(receiverArgument.getType(), expectedReceiverParameterType);
        boolean reportUnsafeCall = false;
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, $receiver);
        Nullability nullability = $receiver.dataFlowInfo.getPredictableNullability(dataFlowValue);
        ReceiverValue receiverValue = receiverArgument;
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
        KtExpression ktExpression = expression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (nullability.canBeNull() && !nullability.canBeNonNull()) {
            if (!TypeUtils.isNullableType(expectedReceiverParameterType)) {
                reportUnsafeCall = true;
            }
            if (dataFlowValue.getImmanentNullability().canBeNonNull()) {
                Unit unit;
                KtExpression ktExpression2 = expression;
                if (ktExpression2 != null) {
                    void $receiver$iv2;
                    KtExpression ktExpression3 = ktExpression2;
                    it = (KtExpression)$receiver$iv2;
                    $receiver.trace.record(BindingContext.SMARTCAST_NULL, it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
        } else if (smartCastNeeded) {
            SmartCastResult smartCastResult = SmartCastManager.checkAndRecordPossibleCast(dataFlowValue, expectedReceiverParameterType, expression, $receiver, candidateCall.getCall().getCalleeExpression(), true);
            if (smartCastResult == null) {
                reportUnsafeCall = true;
            } else if (!smartCastResult.isCorrect()) {
                return ResolutionStatus.OTHER_ERROR;
            }
        }
        KotlinType receiverArgumentType = receiverArgument.getType();
        if (reportUnsafeCall) {
            $receiver.tracing.unsafeCall($receiver.trace, receiverArgumentType, implicitInvokeCheck);
            return ResolutionStatus.UNSAFE_CALL_ERROR;
        }
        it = this.additionalTypeCheckers;
        for (Object element$iv : $receiver$iv) {
            AdditionalTypeChecker it2 = (AdditionalTypeChecker)element$iv;
            it2.checkReceiver(receiverParameter, receiverArgument, safeAccess, (CallResolutionContext)$receiver);
        }
        return ResolutionStatus.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkGenericBoundsInAFunctionCall(List<? extends KtTypeProjection> jetTypeArguments, List<? extends KotlinType> typeArguments, CallableDescriptor functionDescriptor, TypeSubstitutor substitutor2, BindingTrace trace) {
        Collection $receiver$iv;
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getTypeParameters();
        int n = 0;
        Collection collection = typeParameters;
        int n2 = $receiver$iv.size();
        $receiver$iv = jetTypeArguments;
        int n3 = n2;
        int n4 = $receiver$iv.size();
        int n5 = Math.min(n3, n4) - 1;
        if (n <= n5) {
            while (true) {
                void i;
                TypeParameterDescriptor typeParameterDescriptor = typeParameters.get((int)i);
                KotlinType typeArgument = typeArguments.get((int)i);
                KtTypeReference typeReference = jetTypeArguments.get((int)i).getTypeReference();
                if (typeReference != null) {
                    DescriptorResolver.checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor2, trace);
                }
                if (i == n5) break;
                ++i;
            }
        }
    }

    private final <D extends CallableDescriptor> boolean shouldContinue(CallCandidateResolutionContext<D> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.candidateResolveMode, (Object)CandidateResolveMode.FULLY) || $receiver.candidateCall.getStatus().possibleTransformToSuccess();
    }

    private final CallableDescriptor getCandidateDescriptor(CallCandidateResolutionContext<?> $receiver) {
        Object d = $receiver.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "candidateCall.getCandidateDescriptor()");
        return d;
    }

    public CandidateResolver(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull GenericCandidateResolver genericCandidateResolver, @NotNull ReflectionTypes reflectionTypes, @NotNull Iterable<? extends AdditionalTypeChecker> additionalTypeCheckers, @NotNull SmartCastManager smartCastManager) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(genericCandidateResolver, "genericCandidateResolver");
        Intrinsics.checkParameterIsNotNull(reflectionTypes, "reflectionTypes");
        Intrinsics.checkParameterIsNotNull(additionalTypeCheckers, "additionalTypeCheckers");
        Intrinsics.checkParameterIsNotNull(smartCastManager, "smartCastManager");
        this.argumentTypeResolver = argumentTypeResolver;
        this.genericCandidateResolver = genericCandidateResolver;
        this.reflectionTypes = reflectionTypes;
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.smartCastManager = smartCastManager;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0011\u0019%\u0001\u0004\u0001\u001a\u0003a\u0005\u0011\u0015EE\u0005\u0011\u0005i\u0011\u0001g\u0001Q\u0007\u0003Iy\u0001\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00041\u000b\u00016!A)\u0004\u0003!\u001d\u0011&\u0004\u0003D\u0011!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\t!%\u0011F\u0003\u0003D\u0011!\tQ\"\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u0015AY\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult;", "", "status", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "argumentTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;Ljava/util/List;)V", "getArgumentTypes", "()Ljava/util/List;", "getStatus", "()Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;"}, moduleName="kotlin-compiler")
    public final class ValueArgumentsCheckingResult {
        @NotNull
        private final ResolutionStatus status;
        @NotNull
        private final List<KotlinType> argumentTypes;

        @NotNull
        public final ResolutionStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final List<KotlinType> getArgumentTypes() {
            return this.argumentTypes;
        }

        public ValueArgumentsCheckingResult(@NotNull ResolutionStatus status2, @NotNull List<? extends KotlinType> argumentTypes) {
            Intrinsics.checkParameterIsNotNull((Object)status2, "status");
            Intrinsics.checkParameterIsNotNull(argumentTypes, "argumentTypes");
            this.status = status2;
            this.argumentTypes = argumentTypes;
        }
    }
}

