/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;

public class KtConstructorDelegationCall
extends KtElementImpl
implements KtCallElement {
    public KtConstructorDelegationCall(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtConstructorDelegationCall", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public KtValueArgumentList getValueArgumentList() {
        return (KtValueArgumentList)this.findChildByType(KtNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        KtValueArgumentList list = this.getValueArgumentList();
        List<Object> list2 = list != null ? list.getArguments() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtConstructorDelegationCall", "getValueArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<KtLambdaArgument> getLambdaArguments() {
        List<KtLambdaArgument> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtConstructorDelegationCall", "getLambdaArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<KtTypeProjection> getTypeArguments() {
        List<KtTypeProjection> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtConstructorDelegationCall", "getTypeArguments"));
        }
        return list;
    }

    @Override
    public KtTypeArgumentList getTypeArgumentList() {
        return null;
    }

    @Override
    @Nullable
    public KtConstructorDelegationReferenceExpression getCalleeExpression() {
        return this.findChildByClass(KtConstructorDelegationReferenceExpression.class);
    }

    public boolean isImplicit() {
        KtConstructorDelegationReferenceExpression callee = this.getCalleeExpression();
        return callee != null && callee.getFirstChild() == null;
    }

    public boolean isCallToThis() {
        KtConstructorDelegationReferenceExpression callee = this.getCalleeExpression();
        return callee != null && callee.isThis();
    }
}

