/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.header;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.AbiVersionUtil;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;

public class ReadKotlinClassHeaderAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private static final Map<ClassId, KotlinClassHeader.Kind> HEADER_KINDS = new HashMap<ClassId, KotlinClassHeader.Kind>();
    private BinaryVersion version = AbiVersionUtil.INVALID_VERSION;
    private String multifileClassName = null;
    private String[] filePartClassNames = null;
    private String[] annotationData = null;
    private String[] strings = null;
    private KotlinClassHeader.Kind headerKind = null;
    private String syntheticClassKind = null;
    private boolean isInterfaceDefaultImpls = false;
    private boolean isLocalClass = false;

    @Nullable
    public KotlinClassHeader createHeader() {
        if (this.headerKind == null) {
            return null;
        }
        if (!AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            this.annotationData = null;
        } else if (this.shouldHaveData() && this.annotationData == null) {
            return null;
        }
        return new KotlinClassHeader(this.headerKind, this.version, this.annotationData, this.strings, this.syntheticClassKind, this.filePartClassNames, this.multifileClassName, this.isInterfaceDefaultImpls, this.isLocalClass);
    }

    private boolean shouldHaveData() {
        return this.headerKind == KotlinClassHeader.Kind.CLASS || this.headerKind == KotlinClassHeader.Kind.FILE_FACADE || this.headerKind == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId, @NotNull SourceElement source) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        FqName fqName2 = classId.asSingleFqName();
        if (JvmAnnotationNames.KOTLIN_INTERFACE_DEFAULT_IMPLS.equals(fqName2)) {
            this.isInterfaceDefaultImpls = true;
            return null;
        }
        if (JvmAnnotationNames.KOTLIN_LOCAL_CLASS.equals(fqName2)) {
            this.isLocalClass = true;
            return null;
        }
        if (this.headerKind != null) {
            return null;
        }
        KotlinClassHeader.Kind newKind = HEADER_KINDS.get(classId);
        if (newKind != null) {
            this.headerKind = newKind;
            switch (newKind) {
                case CLASS: 
                case FILE_FACADE: 
                case MULTIFILE_CLASS: 
                case MULTIFILE_CLASS_PART: {
                    return new HeaderAnnotationArgumentVisitor();
                }
                case SYNTHETIC_CLASS: {
                    return new SyntheticClassHeaderReader();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    static /* synthetic */ String[] access$402(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.filePartClassNames = x1;
        return x1;
    }

    static /* synthetic */ String[] access$502(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.annotationData = x1;
        return x1;
    }

    static /* synthetic */ String[] access$602(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.strings = x1;
        return x1;
    }

    static {
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_CLASS), KotlinClassHeader.Kind.CLASS);
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_FILE_FACADE), KotlinClassHeader.Kind.FILE_FACADE);
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_MULTIFILE_CLASS), KotlinClassHeader.Kind.MULTIFILE_CLASS);
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_MULTIFILE_CLASS_PART), KotlinClassHeader.Kind.MULTIFILE_CLASS_PART);
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_SYNTHETIC_CLASS), KotlinClassHeader.Kind.SYNTHETIC_CLASS);
    }

    private class SyntheticClassHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        private SyntheticClassHeaderReader() {
        }

        @Override
        public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$SyntheticClassHeaderReader", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$SyntheticClassHeaderReader", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$SyntheticClassHeaderReader", "visitEnum"));
            }
            if ("Kind".equals(enumClassId.getShortClassName().asString()) && enumClassId.isNestedClass() && enumClassId.getOuterClassId().equals(ClassId.topLevel(JvmAnnotationNames.KOTLIN_SYNTHETIC_CLASS)) && "kind".equals(name.asString())) {
                ReadKotlinClassHeaderAnnotationVisitor.this.syntheticClassKind = enumEntryName.asString();
            }
        }
    }

    private class HeaderAnnotationArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        private HeaderAnnotationArgumentVisitor() {
        }

        @Override
        public void visit(@Nullable Name name, @Nullable Object value) {
            if (name == null) {
                return;
            }
            String string = name.asString();
            if ("version".equals(string)) {
                ReadKotlinClassHeaderAnnotationVisitor.this.version = value instanceof int[] ? BinaryVersion.create((int[])value) : AbiVersionUtil.INVALID_VERSION;
            } else if ("multifileClassName".equals(string)) {
                ReadKotlinClassHeaderAnnotationVisitor.this.multifileClassName = value instanceof String ? (String)value : null;
            } else if ("abiVersion".equals(string) && ReadKotlinClassHeaderAnnotationVisitor.this.version == AbiVersionUtil.INVALID_VERSION && value instanceof Integer && (Integer)value > 0) {
                ReadKotlinClassHeaderAnnotationVisitor.this.version = BinaryVersion.create(0, (Integer)value, 0);
            }
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitArray"));
            }
            String string = name.asString();
            if ("data".equals(string)) {
                return this.dataArrayVisitor();
            }
            if ("strings".equals(string)) {
                return this.stringsArrayVisitor();
            }
            if ("filePartClassNames".equals(string)) {
                return this.filePartClassNamesVisitor();
            }
            return null;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor filePartClassNamesVisitor() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] data) {
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$1", "visitEnd"));
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$402(ReadKotlinClassHeaderAnnotationVisitor.this, data);
                }
            };
            if (collectStringArrayAnnotationVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "filePartClassNamesVisitor"));
            }
            return collectStringArrayAnnotationVisitor;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor dataArrayVisitor() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] data) {
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$2", "visitEnd"));
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$502(ReadKotlinClassHeaderAnnotationVisitor.this, data);
                }
            };
            if (collectStringArrayAnnotationVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "dataArrayVisitor"));
            }
            return collectStringArrayAnnotationVisitor;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor stringsArrayVisitor() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] data) {
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$3", "visitEnd"));
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$602(ReadKotlinClassHeaderAnnotationVisitor.this, data);
                }
            };
            if (collectStringArrayAnnotationVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "stringsArrayVisitor"));
            }
            return collectStringArrayAnnotationVisitor;
        }

        @Override
        public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitEnum"));
            }
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name, @NotNull ClassId classId) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitAnnotation"));
            }
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitAnnotation"));
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }

        private abstract class CollectStringArrayAnnotationVisitor
        implements KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor {
            private final List<String> strings = new ArrayList<String>();

            @Override
            public void visit(@Nullable Object value) {
                if (value instanceof String) {
                    this.strings.add((String)value);
                }
            }

            @Override
            public void visitEnum(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                if (enumClassId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$CollectStringArrayAnnotationVisitor", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$CollectStringArrayAnnotationVisitor", "visitEnum"));
                }
            }

            @Override
            public void visitEnd() {
                this.visitEnd(this.strings.toArray(new String[this.strings.size()]));
            }

            protected abstract void visitEnd(@NotNull String[] var1);
        }
    }
}

