/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsTry;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.CatchTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtTryExpression;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UC\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0003#\u000e\t\u0001bA\u0013\u0004\u0011\u0013i\u0011\u0001G\u0003&\u0015\u0011\t\u00012B\u0007\u0003\u0019\u0003Ab!\u0007\u0003\t\u00035\u0011A\u0012\u0001M\u0007S)!1\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001b\u0002\t\t\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/expression/TryTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "expression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/psi/KtTryExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtTryExpression;", "translate", "Lcom/google/dart/compiler/backend/js/ast/JsTry;", "translateAsBlock", "Lcom/google/dart/compiler/backend/js/ast/JsBlock;", "Lorg/jetbrains/kotlin/psi/KtExpression;"}, moduleName="kotlin-compiler")
public final class TryTranslator
extends AbstractTranslator {
    @NotNull
    private final KtTryExpression expression;

    @NotNull
    public final JsTry translate() {
        JsBlock tryBlock = this.translateAsBlock(this.expression.getTryBlock());
        List<KtCatchClause> list = this.expression.getCatchClauses();
        Intrinsics.checkExpressionValueIsNotNull(list, "expression.getCatchClauses()");
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        CatchTranslator catchTranslator = new CatchTranslator(list, translationContext);
        JsCatch catchBlock = catchTranslator.translate();
        KtFinallySection ktFinallySection = this.expression.getFinallyBlock();
        KtBlockExpression finallyExpression = ktFinallySection != null ? ktFinallySection.getFinalExpression() : null;
        JsBlock finallyBlock = this.translateAsBlock(finallyExpression);
        return new JsTry(tryBlock, catchBlock, finallyBlock);
    }

    private final JsBlock translateAsBlock(KtExpression expression) {
        if (expression == null) {
            return null;
        }
        JsStatement statement = Translation.translateAsStatementAndMergeInBlockIfNeeded(expression, this.context());
        return JsAstUtils.convertToBlock(statement);
    }

    @NotNull
    public final KtTryExpression getExpression() {
        return this.expression;
    }

    public TryTranslator(@NotNull KtTryExpression expression, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        this.expression = expression;
    }
}

