/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.IntRange;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinInterfaceDefaultImpls;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.reflect.IllegalCallableAccessException;
import kotlin.reflect.KCallable;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KotlinReflectionInternalError;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.reflect.jvm.internal.FunctionCaller;
import kotlin.reflect.jvm.internal.KAnnotatedElementImpl;
import kotlin.reflect.jvm.internal.KParameterImpl;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"U\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011#)\u0011\u0001\u0003\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0013\u000b\u0005!\u0019!B\u0001\r\u0003\u0011\u0001D\u0002A\u000b\u0004\t\u0001A\t\u0001%\u0001\u001a\t%\u0011\u0011\"\u0001S\u00011\u0005I\u0012\u0001g\u0001&&\u0011]\u00012D\u0007\u00029\u0001I2\u0002\u0003\b\u000e\r%!A\u0011A\u0005\u0003\u0019\u0003Ar\u0002'\b\u0012\u00051\u0005\u0001dD)\u0004\u0003!}Q5\u0005\u0003\f\u0011Ai\u0011\u0001\b\u0001\u001a\u0015!qQ\u0002C\u0005\u0003\u0013\u0005A\"\"C\u0002\n\u00051\u0005\u0001d\u0004M\u0011#\u000e\t\u0001\"E\u0013\n\t\u0005A\u0019#\u0004\u0002\r\u0002ay\u0011d\u0001\u0005\u0013\u001b\u0005A*#\u000b\u0006\u0005\u0017\"A!!D\u0001\u0019\u0006qY\u0013kA\u0002\u000e\u0005\u0011\u0019\u0001rA\u0015\f\tMC\u0001\u0002B\u0007\u0004\u0013\u0005!\u0019\u0001'\u0003R\u0007\ri!\u0001B\u0003\t\f%bAa\u0015\u0005\t\r5!\u0011\"\u0001C\u0002\u0019\u0003AJ!U\u0002\u0004\u001b\t!i\u0001c\u0003*\u0013\u0011\u0019\u0006\u0002C\u0004\u000e\u0003a=\u0011kA\u0002\u000e\u0005\u0011A\u0001\u0012C\u0015\u000e\t-C\u0001\"C\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0006\u0019\u0014qY\u0013kA\u0002\u000e\u0005\u0011U\u0001bC\u0015\u000b\t-C\u0001rC\u0007\u000211a2&U\u0002\u0004\u001b\t!I\u0002C\u0007"}, strings={"Lkotlin/reflect/jvm/internal/KCallableImpl;", "R", "Lkotlin/reflect/KCallable;", "Lkotlin/reflect/jvm/internal/KAnnotatedElementImpl;", "annotated", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "getAnnotated", "()Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "caller", "Lkotlin/reflect/jvm/internal/FunctionCaller;", "getCaller", "()Lkotlin/reflect/jvm/internal/FunctionCaller;", "defaultCaller", "getDefaultCaller", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "parameters", "", "Lkotlin/reflect/KParameter;", "getParameters", "()Ljava/util/List;", "returnType", "Lkotlin/reflect/KType;", "getReturnType", "()Lkotlin/reflect/KType;", "call", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/Object;", "callBy", "", "(Ljava/util/Map;)Ljava/lang/Object;", "defaultPrimitiveValue", "type", "Ljava/lang/reflect/Type;"}, moduleName="kotlin-reflection")
public interface KCallableImpl<R>
extends KCallable<R>,
KAnnotatedElementImpl {
    @NotNull
    public CallableMemberDescriptor getDescriptor();

    @NotNull
    public FunctionCaller<?> getCaller();

    @Nullable
    public FunctionCaller<?> getDefaultCaller();

    @Override
    @NotNull
    public Annotated getAnnotated();

    @Override
    @NotNull
    public List<KParameter> getParameters();

    @Override
    @NotNull
    public KType getReturnType();

    @Override
    public R call(Object ... var1);

    @Override
    public R callBy(@NotNull Map<KParameter, ? extends Object> var1);

    @KotlinInterfaceDefaultImpls(version={1, 0, 1})
    @KotlinSyntheticClass(version={1, 0, 1}, abiVersion=32, moduleName="kotlin-reflection")
    public static final class DefaultImpls {
        @NotNull
        public static Annotated getAnnotated(KCallableImpl<? extends R> $this) {
            return $this.getDescriptor();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<KParameter> getParameters(KCallableImpl<? extends R> $this) {
            int n;
            CallableMemberDescriptor descriptor2 = $this.getDescriptor();
            ArrayList<KParameterImpl> result2 = new ArrayList<KParameterImpl>();
            int index2 = 0;
            if (descriptor2.getDispatchReceiverParameter() != null) {
                result2.add(new KParameterImpl($this, index2++, KParameter.Kind.INSTANCE, (Function0<? extends ParameterDescriptor>)new Function0<ReceiverParameterDescriptor>(descriptor2){
                    final /* synthetic */ CallableMemberDescriptor $descriptor;

                    @NotNull
                    public final ReceiverParameterDescriptor invoke() {
                        ReceiverParameterDescriptor receiverParameterDescriptor = this.$descriptor.getDispatchReceiverParameter();
                        if (receiverParameterDescriptor == null) {
                            Intrinsics.throwNpe();
                        }
                        return receiverParameterDescriptor;
                    }
                    {
                        this.$descriptor = callableMemberDescriptor;
                        super(0);
                    }
                }));
            }
            if (descriptor2.getExtensionReceiverParameter() != null) {
                result2.add(new KParameterImpl($this, index2++, KParameter.Kind.EXTENSION_RECEIVER, (Function0<? extends ParameterDescriptor>)new Function0<ReceiverParameterDescriptor>(descriptor2){
                    final /* synthetic */ CallableMemberDescriptor $descriptor;

                    @NotNull
                    public final ReceiverParameterDescriptor invoke() {
                        ReceiverParameterDescriptor receiverParameterDescriptor = this.$descriptor.getExtensionReceiverParameter();
                        if (receiverParameterDescriptor == null) {
                            Intrinsics.throwNpe();
                        }
                        return receiverParameterDescriptor;
                    }
                    {
                        this.$descriptor = callableMemberDescriptor;
                        super(0);
                    }
                }));
            }
            IntRange intRange = CollectionsKt.getIndices((Collection)descriptor2.getValueParameters());
            int n2 = intRange.getFirst();
            if (n2 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    result2.add(new KParameterImpl($this, index2++, KParameter.Kind.VALUE, (Function0<? extends ParameterDescriptor>)new Function0<ValueParameterDescriptor>(descriptor2, (int)i){
                        final /* synthetic */ CallableMemberDescriptor $descriptor;
                        final /* synthetic */ int $i;

                        public final ValueParameterDescriptor invoke() {
                            ValueParameterDescriptor valueParameterDescriptor = this.$descriptor.getValueParameters().get(this.$i);
                            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "descriptor.valueParameters[i]");
                            return valueParameterDescriptor;
                        }
                        {
                            this.$descriptor = callableMemberDescriptor;
                            this.$i = n;
                            super(0);
                        }
                    }));
                    if (i == n) break;
                    ++i;
                }
            }
            result2.trimToSize();
            return result2;
        }

        @NotNull
        public static KType getReturnType(KCallableImpl<? extends R> $this) {
            KotlinType kotlinType = $this.getDescriptor().getReturnType();
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.returnType!!");
            return new KTypeImpl(kotlinType, (Function0<? extends Type>)new Function0<Type>($this){
                final /* synthetic */ KCallableImpl this$0;

                @NotNull
                public final Type invoke() {
                    return this.this$0.getCaller().getReturnType$kotlin_reflection();
                }
                {
                    this.this$0 = kCallableImpl;
                    super(0);
                }
            });
        }

        public static R call(@NotNull KCallableImpl<? extends R> $this, Object ... args) {
            Intrinsics.checkParameterIsNotNull(args, "args");
            try {
                return $this.getCaller().call(args);
            }
            catch (IllegalAccessException e$iv) {
                throw (Throwable)new IllegalCallableAccessException(e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        public static R callBy(@NotNull KCallableImpl<? extends R> $this, Map<KParameter, ? extends Object> args) {
            Object object;
            Collection thisCollection$iv;
            Intrinsics.checkParameterIsNotNull(args, "args");
            List<KParameter> parameters2 = $this.getParameters();
            ArrayList<Object> arguments2 = new ArrayList<Object>(parameters2.size());
            int mask = 0;
            ArrayList<Integer> masks = new ArrayList<Integer>(1);
            int index2 = 0;
            for (KParameter kParameter : parameters2) {
                if (index2 != 0 && index2 % 32 == 0) {
                    masks.add(mask);
                    mask = 0;
                }
                if (args.containsKey(kParameter)) {
                    arguments2.add(args.get(kParameter));
                } else if (kParameter.isOptional()) {
                    arguments2.add(DefaultImpls.defaultPrimitiveValue($this, ReflectJvmMapping.getJavaType(kParameter.getType())));
                    mask |= 1 << index2 % 32;
                } else {
                    throw (Throwable)new IllegalArgumentException("No argument provided for a required parameter: " + kParameter);
                }
                if (!Intrinsics.areEqual((Object)kParameter.getKind(), (Object)KParameter.Kind.VALUE)) continue;
                ++index2;
            }
            if (mask == 0 && masks.isEmpty()) {
                Collection collection = arguments2;
                KCallableImpl kCallableImpl = $this;
                thisCollection$iv = collection;
                Object[] objectArray = thisCollection$iv.toArray(new Object[thisCollection$iv.size()]);
                if (objectArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Object[] objectArray2 = objectArray;
                return kCallableImpl.call(Arrays.copyOf(objectArray2, objectArray2.length));
            }
            masks.add(mask);
            FunctionCaller<?> functionCaller = $this.getDefaultCaller();
            if (functionCaller == null) {
                throw (Throwable)new KotlinReflectionInternalError("This callable does not support a default call: " + $this.getDescriptor());
            }
            FunctionCaller<?> functionCaller2 = functionCaller;
            arguments2.addAll((Collection)masks);
            if (functionCaller2 instanceof FunctionCaller.Constructor) {
                arguments2.add(null);
            }
            try {
                void $receiver$iv;
                thisCollection$iv = arguments2;
                FunctionCaller<?> functionCaller3 = functionCaller2;
                Collection thisCollection$iv2 = (Collection)$receiver$iv;
                Object[] objectArray = thisCollection$iv2.toArray(new Object[thisCollection$iv2.size()]);
                if (objectArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Object[] objectArray3 = objectArray;
                object = functionCaller3.call(objectArray3);
            }
            catch (IllegalAccessException e$iv) {
                throw (Throwable)new IllegalCallableAccessException(e$iv);
            }
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Object defaultPrimitiveValue(KCallableImpl<? extends R> $this, Type type2) {
            Comparable<Boolean> comparable;
            if (!(type2 instanceof Class)) return null;
            if (!((Class)type2).isPrimitive()) return null;
            Type type3 = type2;
            if (Intrinsics.areEqual(type3, Boolean.TYPE)) {
                comparable = false;
                return comparable;
            } else if (Intrinsics.areEqual(type3, Character.TYPE)) {
                comparable = Character.valueOf((char)0);
                return comparable;
            } else if (Intrinsics.areEqual(type3, Byte.TYPE)) {
                comparable = (byte)0;
                return comparable;
            } else if (Intrinsics.areEqual(type3, Short.TYPE)) {
                comparable = (short)0;
                return comparable;
            } else if (Intrinsics.areEqual(type3, Integer.TYPE)) {
                comparable = 0;
                return comparable;
            } else if (Intrinsics.areEqual(type3, Float.TYPE)) {
                comparable = Float.valueOf(0.0f);
                return comparable;
            } else if (Intrinsics.areEqual(type3, Long.TYPE)) {
                comparable = 0L;
                return comparable;
            } else if (Intrinsics.areEqual(type3, Double.TYPE)) {
                comparable = 0.0;
                return comparable;
            } else {
                if (!Intrinsics.areEqual(type3, Void.TYPE)) throw (Throwable)new UnsupportedOperationException("Unknown primitive: " + type2);
                throw (Throwable)new IllegalStateException("Parameter with void type is illegal");
            }
        }

        @NotNull
        public static List<Annotation> getAnnotations(KCallableImpl<? extends R> $this) {
            return KAnnotatedElementImpl.DefaultImpls.getAnnotations($this);
        }
    }
}

