/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0003\u0006)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAqA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0002\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001bD\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u00031\u0001\u0001\u0003N\r\u00021\u0003i\n\u0001NQ\u0017\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011b\u0001\u0005\u0005\u001b\u0005AJ!C\u0002\t\u000b5\t\u00014B)\u0004\u0003!1QE\u0005\u0003\u0002\u0011\u001fi\u0011\u0001\u0007\u0005\u001a\u0007!EQ\"\u0001\r\n3\u0011A\u0019\"\u0004\u0002\r\u0002aQ\u0011\u0004\u0002E\u000b\u001b\ta\t\u0001G\u0006&\u0019\u0011\t\u0001rC\u0007\u00021!I2\u0001\u0003\u0007\u000e\u0003ae\u0011d\u0001E\t\u001b\u0005A\u0012\"\n\u0005\u0005\u0003!iQ\"\u0001\r\t3\rAY\"D\u0001\u0019\u001d\u0015bA!\u0001E\u000f\u001b\u0005A\u0002\"G\u0002\t\u001f5\t\u0001tD\r\u0004\u0011Ai\u0011\u0001'\t&\u0019\u0011\t\u0001\"E\u0007\u00021!I2\u0001c\t\u000e\u0003aq\u0011d\u0001\u0005\u0011\u001b\u0005A\"#\n\u0007\u0005\u0003!\u0015R\"\u0001\r\t3\rA1#D\u0001\u0019(e\u0019\u0001\u0002F\u0007\u00021S)\u0003\u0002B\u0001\t+5\t\u0001\u0004C\r\u0004\u0011Gi\u0011\u0001g\b&\u0019\u0011\t\u00012F\u0007\u00021!I2\u0001\u0003\f\u000e\u0003a5\u0012d\u0001\u0005\u0011\u001b\u0005A\"#\n\u0007\u0005\u0003!9R\"\u0001\r\t3\rA\u0019#D\u0001\u0019\u001de\u0019\u0001\u0002E\u0007\u00021I)C\u0002B\u0001\t05\t\u0001\u0004C\r\u0004\u0011Gi\u0011\u0001\u0007\b\u001a\u0007!\u0001R\"\u0001\r\u0013K1!\u0011\u0001\u0003\r\u000e\u0003aA\u0011d\u0001E\u0019\u001b\u0005A\u0012$G\u0002\t45\t\u0001DG\u0013\r\t\u0005A)$D\u0001\u0019\u0011e\u0019\u0001\u0012G\u0007\u00021mI2\u0001c\r\u000e\u0003a]R%\u0004\u0003\u0002\u0011qi\u0011\u0001\u0007\u0005\u001a\t!eRB\u0001G\u00011uI2\u0001c\u000f\u000e\u0003aqR\u0005\u0003\u0003\u0002\u0011{i\u0011\u0001\u0007\u0005\u001a\u0007!\u0001R\"\u0001M\u0011K!!\u0011\u0001C\u0010\u000e\u0003aA\u0011d\u0001E \u001b\u0005A\u0002%\n\u0007\u0005\u0003!\u0005S\"\u0001\r\t3\rAA#D\u0001\u0019Ce\u0019\u0001\u0002E\u0007\u00021I)\u0003\u0003B\u0001\tD5\t\u0001\u0004C\r\u0004\u0011\tj\u0011\u0001'\u0012\u001a\u0007!!R\"\u0001\r$3\rA9%D\u0001\u0019I\u0015BA!\u0001E%\u001b\u0005A\u0002\"G\u0002\t!5\t\u0001\u0014E\u0013\r\t\u0005AQ%D\u0001\u0019\u0011e\u0019\u00012D\u0007\u000219I2\u0001\u0003\t\u000e\u0003a\u0011R\u0005\u0004\u0003\u0002\u0011\u0017j\u0011\u0001\u0007\u0005\u001a\u0007!aQ\"\u0001M\r3\rA\t\"D\u0001\u0019\u0013\u0015\u0002B!\u0001\u0005'\u001b\u0005A\u0002\"G\u0002\t\u00195\t\u0001\u0014D\r\u0004\u0011#i\u0011\u0001G\u0005\u001a\u0007!\u0001R\"\u0001\r\u0013K1!\u0011\u0001#\u0014\u000e\u0003aA\u0011d\u0001\u0005\r\u001b\u0005AJ\"G\u0002\t\u00125\t\u0001$C\u0013\r\t\u0005Aq%D\u0001\u0019\u0011e\u0019\u0001\u0002D\u0007\u000213I2\u0001#\u0005\u000e\u0003aIQ\u0005\u0004\u0003\u0002\u0011\u001fj\u0011\u0001\u0007\u0005\u001a\u0007!aQ\"\u0001\r)3\rA\t\"D\u0001\u0019\u0013\u0015BA!\u0001E)\u001b\u0005A\u0002\"G\u0002\tE5\t\u0001$C\u0013\r\t\u0005A\u0011&D\u0001\u0019\u0011e\u0019\u00012K\u0007\u00021)J2\u0001#\u0016\u000e\u0003aYS\u0005\u0003\u0003\u0002\u0011/j\u0011\u0001\u0007\u0005\u001a\u0007!aS\"\u0001\r%K!!\u0011\u0001#\u0017\u000e\u0003aA\u0011d\u0001\u0005-\u001b\u0005AB%\n\u0005\u0005\u0003!iS\"\u0001\r\t3\rAY\"D\u0001\u0019\u001d\u0015BA!\u0001E.\u001b\u0005A\u0002\"G\u0002\t\u001f5\t\u0001tD\u0013\r\t\u0005Aa&D\u0001\u0019\u0011e\u0019\u0001\u0002F\u0007\u00021SI2\u0001#\u0018\u000e\u0003aySe\u0002E0\u001b\u0005A\u0002\"G\u0002\ta5\t\u0001\u0014M\u0013\u0013\t\u0005A\u0011'D\u0001\u0019\u0011e1\u00012M\u0007\u0005\u0013\tI\u0011\u0001G\u0016\u0019ee1\u0001RM\u0007\u0005\u0013\tI\u0011\u0001G\u0016\u0019g\u0015*\u0001rM\u0007\u00021!)\u0012\u0001'\u000b*\u000f\u0011\t\u0005\u0002C\u0002\u000e\u0003a\u001d\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!!Q\"\u0001M\u0005#\u000e\tQ\u0001AU\f\t\u0005C\u0001BAG\u00061\u001bI\u0013\u0001'\u0002R\u0007\u0005!q!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0015i\u0011\u0001g\u0003R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "Lorg/jetbrains/annotations/NotNull;", "checkAccessor", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkAccessors", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkAnnotationClassWithBody", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkClass", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "checkClassExposedType", "klass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkConstructorDeclaration", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkConstructorInInterface", "checkEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "checkExposedParameterBounds", "checkExposedSupertypes", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkFunctionExposedType", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkMemberReceiverExposedType", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkMethodsOfAnyInInterface", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkOnlyOneTypeParameterBound", "descriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "owner", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkOpenMembers", "checkPrimaryConstructor", "checkProperty", "checkPropertyAbstractness", "checkPropertyExposedType", "checkPropertyInitializer", "checkPropertyLateInit", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "checkPropertyTypeParametersAreUsedInReceiverType", "checkSupertypesForConsistency", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "checkTypeParameterConstraints", "typeParameterListOwner", "checkTypeParameters", "checkTypesInClassHeader", "checkValOnAnnotationParameter", "checkVarargParameters", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "process", "bodiesResolveContext", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "checkTypeReferences", "Companion"}, moduleName="kotlin-compiler")
public final class DeclarationsChecker {
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationChecker annotationChecker;
    private final IdentifierChecker identifierChecker;
    private final BindingTrace trace;
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES;
    public static final Companion Companion;

    public final void checkTypeReferences(KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationsCheckerKt.checkTypeReferences($receiver, this.trace);
    }

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        Object propertyDescriptor;
        Object functionDescriptor;
        void $receiver$iv;
        Object classDescriptor;
        KtClassOrObject $receiver$iv2;
        Map.Entry $i$f$component1;
        Intrinsics.checkParameterIsNotNull(bodiesResolveContext, "bodiesResolveContext");
        Iterator<Object> iterator2 = bodiesResolveContext.getFiles().iterator();
        while (iterator2.hasNext()) {
            KtFile entry;
            KtFile ktFile = entry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(ktFile, "file");
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile);
            KtAnnotated ktAnnotated = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktAnnotated, "file");
            this.annotationChecker.check(ktAnnotated, this.trace, null);
        }
        iterator2 = bodiesResolveContext.getDeclaredClasses().entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv22;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            KtClassOrObject classOrObject = (KtClassOrObject)$receiver$iv22.getKey();
            $i$f$component1 = entry;
            classDescriptor = (ClassDescriptorWithResolutionScopes)$receiver$iv2.getValue();
            ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "classDescriptor");
            PsiElement psiElement2 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "classOrObject");
            this.checkSupertypesForConsistency(classifierDescriptor, psiElement2);
            KtClassOrObject ktClassOrObject = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject, "classOrObject");
            this.checkTypesInClassHeader(ktClassOrObject);
            $receiver$iv2 = classOrObject;
            if ($receiver$iv2 instanceof KtClass) {
                KtClass ktClass = (KtClass)classOrObject;
                Object object = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(object, "classDescriptor");
                this.checkClass(ktClass, (ClassDescriptorWithResolutionScopes)object);
                this.descriptorResolver.checkNamesInConstraints(classOrObject, (DeclarationDescriptor)classDescriptor, classDescriptor.getScopeForClassHeaderResolution(), this.trace);
            } else if ($receiver$iv2 instanceof KtObjectDeclaration) {
                KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)classOrObject;
                ClassDescriptor classDescriptor2 = (ClassDescriptor)classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "classDescriptor");
                this.checkObject(ktObjectDeclaration, classDescriptor2);
            }
            KtClassOrObject ktClassOrObject2 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject2, "classOrObject");
            ClassDescriptor classDescriptor3 = (ClassDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor3, "classDescriptor");
            this.checkPrimaryConstructor(ktClassOrObject2, classDescriptor3);
            this.checkTypeReferences(classOrObject);
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, (MemberDescriptor)classDescriptor);
            KtDeclaration ktDeclaration = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "classOrObject");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
            KtClassOrObject ktClassOrObject3 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject3, "classOrObject");
            ClassDescriptor classDescriptor4 = (ClassDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor4, "classDescriptor");
            this.checkClassExposedType(ktClassOrObject3, classDescriptor4);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            classDescriptor = entry;
            KtNamedFunction function = (KtNamedFunction)$receiver$iv.getKey();
            $i$f$component1 = entry;
            functionDescriptor = (SimpleFunctionDescriptor)$receiver$iv2.getValue();
            KtNamedFunction ktNamedFunction = function;
            Intrinsics.checkExpressionValueIsNotNull(ktNamedFunction, "function");
            Object object = functionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(object, "functionDescriptor");
            this.checkFunction(ktNamedFunction, (SimpleFunctionDescriptor)object);
            this.checkTypeReferences(function);
            this.modifiersChecker.checkModifiersForDeclaration(function, (MemberDescriptor)functionDescriptor);
            KtDeclaration ktDeclaration = function;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "function");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            functionDescriptor = entry;
            KtProperty property = (KtProperty)$receiver$iv.getKey();
            $i$f$component1 = entry;
            propertyDescriptor = (PropertyDescriptor)$receiver$iv2.getValue();
            KtProperty ktProperty = property;
            Intrinsics.checkExpressionValueIsNotNull(ktProperty, "property");
            Object object = propertyDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(object, "propertyDescriptor");
            this.checkProperty(ktProperty, (PropertyDescriptor)object);
            this.checkTypeReferences(property);
            this.modifiersChecker.checkModifiersForDeclaration(property, (MemberDescriptor)propertyDescriptor);
            KtDeclaration ktDeclaration = property;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "property");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            ConstructorDescriptor constructorDescriptor;
            propertyDescriptor = entry;
            KtSecondaryConstructor declaration = (KtSecondaryConstructor)$receiver$iv.getKey();
            $i$f$component1 = entry;
            ConstructorDescriptor constructorDescriptor2 = constructorDescriptor = (ConstructorDescriptor)$receiver$iv2.getValue();
            Intrinsics.checkExpressionValueIsNotNull(constructorDescriptor2, "constructorDescriptor");
            KtDeclaration ktDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "declaration");
            this.checkConstructorDeclaration(constructorDescriptor2, ktDeclaration);
            KtFunction ktFunction = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktFunction, "declaration");
            FunctionDescriptor functionDescriptor2 = constructorDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "constructorDescriptor");
            this.checkFunctionExposedType(ktFunction, functionDescriptor2);
        }
    }

    private final void checkConstructorDeclaration(ConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        this.checkTypeReferences(declaration);
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration, this.trace);
        this.checkVarargParameters(declaration, constructorDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file) {
        KtPackageDirective ktPackageDirective = file.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        for (KtAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            Unit unit;
            KtConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() != null) {
                void $receiver$iv;
                KtSimpleNameExpression it = (KtSimpleNameExpression)$receiver$iv;
                this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it), it));
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        KtAnnotated ktAnnotated = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull(ktAnnotated, "packageDirective");
        this.annotationChecker.check(ktAnnotated, this.trace, null);
        KtModifierListOwner ktModifierListOwner = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierListOwner, "packageDirective");
        ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, this.trace, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        KotlinType type2;
        KtTypeReference typeReference;
        Function1<KtTypeReference, KotlinType> type$ = new Function1<KtTypeReference, KotlinType>(this){
            final /* synthetic */ DeclarationsChecker this$0;

            @Nullable
            public final KotlinType invoke(KtTypeReference $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                return (KotlinType)DeclarationsChecker.access$getTrace$p(this.this$0).getBindingContext().get(BindingContext.TYPE, $receiver);
            }
            {
                this.this$0 = declarationsChecker;
                super(1);
            }
        };
        for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
            Unit unit;
            KtTypeReference typeReference2;
            if (delegationSpecifier.getTypeReference() == null) {
                continue;
            }
            if (type$.invoke(typeReference2) != null) {
                void $receiver$iv;
                KotlinType it = (KotlinType)$receiver$iv;
                DescriptorResolver.checkBounds(typeReference2, it, this.trace);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            DeclarationsCheckerKt.checkNotEnumEntry(typeReference2, this.trace);
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        ArrayList<DescriptorResolver.UpperBoundCheckRequest> upperBoundCheckRequests = new ArrayList<DescriptorResolver.UpperBoundCheckRequest>();
        for (KtTypeParameter typeParameter : ((KtClass)classOrObject).getTypeParameters()) {
            if (typeParameter.getExtendsBound() == null) {
                continue;
            }
            if (type$.invoke(typeReference) == null) {
                continue;
            }
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest(typeParameter.getNameAsName(), typeReference, type2));
        }
        for (KtTypeConstraint constraint : ((KtClass)classOrObject).getTypeConstraints()) {
            if (constraint.getBoundTypeReference() == null) {
                continue;
            }
            if (type$.invoke(typeReference) == null) {
                continue;
            }
            Object object = constraint.getSubjectTypeParameterName();
            if (object == null || (object = object.getReferencedNameAsName()) == null) {
                continue;
            }
            Object name = object;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest((Name)name, typeReference, type2));
        }
        DescriptorResolver.checkUpperBoundTypes(this.trace, (List<DescriptorResolver.UpperBoundCheckRequest>)upperBoundCheckRequests);
        for (DescriptorResolver.UpperBoundCheckRequest request : upperBoundCheckRequests) {
            DescriptorResolver.checkBounds(request.upperBound, request.upperBoundType, this.trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(TypeParameterDescriptor descriptor2, KtTypeParameter declaration, KtTypeParameterListOwner owner) {
        void otherBounds;
        void boundsWhichAreTypeParameters;
        Object element$iv2;
        Object object;
        Collection collection;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object $receiver$iv;
        List<KotlinType> upperBounds = descriptor2.getUpperBounds();
        Iterable iterable = upperBounds;
        void var9_6 = $receiver$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void type2;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            collection = destination$iv$iv;
            object = type2.getConstructor();
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv2 = iterator2.next();
            TypeConstructor constructor = (TypeConstructor)element$iv2;
            if (constructor.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        $receiver$iv = new Pair(first$iv, second$iv);
        Object pair = (Pair)$receiver$iv;
        Pair pair2 = TuplesKt.to(CollectionsKt.toSet((Iterable)((Pair)pair).getFirst()), CollectionsKt.toSet((Iterable)((Pair)pair).getSecond()));
        Set set = pair2.component1();
        Set set2 = pair2.component2();
        pair2 = null;
        if (boundsWhichAreTypeParameters.size() > 1 || boundsWhichAreTypeParameters.size() == 1 && CollectionsKt.isNotEmpty((Collection)otherBounds)) {
            KtElement ktElement;
            if (boundsWhichAreTypeParameters.size() + otherBounds.size() == 2) {
                Pair problematicBound;
                Object object2;
                Object v3;
                block11: {
                    void $receiver$iv2;
                    Object element$iv$iv$iv;
                    Iterator $receiver$iv$iv$iv;
                    Collection destination$iv$iv2;
                    Object element$iv$iv2;
                    Iterable $receiver$iv$iv2;
                    Iterable $receiver$iv3;
                    pair = owner.getTypeConstraints();
                    void $i$a$3 = $receiver$iv3;
                    Collection $i$f$let = new ArrayList();
                    for (Object element$iv$iv2 : $receiver$iv$iv2) {
                        KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv2;
                        KtSimpleNameExpression ktSimpleNameExpression = constraint.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null, declaration.getNameAsName())) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    $receiver$iv3 = (List)destination$iv$iv2;
                    $receiver$iv$iv2 = $receiver$iv3;
                    destination$iv$iv2 = new ArrayList();
                    element$iv2 = $receiver$iv$iv2;
                    element$iv$iv2 = $receiver$iv$iv$iv.iterator();
                    while (element$iv$iv2.hasNext()) {
                        Boolean bl;
                        element$iv$iv$iv = element$iv$iv2.next();
                        Object element$iv$iv3 = element$iv$iv$iv;
                        KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv3;
                        if (constraint.getBoundTypeReference() != null) {
                            void $receiver$iv$iv$iv2;
                            void it$iv$iv = $receiver$iv$iv$iv2;
                            bl = destination$iv$iv2.add(it$iv$iv);
                            continue;
                        }
                        bl = null;
                    }
                    $receiver$iv3 = (List)destination$iv$iv2;
                    $receiver$iv$iv2 = $receiver$iv3;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
                    for (Object item$iv$iv : $receiver$iv$iv2) {
                        void typeReference;
                        element$iv$iv$iv = (KtTypeReference)item$iv$iv;
                        collection = destination$iv$iv2;
                        object = TuplesKt.to(typeReference, this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                        collection.add(object);
                    }
                    List allBounds = (List)destination$iv$iv2;
                    $receiver$iv$iv2 = allBounds;
                    for (Object element$iv2 : $receiver$iv2) {
                        Pair bound = (Pair)element$iv2;
                        KotlinType kotlinType = (KotlinType)bound.getSecond();
                        if (!(Intrinsics.areEqual(kotlinType != null ? kotlinType.getConstructor() : null, (TypeConstructor)CollectionsKt.first((Iterable)boundsWhichAreTypeParameters)) ^ true)) continue;
                        v3 = element$iv2;
                        break block11;
                    }
                    v3 = null;
                }
                ktElement = (object2 = (problematicBound = (Pair)v3)) != null && (object2 = (KtTypeReference)((Pair)object2).getFirst()) != null ? (KtElement)object2 : (KtElement)declaration;
            } else {
                ktElement = declaration;
            }
            KtElement reportOn = ktElement;
            this.trace.report(Errors.BOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER.on((KtElement)((PsiElement)reportOn)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifier2, PsiElement sourceElement) {
        Annotated annotated;
        void var18_7;
        Iterator<Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>>> iterator2;
        Iterator iterator3;
        if (classifier2 instanceof TypeParameterDescriptor) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            iterator3 = ((TypeParameterDescriptor)classifier2).getUpperBounds();
            iterator2 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                var18_7 = destination$iv$iv;
                annotated = it.getConstructor();
                var18_7.add(annotated);
            }
            List immediateUpperBounds = (List)destination$iv$iv;
            if (immediateUpperBounds.size() != CollectionsKt.toSet(immediateUpperBounds).size()) {
                return;
            }
        }
        Multimap<TypeParameterDescriptor, TypeProjection> multiMap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifier2.getDefaultType());
        iterator2 = MapsKt.mutableIterator(multiMap.asMap());
        while (iterator2.hasNext()) {
            ClassDescriptor containingDeclaration;
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            void $receiver$iv2;
            void $receiver$iv3;
            Iterator iterator4 = iterator3 = iterator2.next();
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)$receiver$iv3.getKey();
            Iterator $i$f$component1 = iterator3;
            Collection projections = (Collection)$receiver$iv2.getValue();
            if (projections.size() <= 1) continue;
            Iterable $i$f$component2 = projections;
            void $i$a$1 = $receiver$iv;
            Collection $i$f$mapTo = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                var18_7 = destination$iv$iv;
                annotated = it.getType();
                var18_7.add(annotated);
            }
            Set conflictingTypes = CollectionsKt.toMutableSet((List)destination$iv$iv);
            DeclarationsChecker.Companion.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            DeclarationDescriptor declarationDescriptor = typeParameterDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            if ((ClassDescriptor)declarationDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Not a class descriptor: " + typeParameterDescriptor.getContainingDeclaration())));
            }
            if (sourceElement instanceof KtClassOrObject) {
                KtSuperTypeList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getSuperTypeList() == null) {
                    continue;
                }
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtSuperTypeList)((PsiElement)delegationSpecifierList), typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkClassExposedType(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        this.checkExposedSupertypes(klass, classDescriptor);
        this.checkExposedParameterBounds(klass, classDescriptor);
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor constructor = ktPrimaryConstructor;
        ConstructorDescriptor constructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor constructorDescriptor2 = constructorDescriptor;
        KtFunction ktFunction = constructor;
        FunctionDescriptor functionDescriptor = constructorDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "constructorDescriptor");
        this.checkFunctionExposedType(ktFunction, functionDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExposedParameterBounds(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        void $receiver$iv;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility(classDescriptor);
        List<KtTypeParameter> typeParameterList = klass.getTypeParameters();
        Iterable iterable = classDescriptor.getDeclaredTypeParameters();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void typeParameterDescriptor;
            int n = index$iv++;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            int i = n;
            if (i >= typeParameterList.size()) {
                return;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                EffectiveVisibility upperBoundVisibility = EffectiveVisibilityKt.effectiveVisibility(upperBound);
                if (upperBoundVisibility.sameOrMorePermissive(classVisibility)) continue;
                this.trace.report(Errors.EXPOSED_TYPE_PARAMETER_BOUND.on((KtTypeParameter)((PsiElement)typeParameterList.get(i)), classVisibility, upperBoundVisibility));
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExposedSupertypes(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        void $receiver$iv;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility(classDescriptor);
        boolean isInterface = Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.INTERFACE);
        List<KtSuperTypeListEntry> delegationList = klass.getSuperTypeListEntries();
        Iterable iterable = classDescriptor.getTypeConstructor().getSupertypes();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            EffectiveVisibility superTypeVisibility;
            ClassDescriptor superDescriptor;
            void superType;
            int n = index$iv++;
            KotlinType kotlinType = (KotlinType)item$iv;
            int i = n;
            if (i >= delegationList.size()) {
                return;
            }
            if (TypeUtils.getClassDescriptor((KotlinType)superType) == null) {
                continue;
            }
            boolean superIsInterface = Intrinsics.areEqual((Object)superDescriptor.getKind(), (Object)ClassKind.INTERFACE);
            if (superIsInterface != isInterface || (superTypeVisibility = EffectiveVisibilityKt.effectiveVisibility((KotlinType)superType)).sameOrMorePermissive(classVisibility)) continue;
            if (isInterface) {
                this.trace.report(Errors.EXPOSED_SUPER_INTERFACE.on((KtSuperTypeListEntry)((PsiElement)delegationList.get(i)), classVisibility, superTypeVisibility));
                continue;
            }
            this.trace.report(Errors.EXPOSED_SUPER_CLASS.on((KtSuperTypeListEntry)((PsiElement)delegationList.get(i)), classVisibility, superTypeVisibility));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration, ClassDescriptor classDescriptor) {
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration), classDescriptor));
        }
    }

    private final void checkClass(KtClass aClass2, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass2);
        this.checkTypeParameterConstraints(aClass2);
        FiniteBoundRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        NonExpansiveInheritanceRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        if (aClass2.isInterface()) {
            this.checkConstructorInInterface(aClass2);
            this.checkMethodsOfAnyInInterface(classDescriptor);
            if (aClass2.isLocal() && !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass2), classDescriptor));
            }
        } else if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ANNOTATION_CLASS)) {
            this.checkAnnotationClassWithBody(aClass2);
            this.checkValOnAnnotationParameter(aClass2);
        } else if (aClass2 instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass2, classDescriptor);
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtFunction member;
            if (Intrinsics.areEqual((Object)memberDescriptor.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true) continue;
            DeclarationDescriptor declarationDescriptor = memberDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "memberDescriptor");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (!(psiElement2 instanceof KtFunction)) {
                psiElement2 = null;
            }
            if ((member = (KtFunction)psiElement2) == null || !(memberDescriptor instanceof FunctionDescriptor)) continue;
            this.checkFunctionExposedType(member, (FunctionDescriptor)memberDescriptor);
            this.checkVarargParameters(member, memberDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        ConstructorDescriptor constructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor primaryConstructor2 = constructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration = ktPrimaryConstructor;
        for (KtElementImplStub parameter : declaration.getValueParameters()) {
            Unit unit;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter) != null) {
                void $receiver$iv;
                PropertyDescriptor it = (PropertyDescriptor)$receiver$iv;
                this.modifiersChecker.checkModifiersForDeclaration((KtDeclaration)((Object)parameter), it);
                KtCallableDeclaration ktCallableDeclaration = parameter;
                Intrinsics.checkExpressionValueIsNotNull(ktCallableDeclaration, "parameter");
                PropertyDescriptor propertyDescriptor = it;
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "it");
                this.checkPropertyLateInit(ktCallableDeclaration, propertyDescriptor);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        if (!declaration.hasConstructorKeyword()) {
            Unit unit;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null) {
                void $receiver$iv;
                KtElementImplStub parameter;
                parameter = ktModifierList;
                KtModifierList it = (KtModifierList)$receiver$iv;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)((PsiElement)it)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        ConstructorDescriptor constructorDescriptor2 = primaryConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(constructorDescriptor2, "primaryConstructor");
        this.checkConstructorDeclaration(constructorDescriptor2, declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            Unit unit;
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter) != null) {
                void $receiver$iv;
                TypeParameterDescriptor it = (TypeParameterDescriptor)$receiver$iv;
                DescriptorResolver.checkConflictingUpperBounds(this.trace, it, jetTypeParameter);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
    }

    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> constraints = typeParameterListOwner.getTypeConstraints();
        if (constraints.isEmpty()) {
            return;
        }
        for (KtTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            if (typeParameter.getExtendsBound() != null) {
                KtTypeParameter ktTypeParameter = typeParameter;
                Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter, "typeParameter");
                List<KtTypeConstraint> list = constraints;
                Intrinsics.checkExpressionValueIsNotNull(list, "constraints");
                if (DeclarationsChecker.Companion.hasConstraints(ktTypeParameter, list)) {
                    this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter)));
                }
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter) == null) {
                continue;
            }
            ClassifierDescriptor classifierDescriptor = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "typeParameterDescriptor");
            PsiElement psiElement2 = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "typeParameter");
            this.checkSupertypesForConsistency(classifierDescriptor, psiElement2);
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "typeParameterDescriptor");
            KtTypeParameter ktTypeParameter = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter, "typeParameter");
            this.checkOnlyOneTypeParameterBound(typeParameterDescriptor2, ktTypeParameter, typeParameterListOwner);
        }
    }

    private final void checkConstructorInInterface(KtClass klass) {
        Unit unit;
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor != null) {
            KtPrimaryConstructor $receiver$iv = ktPrimaryConstructor;
            KtPrimaryConstructor it = $receiver$iv;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor.getDeclaredCallableMembers()) {
            PsiElement declaration;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration));
        }
    }

    private final void checkAnnotationClassWithBody(KtClassOrObject classOrObject) {
        Unit unit;
        KtClassBody ktClassBody = classOrObject.getBody();
        if (ktClassBody != null) {
            KtClassBody $receiver$iv = ktClassBody;
            KtClassBody it = $receiver$iv;
            this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(it));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass2) {
        for (KtParameter parameter : aClass2.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVar()) continue;
            this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtNamedDeclaration member;
            if (Intrinsics.areEqual((Object)memberDescriptor.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true) continue;
            DeclarationDescriptor declarationDescriptor = memberDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "memberDescriptor");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (!(psiElement2 instanceof KtNamedDeclaration)) {
                psiElement2 = null;
            }
            if ((member = (KtNamedDeclaration)psiElement2) == null || !member.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member)));
        }
    }

    private final void checkProperty(KtProperty property, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "containingDeclaration");
            this.checkPropertyAbstractness(property, propertyDescriptor, classDescriptor);
        }
        this.checkPropertyLateInit(property, propertyDescriptor);
        this.checkPropertyInitializer(property, propertyDescriptor);
        this.checkAccessors(property, propertyDescriptor);
        this.checkTypeParameterConstraints(property);
        this.checkPropertyExposedType(property, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor2) {
        Iterator<TypeParameterDescriptor> iterator2 = descriptor2.getTypeParameters().iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameter;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
            if (DeclarationsChecker.Companion.isTypeParameterUsedInReceiverType(typeParameterDescriptor, descriptor2)) continue;
            DeclarationDescriptor declarationDescriptor = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "typeParameter");
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkPropertyLateInit(KtCallableDeclaration property, PropertyDescriptor propertyDescriptor) {
        boolean hasBackingField;
        boolean isAbstract;
        KtModifierList ktModifierList = property.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        PsiElement psiElement2 = modifierList.getModifier(KtTokens.LATEINIT_KEYWORD);
        if (psiElement2 == null) {
            return;
        }
        PsiElement modifier = psiElement2;
        if (!propertyDescriptor.isVar()) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is allowed only on mutable properties"));
        }
        boolean returnTypeIsNullable = true;
        boolean returnTypeIsPrimitive = true;
        KotlinType returnType2 = propertyDescriptor.getReturnType();
        if (returnType2 != null) {
            returnTypeIsNullable = TypeUtils.isNullableType(returnType2);
            returnTypeIsPrimitive = KotlinBuiltIns.isPrimitiveType(returnType2);
        }
        if (returnTypeIsNullable) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on nullable properties"));
        }
        if (returnTypeIsPrimitive) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primitive type properties"));
        }
        if (isAbstract = Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on abstract properties"));
        }
        if (property instanceof KtParameter) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primary constructor parameters"));
        }
        boolean hasDelegateExpressionOrInitializer = false;
        if (property instanceof KtProperty && ((KtProperty)property).hasDelegateExpressionOrInitializer()) {
            hasDelegateExpressionOrInitializer = true;
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with initializer or on delegated properties"));
        }
        boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
        if (!hasDelegateExpressionOrInitializer && hasAccessorImplementation) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with a custom getter or setter"));
        }
        Boolean bl = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        boolean bl2 = hasBackingField = bl != null ? bl : false;
        if (!(isAbstract || hasAccessorImplementation || hasDelegateExpressionOrInitializer || hasBackingField)) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties without backing field"));
        }
        if (propertyDescriptor.getExtensionReceiverParameter() != null) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on extension properties"));
        }
    }

    private final void checkPropertyAbstractness(KtProperty property, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor) {
        KtModifierList modifierList = property.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                PsiElement psiElement2 = property;
                String string = property.getName();
                if (string == null) {
                    string = "";
                }
                this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement2, string, classDescriptor));
                return;
            }
            if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.INTERFACE)) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property)));
            }
        }
        if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            KtPropertyAccessor setter;
            Unit unit;
            Unit unit2;
            KtElement it;
            KtPropertyDelegate $receiver$iv;
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression != null) {
                KtExpression ktExpression2 = ktExpression;
                it = (KtExpression)((Object)$receiver$iv);
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)it));
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
            if (ktPropertyDelegate != null) {
                $receiver$iv = ktPropertyDelegate;
                it = $receiver$iv;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)it));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            KtPropertyAccessor getter = property.getGetter();
            if (getter != null && getter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter)));
            }
            if ((setter = property.getSetter()) != null && setter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter)));
            }
        }
    }

    private final void checkPropertyInitializer(KtProperty property, PropertyDescriptor propertyDescriptor) {
        boolean backingFieldRequired;
        boolean inTrait;
        boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean bl = inTrait = containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)containingDeclaration).getKind(), (Object)ClassKind.INTERFACE);
        if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            if (inTrait && property.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
            }
            return;
        }
        Boolean bl2 = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        boolean bl3 = backingFieldRequired = bl2 != null ? bl2 : false;
        if (inTrait && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
        }
        KtExpression initializer2 = property.getInitializer();
        KtPropertyDelegate delegate2 = property.getDelegate();
        if (initializer2 != null) {
            if (inTrait) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer2)));
            } else if (!backingFieldRequired) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            } else if (property.getReceiverTypeReference() != null) {
                this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            }
        } else if (delegate2 != null) {
            if (inTrait) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate2)));
            }
        } else if (backingFieldRequired && !inTrait && !propertyDescriptor.isLateInit() && Intrinsics.areEqual(Boolean.TRUE, (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor))) {
            if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                this.trace.report(Errors.MUST_BE_INITIALIZED.on((KtProperty)((PsiElement)property)));
            } else {
                this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
            }
        } else if (property.getTypeReference() == null) {
            this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
        }
    }

    private final void checkMemberReceiverExposedType(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor) {
        if (typeReference == null) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        EffectiveVisibility memberVisibility = EffectiveVisibilityKt.effectiveVisibility(memberDescriptor);
        EffectiveVisibility receiverTypeVisibility = EffectiveVisibilityKt.effectiveVisibility(receiverParameterDescriptor2.getType());
        if (!receiverTypeVisibility.sameOrMorePermissive(memberVisibility)) {
            this.trace.report(Errors.EXPOSED_RECEIVER_TYPE.on((KtTypeReference)((PsiElement)typeReference), memberVisibility, receiverTypeVisibility));
        }
    }

    private final void checkPropertyExposedType(KtProperty property, PropertyDescriptor propertyDescriptor) {
        EffectiveVisibility propertyVisibility = EffectiveVisibilityKt.effectiveVisibility(propertyDescriptor);
        EffectiveVisibility typeVisibility = EffectiveVisibilityKt.effectiveVisibility(propertyDescriptor.getType());
        if (!typeVisibility.sameOrMorePermissive(propertyVisibility)) {
            this.trace.report(Errors.EXPOSED_PROPERTY_TYPE.on((KtProperty)((PsiElement)property), propertyVisibility, typeVisibility));
        }
        this.checkMemberReceiverExposedType(property.getReceiverTypeReference(), propertyDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunction(KtNamedFunction function, SimpleFunctionDescriptor functionDescriptor) {
        Unit unit;
        KtTypeParameterList typeParameterList = function.getTypeParameterList();
        PsiElement nameIdentifier = function.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null && typeParameterList.getTextRange().getStartOffset() > nameIdentifier.getTextRange().getStartOffset()) {
            this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
        }
        this.checkTypeParameterConstraints(function);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = function.hasModifier(KtTokens.EXTERNAL_KEYWORD);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inTrait = Intrinsics.areEqual((Object)((ClassDescriptor)containingDescriptor).getKind(), (Object)ClassKind.INTERFACE);
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractMembers((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if (hasAbstractModifier && inTrait) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function)));
            }
            if ((hasBody = function.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
            }
            if (!hasBody && inTrait && function.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inTrait)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
            }
            return;
        }
        if (!(function.hasBody() || hasAbstractModifier || hasExternalModifier)) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
        }
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (kotlinType != null) {
            void $receiver$iv;
            KotlinType inTrait = kotlinType;
            KotlinType it = (KotlinType)$receiver$iv;
            if (TypeUtilsKt.isNothing(it) && !function.hasDeclaredReturnType()) {
                PsiElement psiElement2 = nameIdentifier;
                if (psiElement2 == null) {
                    psiElement2 = function;
                }
                this.trace.report(Errors.IMPLICIT_NOTHING_RETURN_TYPE.on(psiElement2));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        this.checkFunctionExposedType(function, functionDescriptor);
        this.checkVarargParameters(function, functionDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(KtDeclaration declaration, CallableDescriptor callableDescriptor) {
        void $receiver$iv;
        Iterable iterable = callableDescriptor.getValueParameters();
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            if (!(it.getVarargElementType() != null)) continue;
            ++count$iv;
        }
        int numberOfVarargParameters = count$iv;
        if (numberOfVarargParameters > 1) {
            this.trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtDeclaration)((PsiElement)declaration)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunctionExposedType(KtFunction function, FunctionDescriptor functionDescriptor) {
        void $receiver$iv;
        Object returnTypeVisibility;
        EffectiveVisibility functionVisibility = EffectiveVisibilityKt.effectiveVisibility(functionDescriptor);
        if (!(function instanceof KtConstructor)) {
            KotlinType kotlinType = functionDescriptor.getReturnType();
            Object object = returnTypeVisibility = kotlinType != null ? EffectiveVisibilityKt.effectiveVisibility(kotlinType) : null;
            if (returnTypeVisibility != null && !((EffectiveVisibility)returnTypeVisibility).sameOrMorePermissive(functionVisibility)) {
                PsiElement psiElement2 = function.getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = function;
                }
                this.trace.report(Errors.EXPOSED_FUNCTION_RETURN_TYPE.on(psiElement2, functionVisibility, (EffectiveVisibility)returnTypeVisibility));
            }
        }
        returnTypeVisibility = functionDescriptor.getValueParameters();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void parameterDescriptor;
            int n = index$iv++;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            int i = n;
            EffectiveVisibility typeVisibility = EffectiveVisibilityKt.effectiveVisibility(parameterDescriptor.getType());
            if (typeVisibility.sameOrMorePermissive(functionVisibility) || i >= function.getValueParameters().size()) continue;
            this.trace.report(Errors.EXPOSED_PARAMETER_TYPE.on((KtParameter)((PsiElement)function.getValueParameters().get(i)), functionVisibility, typeVisibility));
        }
        this.checkMemberReceiverExposedType(function.getReceiverTypeReference(), functionDescriptor);
    }

    private final void checkAccessors(KtProperty property, PropertyDescriptor propertyDescriptor) {
        for (KtPropertyAccessor accessor : property.getAccessors()) {
            PropertyAccessorDescriptor propertyAccessorDescriptor;
            if ((accessor.isGetter() ? (PropertyAccessorDescriptor)propertyDescriptor.getGetter() : (PropertyAccessorDescriptor)propertyDescriptor.getSetter()) == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No property accessor descriptor for " + property.getText())));
            }
            propertyAccessorDescriptor = propertyAccessorDescriptor;
            this.checkTypeReferences(accessor);
            this.modifiersChecker.checkModifiersForDeclaration(accessor, propertyAccessorDescriptor);
            KtDeclaration ktDeclaration = accessor;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "accessor");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        this.checkAccessor(propertyDescriptor, property.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement2 : tokens) {
            this.trace.report(diagnostic.on(psiElement2));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList accessorModifierList = ktModifierList;
        Map<KtModifierKeywordToken, PsiElement> tokens = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, (Collection<KtModifierKeywordToken>)Sets.newHashSet(KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD));
        if (accessor.isGetter()) {
            if (Intrinsics.areEqual(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility()) ^ true) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.GETTER_VISIBILITY\u2026_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (ModalityKt.isOverridable(propertyDescriptor) && Intrinsics.areEqual(accessorDescriptor.getVisibility(), Visibilities.PRIVATE) && Intrinsics.areEqual(propertyDescriptor.getVisibility(), Visibilities.PRIVATE) ^ true) {
            if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (propertyDescriptor.isLateInit() && Intrinsics.areEqual(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility()) ^ true) {
            Collection<PsiElement> collection = tokens.values();
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_DIFFERS_FROM_LATEINIT_VISIBILITY;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.SETTER_VISIBILITY\u2026_FROM_LATEINIT_VISIBILITY");
            this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
        } else {
            Integer compare = Visibilities.compare(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility());
            if (compare == null || ((Number)compare).intValue() > 0) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.SETTER_VISIBILITY\u2026_WITH_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor classDescriptor) {
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration();
        if (DescriptorUtils.isEnumClass(declaration)) {
            if (!enumEntry.hasInitializer()) {
                DeclarationDescriptor declarationDescriptor = declaration;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                if (!DeclarationsChecker.Companion.hasDefaultConstructor((ClassDescriptor)declarationDescriptor)) {
                    this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on((KtClass)((PsiElement)enumEntry)));
                }
            }
        } else {
            Unit unit;
            boolean bl = DescriptorUtils.isInterface(declaration);
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Enum entry should be declared in enum class: " + classDescriptor;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
        }
    }

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(descriptorResolver, "descriptorResolver");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        Intrinsics.checkParameterIsNotNull(annotationChecker, "annotationChecker");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.modifiersChecker = modifiersChecker.withTrace(this.trace);
    }

    static {
        Companion = org.jetbrains.kotlin.resolve.DeclarationsChecker$Companion.INSTANCE;
        METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");
    }

    @NotNull
    public static final /* synthetic */ BindingTrace access$getTrace$p(DeclarationsChecker $this) {
        return $this.trace;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"a\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0005\b\u000b\u0005!!!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001c\t\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQe\u0004\u0003\u0002\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u00073\u0019Ai!\u0004\u0003\n\u0005%\t\u0001t\u0002\r\bK!!\u0011\u0001\u0003\u0005\u000e\u0003a)\u0011d\u0001E\t\u001b\u0005A\u0012\"\n\u0005\u0005\u0003!MQ\"\u0001\r\u00063\rA!\"D\u0001\u0019\u0016\u0015BA!\u0001\u0005\f\u001b\u0005AR!G\u0002\t\u00155\t\u0001TC\u0013\u0010\t\u0005A9\"D\u0001\u0019\u000be\u0019\u0001BC\u0007\u00021+Ib\u0001\u0003\u0007\u000e\t%\u0011\u0011\"\u0001\r\n13)C\u0002B\u0001\t\u001b5\t\u0001$B\r\u0004\u00117i\u0011\u0001\u0007\b\u001a\u0007!uQ\"\u0001\r\u0010K-!\u0011\u0001c\b\u000e\u0003a\u0001\u0012D\u0002E\u0011\u001b\u0011I!!C\u0001\u0019#aeQE\u0002\u0003\u0002\u0011Gi\u0011\u0001G\u0003\u0016\u0003ay\u0011&\b\u0003B\u0011!\rQbE\u0005\u0007\u0013\u0015\u00012!\u0006\u0002\r\u0002a\u0015\u0001T\u0001\t\u0004+%Ia!C\u0003\u0011\u0007U\u0011A\u0012\u0001M\u00031\u000ba\t\u0001\u0007\u0002\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011Aq\u0001\u0005\u0005"}, strings={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "()V", "METHOD_OF_ANY_NAMES", "Lcom/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "getMETHOD_OF_ANY_NAMES", "()Lcom/google/common/collect/ImmutableSet;", "hasConstraints", "", "typeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "hasDefaultConstructor", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isHidingParentMemberIfPresent", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAny", "isImplementingMethodOfAnyInternal", "visitedClasses", "", "isTypeParameterUsedInReceiverType", "parameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "removeDuplicateTypes", "", "conflictingTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasAccessorImplementation"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                KotlinType type2 = iterator2.next();
                for (KotlinType otherType : conflictingTypes) {
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block2: {
                if (typeParameter.getName() == null) {
                    return false;
                }
                Iterable $receiver$iv = constraints;
                for (Object element$iv : $receiver$iv) {
                    KtTypeConstraint it = (KtTypeConstraint)element$iv;
                    KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
                    if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null, typeParameter.getName())) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }

        private final ImmutableSet<String> getMETHOD_OF_ANY_NAMES() {
            return METHOD_OF_ANY_NAMES;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member) {
            if (!this.getMETHOD_OF_ANY_NAMES().contains(member.getName().asString())) {
                return false;
            }
            if (Intrinsics.areEqual((Object)member.getModality(), (Object)Modality.ABSTRACT)) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member, Set<ClassDescriptor> visitedClasses) {
            for (CallableMemberDescriptor callableMemberDescriptor : member.getOverriddenDescriptors()) {
                DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual(DescriptorUtils.getFqName(containingDeclaration), KotlinBuiltIns.FQ_NAMES.any)) {
                    return true;
                }
                CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor2, "overridden");
                if (this.isHidingParentMemberIfPresent(callableMemberDescriptor2)) continue;
                DeclarationDescriptor declarationDescriptor = containingDeclaration;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "containingDeclaration");
                visitedClasses.add((ClassDescriptor)declarationDescriptor);
                CallableMemberDescriptor callableMemberDescriptor3 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor3, "overridden");
                if (!this.isImplementingMethodOfAnyInternal(callableMemberDescriptor3, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member) {
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(member);
            if (!(psiElement2 instanceof KtNamedDeclaration)) {
                psiElement2 = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement2;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            KtModifierList modifierList = ktModifierList;
            return !modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        private final boolean isTypeParameterUsedInReceiverType(TypeParameterDescriptor parameter, PropertyDescriptor descriptor2) {
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                return false;
            }
            ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
            return TypeUtils.containsSpecialType(receiverParameter.getType(), new Function1<KotlinType, Boolean>(parameter){
                final /* synthetic */ TypeParameterDescriptor $parameter;

                public final boolean invoke(KotlinType it) {
                    return Intrinsics.areEqual(this.$parameter, it.getConstructor().getDeclarationDescriptor());
                }
                {
                    this.$parameter = typeParameterDescriptor;
                    super(1);
                }
            });
        }

        private final boolean hasDefaultConstructor(ClassDescriptor classDescriptor) {
            boolean bl;
            block1: {
                Iterable $receiver$iv = classDescriptor.getConstructors();
                for (Object element$iv : $receiver$iv) {
                    ConstructorDescriptor it = (ConstructorDescriptor)element$iv;
                    if (!it.getValueParameters().isEmpty()) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean hasAccessorImplementation(PropertyDescriptor $receiver) {
            Unit unit;
            Unit unit2;
            PropertyAccessorDescriptor it;
            PropertyAccessorDescriptor $receiver$iv;
            PropertyGetterDescriptor propertyGetterDescriptor = $receiver.getGetter();
            if (propertyGetterDescriptor != null) {
                $receiver$iv = propertyGetterDescriptor;
                it = $receiver$iv;
                if (it.hasBody()) {
                    return true;
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            PropertySetterDescriptor propertySetterDescriptor = $receiver.getSetter();
            if (propertySetterDescriptor != null) {
                $receiver$iv = propertySetterDescriptor;
                it = (PropertySetterDescriptor)$receiver$iv;
                if (it.hasBody()) {
                    return true;
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return false;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

