/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.validation;

import com.intellij.psi.PsiElement;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u0019\u0001\u0001\"\"G\u0001\u0019\u0002u\u0005!\")\u0002R\u0007\u0005A\u0011!\n\t\u0005\u0003!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)Qe\u0006\u0003\f\u0011\u0017i\u0011\u0001\u0007\u0002\u001a\r!1Q\u0002B\u0005\u0002\t\u0007a\t\u0001'\u0004\u001a\u0007!9Q\"\u0001M\b3\rA\u0001\"D\u0001\u0019\u0012e\u0019\u0001\"C\u0007\u00021'\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/validation/OperatorValidator;", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "()V", "checkDeprecatedUnaryConventions", "", "call", "Lorg/jetbrains/kotlin/psi/Call;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "validateCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "Companion"}, moduleName="kotlin-compiler")
public final class OperatorValidator
implements SymbolUsageValidator {
    public static final Companion Companion = org.jetbrains.kotlin.resolve.validation.OperatorValidator$Companion.INSTANCE;

    @Override
    public void validateCall(@Nullable ResolvedCall<?> resolvedCall, @NotNull CallableDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        CallableDescriptor callableDescriptor = targetDescriptor;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!OperatorValidator.Companion.checkNotErrorOrDynamic(functionDescriptor2)) {
            return;
        }
        PsiElement psiElement2 = element;
        if (!(psiElement2 instanceof KtElement)) {
            psiElement2 = null;
        }
        KtElement ktElement = (KtElement)psiElement2;
        if (ktElement == null) {
            return;
        }
        KtElement jetElement = ktElement;
        ResolvedCall<?> resolvedCall2 = resolvedCall;
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getCall()) == null) {
            resolvedCall2 = (Call)trace.getBindingContext().get(BindingContext.CALL, jetElement);
        }
        ResolvedCall<?> call = resolvedCall2;
        Function0<Boolean> isInvokeCall$ = new Function0<Boolean>((Call)((Object)call)){
            final /* synthetic */ Call $call;

            public final boolean invoke() {
                return this.$call instanceof CallTransformer.CallForImplicitInvoke;
            }
            {
                this.$call = call;
                super(0);
            }
        };
        Function0<Boolean> isMultiDeclaration$ = new Function0<Boolean>(resolvedCall, (Call)((Object)call)){
            final /* synthetic */ ResolvedCall $resolvedCall;
            final /* synthetic */ Call $call;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke() {
                if (this.$resolvedCall == null) return false;
                Call call = this.$call;
                if (!((call != null ? call.getCallElement() : null) instanceof KtMultiDeclarationEntry)) return false;
                return true;
            }
            {
                this.$resolvedCall = resolvedCall;
                this.$call = call;
                super(0);
            }
        };
        Function0<Boolean> isConventionOperator$ = new Function0<Boolean>(jetElement){
            final /* synthetic */ KtElement $jetElement;

            public final boolean invoke() {
                if (!(this.$jetElement instanceof KtOperationReferenceExpression)) {
                    return false;
                }
                return KtOperationReferenceExpression.getNameForConventionalOperation$default((KtOperationReferenceExpression)this.$jetElement, false, false, 3) != null;
            }
            {
                this.$jetElement = ktElement;
                super(0);
            }
        };
        Function0<Boolean> isArrayAccessExpression$ = new Function0<Boolean>(jetElement){
            final /* synthetic */ KtElement $jetElement;

            public final boolean invoke() {
                return this.$jetElement instanceof KtArrayAccessExpression;
            }
            {
                this.$jetElement = ktElement;
                super(0);
            }
        };
        if (isMultiDeclaration$.invoke() || isInvokeCall$.invoke()) {
            if (!functionDescriptor2.isOperator() && call != null) {
                PsiElement psiElement3 = call.getCallElement();
                Intrinsics.checkExpressionValueIsNotNull(psiElement3, "call.callElement");
                Companion.report(psiElement3, functionDescriptor2, trace);
            }
            return;
        }
        boolean isConventionOperator = isConventionOperator$.invoke();
        if (isConventionOperator || isArrayAccessExpression$.invoke()) {
            if (!functionDescriptor2.isOperator()) {
                Companion.report(jetElement, functionDescriptor2, trace);
            }
            if (isConventionOperator && call != null) {
                this.checkDeprecatedUnaryConventions((Call)((Object)call), functionDescriptor2, trace);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDeprecatedUnaryConventions(Call call, FunctionDescriptor functionDescriptor, DiagnosticSink sink) {
        Unit unit;
        KtElement ktElement = call.getCallElement();
        if (!(ktElement instanceof KtPrefixExpression)) {
            ktElement = null;
        }
        KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)ktElement;
        if (ktPrefixExpression != null) {
            void $receiver;
            KtPrefixExpression ktPrefixExpression2 = ktPrefixExpression;
            KtPrefixExpression expr = (KtPrefixExpression)$receiver;
            Name functionName = functionDescriptor.getName();
            if (!Intrinsics.areEqual(functionName, OperatorNameConventions.INSTANCE.getPLUS())) {
                if (Intrinsics.areEqual(functionName, OperatorNameConventions.INSTANCE.getMINUS())) {
                }
            } else {
                Name newName = Intrinsics.areEqual(functionName, OperatorNameConventions.INSTANCE.getPLUS()) ? OperatorNameConventions.INSTANCE.getUNARY_PLUS() : OperatorNameConventions.INSTANCE.getUNARY_MINUS();
                sink.report(Errors.DEPRECATED_UNARY_PLUS_MINUS.on((KtUnaryExpression)((PsiElement)expr), functionDescriptor, newName.asString()));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    @Override
    public void validateTypeUsage(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        SymbolUsageValidator.DefaultImpls.validateTypeUsage(this, targetDescriptor, trace, element);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0011\u0019\u001d\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0013\t\t\u0005A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\r)s\u0002c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001dA\r\u0004\u0011\u0019i\u0011\u0001'\u0004"}, strings={"Lorg/jetbrains/kotlin/resolve/validation/OperatorValidator$Companion;", "", "()V", "checkNotErrorOrDynamic", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "report", "", "element", "Lcom/intellij/psi/PsiElement;", "descriptor", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        public final void report(@NotNull PsiElement element, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink sink) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(sink, "sink");
            if (!this.checkNotErrorOrDynamic(descriptor2)) {
                return;
            }
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            String containingDeclarationName = DescriptorUtilsKt.getFqNameUnsafe(containingDeclaration).asString();
            sink.report(Errors.OPERATOR_MODIFIER_REQUIRED.on(element, descriptor2, containingDeclarationName));
        }

        private final boolean checkNotErrorOrDynamic(FunctionDescriptor functionDescriptor) {
            return !DynamicCallsKt.isDynamic(functionDescriptor) && !ErrorUtils.isError(functionDescriptor);
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

