/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.AnalyzeTryCatchBlocksKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"c\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u0006\u000b\u0005!1!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u000f)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u0011\u000b\u0005!!!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001\u0002\u0002\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005A\u0011!B\u0001\u0005\u0005\u0011\u0001A\u0002A\r\u00021\u0003\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Qe\u0004\u0003\u0002\u0011MiA!\u0003\u0002\n\u0003aM\u0001tE\r\u0004\u0011Qi\u0011\u0001g\u0005\u001a\u0007!%R\"\u0001\r\u0013K\rAQ#D\u0001\u0019\f\u0015BA!\u0001E\u0016\u001b\u0005Ab#G\u0002\t.5\t\u00014C\u0013\u0004\u0011]i\u0011\u0001g\u0003&\u0011\u0011\t\u0001rF\u0007\u00021aI2\u0001\u0003\u000b\u000e\u0003aMQ\u0005\u0003\u0003\u0002\u0011ci\u0011\u0001\u0007\r\u001a\u0007!!R\"\u0001M\nK!!\u0011\u0001C\r\u000e\u0003aA\u0012d\u0001\u0005\u0015\u001b\u0005A\u001a\"\n\u0005\u0005\u0003!MR\"\u0001\r\u00193\rAA#D\u0001\u0019\u0014\u0015BA!\u0001\u0005\u001b\u001b\u0005A\u0002$G\u0002\t)5\t\u00014C\u0015\u000e\t\rC\u0001RA\u0007\u0005\u0013\tI\u0011\u0001g\u0002\u0019\u0007E\u001bA!\u0002\u0001\u000e\u0005\u0011!\u0001\u0012B\u0015\u0013\t\rc\u0002BB\u0007\u00021\u0017I2\u0001C\u0003\u000e\u0003a-\u0001%I)\u0004\u000f\u0015\u0001QB\u0001C\u0007\u0011\u001d\t\"\u0001b\u0004\t\u0011%jAa\u0011\u0005\t\u00125!\u0011BA\u0005\u00021'A\u0012\"U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0006\t\u0016%jAa\u0011\u0005\t\u00175!\u0011BA\u0005\u00021'A\u0012\"U\u0002\u0005\u000b\u0001i!\u0001b\u0006\t\u0016%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001\u0003\r\u00113I\u0003\u0003B\"\t\u00115iq!\u0003\u0002\n\u0003aM\u0011BA\u0005\u00021'AZ\"U\u0002\u0005\u000b\u0001i!\u0001\u0002\b\t\u001e%\u001aBa\u0011\u0005\t\u001f5Q\u0011BA\u0005\u00021'IQ!\u0003\u0003\n\u0005%\t\u00014\u0003M\u001017\t6\u0001B\u0003\u0001\u001b\t!\u0001\u0003#\b*!\u0011\u0019\u0005\u0002#\t\u000e\u000f%\u0011\u0011\"\u0001M\n\u0013\tI\u0011\u0001g\u0005\u0019\u001cE\u001bA!\u0002\u0001\u000e\u0005\u0011\t\u0002RD\u0015\u0011\t\rC\u00012E\u0007\b\u0013\tI\u0011\u0001\u0007\n\n\u0005%\t\u00014\u0003M\u000e#\u000e!Q\u0001A\u0007\u0003\tKAi\u0002"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "breakContinueGotoNodes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "getBreakContinueGotoNodes", "()Ljava/util/LinkedHashSet;", "<set-?>", "", "consistentInlineMarkers", "getConsistentInlineMarkers", "()Z", "setConsistentInlineMarkers", "(Z)V", "fakeAlwaysFalseIfeqMarkers", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getFakeAlwaysFalseIfeqMarkers", "()Ljava/util/ArrayList;", "fakeAlwaysTrueIfeqMarkers", "getFakeAlwaysTrueIfeqMarkers", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "openingInlineMethodMarker", "Ljava/util/HashMap;", "getOpeningInlineMethodMarker", "()Ljava/util/HashMap;", "restoreStackMarkersForSaveMarker", "", "getRestoreStackMarkersForSaveMarker", "saveStackMarkerForRestoreMarker", "getSaveStackMarkerForRestoreMarker", "saveStackNodesForTryStartLabel", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getSaveStackNodesForTryStartLabel", "findMatchingSaveNodes", "", "insnNode", "restoreLabel", "hasAnyMarkers", "indexOf", "", "node", "isAnalysisRequired", "visitFakeAlwaysFalseIfeq", "", "visitFakeAlwaysTrueIfeq", "visitFixStackBeforeJump", "visitRestoreStackInTryCatch", "visitSaveStackBeforeTry"}, moduleName="kotlin-compiler")
public final class FixStackContext {
    @NotNull
    private final LinkedHashSet<JumpInsnNode> breakContinueGotoNodes;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysTrueIfeqMarkers;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysFalseIfeqMarkers;
    @NotNull
    private final HashMap<LabelNode, AbstractInsnNode> saveStackNodesForTryStartLabel;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> saveStackMarkerForRestoreMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, List<AbstractInsnNode>> restoreStackMarkersForSaveMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> openingInlineMethodMarker;
    private boolean consistentInlineMarkers;
    @NotNull
    private final MethodNode methodNode;

    @NotNull
    public final LinkedHashSet<JumpInsnNode> getBreakContinueGotoNodes() {
        return this.breakContinueGotoNodes;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysTrueIfeqMarkers() {
        return this.fakeAlwaysTrueIfeqMarkers;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysFalseIfeqMarkers() {
        return this.fakeAlwaysFalseIfeqMarkers;
    }

    @NotNull
    public final HashMap<LabelNode, AbstractInsnNode> getSaveStackNodesForTryStartLabel() {
        return this.saveStackNodesForTryStartLabel;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getSaveStackMarkerForRestoreMarker() {
        return this.saveStackMarkerForRestoreMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, List<AbstractInsnNode>> getRestoreStackMarkersForSaveMarker() {
        return this.restoreStackMarkersForSaveMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getOpeningInlineMethodMarker() {
        return this.openingInlineMethodMarker;
    }

    public final boolean getConsistentInlineMarkers() {
        return this.consistentInlineMarkers;
    }

    private final void visitFixStackBeforeJump(AbstractInsnNode insnNode) {
        Unit unit;
        AbstractInsnNode next = insnNode.getNext();
        boolean value = next.getOpcode() == 167;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value) {
                String message = this.indexOf(insnNode) + ": should be followed by GOTO";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        AbstractInsnNode abstractInsnNode = next;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        this.breakContinueGotoNodes.add((JumpInsnNode)abstractInsnNode);
    }

    private final void visitFakeAlwaysTrueIfeq(AbstractInsnNode insnNode) {
        Unit unit;
        boolean value = insnNode.getNext().getOpcode() == 153;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value) {
                String message = this.indexOf(insnNode) + ": should be followed by IFEQ";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.fakeAlwaysTrueIfeqMarkers.add(insnNode);
    }

    private final void visitFakeAlwaysFalseIfeq(AbstractInsnNode insnNode) {
        Unit unit;
        boolean value = insnNode.getNext().getOpcode() == 153;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value) {
                String message = this.indexOf(insnNode) + ": should be followed by IFEQ";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.fakeAlwaysFalseIfeqMarkers.add(insnNode);
    }

    private final void visitSaveStackBeforeTry(AbstractInsnNode insnNode) {
        Unit unit;
        AbstractInsnNode tryStartLabel = insnNode.getNext();
        boolean value = tryStartLabel instanceof LabelNode;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value) {
                String message = this.indexOf(insnNode) + ": save should be followed by a label";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        AbstractInsnNode abstractInsnNode = tryStartLabel;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LabelNode");
        }
        MapsKt.set(this.saveStackNodesForTryStartLabel, (LabelNode)abstractInsnNode, insnNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void visitRestoreStackInTryCatch(AbstractInsnNode insnNode) {
        Object object;
        void $receiver;
        void $receiver2;
        AbstractInsnNode restoreLabel;
        AbstractInsnNode it2;
        Object finger;
        AbstractInsnNode $receiver3 = insnNode;
        for (finger = $receiver3.getPrevious(); finger != null && !UtilKt.hasOpcode(it2 = finger); finger = ((AbstractInsnNode)finger).getPrevious()) {
        }
        AbstractInsnNode abstractInsnNode = finger;
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        $receiver3 = abstractInsnNode;
        for (finger = $receiver3.getPrevious(); finger != null && !((it2 = finger) instanceof LabelNode || UtilKt.hasOpcode(it2)); finger = ((AbstractInsnNode)finger).getPrevious()) {
        }
        AbstractInsnNode abstractInsnNode2 = finger;
        if (abstractInsnNode2 == null) {
            Intrinsics.throwNpe();
        }
        if (!((restoreLabel = abstractInsnNode2) instanceof LabelNode)) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": restore should be preceded by a catch block label")));
        }
        List<AbstractInsnNode> saveNodes = this.findMatchingSaveNodes(insnNode, (LabelNode)restoreLabel);
        if (saveNodes.isEmpty()) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": in handler " + this.indexOf(restoreLabel) + " restore is not matched with save")));
        }
        finger = saveNodes;
        if ($receiver2.size() > 1) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": in handler " + this.indexOf(restoreLabel) + " restore is matched with several saves")));
        }
        AbstractInsnNode saveNode = CollectionsKt.first(saveNodes);
        MapsKt.set(this.saveStackMarkerForRestoreMarker, insnNode, saveNode);
        Map $i$f$size = this.restoreStackMarkersForSaveMarker;
        Object value = $receiver.get(saveNode);
        if (value == null && !$receiver.containsKey(saveNode)) {
            SmartList answer = new SmartList();
            $receiver.put(saveNode, answer);
            object = answer;
        } else {
            object = value;
        }
        ((List)object).add(insnNode);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbstractInsnNode> findMatchingSaveNodes(AbstractInsnNode insnNode, LabelNode restoreLabel) {
        void $receiver;
        SmartHashSet<AbstractInsnNode> saveNodes = new SmartHashSet<AbstractInsnNode>();
        Iterable iterable = this.methodNode.tryCatchBlocks;
        for (Object element : $receiver) {
            Boolean bl;
            TryCatchBlockNode tcb = (TryCatchBlockNode)element;
            if (!Intrinsics.areEqual(restoreLabel, tcb.start) && !Intrinsics.areEqual(restoreLabel, tcb.handler)) continue;
            if (this.getSaveStackNodesForTryStartLabel().get(tcb.start) != null) {
                void $receiver2;
                AbstractInsnNode it2 = (AbstractInsnNode)$receiver2;
                bl = saveNodes.add(it2);
                continue;
            }
            bl = null;
        }
        return new SmartList((Collection)saveNodes);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.methodNode.instructions.indexOf(node);
    }

    public final boolean hasAnyMarkers() {
        return CollectionsKt.isNotEmpty((Collection)this.breakContinueGotoNodes) || CollectionsKt.isNotEmpty((Collection)this.fakeAlwaysTrueIfeqMarkers) || CollectionsKt.isNotEmpty((Collection)this.fakeAlwaysFalseIfeqMarkers) || MapsKt.isNotEmpty((Map)this.saveStackNodesForTryStartLabel) || MapsKt.isNotEmpty((Map)this.openingInlineMethodMarker);
    }

    public final boolean isAnalysisRequired() {
        return CollectionsKt.isNotEmpty((Collection)this.breakContinueGotoNodes) || MapsKt.isNotEmpty((Map)this.saveStackNodesForTryStartLabel) || MapsKt.isNotEmpty((Map)this.openingInlineMethodMarker);
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    /*
     * WARNING - void declaration
     */
    public FixStackContext(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        this.methodNode = methodNode;
        this.breakContinueGotoNodes = SetsKt.linkedSetOf(new JumpInsnNode[0]);
        this.fakeAlwaysTrueIfeqMarkers = CollectionsKt.arrayListOf(new AbstractInsnNode[0]);
        this.fakeAlwaysFalseIfeqMarkers = CollectionsKt.arrayListOf(new AbstractInsnNode[0]);
        this.saveStackNodesForTryStartLabel = MapsKt.hashMapOf(new Pair[0]);
        this.saveStackMarkerForRestoreMarker = MapsKt.hashMapOf(new Pair[0]);
        this.restoreStackMarkersForSaveMarker = MapsKt.hashMapOf(new Pair[0]);
        this.openingInlineMethodMarker = MapsKt.hashMapOf(new Pair[0]);
        this.consistentInlineMarkers = true;
        AnalyzeTryCatchBlocksKt.insertTryCatchBlocksMarkers(this.methodNode);
        Stack<AbstractInsnNode> inlineMarkersStack = new Stack<AbstractInsnNode>();
        InsnList insnList = this.methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull(insnList, "methodNode.instructions");
        Sequence $receiver = new InsnSequence(insnList);
        Iterator iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            Unit unit;
            Object element = iterator2.next();
            AbstractInsnNode insnNode = (AbstractInsnNode)element;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(insnNode);
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FIX_STACK_BEFORE_JUMP)) {
                this.visitFixStackBeforeJump(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FAKE_ALWAYS_TRUE_IFEQ)) {
                this.visitFakeAlwaysTrueIfeq(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FAKE_ALWAYS_FALSE_IFEQ)) {
                this.visitFakeAlwaysFalseIfeq(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.SAVE_STACK_BEFORE_TRY)) {
                this.visitSaveStackBeforeTry(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.RESTORE_STACK_IN_TRY_CATCH)) {
                this.visitRestoreStackInTryCatch(insnNode);
                continue;
            }
            if (InlineCodegenUtil.isBeforeInlineMarker(insnNode)) {
                inlineMarkersStack.push(insnNode);
                continue;
            }
            if (!InlineCodegenUtil.isAfterInlineMarker(insnNode)) continue;
            boolean bl = CollectionsKt.isNotEmpty((Collection)inlineMarkersStack);
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value;
                if (value == false) {
                    String message = "Mismatching after inline method marker at " + this.indexOf(insnNode);
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            Map map2 = this.getOpeningInlineMethodMarker();
            Object t = inlineMarkersStack.pop();
            Intrinsics.checkExpressionValueIsNotNull(t, "inlineMarkersStack.pop()");
            MapsKt.set(map2, insnNode, t);
        }
        if (CollectionsKt.isNotEmpty((Collection)inlineMarkersStack)) {
            this.consistentInlineMarkers = false;
        }
    }

    public static final /* synthetic */ boolean access$getConsistentInlineMarkers$p(FixStackContext $this) {
        return $this.consistentInlineMarkers;
    }

    public static final /* synthetic */ void access$setConsistentInlineMarkers$p(FixStackContext $this, boolean bl) {
        $this.consistentInlineMarkers = bl;
    }
}

