/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.CharIterator;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.name.State;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(FqName $receiver, @NotNull FqName packageName) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        if (Intrinsics.areEqual($receiver, packageName)) {
            bl = true;
        } else if (packageName.isRoot()) {
            bl = true;
        } else {
            String string = $receiver.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "this.asString()");
            String string2 = packageName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageName.asString()");
            bl = FqNamesUtilKt.isSubpackageOf(string, string2);
        }
        return bl;
    }

    private static final boolean isSubpackageOf(String subpackageNameStr, String packageNameStr) {
        return StringsKt.startsWith$default(subpackageNameStr, packageNameStr, false, 2) && subpackageNameStr.charAt(CollectionsKt.length(packageNameStr)) == '.';
    }

    public static final boolean isOneSegmentFQN(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return !$receiver.isRoot() && $receiver.parent().isRoot();
    }

    @NotNull
    public static final FqName tail(FqName $receiver, @NotNull FqName prefix) {
        FqName fqName2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        if (!FqNamesUtilKt.isSubpackageOf($receiver, prefix) || prefix.isRoot()) {
            fqName2 = $receiver;
        } else if (Intrinsics.areEqual($receiver, prefix)) {
            FqName fqName3 = FqName.ROOT;
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "FqName.ROOT");
        } else {
            fqName2 = new FqName(StringsKt.substring($receiver.asString(), CollectionsKt.length(prefix.asString()) + 1));
        }
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "when {\n        !isSubpac\u2026ng().length() + 1))\n    }");
        return fqName2;
    }

    @Nullable
    public static final FqName parentOrNull(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.isRoot() ? (FqName)null : $receiver.parent();
    }

    public static final boolean isValidJavaFqName(@Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        State state2 = State.BEGINNING;
        CharIterator charIterator = StringsKt.iterator(qualifiedName);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            switch (FqNamesUtilKt$WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierPart(c)) {
                        return false;
                    }
                    state2 = State.MIDDLE;
                    break;
                }
                case 3: {
                    if (c == '.') {
                        state2 = State.AFTER_DOT;
                        break;
                    }
                    if (Character.isJavaIdentifierPart(c)) break;
                    return false;
                }
            }
        }
        return Intrinsics.areEqual((Object)state2, (Object)State.AFTER_DOT) ^ true;
    }
}

