/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypesUtil {
    @NonNls
    private static final Map<String, String> ourUnboxedTypes = new THashMap<String, String>();
    @NonNls
    private static final Map<String, String> ourBoxedTypes = new THashMap<String, String>();

    private PsiTypesUtil() {
    }

    public static String getDefaultValueOfType(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            PsiClassType classType;
            int count = type2.getArrayDimensions() - 1;
            PsiType componentType = type2.getDeepComponentType();
            if (componentType instanceof PsiClassType && (classType = (PsiClassType)componentType).resolve() instanceof PsiTypeParameter) {
                return "null";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("new");
            buffer.append(" ");
            buffer.append(componentType.getCanonicalText());
            buffer.append("[0]");
            for (int i = 0; i < count; ++i) {
                buffer.append("[]");
            }
            return buffer.toString();
        }
        if (type2 instanceof PsiPrimitiveType) {
            if (PsiType.BOOLEAN.equals(type2)) {
                return "false";
            }
            return "0";
        }
        return "null";
    }

    @Nullable
    public static String unboxIfPossible(String type2) {
        if (type2 == null) {
            return null;
        }
        String s = ourUnboxedTypes.get(type2);
        return s == null ? type2 : s;
    }

    @Nullable
    public static String boxIfPossible(String type2) {
        if (type2 == null) {
            return null;
        }
        String s = ourBoxedTypes.get(type2);
        return s == null ? type2 : s;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiType psiType) {
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
    }

    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/util/PsiTypesUtil", "getClassType"));
        }
        return JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
    }

    @Nullable
    public static PsiClassType getLowestUpperBoundClassType(@NotNull PsiDisjunctionType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/util/PsiTypesUtil", "getLowestUpperBoundClassType"));
        }
        PsiType lub = type2.getLeastUpperBound();
        if (lub instanceof PsiClassType) {
            return (PsiClassType)lub;
        }
        if (lub instanceof PsiIntersectionType) {
            for (PsiType subType : ((PsiIntersectionType)lub).getConjuncts()) {
                PsiClass aClass;
                if (!(subType instanceof PsiClassType) || (aClass = ((PsiClassType)subType).resolve()) == null || aClass.isInterface()) continue;
                return (PsiClassType)subType;
            }
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiExpression call, @NotNull PsiReferenceExpression methodExpression, @NotNull PsiMethod method, @Nullable Condition<IElementType> condition, @NotNull LanguageLevel languageLevel) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/psi/util/PsiTypesUtil", "patchMethodGetClassReturnType"));
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/psi/util/PsiTypesUtil", "patchMethodGetClassReturnType"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/PsiTypesUtil", "patchMethodGetClassReturnType"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/util/PsiTypesUtil", "patchMethodGetClassReturnType"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && PsiTypesUtil.isGetClass(method)) {
            PsiExpression qualifier2 = methodExpression.getQualifierExpression();
            PsiType qualifierType = null;
            Project project = call.getProject();
            if (qualifier2 != null) {
                qualifierType = TypeConversionUtil.erasure(qualifier2.getType());
            } else if (condition != null) {
                ASTNode parent2;
                for (parent2 = call.getNode().getTreeParent(); parent2 != null && condition.value(parent2.getElementType()); parent2 = parent2.getTreeParent()) {
                }
                if (parent2 != null) {
                    qualifierType = JavaPsiFacade.getInstance(project).getElementFactory().createType((PsiClass)parent2.getPsi());
                }
            }
            return PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true);
        }
        return null;
    }

    public static boolean isGetClass(PsiMethod method) {
        return "getClass".equals(method.getName()) && "java.lang.Object".equals(method.getContainingClass().getQualifiedName());
    }

    @Nullable
    public static PsiType createJavaLangClassType(@NotNull PsiElement context, @Nullable PsiType qualifierType, boolean captureTopLevelWildcards) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/util/PsiTypesUtil", "createJavaLangClassType"));
        }
        if (qualifierType != null) {
            PsiUtil.ensureValidType(qualifierType);
            JavaPsiFacade facade = JavaPsiFacade.getInstance(context.getProject());
            PsiClass javaLangClass = facade.findClass("java.lang.Class", context.getResolveScope());
            if (javaLangClass != null && javaLangClass.getTypeParameters().length == 1) {
                PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY.put(javaLangClass.getTypeParameters()[0], PsiWildcardType.createExtends(context.getManager(), qualifierType));
                PsiClassType classType = facade.getElementFactory().createType(javaLangClass, substitutor2, PsiUtil.getLanguageLevel(context));
                return captureTopLevelWildcards ? PsiUtil.captureToplevelWildcards(classType, context) : classType;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getExpectedTypeByParent(PsiElement methodCall) {
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(methodCall.getParent());
        if (parent2 instanceof PsiVariable) {
            if (PsiUtil.checkSameExpression(methodCall, ((PsiVariable)parent2).getInitializer())) {
                return ((PsiVariable)parent2).getType();
            }
        } else if (parent2 instanceof PsiAssignmentExpression) {
            if (PsiUtil.checkSameExpression(methodCall, ((PsiAssignmentExpression)parent2).getRExpression())) {
                return ((PsiAssignmentExpression)parent2).getLExpression().getType();
            }
        } else if (parent2 instanceof PsiReturnStatement) {
            Object psiElement2 = PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, PsiMethod.class);
            if (psiElement2 instanceof PsiLambdaExpression) {
                return null;
            }
            if (psiElement2 instanceof PsiMethod) {
                return ((PsiMethod)psiElement2).getReturnType();
            }
        } else {
            if (PsiUtil.isCondition(methodCall, parent2)) {
                return PsiType.BOOLEAN.getBoxedType(parent2);
            }
            if (parent2 instanceof PsiArrayInitializerExpression) {
                PsiElement gParent = parent2.getParent();
                if (gParent instanceof PsiNewExpression) {
                    PsiType type2 = ((PsiNewExpression)gParent).getType();
                    if (type2 instanceof PsiArrayType) {
                        return ((PsiArrayType)type2).getComponentType();
                    }
                } else if (gParent instanceof PsiVariable) {
                    PsiType type3 = ((PsiVariable)gParent).getType();
                    if (type3 instanceof PsiArrayType) {
                        return ((PsiArrayType)type3).getComponentType();
                    }
                } else if (gParent instanceof PsiArrayInitializerExpression) {
                    PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiExpression)parent2);
                    return expectedTypeByParent != null && expectedTypeByParent instanceof PsiArrayType ? ((PsiArrayType)expectedTypeByParent).getComponentType() : null;
                }
            }
        }
        return null;
    }

    public static boolean compareTypes(PsiType leftType, PsiType rightType, boolean ignoreEllipsis) {
        if (ignoreEllipsis) {
            if (leftType instanceof PsiEllipsisType) {
                leftType = ((PsiEllipsisType)leftType).toArrayType();
            }
            if (rightType instanceof PsiEllipsisType) {
                rightType = ((PsiEllipsisType)rightType).toArrayType();
            }
        }
        return Comparing.equal(leftType, rightType);
    }

    public static boolean isDenotableType(PsiType type2) {
        return !(type2 instanceof PsiWildcardType) && !(type2 instanceof PsiCapturedWildcardType);
    }

    public static boolean hasUnresolvedComponents(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/util/PsiTypesUtil", "hasUnresolvedComponents"));
        }
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                PsiClass psiClass = classType.resolve();
                if (psiClass == null) {
                    return true;
                }
                for (PsiType param : classType.getParameters()) {
                    if (!param.accept(this).booleanValue()) continue;
                    return true;
                }
                return (Boolean)super.visitClassType(classType);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                return bound != null && bound.accept(this) != false;
            }

            @Override
            public Boolean visitType(PsiType type2) {
                return false;
            }
        });
    }

    static {
        ourUnboxedTypes.put("java.lang.Boolean", "boolean");
        ourUnboxedTypes.put("java.lang.Byte", "byte");
        ourUnboxedTypes.put("java.lang.Short", "short");
        ourUnboxedTypes.put("java.lang.Integer", "int");
        ourUnboxedTypes.put("java.lang.Long", "long");
        ourUnboxedTypes.put("java.lang.Float", "float");
        ourUnboxedTypes.put("java.lang.Double", "double");
        ourUnboxedTypes.put("java.lang.Character", "char");
        ourBoxedTypes.put("boolean", "java.lang.Boolean");
        ourBoxedTypes.put("byte", "java.lang.Byte");
        ourBoxedTypes.put("short", "java.lang.Short");
        ourBoxedTypes.put("int", "java.lang.Integer");
        ourBoxedTypes.put("long", "java.lang.Long");
        ourBoxedTypes.put("float", "java.lang.Float");
        ourBoxedTypes.put("double", "java.lang.Double");
        ourBoxedTypes.put("char", "java.lang.Character");
    }
}

