/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import com.google.protobuf.MessageLite;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PossiblyInnerType;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.MutableTypeTable;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.Interner;

public class DescriptorSerializer {
    private final DeclarationDescriptor containingDeclaration;
    private final Interner<TypeParameterDescriptor> typeParameters;
    private final SerializerExtension extension;
    private final MutableTypeTable typeTable;
    private final boolean serializeTypeTableToFunction;

    private DescriptorSerializer(@Nullable DeclarationDescriptor containingDeclaration, @NotNull Interner<TypeParameterDescriptor> typeParameters, @NotNull SerializerExtension extension, @NotNull MutableTypeTable typeTable, boolean serializeTypeTableToFunction) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "<init>"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "<init>"));
        }
        if (typeTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeTable", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "<init>"));
        }
        this.containingDeclaration = containingDeclaration;
        this.typeParameters = typeParameters;
        this.extension = extension;
        this.typeTable = typeTable;
        this.serializeTypeTableToFunction = serializeTypeTableToFunction;
    }

    @NotNull
    public byte[] serialize(@NotNull MessageLite message) {
        byte[] byArray;
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "serialize"));
        }
        try {
            ByteArrayOutputStream result2 = new ByteArrayOutputStream();
            this.getStringTable().serializeTo(result2);
            message.writeTo(result2);
            byArray = result2.toByteArray();
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "serialize"));
        }
        return byArray;
    }

    @NotNull
    public static DescriptorSerializer createTopLevel(@NotNull SerializerExtension extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "createTopLevel"));
        }
        DescriptorSerializer descriptorSerializer = new DescriptorSerializer(null, new Interner<TypeParameterDescriptor>(), extension, new MutableTypeTable(), false);
        if (descriptorSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "createTopLevel"));
        }
        return descriptorSerializer;
    }

    @NotNull
    public static DescriptorSerializer createForLambda(@NotNull SerializerExtension extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "createForLambda"));
        }
        DescriptorSerializer descriptorSerializer = new DescriptorSerializer(null, new Interner<TypeParameterDescriptor>(), extension, new MutableTypeTable(), true);
        if (descriptorSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "createForLambda"));
        }
        return descriptorSerializer;
    }

    @NotNull
    public static DescriptorSerializer create(@NotNull ClassDescriptor descriptor2, @NotNull SerializerExtension extension) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "create"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "create"));
        }
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        DescriptorSerializer parentSerializer = container instanceof ClassDescriptor ? DescriptorSerializer.create((ClassDescriptor)container, extension) : DescriptorSerializer.createTopLevel(extension);
        DescriptorSerializer serializer = new DescriptorSerializer(descriptor2, new Interner<TypeParameterDescriptor>(parentSerializer.typeParameters), parentSerializer.extension, new MutableTypeTable(), false);
        for (TypeParameterDescriptor typeParameter : descriptor2.getDeclaredTypeParameters()) {
            serializer.typeParameters.intern(typeParameter);
        }
        DescriptorSerializer descriptorSerializer = serializer;
        if (descriptorSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "create"));
        }
        return descriptorSerializer;
    }

    @NotNull
    private DescriptorSerializer createChildSerializer(@NotNull CallableDescriptor callable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "createChildSerializer"));
        }
        DescriptorSerializer descriptorSerializer = new DescriptorSerializer(callable, new Interner<TypeParameterDescriptor>(this.typeParameters), this.extension, this.typeTable, false);
        if (descriptorSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "createChildSerializer"));
        }
        return descriptorSerializer;
    }

    @NotNull
    public StringTable getStringTable() {
        StringTable stringTable = this.extension.getStringTable();
        if (stringTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "getStringTable"));
        }
        return stringTable;
    }

    private boolean useTypeTable() {
        return this.extension.shouldUseTypeTable();
    }

    @NotNull
    public ProtoBuf.Class.Builder classProto(@NotNull ClassDescriptor classDescriptor) {
        ProtoBuf.TypeTable typeTable;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "classProto"));
        }
        ProtoBuf.Class.Builder builder = ProtoBuf.Class.newBuilder();
        int flags = Flags.getClassFlags(DescriptorSerializer.hasAnnotations(classDescriptor), classDescriptor.getVisibility(), classDescriptor.getModality(), classDescriptor.getKind(), classDescriptor.isInner(), classDescriptor.isCompanionObject(), classDescriptor.isData());
        if (flags != builder.getFlags()) {
            builder.setFlags(flags);
        }
        builder.setFqName(this.getClassId(classDescriptor));
        for (TypeParameterDescriptor typeParameterDescriptor : classDescriptor.getDeclaredTypeParameters()) {
            builder.addTypeParameter(this.typeParameter(typeParameterDescriptor));
        }
        if (!KotlinBuiltIns.isSpecialClassWithNoSupertypes(classDescriptor)) {
            for (KotlinType kotlinType : classDescriptor.getTypeConstructor().getSupertypes()) {
                if (this.useTypeTable()) {
                    builder.addSupertypeId(this.typeId(kotlinType));
                    continue;
                }
                builder.addSupertype(this.type(kotlinType));
            }
        }
        for (ConstructorDescriptor constructorDescriptor : classDescriptor.getConstructors()) {
            builder.addConstructor(this.constructorProto(constructorDescriptor));
        }
        for (DeclarationDescriptor declarationDescriptor : DescriptorSerializer.sort(DescriptorUtils.getAllDescriptors(classDescriptor.getDefaultType().getMemberScope()))) {
            CallableMemberDescriptor member;
            if (!(declarationDescriptor instanceof CallableMemberDescriptor) || (member = (CallableMemberDescriptor)declarationDescriptor).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            if (declarationDescriptor instanceof PropertyDescriptor) {
                builder.addProperty(this.propertyProto((PropertyDescriptor)declarationDescriptor));
                continue;
            }
            if (!(declarationDescriptor instanceof FunctionDescriptor)) continue;
            builder.addFunction(this.functionProto((FunctionDescriptor)declarationDescriptor));
        }
        for (DeclarationDescriptor declarationDescriptor : DescriptorSerializer.sort(DescriptorUtils.getAllDescriptors(classDescriptor.getUnsubstitutedInnerClassesScope()))) {
            int name = this.getSimpleNameIndex(declarationDescriptor.getName());
            if (DescriptorUtils.isEnumEntry(declarationDescriptor)) {
                builder.addEnumEntry(name);
                continue;
            }
            builder.addNestedClassName(name);
        }
        ClassDescriptor companionObjectDescriptor2 = classDescriptor.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            builder.setCompanionObjectName(this.getSimpleNameIndex(companionObjectDescriptor2.getName()));
        }
        if ((typeTable = this.typeTable.serialize()) != null) {
            builder.setTypeTable(typeTable);
        }
        this.extension.serializeClass(classDescriptor, builder);
        ProtoBuf.Class.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "classProto"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Property.Builder propertyProto(@NotNull PropertyDescriptor descriptor2) {
        int flags;
        PropertySetterDescriptor setter;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "propertyProto"));
        }
        ProtoBuf.Property.Builder builder = ProtoBuf.Property.newBuilder();
        DescriptorSerializer local = this.createChildSerializer(descriptor2);
        boolean hasGetter = false;
        boolean hasSetter = false;
        boolean lateInit = descriptor2.isLateInit();
        boolean isConst = descriptor2.isConst();
        ConstantValue<?> compileTimeConstant = descriptor2.getCompileTimeInitializer();
        boolean hasConstant = compileTimeConstant != null && !(compileTimeConstant instanceof NullValue);
        boolean hasAnnotations = !descriptor2.getAnnotations().getAllAnnotations().isEmpty();
        int propertyFlags = Flags.getAccessorFlags(hasAnnotations, descriptor2.getVisibility(), descriptor2.getModality(), false, false);
        PropertyGetterDescriptor getter = descriptor2.getGetter();
        if (getter != null) {
            hasGetter = true;
            int accessorFlags = DescriptorSerializer.getAccessorFlags(getter);
            if (accessorFlags != propertyFlags) {
                builder.setGetterFlags(accessorFlags);
            }
        }
        if ((setter = descriptor2.getSetter()) != null) {
            hasSetter = true;
            int accessorFlags = DescriptorSerializer.getAccessorFlags(setter);
            if (accessorFlags != propertyFlags) {
                builder.setSetterFlags(accessorFlags);
            }
            if (!setter.isDefault()) {
                DescriptorSerializer setterLocal = local.createChildSerializer(setter);
                for (ValueParameterDescriptor valueParameterDescriptor : setter.getValueParameters()) {
                    builder.setSetterValueParameter(setterLocal.valueParameter(valueParameterDescriptor));
                }
            }
        }
        if ((flags = Flags.getPropertyFlags(hasAnnotations, descriptor2.getVisibility(), descriptor2.getModality(), descriptor2.getKind(), descriptor2.isVar(), hasGetter, hasSetter, hasConstant, isConst, lateInit)) != builder.getFlags()) {
            builder.setFlags(flags);
        }
        builder.setName(this.getSimpleNameIndex(descriptor2.getName()));
        if (this.useTypeTable()) {
            builder.setReturnTypeId(local.typeId(descriptor2.getType()));
        } else {
            builder.setReturnType(local.type(descriptor2.getType()));
        }
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            if (this.useTypeTable()) {
                builder.setReceiverTypeId(local.typeId(receiverParameter.getType()));
            } else {
                builder.setReceiverType(local.type(receiverParameter.getType()));
            }
        }
        this.extension.serializeProperty(descriptor2, builder);
        ProtoBuf.Property.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "propertyProto"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Function.Builder functionProto(@NotNull FunctionDescriptor descriptor2) {
        ProtoBuf.TypeTable typeTableProto;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "functionProto"));
        }
        ProtoBuf.Function.Builder builder = ProtoBuf.Function.newBuilder();
        DescriptorSerializer local = this.createChildSerializer(descriptor2);
        int flags = Flags.getFunctionFlags(DescriptorSerializer.hasAnnotations(descriptor2), descriptor2.getVisibility(), descriptor2.getModality(), descriptor2.getKind(), descriptor2.isOperator(), descriptor2.isInfix(), descriptor2.isInline(), descriptor2.isTailrec(), descriptor2.isExternal());
        if (flags != builder.getFlags()) {
            builder.setFlags(flags);
        }
        builder.setName(this.getSimpleNameIndex(descriptor2.getName()));
        if (this.useTypeTable()) {
            builder.setReturnTypeId(local.typeId(descriptor2.getReturnType()));
        } else {
            builder.setReturnType(local.type(descriptor2.getReturnType()));
        }
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            if (this.useTypeTable()) {
                builder.setReceiverTypeId(local.typeId(receiverParameter.getType()));
            } else {
                builder.setReceiverType(local.type(receiverParameter.getType()));
            }
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getValueParameters()) {
            builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
        }
        if (this.serializeTypeTableToFunction && (typeTableProto = this.typeTable.serialize()) != null) {
            builder.setTypeTable(typeTableProto);
        }
        this.extension.serializeFunction(descriptor2, builder);
        ProtoBuf.Function.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "functionProto"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Constructor.Builder constructorProto(@NotNull ConstructorDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "constructorProto"));
        }
        ProtoBuf.Constructor.Builder builder = ProtoBuf.Constructor.newBuilder();
        DescriptorSerializer local = this.createChildSerializer(descriptor2);
        int flags = Flags.getConstructorFlags(DescriptorSerializer.hasAnnotations(descriptor2), descriptor2.getVisibility(), !descriptor2.isPrimary());
        if (flags != builder.getFlags()) {
            builder.setFlags(flags);
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getValueParameters()) {
            builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
        }
        this.extension.serializeConstructor(descriptor2, builder);
        ProtoBuf.Constructor.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "constructorProto"));
        }
        return builder2;
    }

    private static int getAccessorFlags(@NotNull PropertyAccessorDescriptor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "getAccessorFlags"));
        }
        return Flags.getAccessorFlags(DescriptorSerializer.hasAnnotations(accessor), accessor.getVisibility(), accessor.getModality(), !accessor.isDefault(), accessor.isExternal());
    }

    @NotNull
    private ProtoBuf.ValueParameter.Builder valueParameter(@NotNull ValueParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "valueParameter"));
        }
        ProtoBuf.ValueParameter.Builder builder = ProtoBuf.ValueParameter.newBuilder();
        int flags = Flags.getValueParameterFlags(DescriptorSerializer.hasAnnotations(descriptor2), descriptor2.declaresDefaultValue(), descriptor2.isCrossinline(), descriptor2.isNoinline());
        if (flags != builder.getFlags()) {
            builder.setFlags(flags);
        }
        builder.setName(this.getSimpleNameIndex(descriptor2.getName()));
        if (this.useTypeTable()) {
            builder.setTypeId(this.typeId(descriptor2.getType()));
        } else {
            builder.setType(this.type(descriptor2.getType()));
        }
        KotlinType varargElementType = descriptor2.getVarargElementType();
        if (varargElementType != null) {
            if (this.useTypeTable()) {
                builder.setVarargElementTypeId(this.typeId(varargElementType));
            } else {
                builder.setVarargElementType(this.type(varargElementType));
            }
        }
        this.extension.serializeValueParameter(descriptor2, builder);
        ProtoBuf.ValueParameter.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "valueParameter"));
        }
        return builder2;
    }

    private ProtoBuf.TypeParameter.Builder typeParameter(TypeParameterDescriptor typeParameter) {
        ProtoBuf.TypeParameter.Variance variance;
        ProtoBuf.TypeParameter.Builder builder = ProtoBuf.TypeParameter.newBuilder();
        builder.setId(this.getTypeParameterId(typeParameter));
        builder.setName(this.getSimpleNameIndex(typeParameter.getName()));
        if (typeParameter.isReified() != builder.getReified()) {
            builder.setReified(typeParameter.isReified());
        }
        if ((variance = DescriptorSerializer.variance(typeParameter.getVariance())) != builder.getVariance()) {
            builder.setVariance(variance);
        }
        this.extension.serializeTypeParameter(typeParameter, builder);
        List<KotlinType> upperBounds = typeParameter.getUpperBounds();
        if (upperBounds.size() == 1 && KotlinBuiltIns.isDefaultBound(CollectionsKt.single(upperBounds))) {
            return builder;
        }
        for (KotlinType upperBound : upperBounds) {
            if (this.useTypeTable()) {
                builder.addUpperBoundId(this.typeId(upperBound));
                continue;
            }
            builder.addUpperBound(this.type(upperBound));
        }
        return builder;
    }

    private static ProtoBuf.TypeParameter.Variance variance(Variance variance) {
        switch (variance) {
            case INVARIANT: {
                return ProtoBuf.TypeParameter.Variance.INV;
            }
            case IN_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.IN;
            }
            case OUT_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.OUT;
            }
        }
        throw new IllegalStateException("Unknown variance: " + (Object)((Object)variance));
    }

    private int typeId(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "typeId"));
        }
        return this.typeTable.get(this.type(type2));
    }

    @NotNull
    private ProtoBuf.Type.Builder type(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "type"));
        }
        assert (!type2.isError()) : "Can't serialize error types: " + type2;
        if (FlexibleTypesKt.isFlexible(type2)) {
            Flexibility flexibility = FlexibleTypesKt.flexibility(type2);
            ProtoBuf.Type.Builder lowerBound = this.type(flexibility.getLowerBound());
            lowerBound.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex(flexibility.getExtraCapabilities().getId()));
            if (this.useTypeTable()) {
                lowerBound.setFlexibleUpperBoundId(this.typeId(flexibility.getUpperBound()));
            } else {
                lowerBound.setFlexibleUpperBound(this.type(flexibility.getUpperBound()));
            }
            ProtoBuf.Type.Builder builder = lowerBound;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "type"));
            }
            return builder;
        }
        ProtoBuf.Type.Builder builder = ProtoBuf.Type.newBuilder();
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (descriptor2 instanceof ClassDescriptor) {
            PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
            assert (possiblyInnerType != null) : "possiblyInnerType should not be null in case of class";
            this.fillFromPossiblyInnerType(builder, possiblyInnerType);
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)descriptor2;
            if (typeParameter.getContainingDeclaration() == this.containingDeclaration) {
                builder.setTypeParameterName(this.getSimpleNameIndex(typeParameter.getName()));
            } else {
                builder.setTypeParameter(this.getTypeParameterId(typeParameter));
            }
            assert (type2.getArguments().isEmpty()) : "Found arguments for type constructor build on type parameter: " + descriptor2;
        }
        if (type2.isMarkedNullable() != builder.getNullable()) {
            builder.setNullable(type2.isMarkedNullable());
        }
        this.extension.serializeType(type2, builder);
        ProtoBuf.Type.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "type"));
        }
        return builder2;
    }

    private void fillFromPossiblyInnerType(@NotNull ProtoBuf.Type.Builder builder, @NotNull PossiblyInnerType type2) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "fillFromPossiblyInnerType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "fillFromPossiblyInnerType"));
        }
        builder.setClassName(this.getClassId(type2.getClassDescriptor()));
        for (TypeProjection projection : type2.getArguments()) {
            builder.addArgument(this.typeArgument(projection));
        }
        if (type2.getOuterType() != null) {
            ProtoBuf.Type.Builder outerBuilder = ProtoBuf.Type.newBuilder();
            this.fillFromPossiblyInnerType(outerBuilder, type2.getOuterType());
            if (this.useTypeTable()) {
                builder.setOuterTypeId(this.typeTable.get(outerBuilder));
            } else {
                builder.setOuterType(outerBuilder);
            }
        }
    }

    @NotNull
    private ProtoBuf.Type.Argument.Builder typeArgument(@NotNull TypeProjection typeProjection) {
        if (typeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "typeArgument"));
        }
        ProtoBuf.Type.Argument.Builder builder = ProtoBuf.Type.Argument.newBuilder();
        if (typeProjection.isStarProjection()) {
            builder.setProjection(ProtoBuf.Type.Argument.Projection.STAR);
        } else {
            ProtoBuf.Type.Argument.Projection projection = DescriptorSerializer.projection(typeProjection.getProjectionKind());
            if (projection != builder.getProjection()) {
                builder.setProjection(projection);
            }
            if (this.useTypeTable()) {
                builder.setTypeId(this.typeId(typeProjection.getType()));
            } else {
                builder.setType(this.type(typeProjection.getType()));
            }
        }
        ProtoBuf.Type.Argument.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "typeArgument"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Package.Builder packageProto(@NotNull Collection<PackageFragmentDescriptor> fragments2) {
        if (fragments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packageProto"));
        }
        ProtoBuf.Package.Builder builder = this.packageProto(fragments2, null);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packageProto"));
        }
        return builder;
    }

    @NotNull
    public ProtoBuf.Package.Builder packageProto(@NotNull Collection<PackageFragmentDescriptor> fragments2, @Nullable Function1<DeclarationDescriptor, Boolean> skip2) {
        if (fragments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packageProto"));
        }
        ProtoBuf.Package.Builder builder = ProtoBuf.Package.newBuilder();
        ArrayList<DeclarationDescriptor> members = new ArrayList<DeclarationDescriptor>();
        for (PackageFragmentDescriptor fragment : fragments2) {
            members.addAll(DescriptorUtils.getAllDescriptors(fragment.getMemberScope()));
        }
        for (DeclarationDescriptor declaration : DescriptorSerializer.sort(members)) {
            if (skip2 != null && skip2.invoke(declaration).booleanValue()) continue;
            if (declaration instanceof PropertyDescriptor) {
                builder.addProperty(this.propertyProto((PropertyDescriptor)declaration));
                continue;
            }
            if (!(declaration instanceof FunctionDescriptor)) continue;
            builder.addFunction(this.functionProto((FunctionDescriptor)declaration));
        }
        ProtoBuf.TypeTable typeTableProto = this.typeTable.serialize();
        if (typeTableProto != null) {
            builder.setTypeTable(typeTableProto);
        }
        this.extension.serializePackage(fragments2, builder);
        ProtoBuf.Package.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packageProto"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Package.Builder packagePartProto(@NotNull Collection<DeclarationDescriptor> members) {
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packagePartProto"));
        }
        ProtoBuf.Package.Builder builder = ProtoBuf.Package.newBuilder();
        for (DeclarationDescriptor declaration : DescriptorSerializer.sort(members)) {
            if (declaration instanceof PropertyDescriptor) {
                builder.addProperty(this.propertyProto((PropertyDescriptor)declaration));
                continue;
            }
            if (!(declaration instanceof FunctionDescriptor)) continue;
            builder.addFunction(this.functionProto((FunctionDescriptor)declaration));
        }
        ProtoBuf.TypeTable typeTableProto = this.typeTable.serialize();
        if (typeTableProto != null) {
            builder.setTypeTable(typeTableProto);
        }
        ProtoBuf.Package.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "packagePartProto"));
        }
        return builder2;
    }

    @NotNull
    private static ProtoBuf.Type.Argument.Projection projection(@NotNull Variance projectionKind) {
        if (projectionKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionKind", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "projection"));
        }
        switch (projectionKind) {
            case INVARIANT: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.INV;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
            case IN_VARIANCE: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.IN;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
            case OUT_VARIANCE: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.OUT;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
        }
        throw new IllegalStateException("Unknown projectionKind: " + (Object)((Object)projectionKind));
    }

    private int getClassId(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "getClassId"));
        }
        return this.getStringTable().getFqNameIndex(descriptor2);
    }

    private int getSimpleNameIndex(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "getSimpleNameIndex"));
        }
        return this.getStringTable().getStringIndex(name.asString());
    }

    private int getTypeParameterId(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "getTypeParameterId"));
        }
        return this.typeParameters.intern(descriptor2);
    }

    private static boolean hasAnnotations(Annotated descriptor2) {
        return !descriptor2.getAnnotations().isEmpty();
    }

    @NotNull
    public static <T extends DeclarationDescriptor> List<T> sort(@NotNull Collection<T> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "sort"));
        }
        ArrayList<T> result2 = new ArrayList<T>(descriptors);
        Collections.sort(result2, MemberComparator.INSTANCE);
        ArrayList<T> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/DescriptorSerializer", "sort"));
        }
        return arrayList;
    }
}

