/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.checkers.ReflectionAPICallChecker$isReflectionAvailable$1;
import org.jetbrains.kotlin.resolve.jvm.checkers.ReflectionAPICallChecker$kPropertyClasses$1;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\f\u0015\tAAA\u0003\u0002\u0011E)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UC\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0003#\u000e\t\u0001bA\u0013\u0015\t-A\u0011\"D\u0001\u0019\u0014E!A\u0001\u0001\u0005\u000b+\u0005A*\"\u0007\u0004\t\u00175!\u0011BA\u0005\u0002I)A:\"G\u0002\t\u00195\t\u0001\u0014D\u0015\u000e\t\u0005C\u0001rA\u0007\u00021\u0011a\u0012%U\u0002\u0007\u000b\t!Q\u0001c\u0003\u000e\u0005\u0011\u001d\u0001\u0012B\u0015\u0011\t\u0005C\u0001BB\u0007\u0005\u0013\tI\u0011\u0001G\u0004\u0019\u000eq\t\u0013k\u0001\u0004\u0006\u0005\u0011E\u00012B\u0007\u0003\t\u001fA\u0001\"K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ReflectionAPICallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "isReflectionAvailable", "", "()Z", "isReflectionAvailable$delegate", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "kPropertyClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getKPropertyClasses", "()Ljava/util/Set;", "kPropertyClasses$delegate", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;"}, moduleName="kotlin-compiler")
public final class ReflectionAPICallChecker
implements CallChecker {
    private final NotNullLazyValue<Boolean> isReflectionAvailable$delegate;
    private final NotNullLazyValue<Set<? extends ClassDescriptor>> kPropertyClasses$delegate;
    private final ModuleDescriptor module;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final boolean isReflectionAvailable() {
        return StorageKt.getValue(this.isReflectionAvailable$delegate, (Object)this, $$delegatedProperties[0]);
    }

    private final Set<ClassDescriptor> getKPropertyClasses() {
        return StorageKt.getValue(this.kPropertyClasses$delegate, (Object)this, $$delegatedProperties[1]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (this.isReflectionAvailable()) {
            return;
        }
        F descriptor2 = resolvedCall.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor;
        if (!ReflectionTypes.Companion.isReflectionClass(containingClass)) {
            return;
        }
        Name name = descriptor2.getName();
        if (Intrinsics.areEqual(name, OperatorNameConventions.INSTANCE.getINVOKE())) {
            return;
        }
        if (Intrinsics.areEqual(name.asString(), "name")) {
            return;
        }
        if (Intrinsics.areEqual(name.asString(), "get") || Intrinsics.areEqual(name.asString(), "set")) {
            boolean bl;
            block9: {
                void $receiver;
                Iterable iterable = this.getKPropertyClasses();
                for (Object element : $receiver) {
                    ClassDescriptor kProperty = (ClassDescriptor)element;
                    if (!DescriptorUtils.isSubclass(containingClass, kProperty)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        context.trace.report(ErrorsJvm.NO_REFLECTION_IN_CLASS_PATH.on((KtElement)((PsiElement)resolvedCall.getCall().getCallElement())));
    }

    static {
        $$delegatedProperties = new KProperty[]{ReflectionAPICallChecker$isReflectionAvailable$1.INSTANCE, ReflectionAPICallChecker$kPropertyClasses$1.INSTANCE};
    }

    public ReflectionAPICallChecker(@NotNull ModuleDescriptor module2, @NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        this.module = module2;
        this.isReflectionAvailable$delegate = storageManager.createLazyValue((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ReflectionAPICallChecker this$0;

            public final boolean invoke() {
                ModuleDescriptor moduleDescriptor = ReflectionAPICallChecker.access$getModule$p(this.this$0);
                ClassId classId = JvmAbi.REFLECTION_FACTORY_IMPL;
                Intrinsics.checkExpressionValueIsNotNull(classId, "JvmAbi.REFLECTION_FACTORY_IMPL");
                return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId) != null;
            }
            {
                this.this$0 = reflectionAPICallChecker;
                super(0);
            }
        });
        this.kPropertyClasses$delegate = storageManager.createLazyValue((Function0)new Function0<Set<? extends ClassDescriptor>>(this){
            final /* synthetic */ ReflectionAPICallChecker this$0;

            @NotNull
            public final Set<ClassDescriptor> invoke() {
                ReflectionTypes reflectionTypes = new ReflectionTypes(ReflectionAPICallChecker.access$getModule$p(this.this$0));
                return SetsKt.setOf(reflectionTypes.getKProperty0(), reflectionTypes.getKProperty1(), reflectionTypes.getKProperty2());
            }
            {
                this.this$0 = reflectionAPICallChecker;
                super(0);
            }
        });
    }

    public static final /* synthetic */ boolean access$isReflectionAvailable$p(ReflectionAPICallChecker $this) {
        return $this.isReflectionAvailable();
    }

    @NotNull
    public static final /* synthetic */ Set access$getKPropertyClasses$p(ReflectionAPICallChecker $this) {
        return $this.getKPropertyClasses();
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModule$p(ReflectionAPICallChecker $this) {
        return $this.module;
    }
}

