/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\u000b\u0005\u0017!\rQ\"\u0001\r\u0003#\u0011!\u0001\u0001#\u0002\u0016\u0003a\u0019\u0011D\u0002E\u0004\u001b\u0011I!!C\u0001%\u0006a!\u0011d\u0001E\u0005\u001b\u0005AR!\n\t\u0005\u0003!-Q\"\u0001\r\u00033\rAa!D\u0001\u0019\u000ee\u0019\u0001bB\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003aEQ\u0005\u0005\u0003\u0002\u0011%i\u0011\u0001g\u0005\u001a\u0007!%Q\"\u0001\r\u000b3\rA)\"D\u0001\u0019\u0017e\u0019\u0001rC\u0007\u00021-)C\u0002B\u0001\t\u00195\t\u00014C\r\u0004\u0011/i\u0011\u0001G\u0006\u001a\u0007!UQ\"\u0001\r\f"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "checkCapturingInClosure", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "isCapturedInInline", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "scopeContainer", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "variableParent", "isCapturedVariable"}, moduleName="kotlin-compiler")
public final class CapturingInClosureChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        VariableDescriptor variableDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ResolvedCall<F> variableResolvedCall = resolvedCall instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall() : resolvedCall;
        F f = variableResolvedCall.getResultingDescriptor();
        if (!(f instanceof VariableDescriptor)) {
            f = null;
        }
        if ((variableDescriptor = (VariableDescriptor)f) != null) {
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            this.checkCapturingInClosure(variableDescriptor, bindingTrace, lexicalScope);
        }
    }

    private final void checkCapturingInClosure(VariableDescriptor variable, BindingTrace trace, LexicalScope scope2) {
        DeclarationDescriptor variableParent = variable.getContainingDeclaration();
        DeclarationDescriptor scopeContainer = scope2.getOwnerDescriptor();
        DeclarationDescriptor declarationDescriptor = variableParent;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "variableParent");
        if (this.isCapturedVariable(declarationDescriptor, scopeContainer) && Intrinsics.areEqual((Object)((CaptureKind)((Object)trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable))), (Object)CaptureKind.NOT_INLINE) ^ true) {
            BindingContext bindingContext2 = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
            DeclarationDescriptor declarationDescriptor2 = variableParent;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "variableParent");
            boolean inline = this.isCapturedInInline(bindingContext2, scopeContainer, declarationDescriptor2);
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable, inline ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE);
        }
    }

    private final boolean isCapturedVariable(DeclarationDescriptor variableParent, DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual(scopeContainer, variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            if (Intrinsics.areEqual(scopeContainer, classDescriptor)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual(((PropertyDescriptor)scopeContainer).getContainingDeclaration(), classDescriptor)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCapturedInInline(BindingContext context, DeclarationDescriptor scopeContainer, DeclarationDescriptor variableParent) {
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return false;
        }
        PsiElement psiElement2 = scopeDeclaration;
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        if (InlineUtil.isInlinedArgument((KtFunction)psiElement2, context, false)) {
            Unit unit;
            DeclarationDescriptor scopeContainerParent = scopeContainer.getContainingDeclaration();
            boolean bl = scopeContainerParent != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value;
                if (value == false) {
                    String message = "parent is null for " + scopeContainer;
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            DeclarationDescriptor declarationDescriptor = scopeContainerParent;
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "scopeContainerParent!!");
            return !this.isCapturedVariable(variableParent, declarationDescriptor) || this.isCapturedInInline(context, scopeContainerParent, variableParent);
        }
        return false;
    }
}

