/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContextImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public class AnnotationResolver {
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public AnnotationResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull StorageManager storageManager) {
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/AnnotationResolver", "<init>"));
        }
        if (constantExpressionEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpressionEvaluator", "org/jetbrains/kotlin/resolve/AnnotationResolver", "<init>"));
        }
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/AnnotationResolver", "<init>"));
        }
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.storageManager = storageManager;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/AnnotationResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    @NotNull
    public Annotations resolveAnnotationsWithoutArguments(@NotNull LexicalScope scope2, @Nullable KtModifierList modifierList, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        Annotations annotations2 = this.resolveAnnotations(scope2, modifierList, trace, false);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations resolveAnnotationsWithArguments(@NotNull LexicalScope scope2, @Nullable KtModifierList modifierList, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        Annotations annotations2 = this.resolveAnnotations(scope2, modifierList, trace, true);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations resolveAnnotationsWithoutArguments(@NotNull LexicalScope scope2, @NotNull List<KtAnnotationEntry> annotationEntries, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        if (annotationEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntries", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        Annotations annotations2 = this.resolveAnnotationEntries(scope2, annotationEntries, trace, false);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations resolveAnnotationsWithArguments(@NotNull LexicalScope scope2, @NotNull List<KtAnnotationEntry> annotationEntries, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (annotationEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntries", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        Annotations annotations2 = this.resolveAnnotationEntries(scope2, annotationEntries, trace, true);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        return annotations2;
    }

    private Annotations resolveAnnotations(@NotNull LexicalScope scope2, @Nullable KtModifierList modifierList, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotations"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotations"));
        }
        if (modifierList == null) {
            return Annotations.Companion.getEMPTY();
        }
        return this.resolveAnnotationEntries(scope2, modifierList.getAnnotationEntries(), trace, shouldResolveArguments);
    }

    private Annotations resolveAnnotationEntries(@NotNull LexicalScope scope2, @NotNull List<KtAnnotationEntry> annotationEntryElements, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (annotationEntryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntryElements", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (annotationEntryElements.isEmpty()) {
            return Annotations.Companion.getEMPTY();
        }
        ArrayList<AnnotationWithTarget> result2 = new ArrayList<AnnotationWithTarget>(0);
        for (KtAnnotationEntry entryElement : annotationEntryElements) {
            KtAnnotationUseSiteTarget target;
            AnnotationDescriptor descriptor2 = trace.get(BindingContext.ANNOTATION, entryElement);
            if (descriptor2 == null) {
                descriptor2 = new LazyAnnotationDescriptor(new LazyAnnotationsContextImpl(this, this.storageManager, trace, scope2), entryElement);
            }
            if (shouldResolveArguments) {
                ForceResolveUtil.forceResolveAllContents(descriptor2);
            }
            if ((target = entryElement.getUseSiteTarget()) != null) {
                result2.add(new AnnotationWithTarget(descriptor2, target.getAnnotationUseSiteTarget()));
                continue;
            }
            result2.add(new AnnotationWithTarget(descriptor2, null));
        }
        return AnnotationsImpl.create(result2);
    }

    @NotNull
    public KotlinType resolveAnnotationType(@NotNull LexicalScope scope2, @NotNull KtAnnotationEntry entryElement, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        if (entryElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryElement", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        KtTypeReference typeReference = entryElement.getTypeReference();
        if (typeReference == null) {
            KotlinType kotlinType = ErrorUtils.createErrorType("No type reference: " + entryElement.getText());
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
            }
            return kotlinType;
        }
        KotlinType type2 = this.typeResolver.resolveType(scope2, typeReference, trace, true);
        if (!(type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            KotlinType kotlinType = ErrorUtils.createErrorType("Not an annotation: " + type2);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationType"));
        }
        return kotlinType;
    }

    public static void checkAnnotationType(@NotNull KtAnnotationEntry entryElement, @NotNull BindingTrace trace, @NotNull OverloadResolutionResults<FunctionDescriptor> results) {
        if (entryElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryElement", "org/jetbrains/kotlin/resolve/AnnotationResolver", "checkAnnotationType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "checkAnnotationType"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/AnnotationResolver", "checkAnnotationType"));
        }
        if (!results.isSingleResult()) {
            return;
        }
        FunctionDescriptor descriptor2 = results.getResultingDescriptor();
        if (!ErrorUtils.isError(descriptor2)) {
            if (descriptor2 instanceof ConstructorDescriptor) {
                ConstructorDescriptor constructor = (ConstructorDescriptor)descriptor2;
                ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
                if (classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
                    trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, classDescriptor));
                }
            } else {
                trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, descriptor2));
            }
        }
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveAnnotationCall(KtAnnotationEntry annotationEntry, LexicalScope scope2, BindingTrace trace) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.callResolver.resolveFunctionCall(trace, scope2, CallMaker.makeCall(ReceiverValue.NO_RECEIVER, null, annotationEntry), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY, true);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnnotationResolver", "resolveAnnotationCall"));
        }
        return overloadResolutionResults;
    }

    public static void reportUnsupportedAnnotationForTypeParameter(@NotNull KtTypeParameter jetTypeParameter, @NotNull BindingTrace trace) {
        if (jetTypeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeParameter", "org/jetbrains/kotlin/resolve/AnnotationResolver", "reportUnsupportedAnnotationForTypeParameter"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "reportUnsupportedAnnotationForTypeParameter"));
        }
        KtModifierList modifierList = jetTypeParameter.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (KtAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            trace.report(Errors.UNSUPPORTED.on(annotationEntry, "Annotations for type parameters are not supported yet"));
        }
    }

    @Nullable
    public ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument resolvedArgument) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnnotationResolver", "getAnnotationArgumentValue"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/kotlin/resolve/AnnotationResolver", "getAnnotationArgumentValue"));
        }
        if (resolvedArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedArgument", "org/jetbrains/kotlin/resolve/AnnotationResolver", "getAnnotationArgumentValue"));
        }
        return this.constantExpressionEvaluator.getAnnotationArgumentValue(trace, valueParameter, resolvedArgument);
    }
}

