/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FrameNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001A\u0002A\r\u00021\u0003i\n\u0011BQ\u0003#\u000e\t\u0001\"A\u0013\r\t-A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0001"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "TransformerForMethod"}, moduleName="kotlin-compiler")
public final class LabelNormalizationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        new TransformerForMethod(methodNode).transform();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"e\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rA!\u0001\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\t\t\u0005A\u0011\"D\u0001\u0019\u0010e\u0019\u00012C\u0007\u00021\u001f)\u0003\u0002B\u0001\t\u00155\t\u0001tB\r\u0004\u0011'i\u0011\u0001g\u0004&\u0013\u0011\t\u0001RC\u0007\u0003\u0019\u0003A2\"G\u0002\t\u00185\t\u0001\u0004D\u0013\n\t\u0005AI\"\u0004\u0002\r\u0002aY\u0011d\u0001\u0005\u000e\u001b\u0005AZ\"\n\u0003\u0005\u0003!qQ\"\u0001M\u000fK%!\u0011\u0001C\b\u000e\u00051\u0005\u0001dC\r\u0004\u0011?i\u0011\u0001\u0007\t&\t\u0011\t\u0001\u0012E\u0007\u00021E)\u0013\u0002B\u0001\t$5\u0011A\u0012\u0001\r\f3\rA!#D\u0001\u0019&\u0015\"A!\u0001\u0005\u0014\u001b\u0005A\u0012#J\u0005\u0005\u0003!\u001dRB\u0001G\u00011-I2\u0001\u0003\n\u000e\u0003a!R\u0005\u0002\u0003\u0002\u0011Si\u0011\u0001G\t&\u0007!)R\"\u0001\r\u0012K\u0019!\u0011\u0001c\u000b\u000e\u0003aYQ#\u0001\r\rK\u0019!\u0011\u0001c\u000b\u000e\u0003aYQ#\u0001M\u000eK\u0019!\u0011\u0001c\u000b\u000e\u0003aYQ#\u0001\r\u0011K\u0019!\u0011\u0001c\u000b\u000e\u0003aYQ#\u0001M\u0013K\u0019!\u0011\u0001c\u000b\u000e\u0003aYQ#\u0001\r\u0015S9!1\t\u0003E\u0003\u001b\u0015\u0001:!\u0006\u0002\r\u0002a\u0019\u0001dA)\u0004\t\u0015\u0001QB\u0001\u0003\u0005\u0011\u0013I#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000b!-\u0011\u0006\u0005\u0003D\u0011!1QbB\u0005\u0003\u0013\u0005Ar!\u0003\u0002\n\u0003a=\u0001TB)\u0004\t\u0015\u0001QB\u0001\u0003\t\u0011#\u0001"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer$TransformerForMethod;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "getInstructions", "()Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "newLabelNodes", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/Label;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getNewLabelNodes", "()Ljava/util/HashMap;", "getNew", "oldLabelNode", "getNewOrOld", "rewriteFrameNode", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "oldFrameNode", "Lorg/jetbrains/org/objectweb/asm/tree/FrameNode;", "rewriteJumpInsn", "oldJumpNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "rewriteLabelInstructions", "", "rewriteLineNumberNode", "oldLineNode", "Lorg/jetbrains/org/objectweb/asm/tree/LineNumberNode;", "rewriteLocalVars", "", "rewriteLookupSwitchInsn", "oldSwitchNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "rewriteNonLabelInstructions", "rewriteTableSwitchInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "rewriteTryCatchBlocks", "transform", "rewriteLabels"}, moduleName="kotlin-compiler")
    private static final class TransformerForMethod {
        private final InsnList instructions;
        @NotNull
        private final HashMap<Label, LabelNode> newLabelNodes;
        @NotNull
        private final MethodNode methodNode;

        public final InsnList getInstructions() {
            return this.instructions;
        }

        @NotNull
        public final HashMap<Label, LabelNode> getNewLabelNodes() {
            return this.newLabelNodes;
        }

        public final void transform() {
            if (this.rewriteLabelInstructions()) {
                this.rewriteNonLabelInstructions();
                this.rewriteTryCatchBlocks();
                this.rewriteLocalVars();
            }
        }

        private final boolean rewriteLabelInstructions() {
            boolean removedAnyLabels = false;
            AbstractInsnNode thisNode = this.instructions.getFirst();
            while (thisNode != null) {
                if (thisNode instanceof LabelNode) {
                    AbstractInsnNode prevNode = ((LabelNode)thisNode).getPrevious();
                    if (prevNode instanceof LabelNode) {
                        Map map2 = this.newLabelNodes;
                        Label label = ((LabelNode)thisNode).getLabel();
                        Intrinsics.checkExpressionValueIsNotNull(label, "thisNode.label");
                        MapsKt.set(map2, label, prevNode);
                        removedAnyLabels = true;
                        thisNode = LabelNormalizationMethodTransformerKt.access$removeNodeGetNext(this.instructions, thisNode);
                        continue;
                    }
                    Map map3 = this.newLabelNodes;
                    Label label = ((LabelNode)thisNode).getLabel();
                    Intrinsics.checkExpressionValueIsNotNull(label, "thisNode.label");
                    MapsKt.set(map3, label, thisNode);
                    thisNode = ((LabelNode)thisNode).getNext();
                    continue;
                }
                thisNode = thisNode.getNext();
            }
            return removedAnyLabels;
        }

        private final void rewriteNonLabelInstructions() {
            AbstractInsnNode thisNode = this.instructions.getFirst();
            while (thisNode != null) {
                AbstractInsnNode abstractInsnNode = thisNode;
                thisNode = abstractInsnNode instanceof JumpInsnNode ? this.rewriteJumpInsn((JumpInsnNode)thisNode) : (abstractInsnNode instanceof LineNumberNode ? this.rewriteLineNumberNode((LineNumberNode)thisNode) : (abstractInsnNode instanceof LookupSwitchInsnNode ? this.rewriteLookupSwitchInsn((LookupSwitchInsnNode)thisNode) : (abstractInsnNode instanceof TableSwitchInsnNode ? this.rewriteTableSwitchInsn((TableSwitchInsnNode)thisNode) : (abstractInsnNode instanceof FrameNode ? this.rewriteFrameNode((FrameNode)thisNode) : thisNode.getNext()))));
            }
        }

        private final AbstractInsnNode rewriteLineNumberNode(LineNumberNode oldLineNode) {
            return LabelNormalizationMethodTransformerKt.access$replaceNodeGetNext(this.instructions, oldLineNode, this.rewriteLabels(oldLineNode));
        }

        private final AbstractInsnNode rewriteJumpInsn(JumpInsnNode oldJumpNode) {
            return LabelNormalizationMethodTransformerKt.access$replaceNodeGetNext(this.instructions, oldJumpNode, this.rewriteLabels(oldJumpNode));
        }

        private final AbstractInsnNode rewriteLookupSwitchInsn(LookupSwitchInsnNode oldSwitchNode) {
            return LabelNormalizationMethodTransformerKt.access$replaceNodeGetNext(this.instructions, oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteTableSwitchInsn(TableSwitchInsnNode oldSwitchNode) {
            return LabelNormalizationMethodTransformerKt.access$replaceNodeGetNext(this.instructions, oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteFrameNode(FrameNode oldFrameNode) {
            return LabelNormalizationMethodTransformerKt.access$replaceNodeGetNext(this.instructions, oldFrameNode, this.rewriteLabels(oldFrameNode));
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteTryCatchBlocks() {
            void var3_4;
            Collection<TryCatchBlockNode> collection;
            void $receiver;
            void $receiver2;
            Iterable iterable = this.methodNode.tryCatchBlocks;
            MethodNode methodNode = this.methodNode;
            void var2_3 = $receiver2;
            Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
            for (Object item : $receiver) {
                void oldTcb;
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item;
                collection = destination;
                LabelNode labelNode = oldTcb.start;
                Intrinsics.checkExpressionValueIsNotNull(labelNode, "oldTcb.start");
                LabelNode labelNode2 = this.getNew(labelNode);
                LabelNode labelNode3 = oldTcb.end;
                Intrinsics.checkExpressionValueIsNotNull(labelNode3, "oldTcb.end");
                LabelNode labelNode4 = this.getNew(labelNode3);
                LabelNode labelNode5 = oldTcb.handler;
                Intrinsics.checkExpressionValueIsNotNull(labelNode5, "oldTcb.handler");
                TryCatchBlockNode newTcb = new TryCatchBlockNode(labelNode2, labelNode4, this.getNew(labelNode5), oldTcb.type);
                newTcb.visibleTypeAnnotations = oldTcb.visibleTypeAnnotations;
                newTcb.invisibleTypeAnnotations = oldTcb.invisibleTypeAnnotations;
                TryCatchBlockNode tryCatchBlockNode2 = newTcb;
                collection.add(tryCatchBlockNode2);
            }
            collection = (List)var3_4;
            methodNode.tryCatchBlocks = collection;
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteLocalVars() {
            void var3_4;
            Collection<LocalVariableNode> collection;
            void $receiver;
            void $receiver2;
            Iterable iterable = this.methodNode.localVariables;
            MethodNode methodNode = this.methodNode;
            void var2_3 = $receiver2;
            Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
            for (Object item : $receiver) {
                void oldVar;
                LocalVariableNode localVariableNode = (LocalVariableNode)item;
                collection = destination;
                String string = oldVar.name;
                String string2 = oldVar.desc;
                String string3 = oldVar.signature;
                LabelNode labelNode = oldVar.start;
                Intrinsics.checkExpressionValueIsNotNull(labelNode, "oldVar.start");
                LabelNode labelNode2 = this.getNew(labelNode);
                LabelNode labelNode3 = oldVar.end;
                Intrinsics.checkExpressionValueIsNotNull(labelNode3, "oldVar.end");
                LocalVariableNode localVariableNode2 = new LocalVariableNode(string, string2, string3, labelNode2, this.getNew(labelNode3), oldVar.index);
                collection.add(localVariableNode2);
            }
            collection = (List)var3_4;
            methodNode.localVariables = collection;
        }

        private final AbstractInsnNode rewriteLabels(LineNumberNode $receiver) {
            int n = $receiver.line;
            LabelNode labelNode = $receiver.start;
            Intrinsics.checkExpressionValueIsNotNull(labelNode, "start");
            return new LineNumberNode(n, this.getNewOrOld(labelNode));
        }

        private final AbstractInsnNode rewriteLabels(JumpInsnNode $receiver) {
            int n = $receiver.getOpcode();
            LabelNode labelNode = $receiver.label;
            Intrinsics.checkExpressionValueIsNotNull(labelNode, "label");
            return new JumpInsnNode(n, this.getNew(labelNode));
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(LookupSwitchInsnNode $receiver) {
            void destination;
            void $receiver2;
            void $receiver3;
            LookupSwitchInsnNode lookupSwitchInsnNode;
            LabelNode labelNode = $receiver.dflt;
            Intrinsics.checkExpressionValueIsNotNull(labelNode, "dflt");
            int[] nArray = CollectionsKt.toIntArray((Collection<? extends Integer>)$receiver.keys);
            LabelNode labelNode2 = this.getNew(labelNode);
            Object object = lookupSwitchInsnNode;
            LookupSwitchInsnNode lookupSwitchInsnNode2 = lookupSwitchInsnNode;
            Object[] objectArray = new LabelNode[0];
            ((LookupSwitchInsnNode)object)(labelNode2, nArray, (LabelNode[])objectArray);
            LookupSwitchInsnNode switchNode = lookupSwitchInsnNode2;
            Iterable $i$f$emptyArray = $receiver.labels;
            lookupSwitchInsnNode2 = switchNode;
            void var4_9 = $receiver3;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
            for (Object item : $receiver2) {
                void it2;
                LabelNode labelNode3 = (LabelNode)item;
                object = destination;
                void v2 = it2;
                Intrinsics.checkExpressionValueIsNotNull(v2, "it");
                labelNode2 = this.getNew((LabelNode)v2);
                object.add(labelNode2);
            }
            lookupSwitchInsnNode2.labels = object = (List)destination;
            return switchNode;
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(TableSwitchInsnNode $receiver) {
            List list;
            void destination;
            void $receiver2;
            void $receiver3;
            int n = $receiver.min;
            int n2 = $receiver.max;
            LabelNode labelNode = $receiver.dflt;
            Intrinsics.checkExpressionValueIsNotNull(labelNode, "dflt");
            TableSwitchInsnNode switchNode = new TableSwitchInsnNode(n, n2, this.getNew(labelNode), new LabelNode[0]);
            Iterable iterable = $receiver.labels;
            TableSwitchInsnNode tableSwitchInsnNode = switchNode;
            void var4_5 = $receiver3;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
            for (Object item : $receiver2) {
                void it2;
                LabelNode labelNode2 = (LabelNode)item;
                list = destination;
                void v3 = it2;
                Intrinsics.checkExpressionValueIsNotNull(v3, "it");
                LabelNode labelNode3 = this.getNew((LabelNode)v3);
                list.add(labelNode3);
            }
            tableSwitchInsnNode.labels = list = (List)destination;
            return switchNode;
        }

        private final AbstractInsnNode rewriteLabels(FrameNode $receiver) {
            Object it2;
            Collection destination;
            Object item;
            Iterable $receiver2;
            Iterable $receiver3;
            FrameNode frameNode;
            int n = 0;
            int n2 = $receiver.type;
            Object object = frameNode;
            FrameNode frameNode2 = frameNode;
            Object[] objectArray = new Object[]{};
            int n3 = 0;
            Object[] objectArray2 = new Object[]{};
            ((FrameNode)object)(n2, n, objectArray, n3, objectArray2);
            FrameNode frameNode3 = frameNode2;
            Iterable $i$f$emptyArray = $receiver.local;
            frameNode2 = frameNode3;
            void var4_13 = $receiver3;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
            Iterator iterator2 = $receiver2.iterator();
            while (iterator2.hasNext()) {
                Object t = item = iterator2.next();
                object = destination;
                void var14_4 = it2 instanceof LabelNode ? this.getNewOrOld((LabelNode)it2) : it2;
                object.add(var14_4);
            }
            frameNode2.local = object = (List)destination;
            $receiver3 = $receiver.stack;
            frameNode2 = frameNode3;
            $receiver2 = $receiver3;
            destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
            iterator2 = $receiver2.iterator();
            while (iterator2.hasNext()) {
                it2 = item = iterator2.next();
                object = destination;
                Object t = it2 instanceof LabelNode ? this.getNewOrOld((LabelNode)it2) : it2;
                object.add(t);
            }
            frameNode2.stack = object = (List)destination;
            return frameNode3;
        }

        private final LabelNode getNew(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode.getLabel());
            if (labelNode == null) {
                Intrinsics.throwNpe();
            }
            return labelNode;
        }

        private final LabelNode getNewOrOld(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode.getLabel());
            if (labelNode == null) {
                labelNode = oldLabelNode;
            }
            return labelNode;
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public TransformerForMethod(@NotNull MethodNode methodNode) {
            Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
            this.methodNode = methodNode;
            this.instructions = this.methodNode.instructions;
            this.newLabelNodes = MapsKt.hashMapOf(new Pair[0]);
        }
    }
}

