/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ChainedScope;
import org.jetbrains.kotlin.resolve.scopes.FilteringScope;
import org.jetbrains.kotlin.resolve.scopes.JetScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0019Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u000f1\u0001\u0011$\u0001M\u0001C?I1\u0001C\u0001\u000e\u0003a\r\u0011b\u0001\u0005\u0003\u001b\u0005A*!\u0003\u0003\t\u00075\u0011A\u0012\u0001M\u0004#\u000e\t\u0001\u0002B\u0013\u0005\t-A\t\"D\u0001\u0019\u000f\u0015\"Aa\u0003\u0005\n\u001b\u0005A\u001a\"K\u0006\u0005\u0007\"A1!\u0004\u0002\r\u0002a\u001d\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0002\u0005\u0006S)!1\n\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0005\u000b\u0001i!\u0001b\u0003\t\r%RAa\u0013\u0005\t\u000e5\t\u0001d\u0002\u000f,#\u000e\u0019QB\u0001C\b\u0011!\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassQualifier;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassifierQualifier;", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classValueReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "getClassValueReceiver", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "getClassifier", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getScope", "()Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getNestedClassesAndPackageMembersScope", "toString", ""}, moduleName="kotlin-compiler")
public final class ClassQualifier
extends ClassifierQualifier {
    @NotNull
    private final ClassDescriptor classifier;
    @Nullable
    private final ReceiverValue classValueReceiver;

    @Override
    @NotNull
    public MemberScope getScope() {
        ChainedScope chainedScope;
        FilteringScope filteringScope;
        Object $receiver;
        if (!(this.getClassifier() instanceof ClassDescriptor)) {
            return MemberScope.Empty.INSTANCE;
        }
        ArrayList<MemberScope> scopes = new ArrayList<MemberScope>(3);
        Object object = DescriptorUtilsKt.getClassValueType(this.getClassifier());
        if (object != null && (object = object.getMemberScope()) != null) {
            MemberScope it2;
            $receiver = object;
            MemberScope memberScope2 = it2 = (MemberScope)$receiver;
            Intrinsics.checkExpressionValueIsNotNull(memberScope2, "it");
            filteringScope = new FilteringScope(memberScope2, scope.classObjectTypeScope.1.1.INSTANCE);
        } else {
            filteringScope = null;
        }
        FilteringScope classObjectTypeScope2 = filteringScope;
        CollectionsKt.addIfNotNull((Collection)scopes, classObjectTypeScope2);
        scopes.add(this.getClassifier().getStaticScope());
        if (Intrinsics.areEqual((Object)this.getClassifier().getKind(), (Object)ClassKind.ENUM_ENTRY) ^ true) {
            scopes.add(this.getClassifier().getUnsubstitutedInnerClassesScope());
        }
        $receiver = scopes;
        String string = "Member scope for " + this.getName() + " as class or object";
        ChainedScope chainedScope2 = chainedScope;
        ChainedScope chainedScope3 = chainedScope;
        Collection thisCollection = (Collection)$receiver;
        MemberScope[] memberScopeArray = thisCollection.toArray(new MemberScope[thisCollection.size()]);
        if (memberScopeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = memberScopeArray;
        MemberScope[] memberScopeArray2 = (MemberScope[])objectArray;
        chainedScope2(string, Arrays.copyOf(memberScopeArray2, memberScopeArray2.length));
        return chainedScope3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MemberScope getNestedClassesAndPackageMembersScope() {
        void $receiver;
        ChainedScope chainedScope;
        if (!(this.getClassifier() instanceof ClassDescriptor)) {
            return MemberScope.Empty.INSTANCE;
        }
        ArrayList<MemberScope> scopes = new ArrayList<MemberScope>(2);
        scopes.add(this.getClassifier().getStaticScope());
        if (Intrinsics.areEqual((Object)this.getClassifier().getKind(), (Object)ClassKind.ENUM_ENTRY) ^ true) {
            scopes.add(JetScopeUtils.getStaticNestedClassesScope(this.getClassifier()));
        }
        Collection collection = scopes;
        String string = "Static scope for " + this.getName() + " as class or object";
        ChainedScope chainedScope2 = chainedScope;
        ChainedScope chainedScope3 = chainedScope;
        Collection thisCollection = (Collection)$receiver;
        MemberScope[] memberScopeArray = thisCollection.toArray(new MemberScope[thisCollection.size()]);
        if (memberScopeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = memberScopeArray;
        MemberScope[] memberScopeArray2 = (MemberScope[])objectArray;
        chainedScope2(string, Arrays.copyOf(memberScopeArray2, memberScopeArray2.length));
        return chainedScope3;
    }

    @NotNull
    public String toString() {
        return "Class{" + this.getClassifier() + "}";
    }

    @Override
    @NotNull
    public ClassDescriptor getClassifier() {
        return this.classifier;
    }

    @Nullable
    public final ReceiverValue getClassValueReceiver() {
        return this.classValueReceiver;
    }

    public ClassQualifier(@NotNull KtSimpleNameExpression referenceExpression, @NotNull ClassDescriptor classifier2, @Nullable ReceiverValue classValueReceiver) {
        Intrinsics.checkParameterIsNotNull(referenceExpression, "referenceExpression");
        Intrinsics.checkParameterIsNotNull(classifier2, "classifier");
        super(referenceExpression);
        this.classifier = classifier2;
        this.classValueReceiver = classValueReceiver;
    }
}

