/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.HierarchicalMethodSignatureImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperMethodImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiSuperMethodImplUtil");
    private static final PsiCacheKey<Map<MethodSignature, HierarchicalMethodSignature>, PsiClass> SIGNATURES_FOR_CLASS_KEY = PsiCacheKey.create("SIGNATURES_FOR_CLASS_KEY", new NotNullFunction<PsiClass, Map<MethodSignature, HierarchicalMethodSignature>>(){

        @Override
        @NotNull
        public Map<MethodSignature, HierarchicalMethodSignature> fun(PsiClass dom) {
            Map map2 = PsiSuperMethodImplUtil.buildMethodHierarchy(dom, null, PsiSubstitutor.EMPTY, true, new THashSet(), false, dom.getResolveScope());
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil$1", "fun"));
            }
            return map2;
        }
    });
    private static final PsiCacheKey<FactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>>, PsiClass> SIGNATURES_BY_NAME_KEY = PsiCacheKey.create("SIGNATURES_BY_NAME_KEY", new Function<PsiClass, FactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>>>(){

        @Override
        public FactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>> fun(final PsiClass psiClass) {
            return new ConcurrentFactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>>(){

                @Override
                @Nullable
                protected Map<MethodSignature, HierarchicalMethodSignature> create(String methodName) {
                    return PsiSuperMethodImplUtil.buildMethodHierarchy(psiClass, methodName, PsiSubstitutor.EMPTY, true, new THashSet(), false, psiClass.getResolveScope());
                }
            };
        }
    });
    private static final Key<ParameterizedCachedValue<HierarchicalMethodSignature, PsiMethod>> HIERARCHICAL_SIGNATURE_KEY = Key.create("HierarchicalMethodSignature");
    private static final ParameterizedCachedValueProvider<HierarchicalMethodSignature, PsiMethod> HIERARCHICAL_SIGNATURE_PROVIDER = new ParameterizedCachedValueProvider<HierarchicalMethodSignature, PsiMethod>(){

        @Override
        public CachedValueProvider.Result<HierarchicalMethodSignature> compute(PsiMethod method) {
            PsiClass aClass = method.getContainingClass();
            HierarchicalMethodSignature result2 = null;
            if (aClass != null) {
                result2 = (HierarchicalMethodSignature)((Map)((FactoryMap)SIGNATURES_BY_NAME_KEY.getValue(aClass)).get(method.getName())).get(method.getSignature(PsiSubstitutor.EMPTY));
            }
            if (result2 == null) {
                result2 = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)method.getSignature(PsiSubstitutor.EMPTY));
            }
            if (!method.isPhysical()) {
                return CachedValueProvider.Result.create(result2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, method);
            }
            return CachedValueProvider.Result.create(result2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        }
    };

    private PsiSuperMethodImplUtil() {
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(method, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    private static PsiMethod[] findSuperMethodsInternal(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodsInternal"));
        }
        List<MethodSignatureBackedByPsiMethod> outputMethods = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, parentClass, false);
        PsiMethod[] psiMethodArray = MethodSignatureUtil.convertMethodSignaturesToMethods(outputMethods);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodsInternal"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, true)) {
            List<MethodSignatureBackedByPsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
            }
            return list;
        }
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, null, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list;
    }

    @NotNull
    private static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignatures(@NotNull PsiMethod method, PsiClass parentClass, boolean allowStaticMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignatures"));
        }
        ArrayList<MethodSignatureBackedByPsiMethod> arrayList = new ArrayList<MethodSignatureBackedByPsiMethod>(SuperMethodsSearch.search(method, parentClass, true, allowStaticMethod).findAll());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignatures"));
        }
        return arrayList;
    }

    private static boolean canHaveSuperMethod(@NotNull PsiMethod method, boolean checkAccess, boolean allowStaticMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "canHaveSuperMethod"));
        }
        if (method.isConstructor()) {
            return false;
        }
        if (!allowStaticMethod && method.hasModifierProperty("static")) {
            return false;
        }
        if (checkAccess && method.hasModifierProperty("private")) {
            return false;
        }
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !"java.lang.Object".equals(parentClass.getQualifiedName());
    }

    @Nullable
    public static PsiMethod findDeepestSuperMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethod"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return null;
        }
        return DeepestSuperMethodsSearch.search(method).findFirst();
    }

    @NotNull
    public static PsiMethod[] findDeepestSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethods"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        Collection<PsiMethod> collection = DeepestSuperMethodsSearch.search(method).findAll();
        PsiMethod[] psiMethodArray = collection.toArray(new PsiMethod[collection.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> buildMethodHierarchy(@NotNull PsiClass aClass, @Nullable String nameHint, @NotNull PsiSubstitutor substitutor2, boolean includePrivates, @NotNull Set<PsiClass> visited2, boolean isInRawContext, GlobalSearchScope resolveScope) {
        PsiMethod valuesMethod;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        if (visited2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        ProgressManager.checkCanceled();
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> result2 = new LinkedHashMap<MethodSignature, HierarchicalMethodSignature>();
        final THashMap<MethodSignature, SmartList<PsiMethod>> sameParameterErasureMethods = new THashMap<MethodSignature, SmartList<PsiMethod>>(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        THashMap<MethodSignature, HierarchicalMethodSignatureImpl> map2 = new THashMap<MethodSignature, HierarchicalMethodSignatureImpl>(new TObjectHashingStrategy<MethodSignature>(){

            @Override
            public int computeHashCode(MethodSignature signature) {
                return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.computeHashCode(signature);
            }

            @Override
            public boolean equals(MethodSignature o1, MethodSignature o2) {
                boolean toCheckReturnType;
                if (!MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals(o1, o2)) {
                    return false;
                }
                List list = (List)sameParameterErasureMethods.get(o1);
                boolean bl = toCheckReturnType = list != null && list.size() > 1;
                if (!toCheckReturnType) {
                    return true;
                }
                PsiType returnType1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod().getReturnType();
                PsiType returnType2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod().getReturnType();
                if (returnType1 == null && returnType2 == null) {
                    return true;
                }
                if (returnType1 == null || returnType2 == null) {
                    return false;
                }
                PsiType erasure1 = TypeConversionUtil.erasure(o1.getSubstitutor().substitute(returnType1));
                PsiType erasure2 = TypeConversionUtil.erasure(o2.getSubstitutor().substitute(returnType2));
                return erasure1.equals(erasure2);
            }
        });
        PsiMethod[] methods = aClass.getMethods();
        if ((nameHint == null || "values".equals(nameHint)) && aClass instanceof PsiClassImpl && (valuesMethod = ((PsiClassImpl)aClass).getValuesMethod()) != null) {
            methods = ArrayUtil.append(methods, valuesMethod);
        }
        for (PsiMethod psiMethod : methods) {
            if (!psiMethod.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)psiMethod, "class.valid=" + aClass.isValid() + "; name=" + psiMethod.getName());
            }
            if (nameHint != null && !nameHint.equals(psiMethod.getName()) || !includePrivates && psiMethod.hasModifierProperty("private")) continue;
            MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(psiMethod, substitutor2, isInRawContext);
            HierarchicalMethodSignatureImpl newH = new HierarchicalMethodSignatureImpl(signature);
            SmartList<PsiMethod> list = (SmartList<PsiMethod>)sameParameterErasureMethods.get(signature);
            if (list == null) {
                list = new SmartList<PsiMethod>();
                sameParameterErasureMethods.put(signature, list);
            }
            list.add(psiMethod);
            LOG.assertTrue(newH.getMethod().isValid());
            result2.put(signature, newH);
            map2.put(signature, newH);
        }
        for (PsiClassType psiClassType : aClass.getSuperTypes()) {
            PsiClassType.ClassResolveResult superTypeResolveResult;
            PsiClass superClass;
            PsiClassType psiClassType2 = (PsiClassType)PsiClassImplUtil.correctType(psiClassType, resolveScope);
            if (psiClassType2 == null || (superClass = (superTypeResolveResult = psiClassType2.resolveGenerics()).getElement()) == null || !visited2.add(superClass)) continue;
            PsiSubstitutor superSubstitutor = superTypeResolveResult.getSubstitutor();
            PsiSubstitutor finalSubstitutor = PsiSuperMethodImplUtil.obtainFinalSubstitutor(superClass, superSubstitutor, substitutor2, isInRawContext);
            boolean isInRawContextSuper = (isInRawContext || PsiUtil.isRawSubstitutor(superClass, superSubstitutor)) && superClass.getTypeParameters().length != 0;
            Map<MethodSignature, HierarchicalMethodSignature> superResult = PsiSuperMethodImplUtil.buildMethodHierarchy(superClass, nameHint, finalSubstitutor, false, visited2, isInRawContextSuper, resolveScope);
            visited2.remove(superClass);
            ArrayList<Pair<MethodSignature, HierarchicalMethodSignature>> flattened = new ArrayList<Pair<MethodSignature, HierarchicalMethodSignature>>();
            for (Map.Entry<MethodSignature, HierarchicalMethodSignature> entry : superResult.entrySet()) {
                HierarchicalMethodSignature hms = entry.getValue();
                MethodSignature signature = entry.getKey();
                PsiClass containingClass = hms.getMethod().getContainingClass();
                ArrayList<HierarchicalMethodSignature> supers = new ArrayList<HierarchicalMethodSignature>(hms.getSuperSignatures());
                for (HierarchicalMethodSignature aSuper : supers) {
                    PsiClass superContainingClass = aSuper.getMethod().getContainingClass();
                    if (containingClass == null || superContainingClass == null || containingClass.isInheritor(superContainingClass, true)) continue;
                    flattened.add(Pair.create(signature, aSuper));
                }
                PsiSuperMethodImplUtil.putInMap(aClass, result2, map2, hms, signature);
            }
            for (Pair pair : flattened) {
                PsiSuperMethodImplUtil.putInMap(aClass, result2, map2, (HierarchicalMethodSignature)pair.second, (MethodSignature)pair.first);
            }
        }
        for (Map.Entry entry : map2.entrySet()) {
            HierarchicalMethodSignatureImpl hierarchicalMethodSignature = (HierarchicalMethodSignatureImpl)entry.getValue();
            MethodSignature methodSignature = (MethodSignature)entry.getKey();
            if (result2.get(methodSignature) != null || !PsiUtil.isAccessible(aClass.getProject(), hierarchicalMethodSignature.getMethod(), aClass, aClass)) continue;
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(methodSignature, hierarchicalMethodSignature);
        }
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        return linkedHashMap;
    }

    private static void putInMap(@NotNull PsiClass aClass, @NotNull Map<MethodSignature, HierarchicalMethodSignature> result2, @NotNull Map<MethodSignature, HierarchicalMethodSignatureImpl> map2, @NotNull HierarchicalMethodSignature hierarchicalMethodSignature, @NotNull MethodSignature signature) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (hierarchicalMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchicalMethodSignature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (!PsiUtil.isAccessible(aClass.getProject(), hierarchicalMethodSignature.getMethod(), aClass, aClass)) {
            return;
        }
        HierarchicalMethodSignatureImpl existing = map2.get(signature);
        if (existing == null) {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            LOG.assertTrue(copy.getMethod().isValid());
            map2.put(signature, copy);
        } else if (PsiSuperMethodImplUtil.isReturnTypeIsMoreSpecificThan(hierarchicalMethodSignature, existing) && PsiSuperMethodImplUtil.isSuperMethod(aClass, hierarchicalMethodSignature, existing)) {
            HierarchicalMethodSignatureImpl newSuper = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            PsiSuperMethodImplUtil.mergeSupers(newSuper, existing);
            LOG.assertTrue(newSuper.getMethod().isValid());
            map2.put(signature, newSuper);
        } else if (PsiSuperMethodImplUtil.isSuperMethod(aClass, existing, hierarchicalMethodSignature)) {
            PsiSuperMethodImplUtil.mergeSupers(existing, hierarchicalMethodSignature);
        } else if (!result2.containsKey(signature)) {
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(signature, hierarchicalMethodSignature);
        }
    }

    private static boolean isReturnTypeIsMoreSpecificThan(@NotNull HierarchicalMethodSignature thisSig, @NotNull HierarchicalMethodSignature thatSig) {
        if (thisSig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisSig", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isReturnTypeIsMoreSpecificThan"));
        }
        if (thatSig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thatSig", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isReturnTypeIsMoreSpecificThan"));
        }
        PsiType thisRet = thisSig.getSubstitutor().substitute(thisSig.getMethod().getReturnType());
        PsiType thatRet = thatSig.getSubstitutor().substitute(thatSig.getMethod().getReturnType());
        return thatRet != null && thisRet != null && !thatRet.equals(thisRet) && TypeConversionUtil.isAssignable(thatRet, thisRet, false);
    }

    private static void mergeSupers(@NotNull HierarchicalMethodSignatureImpl existing, @NotNull HierarchicalMethodSignature superSignature) {
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "mergeSupers"));
        }
        if (superSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "mergeSupers"));
        }
        for (HierarchicalMethodSignature existingSuper : existing.getSuperSignatures()) {
            if (existingSuper.getMethod() != superSignature.getMethod()) continue;
            for (HierarchicalMethodSignature signature : superSignature.getSuperSignatures()) {
                PsiSuperMethodImplUtil.mergeSupers((HierarchicalMethodSignatureImpl)existingSuper, signature);
            }
            return;
        }
        if (existing.getMethod() == superSignature.getMethod()) {
            List<HierarchicalMethodSignature> existingSupers = existing.getSuperSignatures();
            for (HierarchicalMethodSignature supers : superSignature.getSuperSignatures()) {
                if (existingSupers.contains(supers)) continue;
                existing.addSuperSignature(PsiSuperMethodImplUtil.copy(supers));
            }
        } else {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(superSignature);
            existing.addSuperSignature(copy);
        }
    }

    private static boolean isSuperMethod(@NotNull PsiClass aClass, @NotNull MethodSignatureBackedByPsiMethod hierarchicalMethodSignature, @NotNull MethodSignatureBackedByPsiMethod superSignatureHierarchical) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethod"));
        }
        if (hierarchicalMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchicalMethodSignature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethod"));
        }
        if (superSignatureHierarchical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignatureHierarchical", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethod"));
        }
        PsiMethod superMethod = superSignatureHierarchical.getMethod();
        PsiClass superClass = superMethod.getContainingClass();
        PsiMethod method = hierarchicalMethodSignature.getMethod();
        PsiClass containingClass = method.getContainingClass();
        if (!superMethod.isConstructor() && !aClass.equals(superClass) && PsiUtil.isAccessible(aClass.getProject(), superMethod, aClass, aClass) && MethodSignatureUtil.isSubsignature(superSignatureHierarchical, hierarchicalMethodSignature) && superClass != null) {
            if (superClass.isInterface() || "java.lang.Object".equals(superClass.getQualifiedName())) {
                if (superMethod.hasModifierProperty("static") || superMethod.hasModifierProperty("default") && method.hasModifierProperty("static") && !InheritanceUtil.isInheritorOrSelf(containingClass, superClass, true)) {
                    return false;
                }
                if (superMethod.hasModifierProperty("default") || method.hasModifierProperty("default")) {
                    return superMethod.equals(method) || !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true);
                }
                return true;
            }
            if (containingClass != null) {
                if (containingClass.isInterface()) {
                    return false;
                }
                if (!aClass.isInterface() && !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true)) {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    private static HierarchicalMethodSignatureImpl copy(@NotNull HierarchicalMethodSignature hi) {
        if (hi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hi", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "copy"));
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignature = new HierarchicalMethodSignatureImpl(hi);
        for (HierarchicalMethodSignature his : hi.getSuperSignatures()) {
            hierarchicalMethodSignature.addSuperSignature(PsiSuperMethodImplUtil.copy(his));
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignatureImpl = hierarchicalMethodSignature;
        if (hierarchicalMethodSignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "copy"));
        }
        return hierarchicalMethodSignatureImpl;
    }

    @NotNull
    private static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "obtainFinalSubstitutor"));
        }
        if (superSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSubstitutor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "obtainFinalSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "obtainFinalSubstitutor"));
        }
        if (inRawContext) {
            Set<PsiTypeParameter> typeParams = superSubstitutor.getSubstitutionMap().keySet();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(superClass.getProject());
            superSubstitutor = factory.createRawSubstitutor(derivedSubstitutor, typeParams.toArray(new PsiTypeParameter[typeParams.size()]));
        }
        THashMap<PsiTypeParameter, PsiType> map2 = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(superClass)) {
            PsiType type2 = superSubstitutor.substitute(typeParameter);
            PsiType t = derivedSubstitutor.substitute(type2);
            if (map2 == null) {
                map2 = new THashMap<PsiTypeParameter, PsiType>();
            }
            map2.put(typeParameter, t);
        }
        PsiSubstitutor psiSubstitutor = map2 == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getInstance(superClass.getProject()).getElementFactory().createSubstitutor(map2);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "obtainFinalSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public static Collection<HierarchicalMethodSignature> getVisibleSignatures(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getVisibleSignatures"));
        }
        Map<MethodSignature, HierarchicalMethodSignature> map2 = PsiSuperMethodImplUtil.getSignaturesMap(aClass);
        Collection<HierarchicalMethodSignature> collection = map2.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getVisibleSignatures"));
        }
        return collection;
    }

    @NotNull
    public static HierarchicalMethodSignature getHierarchicalMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getHierarchicalMethodSignature"));
        }
        Project project = method.getProject();
        HierarchicalMethodSignature hierarchicalMethodSignature = CachedValuesManager.getManager(project).getParameterizedCachedValue(method, HIERARCHICAL_SIGNATURE_KEY, HIERARCHICAL_SIGNATURE_PROVIDER, false, method);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> getSignaturesMap(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getSignaturesMap"));
        }
        Map<MethodSignature, HierarchicalMethodSignature> map2 = SIGNATURES_FOR_CLASS_KEY.getValue(aClass);
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getSignaturesMap"));
        }
        return map2;
    }

    public static boolean processDirectSuperMethodsSmart(@NotNull PsiMethod method, @NotNull Processor<PsiMethod> superMethodProcessor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "processDirectSuperMethodsSmart"));
        }
        if (superMethodProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodProcessor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "processDirectSuperMethodsSmart"));
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return false;
        }
        Map<MethodSignature, HierarchicalMethodSignature> cachedMap = SIGNATURES_BY_NAME_KEY.getValue(aClass).get(method.getName());
        HierarchicalMethodSignature signature = cachedMap.get(method.getSignature(PsiSubstitutor.EMPTY));
        if (signature != null) {
            List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            for (HierarchicalMethodSignature superSignature : superSignatures) {
                if (superMethodProcessor.process(superSignature.getMethod())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSuperMethodSmart(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethodSmart"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethodSmart"));
        }
        if (method == superMethod) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        PsiClass superClass = superMethod.getContainingClass();
        if (aClass == null || superClass == null || superClass == aClass) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return false;
        }
        Map<MethodSignature, HierarchicalMethodSignature> cachedMap = SIGNATURES_BY_NAME_KEY.getValue(aClass).get(method.getName());
        HierarchicalMethodSignature signature = cachedMap.get(method.getSignature(PsiSubstitutor.EMPTY));
        for (PsiMethod superCandidate : MethodSignatureUtil.convertMethodSignaturesToMethods(signature.getSuperSignatures())) {
            if (!superMethod.equals(superCandidate) && !PsiSuperMethodImplUtil.isSuperMethodSmart(superCandidate, superMethod)) continue;
            return true;
        }
        return false;
    }
}

