/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.preprocessor.CollectModificationsVisitor;
import org.jetbrains.kotlin.preprocessor.Conditional;
import org.jetbrains.kotlin.preprocessor.ConditionalKt;
import org.jetbrains.kotlin.preprocessor.Evaluator;
import org.jetbrains.kotlin.preprocessor.Logger;
import org.jetbrains.kotlin.preprocessor.Modification;
import org.jetbrains.kotlin.preprocessor.ModificationsKt;
import org.jetbrains.kotlin.preprocessor.Preprocessor;
import org.jetbrains.kotlin.preprocessor.PreprocessorKt;
import org.jetbrains.kotlin.preprocessor.Profile;
import org.jetbrains.kotlin.preprocessor.SystemOutLogger;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001C\u0003\u000b\u0005A\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!\u0002\u0001\r\u0001e\t\u0001\u0014AO\u0001\u001e\u0005>\u0011\u0002\u0002\u0003\u0002\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!\n\t\u0005\u0003!AQ\"\u0001M\t3\rA\u0011\"D\u0001\u0019\u0014e\u0019\u0001BC\u0007\u00021'I2\u0001#\u0006\u000e\u0003aYQ\u0005\u0004\u0003\u0002\u0011/i\u0011\u0001\u0007\u0007\u001a\u0007!eQ\"\u0001M\n3\rA)\"D\u0001\u0019\u0017\u0015Z\u0001\"D\u0007\u00021#I2\u0001C\u0005\u000e\u0003aM\u0011d\u0001E\u000e\u001b\u0005Ab\"\u000b\b\u0005\u0007\"A)!D\u0003\u0011\bU\u0011A\u0012\u0001\r\u00041\r\t6\u0001B\u0003\u0001\u001b\t!A\u0001#\u0003*\u0015\u0011\u0019\u0005\u0002C\u0003\u000e\u0003a-\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0002E\u0007S)!1\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001B\u0004\t\u0010\u0001"}, strings={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor;", "", "logger", "Lorg/jetbrains/kotlin/preprocessor/Logger;", "(Lorg/jetbrains/kotlin/preprocessor/Logger;)V", "fileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "kotlin.jvm.PlatformType", "getFileType", "()Lorg/jetbrains/kotlin/idea/KotlinFileType;", "jetPsiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "getJetPsiFactory", "()Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "getLogger", "()Lorg/jetbrains/kotlin/preprocessor/Logger;", "processDirectorySingleEvaluator", "", "sourceRoot", "Ljava/io/File;", "targetRoot", "evaluator", "Lorg/jetbrains/kotlin/preprocessor/Evaluator;", "processFileSingleEvaluator", "Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "sourceFile", "processSources", "profile", "Lorg/jetbrains/kotlin/preprocessor/Profile;", "FileProcessingResult"}, moduleName="kotlin-compiler")
public final class Preprocessor {
    private final KotlinFileType fileType;
    @NotNull
    private final KtPsiFactory jetPsiFactory;
    @NotNull
    private final Logger logger;

    public final KotlinFileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final KtPsiFactory getJetPsiFactory() {
        return this.jetPsiFactory;
    }

    public final void processSources(@NotNull File sourceRoot, @NotNull Profile profile) {
        Intrinsics.checkParameterIsNotNull(sourceRoot, "sourceRoot");
        Intrinsics.checkParameterIsNotNull(profile, "profile");
        this.processDirectorySingleEvaluator(sourceRoot, profile.getTargetRoot(), profile.getEvaluator());
    }

    /*
     * WARNING - void declaration
     */
    private final FileProcessingResult processFileSingleEvaluator(File sourceFile, Evaluator evaluator) {
        void $receiver;
        if (Intrinsics.areEqual(FilesKt.getExtension(sourceFile), this.fileType.getDefaultExtension()) ^ true) {
            return FileProcessingResult.Copy.INSTANCE;
        }
        String sourceText = PreprocessorKt.convertLineSeparators(FilesKt.readText$default(sourceFile, null, 1));
        String string = sourceFile.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.name");
        KtFile psiFile = this.jetPsiFactory.createFile(string, sourceText);
        List<Conditional> fileAnnotations = ConditionalKt.parseConditionalAnnotations(psiFile);
        if (!((Boolean)evaluator.invoke(fileAnnotations)).booleanValue()) {
            return FileProcessingResult.Skip.INSTANCE;
        }
        CollectModificationsVisitor visitor2 = new CollectModificationsVisitor(CollectionsKt.listOf(evaluator));
        psiFile.accept(visitor2);
        Map<Evaluator, List<Modification>> map2 = visitor2.getElementModifications();
        List list = (List)CollectionsKt.single($receiver.values());
        return CollectionsKt.isNotEmpty(list) ? (FileProcessingResult)new FileProcessingResult.Modify(sourceText, list) : (FileProcessingResult)FileProcessingResult.Copy.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void processDirectorySingleEvaluator(File sourceRoot, File targetRoot, Evaluator evaluator) {
        void sourceDirectories;
        String resultText;
        void sourceFiles;
        void $receiver;
        Object[] objectArray = sourceRoot.listFiles();
        ArrayList<void> first = new ArrayList<void>();
        ArrayList<void> second = new ArrayList<void>();
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void element = $receiver[i];
            File it2 = (File)element;
            if (!it2.isDirectory()) {
                first.add(element);
                continue;
            }
            second.add(element);
        }
        Pair pair = new Pair(first, second);
        List list = pair.component1();
        List list2 = pair.component2();
        pair = null;
        HashSet<File> processedFiles = SetsKt.hashSetOf(new File[0]);
        Iterator iterator2 = sourceFiles.iterator();
        while (iterator2.hasNext()) {
            File sourceFile;
            File file = sourceFile = (File)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(file, "sourceFile");
            FileProcessingResult result2 = this.processFileSingleEvaluator(file, evaluator);
            this.logger.debug(result2 + ": " + sourceFile);
            if (result2 instanceof FileProcessingResult.Skip) continue;
            File targetFile2 = PreprocessorKt.makeRelativeTo(sourceFile, sourceRoot, targetRoot);
            CollectionsKt.plusAssign((Collection)processedFiles, targetFile2);
            if (targetFile2.exists() && targetFile2.isDirectory()) {
                FilesKt.deleteRecursively(targetFile2);
            }
            if (result2 instanceof FileProcessingResult.Copy) {
                FileUtil.copy(sourceFile, targetFile2);
                continue;
            }
            if (!(result2 instanceof FileProcessingResult.Modify)) continue;
            resultText = ((FileProcessingResult.Modify)result2).getModifiedText();
            if (targetFile2.exists() && PreprocessorKt.isTextEqualTo(targetFile2, resultText)) continue;
            this.logger.info("Rewriting modified " + targetFile2);
            FilesKt.writeText$default(targetFile2, resultText, null, 2);
        }
        for (File sourceDir : sourceDirectories) {
            File targetDir = PreprocessorKt.makeRelativeTo(sourceDir, sourceRoot, targetRoot);
            if (targetDir.exists() && !targetDir.isDirectory()) {
                targetDir.delete();
            }
            PreprocessorKt.mkdirsOrFail(targetDir);
            File file = sourceDir;
            Intrinsics.checkExpressionValueIsNotNull(file, "sourceDir");
            this.processDirectorySingleEvaluator(file, targetDir, evaluator);
            CollectionsKt.plusAssign((Collection)processedFiles, targetDir);
        }
        File[] fileArray = targetRoot.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Object var19_19;
            Collection collection;
            File targetFile;
            block9: {
                Object v2;
                void $receiver2;
                void $receiver3;
                targetFile = fileArray[i];
                Iterable targetFile2 = processedFiles;
                collection = processedFiles;
                resultText = $receiver3;
                for (Object element : $receiver2) {
                    File it3 = (File)element;
                    if (!FileUtil.filesEqual(it3, targetFile)) continue;
                    v2 = element;
                    break block9;
                }
                v2 = var19_19 = null;
            }
            if (CollectionsKt.remove(collection, var19_19)) continue;
            this.logger.info("Deleting skipped " + targetFile);
            FilesKt.deleteRecursively(targetFile);
        }
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public Preprocessor(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        this.logger = logger;
        this.fileType = KotlinFileType.INSTANCE;
        CompilerConfiguration configuration = new CompilerConfiguration();
        KotlinCoreEnvironment environment2 = KotlinCoreEnvironment.Companion.createForProduction(environment.1.INSTANCE, configuration, CollectionsKt.emptyList());
        Project project = environment2.getProject();
        this.jetPsiFactory = new KtPsiFactory(project);
    }

    public /* synthetic */ Preprocessor(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = SystemOutLogger.INSTANCE;
        }
        this(logger);
    }

    public Preprocessor() {
        this(null, 1, null);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\u0003\tma\u0001!G\u0001\u0019\u0002u\r1q\u0001\u0003\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015BAa\u0003E\u0002\u001b\u0015\u0001*!\u0006\u0002\r\u0002a\u0011\u0001D\u0001"}, strings={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "", "()V", "toString", "", "kotlin.jvm.PlatformType", "Copy", "Modify", "Skip"}, moduleName="kotlin-compiler")
    public static abstract class FileProcessingResult {
        public String toString() {
            return this.getClass().getSimpleName();
        }

        private FileProcessingResult() {
        }

        public /* synthetic */ FileProcessingResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u000b\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001\u0001B2\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult$Skip;", "Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "()V"}, moduleName="kotlin-compiler")
        public static final class Skip
        extends FileProcessingResult {
            public static final Skip INSTANCE;
            public static final Skip INSTANCE$;

            static {
                new Skip();
            }

            private Skip() {
                super(null);
                INSTANCE = this;
                INSTANCE$ = this;
            }
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u000b\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001\u0001B2\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult$Copy;", "Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "()V"}, moduleName="kotlin-compiler")
        public static final class Copy
        extends FileProcessingResult {
            public static final Copy INSTANCE;
            public static final Copy INSTANCE$;

            static {
                new Copy();
            }

            private Copy() {
                super(null);
                INSTANCE = this;
                INSTANCE$ = this;
            }
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\u0005\b1\u0001\u0011$\u0001M\u0001C7I1\u0001C\u0001\u000e\u0003a\r\u0011B\u0002\u0005\u0003\u001b\u0011I!!C\u0001\u0019\u0007a\u0015\u0011kA\u0001\t\b\u0015\u001a\u0001BB\u0007\u00021\u0007)C\u0001B\u0006\t\u000e5\t\u00014A\u0015\u000e\t\rC\u0001BA\u0007\u0005\u0013\tI\u0011\u0001G\u0002\u0019\u0006E\u001bA!\u0002\u0001\u000e\u0005\u0011!\u0001\u0012B\u0015\u000b\t\rC\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!Q\u0001c\u0003"}, strings={"Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult$Modify;", "Lorg/jetbrains/kotlin/preprocessor/Preprocessor$FileProcessingResult;", "sourceText", "", "modifications", "", "Lorg/jetbrains/kotlin/preprocessor/Modification;", "(Ljava/lang/String;Ljava/util/List;)V", "getModifications", "()Ljava/util/List;", "getSourceText", "()Ljava/lang/String;", "getModifiedText", "toString"}, moduleName="kotlin-compiler")
        public static final class Modify
        extends FileProcessingResult {
            @NotNull
            private final String sourceText;
            @NotNull
            private final List<? extends Modification> modifications;

            @NotNull
            public final String getModifiedText() {
                return ModificationsKt.applyTo(this.modifications, this.sourceText);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public String toString() {
                void $receiver;
                Collection collection = this.modifications;
                StringBuilder stringBuilder = new StringBuilder().append("Modify(");
                int n = $receiver.size();
                return stringBuilder.append(n).append(")").toString();
            }

            @NotNull
            public final String getSourceText() {
                return this.sourceText;
            }

            @NotNull
            public final List<Modification> getModifications() {
                return this.modifications;
            }

            public Modify(@NotNull String sourceText, @NotNull List<? extends Modification> modifications) {
                Intrinsics.checkParameterIsNotNull(sourceText, "sourceText");
                Intrinsics.checkParameterIsNotNull(modifications, "modifications");
                super(null);
                this.sourceText = sourceText;
                this.modifications = modifications;
            }
        }
    }
}

