/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.google.common.base.Predicates;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.MessageSeverityCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.jvm.PluginCliParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CommandLineScriptUtils;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0005\u00171\u0001\u0001#C\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002u\u0005\u0011\")\u0002R\u0007\u0005A\u0019!\n\u0003\u0005\u0015!\u0011Q\"\u0001\r\u0002K1!\u0011\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$B\u0013\u0015\t)AY!D\u0001\u0019\re\u0019\u0001RB\u0007\u00021\u0005I2\u0001C\u0004\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A\n\"G\u0002\t\b5\t\u0001\u0004\u0002"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "()V", "createArguments", "createCoreEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "services", "Lorg/jetbrains/kotlin/config/Services;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Companion"}, moduleName="kotlin-compiler")
public class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    private static long initStartNanos;
    private static final HashMap<String, Long> elapsedGCTime;
    private static long elapsedJITTime;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.cli.jvm.K2JVMCompiler$Companion.INSTANCE;
        initStartNanos = System.nanoTime();
        elapsedGCTime = MapsKt.hashMapOf(new Pair[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments2, @NotNull Services services, @NotNull MessageCollector messageCollector, @NotNull Disposable rootDisposable) {
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(services, "services");
        Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
        Intrinsics.checkParameterIsNotNull(rootDisposable, "rootDisposable");
        MessageSeverityCollector messageSeverityCollector = new MessageSeverityCollector(messageCollector);
        KotlinPaths paths = arguments2.kotlinHome != null ? (KotlinPaths)new KotlinPathsFromHomeDir(new File(arguments2.kotlinHome)) : PathUtil.getKotlinPathsForCompiler();
        messageSeverityCollector.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), CompilerMessageLocation.NO_LOCATION);
        PerformanceCounter.Companion.setTimeCounterEnabled(arguments2.reportPerf);
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageSeverityCollector);
        if (IncrementalCompilation.isEnabled()) {
            IncrementalCompilationComponents incrementalCompilationComponents = services.get(IncrementalCompilationComponents.class);
            configuration.put(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, incrementalCompilationComponents);
        }
        CompilerJarLocator locator = services.get(CompilerJarLocator.class);
        configuration.put(JVMConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        try {
            if (!arguments2.noJdk) {
                List<File> list = PathUtil.getJdkClassesRoots();
                Intrinsics.checkExpressionValueIsNotNull(list, "PathUtil.getJdkClassesRoots()");
                JvmContentRootsKt.addJvmClasspathRoots(configuration, list);
            }
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageSeverityCollector, t);
            return ExitCode.INTERNAL_ERROR;
        }
        try {
            PluginCliParser.loadPlugins(arguments2, configuration);
        }
        catch (PluginCliOptionProcessingException e) {
            void $receiver;
            Throwable throwable = e;
            StringBuilder stringBuilder = new StringBuilder();
            String string = $receiver.getMessage();
            String message = stringBuilder.append(string).append("\n\n").append(CliOptionsKt.cliPluginUsageString(e.getPluginId(), e.getOptions())).toString();
            messageSeverityCollector.report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (CliOptionProcessingException e) {
            void $receiver;
            String string;
            Throwable message = e;
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            MessageSeverityCollector messageSeverityCollector2 = messageSeverityCollector;
            String string2 = string = $receiver.getMessage();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            messageSeverityCollector2.report(compilerMessageSeverity, string2, CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageSeverityCollector, t);
            return ExitCode.INTERNAL_ERROR;
        }
        if (arguments2.script) {
            if (arguments2.freeArgs.isEmpty()) {
                messageSeverityCollector.report(CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", CompilerMessageLocation.NO_LOCATION);
                return ExitCode.COMPILATION_ERROR;
            }
            String string = (String)arguments2.freeArgs.get(0);
            Intrinsics.checkExpressionValueIsNotNull(string, "arguments.freeArgs.get(0)");
            ContentRootsKt.addKotlinSourceRoot(configuration, string);
        } else if (arguments2.module == null) {
            Iterator $receiver = arguments2.freeArgs.iterator();
            while ($receiver.hasNext()) {
                String arg;
                String string = arg = (String)$receiver.next();
                Intrinsics.checkExpressionValueIsNotNull(string, "arg");
                ContentRootsKt.addKotlinSourceRoot(configuration, string);
                File file = new File(arg);
                if (!file.isDirectory()) continue;
                JvmContentRootsKt.addJavaSourceRoot$default(configuration, file, null, 2);
            }
        }
        KotlinPaths kotlinPaths = paths;
        Intrinsics.checkExpressionValueIsNotNull(kotlinPaths, "paths");
        JvmContentRootsKt.addJvmClasspathRoots(configuration, K2JVMCompiler.Companion.getClasspath(kotlinPaths, arguments2));
        String string = arguments2.moduleName;
        if (string == null) {
            string = "main";
        }
        configuration.put(JVMConfigurationKeys.MODULE_NAME, string);
        if (arguments2.module == null && arguments2.freeArgs.isEmpty() && !arguments2.version) {
            ReplFromTerminal.run(rootDisposable, configuration);
            return ExitCode.OK;
        }
        configuration.put(JVMConfigurationKeys.SCRIPT_PARAMETERS, arguments2.script ? CommandLineScriptUtils.scriptParameters() : CollectionsKt.emptyList());
        K2JVMCompiler.Companion.putAdvancedOptions(configuration, arguments2);
        messageSeverityCollector.report(CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", CompilerMessageLocation.NO_LOCATION);
        try {
            KotlinCoreEnvironment environment2;
            Object friendPaths;
            File outputDir;
            File jar;
            this.configureEnvironment(configuration, (CommonCompilerArguments)arguments2);
            String destination = arguments2.destination;
            if (destination != null) {
                boolean isJar = StringsKt.endsWith$default(destination, ".jar", false, 2);
                jar = isJar ? new File(destination) : (File)null;
                outputDir = isJar ? (File)null : new File(destination);
            } else {
                jar = null;
                outputDir = null;
            }
            Object object = arguments2.friendPaths;
            if (arguments2.friendPaths == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = friendPaths = CollectionsKt.emptyList();
            }
            if (arguments2.module != null) {
                CompilerConfiguration compilerConfiguration;
                FilteringMessageCollector sanitizedCollector = new FilteringMessageCollector(messageSeverityCollector, Predicates.in((Collection)CompilerMessageSeverity.VERBOSE));
                ModuleScriptData moduleScript = CompileEnvironmentUtil.loadModuleDescriptions(arguments2.module, sanitizedCollector);
                if (outputDir != null) {
                    messageSeverityCollector.report(CompilerMessageSeverity.WARNING, "The '-d' option with a directory destination is ignored because '-module' is specified", CompilerMessageLocation.NO_LOCATION);
                }
                File directory = new File(arguments2.module).getAbsoluteFile().getParentFile();
                CompilerConfiguration compilerConfiguration2 = compilerConfiguration = KotlinToJVMBytecodeCompiler.createCompilerConfiguration(configuration, moduleScript.getModules(), directory);
                Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration2, "compilerConfiguration");
                environment2 = this.createCoreEnvironment(rootDisposable, compilerConfiguration2);
                if (messageSeverityCollector.anyReported(CompilerMessageSeverity.ERROR)) {
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.compileModules(environment2, configuration, moduleScript.getModules(), directory, jar, (List<String>)friendPaths, arguments2.includeRuntime);
            } else if (arguments2.script) {
                void $receiver;
                Collection moduleScript = arguments2.freeArgs;
                int n = 1;
                List list = arguments2.freeArgs;
                int n2 = $receiver.size();
                List<String> scriptArgs = list.subList(n, n2);
                environment2 = this.createCoreEnvironment(rootDisposable, configuration);
                if (messageSeverityCollector.anyReported(CompilerMessageSeverity.ERROR)) {
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.compileAndExecuteScript(configuration, paths, environment2, scriptArgs);
            } else {
                environment2 = this.createCoreEnvironment(rootDisposable, configuration);
                if (messageSeverityCollector.anyReported(CompilerMessageSeverity.ERROR)) {
                    return ExitCode.COMPILATION_ERROR;
                }
                if (environment2.getSourceFiles().isEmpty()) {
                    if (arguments2.version) {
                        return ExitCode.OK;
                    }
                    messageSeverityCollector.report(CompilerMessageSeverity.ERROR, "No source files", CompilerMessageLocation.NO_LOCATION);
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.compileBunchOfSources(environment2, jar, outputDir, (List<String>)friendPaths, arguments2.includeRuntime);
            }
            if (arguments2.reportPerf) {
                Companion.reportGCTime(environment2.getConfiguration());
                Companion.reportCompilationTime(environment2.getConfiguration());
                PerformanceCounter.Companion.report((Function1<? super String, ? extends Unit>)new Function1<String, Unit>(environment2){
                    final /* synthetic */ KotlinCoreEnvironment $environment;

                    public final void invoke(@NotNull String s) {
                        Intrinsics.checkParameterIsNotNull(s, "s");
                        K2JVMCompiler.Companion.reportPerf(this.$environment.getConfiguration(), s);
                    }
                    {
                        this.$environment = kotlinCoreEnvironment;
                        super(1);
                    }
                });
            }
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            messageSeverityCollector.report(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private final KotlinCoreEnvironment createCoreEnvironment(Disposable rootDisposable, CompilerConfiguration configuration) {
        List<String> list = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull(list, "EnvironmentConfigFiles.JVM_CONFIG_FILES");
        KotlinCoreEnvironment result2 = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, list);
        if (K2JVMCompiler.Companion.getInitStartNanos() != 0L) {
            long initNanos = System.nanoTime() - K2JVMCompiler.Companion.getInitStartNanos();
            Companion.reportPerf(configuration, "INIT: Compiler initialized in " + TimeUnit.NANOSECONDS.toMillis(initNanos) + " ms");
            K2JVMCompiler.Companion.setInitStartNanos(0L);
        }
        return result2;
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments result2 = new K2JVMCompilerArguments();
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            result2.reportPerf = true;
        }
        return result2;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Companion.main(args);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0005\b\u000b\u0005AI!B\u0001\u0005\f\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0001\u0015\t\u0001\u0012C\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Aaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K=!\u0011\u0001#\u0005\u000e\t%\u0011\u0011\"\u0001M\n1%I2\u0001\u0003\u0006\u000e\u0003aU\u0011d\u0001\u0005\f\u001b\u0005A:\"j\u0007\u0005\b!aQ\"\u0001M\r3\u0019AQ\"\u0004\u0003\n\u0005%\t\u0001T\u0001M\u000e#\u000e\t\u0001BD\u0013\r\t\u0005Ai\"D\u0001\u0019\u001ae\u0019\u0001bD\u0007\u00021?I2\u0001C\u0006\u000e\u0003a]Qe\u0002\u0005\u0011\u001b\u0005AJ\"G\u0002\t\u001f5\t\u0001tD\u0013\b\u0011Ci\u0011\u0001'\u0007\u001a\u0007!yQ\"\u0001M\u0010K-A\u0011#D\u0001\u0019\u001ae\u0019\u0001bD\u0007\u00021?I2\u0001c\t\u000e\u0003a\u0015Qe\u0001\u0005\u0013\u001b\u0005AJ\"K\t\u0005\u0003\"A\u0019!D\u0004\n\u0005%\t\u0001TA\u0005\u0003\u0013\u0005A2\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011\u001d\u0001\u0002B\u0015\u000f\t\u0005c\u0002\u0012B\u0007\u00021\r\t6\u0001C\u0003\u0002\u0019\u0003i!\u0001B\u0003\t\fE\u0011AA\u0002E\u0007S9!\u0011\t\b\u0005\b\u001b\u0005A2!U\u0002\t\u000b\u0005a\t!\u0004\u0002\u0005\u0010!-\u0011C\u0001\u0003\t\u0011\u001b\u0001"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$Companion;", "", "()V", "elapsedGCTime", "Ljava/util/HashMap;", "", "", "getElapsedGCTime", "()Ljava/util/HashMap;", "elapsedJITTime", "getElapsedJITTime", "()J", "setElapsedJITTime", "(J)V", "initStartNanos", "getInitStartNanos", "setInitStartNanos", "getClasspath", "", "Ljava/io/File;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "main", "", "args", "", "([Ljava/lang/String;)V", "putAdvancedOptions", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "reportCompilationTime", "reportGCTime", "reportPerf", "message", "resetInitStartTime"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final long getInitStartNanos() {
            return initStartNanos;
        }

        private final void setInitStartNanos(long l) {
            initStartNanos = l;
        }

        private final HashMap<String, Long> getElapsedGCTime() {
            return elapsedGCTime;
        }

        private final long getElapsedJITTime() {
            return elapsedJITTime;
        }

        private final void setElapsedJITTime(long l) {
            elapsedJITTime = l;
        }

        public final void resetInitStartTime() {
            if (this.getInitStartNanos() == 0L) {
                this.setInitStartNanos(System.nanoTime());
            }
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull(args, "args");
            CLICompiler.doMain(new K2JVMCompiler(), args);
        }

        public final void reportPerf(@NotNull CompilerConfiguration configuration, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(message, "message");
            MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector == null) {
                Intrinsics.throwNpe();
            }
            MessageCollector collector2 = messageCollector;
            collector2.report(CompilerMessageSeverity.INFO, "PERF: " + message, CompilerMessageLocation.NO_LOCATION);
        }

        /*
         * WARNING - void declaration
         */
        public final void reportGCTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Iterable $receiver = ManagementFactory.getGarbageCollectorMXBeans();
            for (Object element : $receiver) {
                void key;
                void $receiver2;
                GarbageCollectorMXBean it2 = (GarbageCollectorMXBean)element;
                long currentTime = it2.getCollectionTime();
                Map map2 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it2.getName(), "it.getName()");
                Object value2 = $receiver2.get(key);
                long elapsedTime = ((Number)(value2 == null && !$receiver2.containsKey(key) ? Long.valueOf(0L) : value2)).longValue();
                long time = currentTime - elapsedTime;
                Companion.reportPerf(configuration, "GC time for " + it2.getName() + " is " + time + " ms");
                Map map3 = Companion.getElapsedGCTime();
                String string = it2.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.getName()");
                MapsKt.set(map3, string, currentTime);
            }
        }

        public final void reportCompilationTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (compilationMXBean == null) {
                return;
            }
            CompilationMXBean bean = compilationMXBean;
            long currentTime = bean.getTotalCompilationTime();
            this.reportPerf(configuration, "JIT time is " + (currentTime - this.getElapsedJITTime()) + " ms");
            this.setElapsedJITTime(currentTime);
        }

        private final void putAdvancedOptions(CompilerConfiguration configuration, K2JVMCompilerArguments arguments2) {
            configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments2.noCallAssertions);
            configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments2.noParamAssertions);
            configuration.put(JVMConfigurationKeys.DISABLE_INLINE, arguments2.noInline);
            configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments2.noOptimize);
        }

        /*
         * WARNING - void declaration
         */
        private final List<File> getClasspath(KotlinPaths paths, K2JVMCompilerArguments arguments2) {
            ArrayList<File> classpath = CollectionsKt.arrayListOf(new File[0]);
            if (arguments2.classpath != null) {
                List list;
                void destination;
                void $receiver;
                void $receiver2;
                Iterable iterable = StringsKt.split$default((CharSequence)arguments2.classpath, new char[]{File.pathSeparatorChar}, false, 0, 6);
                ArrayList<File> arrayList = classpath;
                void var5_6 = $receiver2;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
                for (Object item : $receiver) {
                    void it2;
                    String string = (String)item;
                    list = destination;
                    File file = new File((String)it2);
                    list.add(file);
                }
                list = (List)destination;
                arrayList.addAll(list);
            }
            if (!arguments2.noStdlib) {
                classpath.add(paths.getRuntimePath());
            }
            return classpath;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

