/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.config.PropertySetterException;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.OptionHandler;

public class PropertySetter {
    protected Object obj;
    protected PropertyDescriptor[] props;
    static /* synthetic */ Class class$org$apache$log4j$spi$OptionHandler;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Priority;
    static /* synthetic */ Class class$org$apache$log4j$spi$ErrorHandler;

    public PropertySetter(Object obj) {
        this.obj = obj;
    }

    protected void introspect() {
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.obj.getClass());
            this.props = bi.getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            LogLog.error(new StringBuffer().append("Failed to introspect ").append(this.obj).append(": ").append(ex.getMessage()).toString());
            this.props = new PropertyDescriptor[0];
        }
    }

    public static void setProperties(Object obj, Properties properties2, String prefix) {
        new PropertySetter(obj).setProperties(properties2, prefix);
    }

    public void setProperties(Properties properties2, String prefix) {
        int len = prefix.length();
        Enumeration<?> e = properties2.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix) || key.indexOf(46, len + 1) > 0) continue;
            String value2 = OptionConverter.findAndSubst(key, properties2);
            if (("layout".equals(key = key.substring(len)) || "errorhandler".equals(key)) && this.obj instanceof Appender) continue;
            PropertyDescriptor prop = this.getPropertyDescriptor(Introspector.decapitalize(key));
            if (prop != null && (class$org$apache$log4j$spi$OptionHandler == null ? PropertySetter.class$("org.apache.log4j.spi.OptionHandler") : class$org$apache$log4j$spi$OptionHandler).isAssignableFrom(prop.getPropertyType()) && prop.getWriteMethod() != null) {
                OptionHandler opt = (OptionHandler)OptionConverter.instantiateByKey(properties2, new StringBuffer().append(prefix).append(key).toString(), prop.getPropertyType(), null);
                PropertySetter setter2 = new PropertySetter(opt);
                setter2.setProperties(properties2, new StringBuffer().append(prefix).append(key).append(".").toString());
                try {
                    prop.getWriteMethod().invoke(this.obj, opt);
                }
                catch (IllegalAccessException ex) {
                    LogLog.warn(new StringBuffer().append("Failed to set property [").append(key).append("] to value \"").append(value2).append("\". ").toString(), ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof InterruptedException || ex.getTargetException() instanceof InterruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    LogLog.warn(new StringBuffer().append("Failed to set property [").append(key).append("] to value \"").append(value2).append("\". ").toString(), ex);
                }
                catch (RuntimeException ex) {
                    LogLog.warn(new StringBuffer().append("Failed to set property [").append(key).append("] to value \"").append(value2).append("\". ").toString(), ex);
                }
                continue;
            }
            this.setProperty(key, value2);
        }
        this.activate();
    }

    public void setProperty(String name, String value2) {
        if (value2 == null) {
            return;
        }
        PropertyDescriptor prop = this.getPropertyDescriptor(name = Introspector.decapitalize(name));
        if (prop == null) {
            LogLog.warn(new StringBuffer().append("No such property [").append(name).append("] in ").append(this.obj.getClass().getName()).append(".").toString());
        } else {
            try {
                this.setProperty(prop, name, value2);
            }
            catch (PropertySetterException ex) {
                LogLog.warn(new StringBuffer().append("Failed to set property [").append(name).append("] to value \"").append(value2).append("\". ").toString(), ex.rootCause);
            }
        }
    }

    public void setProperty(PropertyDescriptor prop, String name, String value2) throws PropertySetterException {
        Object arg;
        Method setter2 = prop.getWriteMethod();
        if (setter2 == null) {
            throw new PropertySetterException(new StringBuffer().append("No setter for property [").append(name).append("].").toString());
        }
        Class<?>[] paramTypes = setter2.getParameterTypes();
        if (paramTypes.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            arg = this.convertArg(value2, paramTypes[0]);
        }
        catch (Throwable t) {
            throw new PropertySetterException(new StringBuffer().append("Conversion to type [").append(paramTypes[0]).append("] failed. Reason: ").append(t).toString());
        }
        if (arg == null) {
            throw new PropertySetterException(new StringBuffer().append("Conversion to type [").append(paramTypes[0]).append("] failed.").toString());
        }
        LogLog.debug(new StringBuffer().append("Setting property [").append(name).append("] to [").append(arg).append("].").toString());
        try {
            setter2.invoke(this.obj, arg);
        }
        catch (IllegalAccessException ex) {
            throw new PropertySetterException(ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof InterruptedException || ex.getTargetException() instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            throw new PropertySetterException(ex);
        }
        catch (RuntimeException ex) {
            throw new PropertySetterException(ex);
        }
    }

    protected Object convertArg(String val, Class type2) {
        if (val == null) {
            return null;
        }
        String v = val.trim();
        if ((class$java$lang$String == null ? (class$java$lang$String = PropertySetter.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type2)) {
            return val;
        }
        if (Integer.TYPE.isAssignableFrom(type2)) {
            return new Integer(v);
        }
        if (Long.TYPE.isAssignableFrom(type2)) {
            return new Long(v);
        }
        if (Boolean.TYPE.isAssignableFrom(type2)) {
            if ("true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
        } else {
            if ((class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = PropertySetter.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority).isAssignableFrom(type2)) {
                return OptionConverter.toLevel(v, Level.DEBUG);
            }
            if ((class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = PropertySetter.class$("org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler).isAssignableFrom(type2)) {
                return OptionConverter.instantiateByClassName(v, class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = PropertySetter.class$("org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler, null);
            }
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        if (this.props == null) {
            this.introspect();
        }
        for (int i = 0; i < this.props.length; ++i) {
            if (!name.equals(this.props[i].getName())) continue;
            return this.props[i];
        }
        return null;
    }

    public void activate() {
        if (this.obj instanceof OptionHandler) {
            ((OptionHandler)this.obj).activateOptions();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

