/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.structure.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.SequencesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaConstructor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaField;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectJavaClass
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaClass {
    private final Class<?> klass;

    @Override
    @NotNull
    public Class<?> getElement() {
        return this.klass;
    }

    @Override
    public int getModifiers() {
        return this.klass.getModifiers();
    }

    @NotNull
    public List<ReflectJavaClass> getInnerClasses() {
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filterNot(ArraysKt.asSequence((Object[])this.klass.getDeclaredClasses()), getInnerClasses.1.INSTANCE), (Function1)((Object)Reflection.function(getInnerClasses.2.INSTANCE))));
    }

    @Override
    @NotNull
    public FqName getFqName() {
        return ReflectClassUtilKt.getClassId(this.klass).asSingleFqName();
    }

    @Override
    @Nullable
    public ReflectJavaClass getOuterClass() {
        ReflectJavaClass reflectJavaClass;
        Class<?> clazz = this.klass.getDeclaringClass();
        if (clazz != null) {
            Class<?> $receiver = clazz;
            Class<?> p1 = $receiver;
            reflectJavaClass = new ReflectJavaClass(p1);
        } else {
            reflectJavaClass = null;
        }
        return reflectJavaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        void var3_3;
        void $receiver;
        if (Intrinsics.areEqual(this.klass, Object.class)) {
            return CollectionsKt.emptyList();
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Type type2 = this.klass.getGenericSuperclass();
        if (type2 == null) {
            type2 = (Type)((Object)Object.class);
        }
        spreadBuilder.add(type2);
        Type[] typeArray = this.klass.getGenericInterfaces();
        Intrinsics.checkExpressionValueIsNotNull(typeArray, "klass.genericInterfaces");
        spreadBuilder.addSpread(typeArray);
        Iterable $receiver2 = CollectionsKt.listOf((Type[])spreadBuilder.toArray(new Type[spreadBuilder.size()]));
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void p1;
            Type type3 = (Type)item;
            Collection collection = destination;
            ReflectJavaClassifierType reflectJavaClassifierType = new ReflectJavaClassifierType((Type)p1);
            collection.add(reflectJavaClassifierType);
        }
        return (List)var3_3;
    }

    @NotNull
    public List<ReflectJavaMethod> getMethods() {
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filter(ArraysKt.asSequence((Object[])this.klass.getDeclaredMethods()), (Function1)new Function1<Method, Boolean>(this){
            final /* synthetic */ ReflectJavaClass this$0;

            public final boolean invoke(Method method) {
                boolean bl;
                if (method.isSynthetic()) {
                    bl = false;
                } else if (this.this$0.isEnum()) {
                    Method method2 = method;
                    Intrinsics.checkExpressionValueIsNotNull(method2, "method");
                    bl = !ReflectJavaClass.access$isEnumValuesOrValueOf(this.this$0, method2);
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = reflectJavaClass;
                super(1);
            }
        }), (Function1)((Object)Reflection.function(getMethods.2.INSTANCE))));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean isEnumValuesOrValueOf(Method method) {
        block4: {
            boolean bl;
            block5: {
                String string;
                String string2 = string = method.getName();
                if (string2 == null) break block4;
                switch (string2.hashCode()) {
                    case -823812830: {
                        if (!string.equals("values")) return false;
                        break;
                    }
                    case 231605032: {
                        if (!string.equals("valueOf")) return false;
                        break block5;
                    }
                }
                bl = ArraysKt.isEmpty((Object[])method.getParameterTypes());
                return bl;
            }
            bl = Arrays.equals(method.getParameterTypes(), new Class[]{String.class});
            return bl;
        }
        return false;
    }

    @NotNull
    public List<ReflectJavaField> getFields() {
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filter(ArraysKt.asSequence((Object[])this.klass.getDeclaredFields()), getFields.1.INSTANCE), (Function1)((Object)Reflection.function(getFields.2.INSTANCE))));
    }

    @NotNull
    public List<ReflectJavaConstructor> getConstructors() {
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filter(ArraysKt.asSequence((Object[])this.klass.getDeclaredConstructors()), getConstructors.1.INSTANCE), (Function1)((Object)Reflection.function(getConstructors.2.INSTANCE))));
    }

    @Override
    @NotNull
    public ReflectJavaClassifierType getDefaultType() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public JavaClass.OriginKind getOriginKind() {
        return JavaClass.OriginKind.COMPILED;
    }

    @Override
    @NotNull
    public JavaType createImmediateType(@NotNull JavaTypeSubstitutor substitutor2) {
        Intrinsics.checkParameterIsNotNull(substitutor2, "substitutor");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = Name.identifier(this.klass.getSimpleName());
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(klass.getSimpleName())");
        return name;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReflectJavaTypeParameter> getTypeParameters() {
        void $receiver;
        void $receiver2;
        ArrayList arrayList;
        Object[] $receiver3 = this.klass.getTypeParameters();
        Object[] objectArray = $receiver3;
        Object[] objectArray2 = $receiver3;
        ArrayList arrayList2 = arrayList;
        ArrayList arrayList3 = arrayList;
        int n = ((void)$receiver2).length;
        arrayList2(n);
        Collection destination = arrayList3;
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void it2;
            void item = $receiver[i];
            TypeVariable typeVariable = (TypeVariable)item;
            Collection collection = destination;
            void v1 = it2;
            Intrinsics.checkExpressionValueIsNotNull(v1, "it");
            ReflectJavaTypeParameter reflectJavaTypeParameter = new ReflectJavaTypeParameter((TypeVariable<?>)v1);
            collection.add(reflectJavaTypeParameter);
        }
        return (List)objectArray2;
    }

    @Override
    public boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.klass.isEnum();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ReflectJavaClass && Intrinsics.areEqual(this.klass, ((ReflectJavaClass)other).klass);
    }

    public int hashCode() {
        return this.klass.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.klass;
    }

    public ReflectJavaClass(@NotNull Class<?> klass) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        this.klass = klass;
    }

    @Override
    @NotNull
    public List<ReflectJavaAnnotation> getAnnotations() {
        return ReflectJavaAnnotationOwner.DefaultImpls.getAnnotations(this);
    }

    @Override
    @Nullable
    public ReflectJavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return ReflectJavaAnnotationOwner.DefaultImpls.findAnnotation(this, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return ReflectJavaAnnotationOwner.DefaultImpls.isDeprecatedInJavaDoc(this);
    }

    @Override
    public boolean isAbstract() {
        return ReflectJavaModifierListOwner.DefaultImpls.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return ReflectJavaModifierListOwner.DefaultImpls.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return ReflectJavaModifierListOwner.DefaultImpls.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return ReflectJavaModifierListOwner.DefaultImpls.getVisibility(this);
    }

    public static final /* synthetic */ boolean access$isEnumValuesOrValueOf(ReflectJavaClass $this, @NotNull Method method) {
        return $this.isEnumValuesOrValueOf(method);
    }
}

