/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"y\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005a\u0001!G\u0001\u0019\u0002\u00056\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u0011\t)\u0003\u0005B\u0001\t\u00065\t\u0001dA\t\u0005\t\u0001A9!F\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0003\u000e\u0003a1\u0011d\u0001E\u0007\u001b\u0005Ar!G\u0002\t\u00105\t\u0001\u0004C\r\u0007\u0011#iA!\u0003\u0002\n\u0003\u0011\u001e\u0001$C\u0013!\t\u0005A\u0019\"D\u0001\u0019\u0007E!A\u0001\u0001E\u0004+\u0005AB!G\u0002\t\u00155\t\u0001TC\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004\u001a\u0007!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\u0011e1\u0001\u0012C\u0007\u0005\u0013\tI\u0011\u0001j\u0002\u0019\u0013\u0015ZB!\u0001\u0005\f\u001b\u0005A:\"\u0007\u0003\t\u00195\u0011A\u0012\u0001M\r3\rAQ\"D\u0001\u0019\u001ce\u0019\u0001rB\u0007\u00021!IR\u0001#\u0005\u000e\u0007%\tA1\u0001\r\n3\rAa\"D\u0001\u0019\u001e\u0015j\u0002bD\u0007\u00021\rI2\u0001c\u0003\u000e\u0003a1\u0011d\u0001E\u0007\u001b\u0005Ar!G\u0002\t 5\t\u0001\u0004E\r\u0004\u0011\u001fi\u0011\u0001\u0007\u0005\u001a\u000b!EQbA\u0005\u0002\t\u0007A\u0012\"G\u0002\t\"5\t\u0001$E\u0013\u0010\u0011Gi\u0011\u0001G\u0002\u0012\t\u0011\u0001\u0001rA\u000b\u00021\u0011Ib\u0001#\u0005\u000e\t%\u0011\u0011\"\u0001S\u00041%)S\u0004B\u0001\t%5\u0011A\u0012\u0001M\u000f#\u0011!\u0001\u0001c\u0002\u0016\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\u00105\t\u0001\u0004C\r\u0007\u0011#iA!\u0003\u0002\n\u0003\u0011\u001e\u0001$C\r\u0004\u00119i\u0011\u0001'\b&;\u0011\t\u0001RE\u0007\u0003\u0019\u0003Aj\"\u0005\u0003\u0005\u0001!\u001dQ#\u0001\r\u00053\rAI!D\u0001\u0019\u000be1\u0001\u0012C\u0007\u0005\u0013\tI\u0011\u0001j\u0002\u0019\u0013e\u0019\u0001bE\u0007\u00021;I2\u0001c\u0003\u000e\u0003a1Qe\u0004E\u0014\u001b\u0005AB#\u0005\u0003\u0005\u0001!\u001dQ#\u0001\r\u00053\u0019A\t\"\u0004\u0003\n\u0005%\tAu\u0001\r\nKU!\u0011\u0001#\u000b\u000e\u00051\u0005\u0001TD\r\u0005\u0011Ui!\u0001$\u0001\u0019\u001ee!\u0001\u0002D\u0007\u0003\u0019\u0003AJ\"G\u0003\t\u00125\u0019\u0011\"\u0001C\u00021WIs\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;)V", "addConstraintForCallableReference", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "callableReference", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "addConstraintForFunctionLiteral", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunction;", "addConstraintForNestedCall", "", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "constraintPosition", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "effectiveExpectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "addConstraintForValueArgument", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "resolveFunctionArgumentBodies", "Lorg/jetbrains/kotlin/resolve/calls/callResolverUtil/ResolveArgumentsMode;", "completeTypeInferenceDependentOnFunctionArgumentsForCall", "getExpectedTypeForCallableReference", "getResolvedTypeForCallableReference", "expectedType", "inferTypeArguments", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "updateResultTypeForSmartCasts", "type", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;"}, moduleName="kotlin-compiler")
public final class GenericCandidateResolver {
    private final ArgumentTypeResolver argumentTypeResolver;

    @NotNull
    public final <D extends CallableDescriptor> ResolutionStatus inferTypeArguments(@NotNull CallCandidateResolutionContext<D> context) {
        boolean hasContradiction;
        Intrinsics.checkParameterIsNotNull(context, "context");
        MutableResolvedCall candidateCall = context.candidateCall;
        Object candidate = candidateCall.getCandidateDescriptor();
        ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
        candidateCall.setConstraintSystem(constraintSystem);
        Object candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidate);
        Iterable iterable = candidateWithFreshVariables.getTypeParameters();
        Iterable iterable2 = candidate.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(iterable2, "candidate.getTypeParameters()");
        Map conversionToOriginal = MapsKt.toMap(CollectionsKt.zip(iterable, iterable2));
        Collection collection = candidateWithFreshVariables.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection, "candidateWithFreshVariables.getTypeParameters()");
        ConstraintSystem.DefaultImpls.registerTypeVariables$default(constraintSystem, collection, inferTypeArguments.1.INSTANCE, new Function1<TypeParameterDescriptor, TypeParameterDescriptor>(conversionToOriginal){
            final /* synthetic */ Map $conversionToOriginal;

            @NotNull
            public final TypeParameterDescriptor invoke(@NotNull TypeParameterDescriptor it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                V v = this.$conversionToOriginal.get(it2);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                return (TypeParameterDescriptor)v;
            }
            {
                this.$conversionToOriginal = map2;
                super(1);
            }
        }, false, 8);
        Collection collection2 = candidate.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection2, "candidate.getTypeParameters()");
        KotlinType kotlinType = TypeUtils.DONT_CARE;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "DONT_CARE");
        TypeSubstitutor substituteDontCare = GenericCandidateResolverKt.makeConstantSubstitutor(collection2, kotlinType);
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : CollectionsKt.mutableEntrySet(candidateCall.getValueArguments())) {
            ResolvedValueArgument resolvedValueArgument = CollectionsKt.getValue(entry);
            ValueParameterDescriptor valueParameterDescriptor = candidate.getValueParameters().get(CollectionsKt.getKey(entry).getIndex());
            Iterator<ValueArgument> iterator2 = resolvedValueArgument.getArguments().iterator();
            while (iterator2.hasNext()) {
                ValueArgument valueArgument;
                ValueArgument valueArgument2 = valueArgument = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(valueArgument2, "valueArgument");
                ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "valueParameterDescriptor");
                this.addConstraintForValueArgument(valueArgument2, valueParameterDescriptor2, substituteDontCare, constraintSystem, context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            }
        }
        ReceiverValue receiverArgument = candidateCall.getExtensionReceiver();
        ReceiverParameterDescriptor receiverParameter = candidate.getExtensionReceiverParameter();
        if (receiverArgument.exists() && receiverParameter != null) {
            KotlinType receiverType;
            KotlinType kotlinType2 = receiverType = context.candidateCall.isSafeCall() ? TypeUtils.makeNotNullable(receiverArgument.getType()) : receiverArgument.getType();
            if (receiverArgument instanceof ExpressionReceiver) {
                receiverType = this.updateResultTypeForSmartCasts(receiverType, ((ExpressionReceiver)receiverArgument).getExpression(), (ResolutionContext)context);
            }
            KotlinType kotlinType3 = receiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "receiverParameter.getType()");
            constraintSystem.addSubtypeConstraint(receiverType, kotlinType3, ConstraintPositionKind.RECEIVER_POSITION.position());
        }
        if (!(hasContradiction = constraintSystem.getStatus().hasContradiction())) {
            return ResolutionStatus.INCOMPLETE_TYPE_INFERENCE;
        }
        return ResolutionStatus.OTHER_ERROR;
    }

    public final void addConstraintForValueArgument(@NotNull ValueArgument valueArgument, @NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull ConstraintSystem constraintSystem, @NotNull CallCandidateResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveFunctionArgumentBodies) {
        Intrinsics.checkParameterIsNotNull(valueArgument, "valueArgument");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptor, "valueParameterDescriptor");
        Intrinsics.checkParameterIsNotNull(substitutor2, "substitutor");
        Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)resolveFunctionArgumentBodies, "resolveFunctionArgumentBodies");
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
        KtExpression argumentExpression = valueArgument.getArgumentExpression();
        KotlinType expectedType = substitutor2.substitute(effectiveExpectedType, Variance.INVARIANT);
        DataFlowInfo dataFlowInfoForArgument = context.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument);
        KotlinTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(argumentExpression, newContext, resolveFunctionArgumentBodies);
        context.candidateCall.getDataFlowInfoForArguments().updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        ConstraintPosition constraintPosition = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        CallCandidateResolutionContext callCandidateResolutionContext = newContext;
        Intrinsics.checkExpressionValueIsNotNull(callCandidateResolutionContext, "newContext");
        if (this.addConstraintForNestedCall(argumentExpression, constraintPosition, constraintSystem, callCandidateResolutionContext, effectiveExpectedType)) {
            return;
        }
        KotlinType kotlinType = typeInfoForCall.getType();
        Object Context2 = context.replaceDataFlowInfo(dataFlowInfoForArgument);
        Intrinsics.checkExpressionValueIsNotNull(Context2, "context.replaceDataFlowI\u2026(dataFlowInfoForArgument)");
        KotlinType type2 = this.updateResultTypeForSmartCasts(kotlinType, argumentExpression, (ResolutionContext<?>)Context2);
        constraintSystem.addSubtypeConstraint(type2, effectiveExpectedType, constraintPosition);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addConstraintForNestedCall(KtExpression argumentExpression, ConstraintPosition constraintPosition, ConstraintSystem constraintSystem, CallCandidateResolutionContext<?> context, KotlinType effectiveExpectedType) {
        void destination;
        void $receiver;
        void $receiver2;
        boolean bl;
        Object it2;
        List nestedTypeVariables;
        Object candidateDescriptor;
        block7: {
            OverloadResolutionResultsImpl<?> resolutionResults;
            ResolutionResultsCache.CachedData cachedData = GenericCandidateResolverKt.getResolutionResultsCachedData(argumentExpression, (ResolutionContext)context);
            OverloadResolutionResultsImpl<Object> overloadResolutionResultsImpl = resolutionResults = cachedData != null ? cachedData.getResolutionResults() : null;
            if (resolutionResults == null || !resolutionResults.isSingleResult()) {
                return false;
            }
            ResolvedCall resultingCall = resolutionResults.getResultingCall();
            if (resultingCall.isCompleted()) {
                return false;
            }
            ConstraintSystemImpl constraintSystemImpl = (ConstraintSystemImpl)resultingCall.getConstraintSystem();
            if (constraintSystemImpl == null) {
                return false;
            }
            ConstraintSystemImpl argumentConstraintSystem = constraintSystemImpl;
            candidateDescriptor = resultingCall.getCandidateDescriptor();
            KotlinType kotlinType = candidateDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType returnType2 = kotlinType;
            Object $receiver3 = argumentConstraintSystem;
            nestedTypeVariables = ConstraintSystemImpl.getNestedTypeVariables$default((ConstraintSystemImpl)$receiver3, returnType2, false, 1);
            $receiver3 = nestedTypeVariables;
            Iterator $i$a$1 = $receiver3.iterator();
            while ($i$a$1.hasNext()) {
                Object element = $i$a$1.next();
                it2 = (TypeParameterDescriptor)element;
                if (!CollectionsKt.isNotEmpty(argumentConstraintSystem.getTypeBounds((TypeParameterDescriptor)it2).getBounds())) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        Object candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidateDescriptor);
        Iterable iterable = candidateDescriptor.getTypeParameters();
        Iterable iterable2 = candidateWithFreshVariables.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(iterable2, "candidateWithFreshVariables.getTypeParameters()");
        Map conversion = MapsKt.toMap(CollectionsKt.zip(iterable, iterable2));
        it2 = nestedTypeVariables;
        void $i$a$1 = $receiver2;
        Collection $i$f$any = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it3;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item;
            void var24_21 = destination;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)conversion.get(it3);
            var24_21.add(typeParameterDescriptor2);
        }
        List freshVariables = CollectionsKt.filterNotNull((List)destination);
        constraintSystem.registerTypeVariables(freshVariables, addConstraintForNestedCall.2.INSTANCE, addConstraintForNestedCall.3.INSTANCE, true);
        constraintSystem.addSubtypeConstraint(candidateWithFreshVariables.getReturnType(), effectiveExpectedType, constraintPosition);
        return true;
    }

    private final KotlinType updateResultTypeForSmartCasts(KotlinType type2, KtExpression argumentExpression, ResolutionContext<?> context) {
        KtExpression deparenthesizedArgument = KtPsiUtil.getLastElementDeparenthesized(argumentExpression, context.statementFilter);
        if (deparenthesizedArgument == null || type2 == null) {
            return type2;
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(deparenthesizedArgument, type2, context);
        if (!dataFlowValue.isPredictable()) {
            return type2;
        }
        Set<KotlinType> possibleTypes = context.dataFlowInfo.getPossibleTypes(dataFlowValue);
        if (possibleTypes.isEmpty()) {
            return type2;
        }
        return TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, (Collection<KotlinType>)possibleTypes);
    }

    /*
     * WARNING - void declaration
     */
    public final <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionArgumentsForCall(@NotNull CallCandidateResolutionContext<D> context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        MutableResolvedCall resolvedCall = context.candidateCall;
        ConstraintSystem constraintSystem = resolvedCall.getConstraintSystem();
        if (constraintSystem == null) {
            return;
        }
        ConstraintSystem constraintSystem2 = constraintSystem;
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : CollectionsKt.mutableEntrySet(resolvedCall.getValueArguments())) {
            ResolvedValueArgument resolvedValueArgument = CollectionsKt.getValue(entry);
            ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.getKey(entry);
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                Unit unit;
                if (valueArgument.getArgumentExpression() != null) {
                    Unit unit2;
                    Unit unit3;
                    KtCallableReferenceExpression $receiver;
                    void $receiver2;
                    KtExpression argumentExpression = (KtExpression)$receiver2;
                    if (ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(argumentExpression, context) != null) {
                        KtFunction functionLiteral;
                        KtFunction ktFunction = functionLiteral = (KtFunction)((Object)$receiver);
                        Intrinsics.checkExpressionValueIsNotNull(ktFunction, "functionLiteral");
                        ValueArgument valueArgument2 = valueArgument;
                        Intrinsics.checkExpressionValueIsNotNull(valueArgument2, "valueArgument");
                        ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
                        Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "valueParameterDescriptor");
                        ConstraintSystem constraintSystem3 = constraintSystem2;
                        Intrinsics.checkExpressionValueIsNotNull(constraintSystem3, "constraintSystem");
                        this.addConstraintForFunctionLiteral(ktFunction, valueArgument2, valueParameterDescriptor2, constraintSystem3, context);
                        unit3 = Unit.INSTANCE;
                    } else {
                        unit3 = null;
                    }
                    if (ArgumentTypeResolver.getCallableReferenceExpressionIfAny(argumentExpression, (CallResolutionContext)context) != null) {
                        KtCallableReferenceExpression callableReference;
                        KtCallableReferenceExpression ktCallableReferenceExpression = callableReference = $receiver;
                        Intrinsics.checkExpressionValueIsNotNull(ktCallableReferenceExpression, "callableReference");
                        ValueArgument valueArgument3 = valueArgument;
                        Intrinsics.checkExpressionValueIsNotNull(valueArgument3, "valueArgument");
                        ValueParameterDescriptor valueParameterDescriptor3 = valueParameterDescriptor;
                        Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor3, "valueParameterDescriptor");
                        ConstraintSystem constraintSystem4 = constraintSystem2;
                        Intrinsics.checkExpressionValueIsNotNull(constraintSystem4, "constraintSystem");
                        this.addConstraintForCallableReference(ktCallableReferenceExpression, valueArgument3, valueParameterDescriptor3, constraintSystem4, context);
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    unit = unit2;
                    continue;
                }
                unit = null;
            }
        }
        resolvedCall.setResultingSubstitutor(constraintSystem2.getResultingSubstitutor());
    }

    private final <D extends CallableDescriptor> void addConstraintForFunctionLiteral(KtFunction functionLiteral, ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, ConstraintSystem constraintSystem, CallCandidateResolutionContext<D> context) {
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
        KotlinType expectedType = constraintSystem.getCurrentSubstitutor().substitute(effectiveExpectedType, Variance.INVARIANT);
        if (expectedType == null || TypeUtils.isDontCarePlaceholder(expectedType)) {
            expectedType = this.argumentTypeResolver.getShapeTypeOfFunctionLiteral(functionLiteral, context.scope, context.trace, false);
        }
        if (expectedType == null || !KotlinBuiltIns.isFunctionOrExtensionFunctionType(expectedType) || CallResolverUtilKt.hasUnknownFunctionParameter(expectedType)) {
            return;
        }
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = context.candidateCall.getDataFlowInfoForArguments();
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfoForArguments.getInfo(valueArgument);
        boolean hasExpectedReturnType = !CallResolverUtilKt.hasUnknownReturnType(expectedType);
        ConstraintPosition position = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        if (hasExpectedReturnType) {
            TemporaryTraceAndCache temporaryToResolveFunctionLiteral = TemporaryTraceAndCache.create(context, "trace to resolve function literal with expected return type", argumentExpression);
            KtExpression ktExpression2 = KtPsiUtil.getExpressionOrLastStatementInBlock(functionLiteral.getBodyExpression());
            if (ktExpression2 == null) {
                return;
            }
            KtExpression statementExpression = ktExpression2;
            boolean[] mismatch = new boolean[1];
            ObservableBindingTrace errorInterceptingTrace = ExpressionTypingUtils.makeTraceInterceptingTypeMismatch(temporaryToResolveFunctionLiteral.trace, statementExpression, mismatch);
            CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceBindingTrace(errorInterceptingTrace)).replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceResolutionResultsCache(temporaryToResolveFunctionLiteral.cache)).replaceContextDependency(ContextDependency.INDEPENDENT);
            KotlinType type2 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
            if (!mismatch[0]) {
                constraintSystem.addSubtypeConstraint(type2, effectiveExpectedType, position);
                temporaryToResolveFunctionLiteral.commit();
                return;
            }
        }
        KotlinType expectedTypeWithoutReturnType = CallResolverUtilKt.replaceReturnTypeByUnknown(expectedType);
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(expectedTypeWithoutReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KotlinType type3 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
        constraintSystem.addSubtypeConstraint(type3, effectiveExpectedType, position);
    }

    private final <D extends CallableDescriptor> void addConstraintForCallableReference(KtCallableReferenceExpression callableReference, ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, ConstraintSystem constraintSystem, CallCandidateResolutionContext<D> context) {
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
        KotlinType kotlinType = this.getExpectedTypeForCallableReference(callableReference, constraintSystem, context, effectiveExpectedType);
        if (kotlinType == null) {
            return;
        }
        KotlinType expectedType = kotlinType;
        if (!ReflectionTypes.Companion.isCallableType(expectedType)) {
            return;
        }
        KotlinType resolvedType = this.getResolvedTypeForCallableReference(callableReference, context, expectedType, valueArgument);
        ConstraintPosition position = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        constraintSystem.addSubtypeConstraint(resolvedType, effectiveExpectedType, position);
    }

    private final <D extends CallableDescriptor> KotlinType getExpectedTypeForCallableReference(KtCallableReferenceExpression callableReference, ConstraintSystem constraintSystem, CallCandidateResolutionContext<D> context, KotlinType effectiveExpectedType) {
        KotlinType substitutedType = constraintSystem.getCurrentSubstitutor().substitute(effectiveExpectedType, Variance.INVARIANT);
        if (substitutedType != null && !TypeUtils.isDontCarePlaceholder(substitutedType)) {
            return substitutedType;
        }
        KotlinType shapeType = this.argumentTypeResolver.getShapeTypeOfCallableReference(callableReference, (CallResolutionContext)context, false);
        if (shapeType != null && KotlinBuiltIns.isFunctionOrExtensionFunctionType(shapeType) && !CallResolverUtilKt.hasUnknownFunctionParameter(shapeType)) {
            return shapeType;
        }
        return null;
    }

    private final <D extends CallableDescriptor> KotlinType getResolvedTypeForCallableReference(KtCallableReferenceExpression callableReference, CallCandidateResolutionContext<D> context, KotlinType expectedType, ValueArgument valueArgument) {
        DataFlowInfo dataFlowInfoForArgument = context.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        KotlinType expectedTypeWithoutReturnType = !CallResolverUtilKt.hasUnknownReturnType(expectedType) ? CallResolverUtilKt.replaceReturnTypeByUnknown(expectedType) : expectedType;
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(expectedTypeWithoutReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType type2 = this.argumentTypeResolver.getCallableReferenceTypeInfo(argumentExpression, callableReference, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
        return type2;
    }

    public GenericCandidateResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        this.argumentTypeResolver = argumentTypeResolver;
    }
}

