/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtDelegatorToSuperCall
extends KtDelegationSpecifier
implements KtCallElement {
    public KtDelegatorToSuperCall(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtDelegatorToSuperCall", "<init>"));
        }
        super(node);
    }

    public KtDelegatorToSuperCall(@NotNull KotlinPlaceHolderStub<? extends KtDelegationSpecifier> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtDelegatorToSuperCall", "<init>"));
        }
        super(stub, (IStubElementType)KtStubElementTypes.DELEGATOR_SUPER_CALL);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtDelegatorToSuperCall", "accept"));
        }
        return visitor2.visitDelegationToSuperCallSpecifier(this, data);
    }

    @Override
    @NotNull
    public KtConstructorCalleeExpression getCalleeExpression() {
        KtConstructorCalleeExpression ktConstructorCalleeExpression = (KtConstructorCalleeExpression)this.getRequiredStubOrPsiChild(KtStubElementTypes.CONSTRUCTOR_CALLEE);
        if (ktConstructorCalleeExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDelegatorToSuperCall", "getCalleeExpression"));
        }
        return ktConstructorCalleeExpression;
    }

    @Override
    @Nullable
    public KtValueArgumentList getValueArgumentList() {
        return (KtValueArgumentList)this.findChildByType(KtNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        KtValueArgumentList list = this.getValueArgumentList();
        List<Object> list2 = list != null ? list.getArguments() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDelegatorToSuperCall", "getValueArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<KtFunctionLiteralArgument> getFunctionLiteralArguments() {
        List<KtFunctionLiteralArgument> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDelegatorToSuperCall", "getFunctionLiteralArguments"));
        }
        return list;
    }

    @Override
    public KtTypeReference getTypeReference() {
        return this.getCalleeExpression().getTypeReference();
    }

    @Override
    @NotNull
    public List<KtTypeProjection> getTypeArguments() {
        KtTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        if (typeArgumentList == null) {
            List<KtTypeProjection> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDelegatorToSuperCall", "getTypeArguments"));
            }
            return list;
        }
        List<KtTypeProjection> list = typeArgumentList.getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDelegatorToSuperCall", "getTypeArguments"));
        }
        return list;
    }

    @Override
    public KtTypeArgumentList getTypeArgumentList() {
        KtUserType userType = this.getTypeAsUserType();
        return userType != null ? userType.getTypeArgumentList() : null;
    }
}

