/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.CharsKt;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!1!B\u0001\r\u0003\u0015\tAqA\u0003\u0002\u0011\u0017)\u0011\u0001\u0002\u0002\u000e\u0014\u0011\t\u0001RA\u0007\u00021\u0003I2\u0001C\u0002\u000e\u0003a\u0005AkA\u0001\u000e\u0014\u0011\t\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a!AkA\u0001\u000e\u0014\u0011\t\u0001\"B\u0007\u00021\u0003I2\u0001#\u0003\u000e\u0003a!AkA\u0001\u000e\u0014\u0011\t\u00012B\u0007\u00021\u0011I2\u0001\u0003\u0004\u000e\u0003a\u0005AkA\u0001\u000e\u0014\u0011\t\u0001RB\u0007\u00021\u0003I2\u0001C\u0004\u000e\u0003a\u0005AkA\u0001\u000e\u0012!=Q\"\u0001\r\t3\rAa!D\u0001\u0019\u0002Q\u001b\u0011!$\u0005\t\u00125\t\u0001\u0004C\r\u0004\u0011\u0019i\u0011\u0001'\u0001U\u0007\u0005i\t\u0002C\u0005\u000e\u0003aA\u0011d\u0001\u0005\u0007\u001b\u0005A\n\u0001V\u0002\u0002\u001b#A\u0019\"D\u0001\u0019\u0011e\u0019\u0001BB\u0007\u00021\u0003!6!AG\u0007\u0011)i\u0011\u0001\u0007\u0005\u0016\u0003a!AkA\u0001\u0012\u0013\u0011\t\u0005*\u0001\u0005\u0001\u001b\u0005A\n!U\u0002\u0002\u000b\u0001!6!A\t\n\t\u0005C\u0015\u0001c\u0001\u000e\u0003a\u0005\u0011kA\u0001\u0006\u0001Q\u001b\u0011!E\u0005\u0005\u0003\"\u000b\u0001BA\u0007\u00021\u0003\t6!A\u0003\u0001)\u000e\t\u0001"}, strings={"DEFAULT_PACKAGE_CLASS_NAME", "", "KotlinJavascriptSerializedResourcePathsKt", "DEFAULT_PACKAGE_METAFILE_NAME", "PACKAGE_CLASS_NAME_SUFFIX", "capitalizeNonEmptyString", "s", "getPackageClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "packageFQN", "getPackageClassName", "getPackageFqName", "fileName", "getPackageName", "filePath", "isClassesInPackageFile", "", "isDefaultPackageMetafile", "isPackageMetadataFile", "isStringTableFile", "isPackageClassFqName"}, moduleName="kotlin-compiler")
public final class KotlinJavascriptSerializedResourcePathsKt {
    private static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    private static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";
    private static final String DEFAULT_PACKAGE_METAFILE_NAME = "_DefaultPackage.kjsm";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPackageClassFqName(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isRoot()) return false;
        FqName fqName2 = $receiver.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "this.parent()");
        if (!Intrinsics.areEqual(KotlinJavascriptSerializedResourcePathsKt.getPackageClassFqName(fqName2), $receiver)) return false;
        return true;
    }

    public static final boolean isDefaultPackageMetafile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(fileName, DEFAULT_PACKAGE_METAFILE_NAME);
    }

    public static final boolean isPackageMetadataFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE.getPackageFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), fileName);
    }

    public static final boolean isStringTableFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE.getStringTableFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), fileName);
    }

    public static final boolean isClassesInPackageFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE.getClassesInPackageFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), fileName);
    }

    private static final FqName getPackageFqName(String fileName) {
        return new FqName(KotlinJavascriptSerializedResourcePathsKt.getPackageName(fileName));
    }

    private static final String getPackageName(String filePath) {
        return StringsKt.indexOf$default(filePath, '/', 0, false, 6) >= 0 ? StringsKt.replace$default(StringsKt.substringBeforeLast$default(filePath, '/', null, 2), '/', '.', false, 4) : "";
    }

    private static final FqName getPackageClassFqName(FqName packageFQN) {
        FqName fqName2 = packageFQN.child(Name.identifier(KotlinJavascriptSerializedResourcePathsKt.getPackageClassName(packageFQN)));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFQN.child(Name.id\u2026geClassName(packageFQN)))");
        return fqName2;
    }

    private static final String getPackageClassName(FqName packageFQN) {
        String string;
        if (packageFQN.isRoot()) {
            string = DEFAULT_PACKAGE_CLASS_NAME;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = packageFQN.shortName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageFQN.shortName().asString()");
            string = stringBuilder.append(KotlinJavascriptSerializedResourcePathsKt.capitalizeNonEmptyString(string2)).append(PACKAGE_CLASS_NAME_SUFFIX).toString();
        }
        return string;
    }

    private static final String capitalizeNonEmptyString(String s) {
        return Character.isUpperCase(CollectionsKt.charAt(s, 0)) ? s : CharsKt.plus(Character.toUpperCase(CollectionsKt.charAt(s, 0)), StringsKt.substring(s, 1));
    }

    static {
        PACKAGE_CLASS_NAME_SUFFIX = PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_CLASS_NAME = "_Default" + PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_METAFILE_NAME = DEFAULT_PACKAGE_CLASS_NAME + "." + KotlinJavascriptSerializationUtil.INSTANCE.getCLASS_METADATA_FILE_EXTENSION();
    }

    @NotNull
    public static final /* synthetic */ FqName access$getPackageClassFqName(@NotNull FqName packageFQN) {
        return KotlinJavascriptSerializedResourcePathsKt.getPackageClassFqName(packageFQN);
    }
}

