/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinLocalClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.context.TypeLazinessToken;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtSelfType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.PlatformTypesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.TypeResolver$Companion$WhenMappings;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallableDescriptors;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.scopes.KtScope;
import org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!\u0001\u0007\u0001!wI\u0012\u0001'\u0001\u001e\u0003wq\u0012UJ\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0003\u0013\rA1!D\u0001\u0019\b%\u0019\u0001\u0002B\u0007\u00021\u0013I1\u0001C\u0003\u000e\u0003a-\u0011b\u0001\u0005\u0007\u001b\u0005Aj!C\u0002\t\u000f5\t\u0001tB\u0005\u0004\u0011!i\u0011\u0001'\u0005\n\u0007!IQ\"\u0001M\n#\u000e\t\u0001BC\u0013\r\t\u0005A)\"D\u0001\u0019\u0017e\u0019\u0001rC\u0007\u000211I2\u0001#\u0007\u000e\u0003aiQ\u0005\u0003\u0003\u0002\u00117i\u0011\u0001\u0007\b\u001a\u0007!uQ\"\u0001\r\u0010K1!\u0011\u0001c\b\u000e\u0003a\u0001\u0012d\u0001E\f\u001b\u0005AB\"G\u0002\t\"5\t\u0001$E\u0013\u0011\u0011Gi!\u0001$\u0001\u0019%e\u0019\u0001RE\u0007\u00021MI2\u0001c\n\u000e\u0003a!\u0012d\u0001E\u0015\u001b\u0005AR#J\u0006\t,5\t\u0001dC\r\u0004\u0011/i\u0011\u0001\u0007\u0007\u001a\u0007!eQ\"\u0001\r\u000eK1!\u0011\u0001\u0003\f\u000e\u0003ay\u0011d\u0001E\f\u001b\u0005AB\"G\u0002\t\u001a5\t\u0001$D\u0013\u0014\u0011Yi\u0011\u0001G\b\u001a\u0007!\u0015R\"\u0001\r\u00143\rAI\"D\u0001\u0019\u001be\u0019\u0001\u0012F\u0007\u00021UI2\u0001#\f\u000e\u0003a9R%\u0005\u0003\u0002\u0011_i\u0011\u0001G\u0006\u001a\u0007!]Q\"\u0001\r\r3\rA\u0001$D\u0001\u00192e!\u0001\"G\u0007\u0003\u0019\u0003A\u001a$\n\f\u0005\u0003!QR\u0002B\u0005\u0003\u0013\u0005A2\u0004'\u000e\u001a\u0007!]Q\"\u0001\r\r3\rA9$D\u0001\u00199e1\u0001\u0012H\u0007\u0005\u0013\tI\u0011\u0001G\u000f\u00196%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!AQ\"\u0001M\t#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001bB\u0007\u00021\u001f\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0005\u001b\u0005AJ!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011%i\u0011\u0001g\u0005R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"Aa!D\u0001\u0019\u000eE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002C\u0002\u000e\u0003a\u001d\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00055\t\u0001TA)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!)Q\"\u0001M\u0006#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/TypeResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "flexibleTypeCapabilitiesProvider", "Lorg/jetbrains/kotlin/resolve/TypeResolver$FlexibleTypeCapabilitiesProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "lazinessToken", "Lorg/jetbrains/kotlin/context/TypeLazinessToken;", "dynamicTypesSettings", "Lorg/jetbrains/kotlin/types/DynamicTypesSettings;", "dynamicCallableDescriptors", "Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/TypeResolver$FlexibleTypeCapabilitiesProvider;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/context/TypeLazinessToken;Lorg/jetbrains/kotlin/types/DynamicTypesSettings;Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;)V", "doResolvePossiblyBareType", "Lorg/jetbrains/kotlin/resolve/PossiblyBareType;", "c", "Lorg/jetbrains/kotlin/resolve/TypeResolutionContext;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "forceResolveTypeContents", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getScopeForTypeParameter", "Lorg/jetbrains/kotlin/resolve/scopes/KtScope;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "resolveClass", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolvePossiblyBareType", "resolveType", "checkBounds", "", "resolveTypeElement", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "typeElement", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "resolveTypeProjections", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "constructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "argumentElements", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "Companion", "FlexibleTypeCapabilitiesProvider"}, moduleName="kotlin-compiler")
public final class TypeResolver {
    private final AnnotationResolver annotationResolver;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final ModuleDescriptor moduleDescriptor;
    private final FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider;
    private final StorageManager storageManager;
    private final TypeLazinessToken lazinessToken;
    private final DynamicTypesSettings dynamicTypesSettings;
    private final DynamicCallableDescriptors dynamicCallableDescriptors;
    private final IdentifierChecker identifierChecker;
    public static final Companion Companion = org.jetbrains.kotlin.resolve.TypeResolver$Companion.INSTANCE;

    @NotNull
    public final KotlinType resolveType(@NotNull LexicalScope scope2, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace, boolean checkBounds) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        return this.resolveType(new TypeResolutionContext(scope2, trace, checkBounds, false), typeReference);
    }

    private final KotlinType resolveType(TypeResolutionContext c, KtTypeReference typeReference) {
        boolean value2 = !c.allowBareTypes;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Use resolvePossiblyBareType() when bare types are allowed";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        KotlinType kotlinType = this.resolvePossiblyBareType(c, typeReference).getActualType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "resolvePossiblyBareType(\u2026eference).getActualType()");
        return kotlinType;
    }

    @NotNull
    public final PossiblyBareType resolvePossiblyBareType(@NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        KotlinType cachedType = (KotlinType)c.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (cachedType != null) {
            PossiblyBareType possiblyBareType = PossiblyBareType.type(cachedType);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(cachedType)");
            return possiblyBareType;
        }
        KotlinType debugType = CodeFragmentUtilKt.getDebugTypeInfo(typeReference);
        if (debugType != null) {
            c.trace.record(BindingContext.TYPE, typeReference, debugType);
            PossiblyBareType possiblyBareType = PossiblyBareType.type(debugType);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(debugType)");
            return possiblyBareType;
        }
        if (!c.allowBareTypes && !c.forceResolveLazyTypes && this.lazinessToken.isLazy()) {
            @KotlinLocalClass(version={1, 0, 0})
            @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"&\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001+\u0003\u0001A!\u0002\u0007\u00013\u0005A\n!G\u0001\u0019\u0003\u0005\u0016\u0011kA\u0001\t\u0004\u0015\"Aa\u0003\u0005\u0005\u001b\u0005AJ!*\u0004\u0005\u0015!)Qr\u0001\r\u0004#\u000e\tAqAU\r\t\u0005C\u0001BAG\u0007\u0013\u0013I9\u0001G\u0002R\u0007\u0005!9\u0001'\u0002R\u0007\u0005)\u0001\u0001"}, strings={"org/jetbrains/kotlin/resolve/TypeResolver$resolvePossiblyBareType$LazyKotlinType", "Lorg/jetbrains/kotlin/types/DelegatingType;", "Lorg/jetbrains/kotlin/resolve/lazy/LazyEntity;", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/TypeResolutionContext;Lorg/jetbrains/kotlin/psi/KtTypeReference;)V", "_delegate", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/annotations/NotNull;", "forceResolveAllContents", "", "getDelegate"}, moduleName="kotlin-compiler")
            public final class LazyKotlinType
            extends DelegatingType
            implements LazyEntity {
                private final NotNullLazyValue<KotlinType> _delegate;
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ KtTypeReference $typeReference;

                @NotNull
                protected KotlinType getDelegate() {
                    return (KotlinType)this._delegate.invoke();
                }

                public void forceResolveAllContents() {
                    ForceResolveUtil.forceResolveAllContents(this.getConstructor());
                    Iterable $receiver = this.getArguments();
                    for (T element : $receiver) {
                        TypeProjection it2 = (TypeProjection)element;
                        ForceResolveUtil.forceResolveAllContents(it2.getType());
                    }
                }

                public LazyKotlinType(TypeResolver $outer, TypeResolutionContext $captured_local_variable$1, KtTypeReference $captured_local_variable$2) {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$typeReference = $captured_local_variable$2;
                    this._delegate = TypeResolver.access$getStorageManager$p($outer).createLazyValue((Function0)new Function0<KotlinType>(this){
                        final /* synthetic */ LazyKotlinType this$0;

                        @NotNull
                        public final KotlinType invoke() {
                            return TypeResolver.access$doResolvePossiblyBareType(this.this$0.this$0, this.this$0.$c, this.this$0.$typeReference).getActualType();
                        }
                        {
                            this.this$0 = lazyKotlinType;
                            super(0);
                        }
                    });
                }
            }
            LazyKotlinType lazyKotlinType = new LazyKotlinType(this, c, typeReference);
            c.trace.record(BindingContext.TYPE, typeReference, lazyKotlinType);
            PossiblyBareType possiblyBareType = PossiblyBareType.type(lazyKotlinType);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(lazyKotlinType)");
            return possiblyBareType;
        }
        PossiblyBareType type2 = this.doResolvePossiblyBareType(c, typeReference);
        if (!type2.isBare()) {
            c.trace.record(BindingContext.TYPE, typeReference, type2.getActualType());
        }
        return type2;
    }

    private final PossiblyBareType doResolvePossiblyBareType(TypeResolutionContext c, KtTypeReference typeReference) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(c.scope, typeReference.getAnnotationEntries(), c.trace);
        KtTypeElement typeElement = typeReference.getTypeElement();
        Annotations annotations3 = annotations2;
        Intrinsics.checkExpressionValueIsNotNull(annotations3, "annotations");
        PossiblyBareType type2 = this.resolveTypeElement(c, annotations3, typeElement);
        BindingTrace bindingTrace = c.trace;
        LexicalScope lexicalScope = c.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "c.scope");
        BindingContextUtilsKt.recordScope(bindingTrace, lexicalScope, typeReference);
        if (!type2.isBare()) {
            for (TypeProjection argument : type2.getActualType().getArguments()) {
                KotlinType kotlinType = argument.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "argument.type");
                this.forceResolveTypeContents(kotlinType);
            }
        }
        return type2;
    }

    private final void forceResolveTypeContents(KotlinType type2) {
        type2.getAnnotations();
        if (FlexibleTypesKt.isFlexible(type2)) {
            this.forceResolveTypeContents(FlexibleTypesKt.flexibility(type2).getLowerBound());
            this.forceResolveTypeContents(FlexibleTypesKt.flexibility(type2).getUpperBound());
        } else {
            type2.getConstructor();
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                KotlinType kotlinType = projection.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "projection.type");
                this.forceResolveTypeContents(kotlinType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PossiblyBareType resolveTypeElement(TypeResolutionContext c, Annotations annotations2, KtTypeElement typeElement) {
        PossiblyBareType possiblyBareType;
        Unit unit;
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        KtTypeElement ktTypeElement = typeElement;
        if (ktTypeElement != null) {
            ktTypeElement.accept(new KtVisitorVoid(this, c, (Ref.ObjectRef)result2, annotations2){
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ Ref.ObjectRef $result;
                final /* synthetic */ Annotations $annotations;

                /*
                 * WARNING - void declaration
                 */
                public void visitUserType(@NotNull KtUserType type2) {
                    ClassifierDescriptor classifierDescriptor;
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    LexicalScope lexicalScope = this.$c.scope;
                    Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "c.scope");
                    BindingTrace bindingTrace = this.$c.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
                    ClassifierDescriptor classifierDescriptor2 = this.this$0.resolveClass(lexicalScope, type2, bindingTrace);
                    if (classifierDescriptor2 == null) {
                        TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("No type").getConstructor();
                        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "ErrorUtils.createErrorTy\u2026o type\").getConstructor()");
                        List<KtTypeProjection> list = type2.getTypeArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list, "type.getTypeArguments()");
                        List<TypeProjection> arguments2 = TypeResolver.access$resolveTypeProjections(this.this$0, this.$c, typeConstructor2, list);
                        this.$result.element = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments(DebugTextUtilKt.getDebugText(type2), arguments2));
                        return;
                    }
                    KtSimpleNameExpression referenceExpression = type2.getReferenceExpression();
                    String referencedName = type2.getReferencedName();
                    if (referenceExpression == null || referencedName == null) {
                        return;
                    }
                    this.$c.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classifierDescriptor2);
                    if (type2.hasTypesWithTypeArgsInside()) {
                        this.$c.trace.report(Errors.GENERICS_IN_CONTAINING_TYPE_NOT_ALLOWED.on(type2));
                    }
                    if ((classifierDescriptor = classifierDescriptor2) instanceof TypeParameterDescriptor) {
                        DeclarationDescriptor containing;
                        PossiblyBareType possiblyBareType;
                        KtScope scopeForTypeParameter = TypeResolver.access$getScopeForTypeParameter(this.this$0, this.$c, (TypeParameterDescriptor)classifierDescriptor2);
                        if (scopeForTypeParameter instanceof ErrorUtils.ErrorScope) {
                            possiblyBareType = PossiblyBareType.type(ErrorUtils.createErrorType("?"));
                        } else {
                            TypeConstructor typeConstructor3 = ((TypeParameterDescriptor)classifierDescriptor2).getTypeConstructor();
                            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "classifierDescriptor.getTypeConstructor()");
                            possiblyBareType = PossiblyBareType.type(KotlinTypeImpl.Companion.create(this.$annotations, typeConstructor3, TypeUtils.hasNullableLowerBound((TypeParameterDescriptor)classifierDescriptor2), CollectionsKt.<T>listOf(), scopeForTypeParameter));
                        }
                        this.$result.element = possiblyBareType;
                        TypeConstructor typeConstructor4 = ErrorUtils.createErrorType("No type").getConstructor();
                        Intrinsics.checkExpressionValueIsNotNull(typeConstructor4, "ErrorUtils.createErrorTy\u2026o type\").getConstructor()");
                        List<KtTypeProjection> list = type2.getTypeArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list, "type.getTypeArguments()");
                        List<TypeProjection> arguments3 = TypeResolver.access$resolveTypeProjections(this.this$0, this.$c, typeConstructor4, list);
                        if (!arguments3.isEmpty()) {
                            this.$c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)type2.getTypeArgumentList()), 0));
                        }
                        if ((containing = ((TypeParameterDescriptor)classifierDescriptor2).getContainingDeclaration()) instanceof ClassDescriptor) {
                            DescriptorResolver.checkHasOuterClassInstance(this.$c.scope, this.$c.trace, referenceExpression, (ClassDescriptor)containing);
                        }
                    } else if (classifierDescriptor instanceof ClassDescriptor) {
                        Collection $receiver;
                        void $receiver2;
                        TypeConstructor typeConstructor5;
                        TypeConstructor typeConstructor6 = typeConstructor5 = ((ClassDescriptor)classifierDescriptor2).getTypeConstructor();
                        Intrinsics.checkExpressionValueIsNotNull(typeConstructor6, "typeConstructor");
                        List<KtTypeProjection> list = type2.getTypeArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list, "type.getTypeArguments()");
                        List<TypeProjection> arguments4 = TypeResolver.access$resolveTypeProjections(this.this$0, this.$c, typeConstructor6, list);
                        List<TypeParameterDescriptor> parameters2 = typeConstructor5.getParameters();
                        Collection collection = parameters2;
                        int expectedArgumentCount = $receiver2.size();
                        Collection $i$f$size = arguments4;
                        int actualArgumentCount = $receiver.size();
                        if (ErrorUtils.isError(classifierDescriptor2)) {
                            this.$result.element = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments("[Error type: " + typeConstructor5 + "]", arguments4));
                        } else if (actualArgumentCount != expectedArgumentCount) {
                            if (actualArgumentCount == 0) {
                                if (this.$c.allowBareTypes) {
                                    this.$result.element = PossiblyBareType.bare(typeConstructor5, false);
                                    return;
                                }
                                this.$c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)type2), expectedArgumentCount));
                            } else {
                                this.$c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)type2.getTypeArgumentList()), expectedArgumentCount));
                            }
                            this.$result.element = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments("" + typeConstructor5, arguments4));
                        } else {
                            if (Intrinsics.areEqual(Flexibility.Companion.getFLEXIBLE_TYPE_CLASSIFIER().asSingleFqName().toUnsafe(), DescriptorUtils.getFqName(classifierDescriptor2))) {
                                $receiver = ((ClassDescriptor)classifierDescriptor2).getTypeConstructor().getParameters();
                                if ($receiver.size() == 2) {
                                    KotlinType kotlinType = arguments4.get(0).getType();
                                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "arguments[0].getType()");
                                    KotlinType kotlinType2 = arguments4.get(1).getType();
                                    Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "arguments[1].getType()");
                                    this.$result.element = PossiblyBareType.type(DelegatingFlexibleType.Companion.create(kotlinType, kotlinType2, TypeResolver.access$getFlexibleTypeCapabilitiesProvider$p(this.this$0).getCapabilities()));
                                    return;
                                }
                            }
                            KotlinTypeImpl resultingType = KotlinTypeImpl.Companion.create(this.$annotations, (ClassDescriptor)classifierDescriptor2, false, arguments4);
                            this.$result.element = PossiblyBareType.type(resultingType);
                            if (this.$c.checkBounds) {
                                int n;
                                TypeSubstitutor substitutor2 = TypeSubstitutor.create(resultingType);
                                IntRange intRange = CollectionsKt.getIndices((Collection)parameters2);
                                int n2 = ((Number)intRange.getStart()).intValue();
                                if (n2 <= (n = ((Number)intRange.getEnd()).intValue())) {
                                    while (true) {
                                        void i;
                                        TypeParameterDescriptor parameter = parameters2.get((int)i);
                                        KotlinType argument = arguments4.get((int)i).getType();
                                        KtTypeReference typeReference = type2.getTypeArguments().get((int)i).getTypeReference();
                                        if (typeReference != null) {
                                            DescriptorResolver.checkBounds(typeReference, argument, parameter, substitutor2, this.$c.trace);
                                        }
                                        if (i == n) break;
                                        ++i;
                                    }
                                }
                            }
                        }
                    }
                }

                public void visitNullableType(@NotNull KtNullableType nullableType) {
                    Intrinsics.checkParameterIsNotNull(nullableType, "nullableType");
                    KtTypeElement innerType = nullableType.getInnerType();
                    PossiblyBareType baseType = TypeResolver.access$resolveTypeElement(this.this$0, this.$c, this.$annotations, innerType);
                    if (baseType.isNullable() || innerType instanceof KtNullableType || innerType instanceof KtDynamicType) {
                        this.$c.trace.report(Errors.REDUNDANT_NULLABLE.on((KtNullableType)((PsiElement)nullableType)));
                    }
                    this.$result.element = baseType.makeNullable();
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitFunctionType(@NotNull KtFunctionType type2) {
                    KotlinType kotlinType;
                    void destination;
                    void $receiver;
                    void $receiver2;
                    Object it2;
                    E element3;
                    void $receiver3;
                    KotlinType kotlinType2;
                    Object element22;
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    KtTypeReference receiverTypeRef = type2.getReceiverTypeReference();
                    Iterable $receiver4 = type2.getParameters();
                    for (Object element22 : $receiver4) {
                        KtParameter it3 = (KtParameter)element22;
                        IdentifierChecker identifierChecker = TypeResolver.access$getIdentifierChecker$p(this.this$0);
                        KtDeclaration ktDeclaration = it3;
                        Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "it");
                        DiagnosticSink diagnosticSink = this.$c.trace;
                        Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "c.trace");
                        identifierChecker.checkDeclaration(ktDeclaration, diagnosticSink);
                    }
                    if (receiverTypeRef == null) {
                        kotlinType2 = null;
                    } else {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                        kotlinType2 = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, receiverTypeRef);
                    }
                    KotlinType receiverType = kotlinType2;
                    Iterable iterable = type2.getParameters();
                    for (E element3 : $receiver3) {
                        it2 = (KtParameter)element3;
                        KtParameter ktParameter = it2;
                        Intrinsics.checkExpressionValueIsNotNull(ktParameter, "it");
                        resolveTypeElement.1.access$checkParameterInFunctionType(this, ktParameter);
                    }
                    element22 = type2.getParameters();
                    element3 = $receiver2;
                    it2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
                    for (T item : $receiver) {
                        void it4;
                        KtParameter ktParameter = (KtParameter)item;
                        void var14_11 = destination;
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                        KtTypeReference ktTypeReference = it4.getTypeReference();
                        if (ktTypeReference == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull(ktTypeReference, "it.getTypeReference()!!");
                        KotlinType kotlinType3 = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, ktTypeReference);
                        var14_11.add(kotlinType3);
                    }
                    List parameterTypes = (List)destination;
                    KtTypeReference returnTypeRef = type2.getReturnTypeReference();
                    if (returnTypeRef != null) {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                        kotlinType = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, returnTypeRef);
                    } else {
                        KotlinType kotlinType4 = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType();
                        kotlinType = kotlinType4;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "moduleDescriptor.builtIns.getUnitType()");
                    }
                    KotlinType returnType2 = kotlinType;
                    this.$result.element = PossiblyBareType.type(TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getFunctionType(this.$annotations, receiverType, parameterTypes, returnType2));
                }

                public void visitDynamicType(@NotNull KtDynamicType type2) {
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    this.$result.element = PossiblyBareType.type(TypeResolver.access$getDynamicCallableDescriptors$p(this.this$0).getDynamicType());
                    if (!TypeResolver.access$getDynamicTypesSettings$p(this.this$0).getDynamicTypesAllowed()) {
                        this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Dynamic types are not supported in this context"));
                    }
                }

                public void visitSelfType(@NotNull KtSelfType type2) {
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Self-types are not supported"));
                }

                public void visitJetElement(@NotNull KtElement element) {
                    Intrinsics.checkParameterIsNotNull(element, "element");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(element, "Self-types are not supported yet"));
                }

                /*
                 * WARNING - void declaration
                 */
                private final void checkParameterInFunctionType(KtParameter param) {
                    Unit unit;
                    Object $receiver;
                    KtModifierList modifierList;
                    if (param.hasDefaultValue()) {
                        BindingTrace bindingTrace = this.$c.trace;
                        KtExpression ktExpression = param.getDefaultValue();
                        if (ktExpression == null) {
                            Intrinsics.throwNpe();
                        }
                        bindingTrace.report(Errors.UNSUPPORTED.on(ktExpression, "default value of parameter in function type"));
                    }
                    if (param.getName() != null) {
                        for (KtAnnotationEntry annotationEntry : param.getAnnotationEntries()) {
                            this.$c.trace.report(Errors.UNSUPPORTED.on(annotationEntry, "annotation on parameter in function type"));
                        }
                    }
                    if ((modifierList = param.getModifierList()) != null) {
                        void destination;
                        Iterator<T> $receiver2;
                        Collection $receiver3;
                        ArrayList<E> arrayList;
                        $receiver = KtTokens.MODIFIER_KEYWORDS_ARRAY;
                        Object[] objectArray = $receiver;
                        Object object = $receiver;
                        ArrayList<E> arrayList2 = arrayList;
                        ArrayList<E> arrayList3 = arrayList;
                        int n = ((void)$receiver3).length;
                        arrayList2(n);
                        $receiver3 = arrayList3;
                        for (int i = 0; i < ((void)$receiver2).length; ++i) {
                            void it2;
                            void item = $receiver2[i];
                            KtModifierKeywordToken ktModifierKeywordToken = (KtModifierKeywordToken)item;
                            void var15_12 = destination;
                            PsiElement psiElement2 = modifierList.getModifier((KtModifierKeywordToken)it2);
                            var15_12.add(psiElement2);
                        }
                        $receiver = CollectionsKt.filterNotNull((List)destination);
                        $receiver2 = $receiver.iterator();
                        while ($receiver2.hasNext()) {
                            T element = $receiver2.next();
                            PsiElement it3 = (PsiElement)element;
                            this.$c.trace.report(Errors.UNSUPPORTED.on(it3, "modifier on parameter in function type"));
                        }
                    }
                    PsiElement psiElement3 = param.getValOrVarKeyword();
                    if (psiElement3 != null) {
                        $receiver = psiElement3;
                        PsiElement it4 = (PsiElement)$receiver;
                        this.$c.trace.report(Errors.UNSUPPORTED.on(it4, "val or val on parameter in function type"));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$result = $captured_local_variable$2;
                    this.$annotations = $captured_local_variable$3;
                }

                public static final /* synthetic */ void access$checkParameterInFunctionType(resolveTypeElement.1 $this, @NotNull KtParameter param) {
                    $this.checkParameterInFunctionType(param);
                }
            });
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if ((possiblyBareType = (PossiblyBareType)result2.element) == null) {
            Object object = typeElement;
            if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
                object = "No type element";
            }
            PossiblyBareType possiblyBareType2 = PossiblyBareType.type(ErrorUtils.createErrorType((String)object));
            possiblyBareType = possiblyBareType2;
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType2, "type(ErrorUtils.createEr\u2026() ?: \"No type element\"))");
        }
        return possiblyBareType;
    }

    private final KtScope getScopeForTypeParameter(TypeResolutionContext c, TypeParameterDescriptor typeParameterDescriptor) {
        if (c.checkBounds) {
            KtScope ktScope = typeParameterDescriptor.getUpperBoundsAsType().getMemberScope();
            Intrinsics.checkExpressionValueIsNotNull(ktScope, "typeParameterDescriptor.\u2026AsType().getMemberScope()");
            return ktScope;
        }
        return new LazyScopeAdapter(LockBasedStorageManager.NO_LOCKS.createLazyValue((Function0)new Function0<KtScope>(typeParameterDescriptor){
            final /* synthetic */ TypeParameterDescriptor $typeParameterDescriptor;

            @NotNull
            public final KtScope invoke() {
                return this.$typeParameterDescriptor.getUpperBoundsAsType().getMemberScope();
            }
            {
                this.$typeParameterDescriptor = typeParameterDescriptor;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjection> resolveTypeProjections(TypeResolutionContext c, TypeConstructor constructor, List<? extends KtTypeProjection> argumentElements) {
        void destination;
        void $receiver;
        void $receiver2;
        Iterable iterable = argumentElements;
        void var5_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        int index2 = 0;
        for (Object item : $receiver) {
            TypeProjection typeProjection;
            void i;
            void argumentElement;
            int n = index2++;
            KtTypeProjection ktTypeProjection = (KtTypeProjection)item;
            int n2 = n;
            void var20_16 = destination;
            KtProjectionKind projectionKind = argumentElement.getProjectionKind();
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)argumentElement;
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
            ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, bindingTrace, null);
            if (Intrinsics.areEqual((Object)projectionKind, (Object)KtProjectionKind.STAR)) {
                void $receiver3;
                List<TypeParameterDescriptor> parameters2 = constructor.getParameters();
                Collection collection2 = parameters2;
                if ($receiver3.size() > i) {
                    TypeParameterDescriptor parameterDescriptor = parameters2.get((int)i);
                    TypeProjection typeProjection2 = TypeUtils.makeStarProjection(parameterDescriptor);
                    typeProjection = typeProjection2;
                    Intrinsics.checkExpressionValueIsNotNull(typeProjection2, "TypeUtils.makeStarProjection(parameterDescriptor)");
                } else {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, ErrorUtils.createErrorType("*"));
                }
            } else {
                void $receiver4;
                TypeResolutionContext typeResolutionContext = c.noBareTypes();
                Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                KtTypeReference ktTypeReference = argumentElement.getTypeReference();
                if (ktTypeReference == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(ktTypeReference, "argumentElement.getTypeReference()!!");
                KotlinType type2 = this.resolveType(typeResolutionContext, ktTypeReference);
                KtProjectionKind ktProjectionKind = projectionKind;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktProjectionKind, "projectionKind");
                Variance kind = Companion.resolveProjectionKind(ktProjectionKind);
                Collection $i$f$size = constructor.getParameters();
                if ($receiver4.size() > i) {
                    TypeParameterDescriptor parameterDescriptor = constructor.getParameters().get((int)i);
                    if (Intrinsics.areEqual((Object)kind, (Object)Variance.INVARIANT) ^ true && Intrinsics.areEqual((Object)parameterDescriptor.getVariance(), (Object)Variance.INVARIANT) ^ true) {
                        if (Intrinsics.areEqual((Object)kind, (Object)parameterDescriptor.getVariance())) {
                            c.trace.report(Errors.REDUNDANT_PROJECTION.on((KtTypeProjection)((PsiElement)argumentElement), constructor.getDeclarationDescriptor()));
                        } else {
                            c.trace.report(Errors.CONFLICTING_PROJECTION.on((KtTypeProjection)((PsiElement)argumentElement), constructor.getDeclarationDescriptor()));
                        }
                    }
                }
                typeProjection = new TypeProjectionImpl(kind, type2);
            }
            TypeProjection typeProjection3 = typeProjection;
            var20_16.add(typeProjection3);
        }
        return (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassifierDescriptor resolveClass(@NotNull LexicalScope scope2, @NotNull KtUserType userType, @NotNull BindingTrace trace) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(userType, "userType");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (userType.getQualifier() != null) {
            KtUserType ktUserType = userType.getQualifier();
            if (ktUserType == null) {
                Intrinsics.throwNpe();
            }
            for (KtTypeProjection typeArgument : ktUserType.getTypeArguments()) {
                Unit unit;
                if (typeArgument.getTypeReference() != null) {
                    void $receiver;
                    KtTypeReference it2;
                    KtTypeReference ktTypeReference = it2 = (KtTypeReference)$receiver;
                    Intrinsics.checkExpressionValueIsNotNull(ktTypeReference, "it");
                    this.forceResolveTypeContents(this.resolveType(scope2, ktTypeReference, trace, true));
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
        }
        if ((classifierDescriptor = this.qualifiedExpressionResolver.resolveDescriptorForUserType(userType, scope2, trace)) != null) {
            PlatformTypesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(this.moduleDescriptor, trace, userType, classifierDescriptor);
        }
        return classifierDescriptor;
    }

    public TypeResolver(@NotNull AnnotationResolver annotationResolver, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider, @NotNull StorageManager storageManager, @NotNull TypeLazinessToken lazinessToken, @NotNull DynamicTypesSettings dynamicTypesSettings, @NotNull DynamicCallableDescriptors dynamicCallableDescriptors, @NotNull IdentifierChecker identifierChecker) {
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(flexibleTypeCapabilitiesProvider, "flexibleTypeCapabilitiesProvider");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(lazinessToken, "lazinessToken");
        Intrinsics.checkParameterIsNotNull(dynamicTypesSettings, "dynamicTypesSettings");
        Intrinsics.checkParameterIsNotNull(dynamicCallableDescriptors, "dynamicCallableDescriptors");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        this.annotationResolver = annotationResolver;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.flexibleTypeCapabilitiesProvider = flexibleTypeCapabilitiesProvider;
        this.storageManager = storageManager;
        this.lazinessToken = lazinessToken;
        this.dynamicTypesSettings = dynamicTypesSettings;
        this.dynamicCallableDescriptors = dynamicCallableDescriptors;
        this.identifierChecker = identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ StorageManager access$getStorageManager$p(TypeResolver $this) {
        return $this.storageManager;
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$doResolvePossiblyBareType(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        return $this.doResolvePossiblyBareType(c, typeReference);
    }

    @NotNull
    public static final /* synthetic */ List<TypeProjection> access$resolveTypeProjections(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull TypeConstructor constructor, @NotNull List<? extends KtTypeProjection> argumentElements) {
        return $this.resolveTypeProjections(c, constructor, argumentElements);
    }

    @NotNull
    public static final /* synthetic */ KtScope access$getScopeForTypeParameter(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
        return $this.getScopeForTypeParameter(c, typeParameterDescriptor);
    }

    @NotNull
    public static final /* synthetic */ FlexibleTypeCapabilitiesProvider access$getFlexibleTypeCapabilitiesProvider$p(TypeResolver $this) {
        return $this.flexibleTypeCapabilitiesProvider;
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$resolveTypeElement(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull Annotations annotations2, @Nullable KtTypeElement typeElement) {
        return $this.resolveTypeElement(c, annotations2, typeElement);
    }

    @NotNull
    public static final /* synthetic */ IdentifierChecker access$getIdentifierChecker$p(TypeResolver $this) {
        return $this.identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(TypeResolver $this) {
        return $this.moduleDescriptor;
    }

    @NotNull
    public static final /* synthetic */ DynamicCallableDescriptors access$getDynamicCallableDescriptors$p(TypeResolver $this) {
        return $this.dynamicCallableDescriptors;
    }

    @NotNull
    public static final /* synthetic */ DynamicTypesSettings access$getDynamicTypesSettings$p(TypeResolver $this) {
        return $this.dynamicTypesSettings;
    }

    @JvmStatic
    @NotNull
    public static final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
        Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
        return Companion.resolveProjectionKind(projectionKind);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0011\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tAa\u0003\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\u0003\u0005\u0017!\rQ\"\u0001\r\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/TypeResolver$FlexibleTypeCapabilitiesProvider;", "", "()V", "getCapabilities", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;"}, moduleName="kotlin-compiler")
    public static class FlexibleTypeCapabilitiesProvider {
        @NotNull
        public FlexibleTypeCapabilities getCapabilities() {
            return FlexibleTypeCapabilities.NONE.INSTANCE;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0011\u0011\u001d\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/TypeResolver$Companion;", "", "()V", "resolveProjectionKind", "Lorg/jetbrains/kotlin/types/Variance;", "projectionKind", "Lorg/jetbrains/kotlin/psi/KtProjectionKind;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        @NotNull
        public final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
            Variance variance;
            Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
            switch (TypeResolver$Companion$WhenMappings.$EnumSwitchMapping$0[projectionKind.ordinal()]) {
                case 1: {
                    variance = Variance.IN_VARIANCE;
                    break;
                }
                case 2: {
                    variance = Variance.OUT_VARIANCE;
                    break;
                }
                case 3: {
                    variance = Variance.INVARIANT;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Illegal projection kind:" + (Object)((Object)projectionKind));
                }
            }
            return variance;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

