/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IndexedValue;
import kotlin.IntRange;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.AllUnderImportsScope;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.PropertyImportedFromObject;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.SingleImportScope;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.KtScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!-Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0010\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005AA!\u0002\u0001\r\u0001e\t\u0001\u0014AO\u0001A\u00056\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u0011\t)s\u0002B\u0001\t\r5!\u0011BA\u0005\u00021\u001dAj!G\u0002\t\u00105\t\u0001\u0004C\r\u0004\u0011#i\u0011\u0001G\u0004&#\u0011\t\u0001\"C\u0007\u00021\u0011I2\u0001c\u0005\u000e\u0003a9\u0011\u0004\u0002\u0005\u000b\u001b\ta\t\u0001G\u0004\u001a\u0007!UQ\"\u0001\r\u0005KUA1\"\u0004\u0002\r\u0002a]\u0011d\u0001\u0005\r\u001b\u0005AJ\"G\u0002\t\u001b5\t\u00014D\r\u0004\u00119i\u0011\u0001'\b\u001a\t!yQB\u0001G\u00011?)\u0013\u0005B\u0001\t!5\u0011A\u0012\u0001M\u00113\rAQ\"D\u0001\u0019\u001ce\u0019\u0001BD\u0007\u00021;I2\u0001\u0003\u0007\u000e\u0003ae\u0011D\u0002\u0005\u0012\u001b\u0011I!!C\u0001\u0019\u0011a\r\u0012d\u0001E\b\u001b\u0005A\u0002\"\u0007\u0003\t\u001f5\u0011A\u0012\u0001M\u0010K]!\u0011\u0001\u0003\n\u000e\u0003a\u0015\u0012D\u0002\u0005\u0012\u001b\u0011I!!C\u0001\u0019\u0011a\r\u0012d\u0001\u0005\u0014\u001b\u0005A:#G\u0002\t\u001d5\t\u0001TD\r\u0004\u0011+i\u0011\u0001\u0007\u0003&!!!RB\u0001G\u00011SI2\u0001C\u000b\u000e\u0003a%\u0011d\u0001E\u0016\u001b\u0005Ab#G\u0002\t\u001d5\t\u0001TD\u0013\u0010\u0011[i\u0011\u0001'\n\u001a\u0007!9R\"\u0001M\u00183\rA\u0001$D\u0001\u0019\u001ce\u0019\u0001BD\u0007\u00021;)#\u0005B\u0001\t25\u0011A\u0012\u0001\r\b3\u0019A\u0011#\u0004\u0003\n\u0005%\t\u0001\u0004\u0003M\u00123\rAQ\"D\u0001\u0019\u001ce\u0019\u0001BD\u0007\u00021;IB\u0001\u0003\u0006\u000e\u00051\u0005\u0001dB\r\u0005\u0011ei!\u0001$\u0001\u0019-e\u0019\u0001RC\u0007\u00021\u0011)\u0003\u0003B\u0001\t45\t\u0001TE\r\u0004\u00119i\u0011\u0001'\b\u001a\u0007!QR\"\u0001M\u001b3\rA\u0019\"D\u0001\u0019\u000f\u0015\nC!\u0001\u0005\u001c\u001b\u0005A*#G\u0002\t\u001d5\t\u0001TD\r\u0004\u0011ii\u0011\u0001'\u000e\u001a\r!]R\u0002B\u0005\u0003\u0013\u0005Ar\u0001\u0007\u000f\u001a\t!QQB\u0001G\u00011\u001dI2\u0001#\u0006\u000e\u0003a!\u0011\u0004\u0002\u0003\u0002\u0011si\u0011\u0001\u0007\u0003&?\u0011\t\u0001bG\u0007\u00021KI2\u0001\u0003\b\u000e\u0003au\u0011d\u0001\u0005\u001b\u001b\u0005A*$\u0007\u0003\t\u00145\u0011A\u0012\u0001\r\b3\u0011A!\"\u0004\u0002\r\u0002a9\u0011d\u0001E\u000b\u001b\u0005AB!\u0007\u0003\u0005\u0003!eR\"\u0001\r\u0005KQ!\u0011\u0001C\u000f\u000e\u0003a\u0015\u0012d\u0001\u0005\u000f\u001b\u0005Aj\"G\u0002\t\u001b5\t\u00014D\r\u0004\u0011#i\u0011\u0001G\u0004\u001a\u0007!=Q\"\u0001\r\tK;!\u0011\u0001c\u000f\u000e\t%\u0011\u0011\"\u0001\r\t1G)\u0012\u0001\u0007\u0010\u001a\n!qQ\"\u0001M\u000f!\u000e\u0005Qe\u0004\u0003\u0002\u0011wi!\"C\u0003\n\t%\u0011\u0011\"\u0001\r\t1GI!!C\u0001\u0019\tauR#\u0001M\u0005K\u007f!\u0011\u0001C\u0010\u000e\u000f%\u0011\u0011\"\u0001M\u0014\u0013\tI\u0011\u0001g\u0010\u0019>U\t\u00014DM\b\u0011EiA!\u0003\u0002\n\u0003aA\u00014\u0005)\u0004\u0002e%\u0001BD\u0007\u00021;\u00016!AM\u0005\u0011+i\u0011\u0001\u0007\u0003Q\u0007\u0007I#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0006!\u0019\u0011\u0006\u0004\u0003B\u0011!\u001dQ\"\u0001\r\u0005+\u0005AJ\u0001H\u0011R\u0007\ri!\u0001B\u0003\t\f\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "", "symbolUsageValidator", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "(Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;)V", "getSymbolUsageValidator", "()Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "startWithPackage", "", "Lorg/jetbrains/kotlin/psi/KtUserType;", "getStartWithPackage", "(Lorg/jetbrains/kotlin/psi/KtUserType;)Z", "collectCandidateDescriptors", "Lcom/intellij/util/SmartList;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "lastPart", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "packageOrClassDescriptor", "isVisible", "descriptor", "shouldBeVisibleFrom", "inImport", "processImportReference", "Lorg/jetbrains/kotlin/resolve/scopes/KtScope;", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "packageFragmentForVisibilityCheck", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "processSingleImport", "Lorg/jetbrains/kotlin/resolve/SingleImportScope;", "path", "", "recordPackageViews", "", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "resolveDescriptorForUserType", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "userType", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "resolvePackageHeader", "packageDirective", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "module", "resolveToPackageOrClass", "scopeForFirstPart", "storageQualifier", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "storeResult", "descriptors", "", "isQualifier", "tryResolveDescriptorsWhichCannotBeImported", "asQualifierPartList", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lkotlin/Pair;", "quickResolveToPackage", "", "QualifierPart"}, moduleName="kotlin-compiler")
public final class QualifiedExpressionResolver {
    @NotNull
    private final SymbolUsageValidator symbolUsageValidator;

    public final void resolvePackageHeader(@NotNull KtPackageDirective packageDirective, @NotNull ModuleDescriptor module2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(packageDirective, "packageDirective");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        List<KtSimpleNameExpression> packageNames = packageDirective.getPackageNames();
        for (IndexedValue indexedValue : kotlin.CollectionsKt.withIndex((Iterable)packageNames)) {
            KtSimpleNameExpression nameExpression;
            int index2 = indexedValue.component1();
            KtSimpleNameExpression ktSimpleNameExpression = nameExpression = (KtSimpleNameExpression)indexedValue.component2();
            Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression, "nameExpression");
            FqName fqName2 = packageDirective.getFqName(nameExpression);
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageDirective.getFqName(nameExpression)");
            this.storeResult(trace, ktSimpleNameExpression, module2.getPackage(fqName2), (DeclarationDescriptor)null, false, index2 != kotlin.CollectionsKt.getLastIndex(packageNames));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassifierDescriptor resolveDescriptorForUserType(@NotNull KtUserType userType, @NotNull LexicalScope scope2, @NotNull BindingTrace trace) {
        void $receiver;
        void value2;
        void $receiver22;
        void qualifierPartList;
        void hasError;
        Intrinsics.checkParameterIsNotNull(userType, "userType");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (userType.getQualifier() == null && !this.getStartWithPackage(userType)) {
            ClassifierDescriptor classifierDescriptor;
            KtSimpleNameExpression ktSimpleNameExpression = userType.getReferenceExpression();
            if (ktSimpleNameExpression != null) {
                void $receiver3;
                KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
                KtSimpleNameExpression it2 = (KtSimpleNameExpression)$receiver3;
                Name name = it2.getReferencedNameAsName();
                KtElement ktElement = it2;
                Intrinsics.checkExpressionValueIsNotNull(ktElement, "it");
                ClassifierDescriptor classifier2 = ScopeUtilsKt.getClassifier(scope2, name, new KotlinLookupLocation(ktElement));
                KtSimpleNameExpression ktSimpleNameExpression3 = it2;
                Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression3, "it");
                this.storeResult(trace, ktSimpleNameExpression3, classifier2, scope2.getOwnerDescriptor(), false, false);
                classifierDescriptor = classifier2;
            } else {
                classifierDescriptor = null;
            }
            return classifierDescriptor;
        }
        ModuleDescriptor module2 = DescriptorUtilsKt.getModule(scope2.getOwnerDescriptor());
        Object $i$a$1 = this.asQualifierPartList(userType);
        List<? extends QualifierPart> it2 = ((Pair)$i$a$1).component1();
        boolean classifier2 = ((Pair)$i$a$1).component2();
        $i$a$1 = null;
        if (hasError != false) {
            this.resolveToPackageOrClass((List<? extends QualifierPart>)qualifierPartList, module2, trace, scope2.getOwnerDescriptor(), scope2, false);
            return null;
        }
        $i$a$1 = (Collection)qualifierPartList;
        boolean $receiver22 = $receiver22.size() >= 1;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "Too short qualifier list for user type " + userType + " : " + kotlin.CollectionsKt.joinToString$default((Iterable)qualifierPartList, null, null, null, 0, null, null, 63);
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Collection $i$a$2 = (Collection)qualifierPartList;
        int n = 0;
        void var12_17 = qualifierPartList;
        QualifiedExpressionResolver qualifiedExpressionResolver = this;
        int n2 = $receiver.size();
        DeclarationDescriptor declarationDescriptor = qualifiedExpressionResolver.resolveToPackageOrClass(var12_17.subList(n, n2 - 1), module2, trace, scope2.getOwnerDescriptor(), AddToStdlibKt.check(scope2, (Function1)new Function1<LexicalScope, Boolean>(this, userType){
            final /* synthetic */ QualifiedExpressionResolver this$0;
            final /* synthetic */ KtUserType $userType;

            public final boolean invoke(@NotNull LexicalScope it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                return !QualifiedExpressionResolver.access$getStartWithPackage$p(this.this$0, this.$userType);
            }
            {
                this.this$0 = qualifiedExpressionResolver;
                this.$userType = ktUserType;
                super(1);
            }
        }), false);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor qualifier2 = declarationDescriptor;
        QualifierPart lastPart = (QualifierPart)kotlin.CollectionsKt.last(qualifierPartList);
        DeclarationDescriptor declarationDescriptor2 = qualifier2;
        ClassifierDescriptor classifier3 = declarationDescriptor2 instanceof PackageViewDescriptor ? ((PackageViewDescriptor)qualifier2).getMemberScope().getClassifier(lastPart.getName(), lastPart.getLocation()) : (declarationDescriptor2 instanceof ClassDescriptor ? ((ClassDescriptor)qualifier2).getUnsubstitutedInnerClassesScope().getClassifier(lastPart.getName(), lastPart.getLocation()) : (ClassifierDescriptor)null);
        this.storeResult(trace, lastPart.getExpression(), classifier3, scope2.getOwnerDescriptor(), false, false);
        return classifier3;
    }

    private final boolean getStartWithPackage(KtUserType $receiver) {
        KtUserType firstPart = $receiver;
        while (firstPart.getQualifier() != null) {
            if (firstPart.getQualifier() != null) continue;
            Intrinsics.throwNpe();
        }
        return firstPart.isAbsoluteInRootPackage();
    }

    private final Pair<List<? extends QualifierPart>, Boolean> asQualifierPartList(KtUserType $receiver) {
        boolean hasError = false;
        SmartList<QualifierPart> result2 = new SmartList<QualifierPart>();
        for (KtUserType userType = $receiver; userType != null; userType = userType.getQualifier()) {
            KtSimpleNameExpression referenceExpression = userType.getReferenceExpression();
            if (referenceExpression != null) {
                result2.add(new QualifierPart(referenceExpression.getReferencedNameAsName(), referenceExpression, userType.getTypeArgumentList()));
                continue;
            }
            hasError = true;
        }
        return TuplesKt.to(kotlin.CollectionsKt.asReversedMutable((List)result2), hasError);
    }

    @Nullable
    public final KtScope processImportReference(@NotNull KtImportDirective importDirective, @NotNull ModuleDescriptor moduleDescriptor, @NotNull BindingTrace trace, @Nullable PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        Intrinsics.checkParameterIsNotNull(importDirective, "importDirective");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        KtExpression ktExpression = importDirective.getImportedReference();
        if (ktExpression == null) {
            return null;
        }
        KtExpression importedReference = ktExpression;
        List<QualifierPart> path = this.asQualifierPartList(importedReference, trace);
        QualifierPart qualifierPart = kotlin.CollectionsKt.lastOrNull(path);
        if (qualifierPart == null) {
            return null;
        }
        QualifierPart lastPart = qualifierPart;
        if (!importDirective.isAllUnder()) {
            return this.processSingleImport(moduleDescriptor, trace, importDirective, path, lastPart, packageFragmentForVisibilityCheck);
        }
        DeclarationDescriptor declarationDescriptor = this.resolveToPackageOrClass(path, moduleDescriptor, trace, packageFragmentForVisibilityCheck, null, true);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor packageOrClassDescriptor = declarationDescriptor;
        if (packageOrClassDescriptor instanceof ClassDescriptor && ((ClassDescriptor)packageOrClassDescriptor).getKind().isSingleton()) {
            trace.report(Errors.CANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON.on((KtSimpleNameExpression)((PsiElement)lastPart.getExpression()), (ClassDescriptor)packageOrClassDescriptor));
        }
        return new AllUnderImportsScope(packageOrClassDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final SingleImportScope processSingleImport(ModuleDescriptor moduleDescriptor, BindingTrace trace, KtImportDirective importDirective, List<? extends QualifierPart> path, QualifierPart lastPart, PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        void destination;
        void $receiver;
        void $receiver2;
        void $receiver3;
        Name aliasName = KtPsiUtil.getAliasName(importDirective);
        if (aliasName == null) {
            this.resolveToPackageOrClass(path, moduleDescriptor, trace, packageFragmentForVisibilityCheck, null, true);
            return null;
        }
        Collection collection = path;
        int n = 0;
        List<? extends QualifierPart> list = path;
        QualifiedExpressionResolver qualifiedExpressionResolver = this;
        int n2 = $receiver3.size();
        DeclarationDescriptor declarationDescriptor = qualifiedExpressionResolver.resolveToPackageOrClass(list.subList(n, n2 - 1), moduleDescriptor, trace, packageFragmentForVisibilityCheck, null, true);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor packageOrClassDescriptor = declarationDescriptor;
        SmartList<DeclarationDescriptor> candidates = this.collectCandidateDescriptors(lastPart, packageOrClassDescriptor);
        if (!kotlin.CollectionsKt.isNotEmpty((Collection)candidates)) {
            this.tryResolveDescriptorsWhichCannotBeImported(trace, moduleDescriptor, packageOrClassDescriptor, lastPart);
            return null;
        }
        this.storeResult(trace, lastPart.getExpression(), (Collection<? extends DeclarationDescriptor>)candidates, (DeclarationDescriptor)packageFragmentForVisibilityCheck, true, false);
        Iterable iterable = candidates;
        void var12_15 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element : $receiver) {
            DeclarationDescriptor it2;
            DeclarationDescriptor declarationDescriptor2 = it2 = (DeclarationDescriptor)element;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "it");
            if (!this.isVisible(declarationDescriptor2, packageFragmentForVisibilityCheck, true)) continue;
            destination.add(element);
        }
        List list2 = AddToStdlibKt.check((List)destination, processSingleImport.importedDescriptors.2.INSTANCE);
        if (list2 == null) {
            list2 = candidates;
        }
        List importedDescriptors2 = list2;
        return new SingleImportScope(aliasName, importedDescriptors2);
    }

    /*
     * WARNING - void declaration
     */
    private final SmartList<DeclarationDescriptor> collectCandidateDescriptors(QualifierPart lastPart, DeclarationDescriptor packageOrClassDescriptor) {
        SmartList<DeclarationDescriptor> descriptors = new SmartList<DeclarationDescriptor>();
        Name lastName = lastPart.getName();
        KotlinLookupLocation location = lastPart.getLocation();
        DeclarationDescriptor declarationDescriptor = packageOrClassDescriptor;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            KtScope packageScope = ((PackageViewDescriptor)packageOrClassDescriptor).getMemberScope();
            CollectionsKt.addIfNotNull((Collection)descriptors, packageScope.getClassifier(lastName, location));
            descriptors.addAll(packageScope.getProperties(lastName, location));
            descriptors.addAll(packageScope.getFunctions(lastName, location));
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            CollectionsKt.addIfNotNull((Collection)descriptors, ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedInnerClassesScope().getClassifier(lastName, location));
            KtScope staticClassScope = ((ClassDescriptor)packageOrClassDescriptor).getStaticScope();
            descriptors.addAll(staticClassScope.getFunctions(lastName, location));
            descriptors.addAll(staticClassScope.getProperties(lastName, location));
            if (Intrinsics.areEqual((Object)((ClassDescriptor)packageOrClassDescriptor).getKind(), (Object)ClassKind.OBJECT)) {
                Collection destination;
                Iterable $receiver;
                Object object;
                Iterable destination2;
                Iterable $receiver2;
                void $receiver3;
                Iterable iterable = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope().getFunctions(lastName, location);
                Collection<DeclarationDescriptor> collection = descriptors;
                void var9_11 = $receiver3;
                Collection collection2 = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver3, 10));
                for (Object item : $receiver2) {
                    void it2;
                    FunctionDescriptor functionDescriptor = (FunctionDescriptor)item;
                    object = destination2;
                    FunctionImportedFromObject functionImportedFromObject = new FunctionImportedFromObject((FunctionDescriptor)it2);
                    object.add(functionImportedFromObject);
                }
                object = (List)destination2;
                ((AbstractCollection)collection).addAll((Collection)object);
                $receiver2 = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope().getProperties(lastName, location);
                destination2 = $receiver2;
                Collection collection3 = new ArrayList();
                for (Object element : $receiver) {
                    if (!(element instanceof PropertyDescriptor)) continue;
                    destination.add(element);
                }
                $receiver2 = (List)destination;
                $receiver = $receiver2;
                destination = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver2, 10));
                for (Object item : $receiver) {
                    void it3;
                    PropertyDescriptor $i$f$filterIsInstanceTo = (PropertyDescriptor)item;
                    collection = destination;
                    object = new PropertyImportedFromObject((PropertyDescriptor)it3);
                    collection.add((DeclarationDescriptor)object);
                }
                List properties2 = (List)destination;
                descriptors.addAll(properties2);
            }
        } else {
            throw (Throwable)new IllegalStateException("Should be class or package: " + packageOrClassDescriptor);
        }
        return descriptors;
    }

    private final void tryResolveDescriptorsWhichCannotBeImported(BindingTrace trace, ModuleDescriptor moduleDescriptor, DeclarationDescriptor packageOrClassDescriptor, QualifierPart lastPart) {
        SmartList<DeclarationDescriptor> descriptors = new SmartList<DeclarationDescriptor>();
        Name lastName = lastPart.getName();
        DeclarationDescriptor declarationDescriptor = packageOrClassDescriptor;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            FqName fqName2 = ((PackageViewDescriptor)packageOrClassDescriptor).getFqName().child(lastName);
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageOrClassDescriptor.fqName.child(lastName)");
            PackageViewDescriptor packageDescriptor = moduleDescriptor.getPackage(fqName2);
            if (!packageDescriptor.isEmpty()) {
                trace.report(Errors.PACKAGE_CANNOT_BE_IMPORTED.on((KtSimpleNameExpression)((PsiElement)lastPart.getExpression())));
                descriptors.add(packageOrClassDescriptor);
            }
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            KtScope memberScope2 = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope();
            descriptors.addAll(memberScope2.getFunctions(lastName, lastPart.getLocation()));
            descriptors.addAll(memberScope2.getProperties(lastName, lastPart.getLocation()));
            if (kotlin.CollectionsKt.isNotEmpty((Collection)descriptors)) {
                trace.report(Errors.CANNOT_BE_IMPORTED.on((KtSimpleNameExpression)((PsiElement)lastPart.getExpression()), lastName));
            }
        } else {
            throw (Throwable)new IllegalStateException("Should be class or package: " + packageOrClassDescriptor);
        }
        this.storeResult(trace, lastPart.getExpression(), (Collection<? extends DeclarationDescriptor>)descriptors, (DeclarationDescriptor)null, true, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<QualifierPart> asQualifierPartList(KtExpression $receiver, BindingTrace trace) {
        SmartList<QualifierPart> result2 = new SmartList<QualifierPart>();
        KtExpression expression = $receiver;
        while (expression != null) {
            KtExpression ktExpression = expression;
            if (ktExpression instanceof KtSimpleNameExpression) {
                result2.add(new QualifierPart(((KtSimpleNameExpression)expression).getReferencedNameAsName(), (KtSimpleNameExpression)expression, null, 4, null));
                break;
            }
            if (ktExpression instanceof KtQualifiedExpression) {
                Boolean bl;
                KtExpression ktExpression2 = ((KtQualifiedExpression)expression).getSelectorExpression();
                if (!(ktExpression2 instanceof KtSimpleNameExpression)) {
                    ktExpression2 = null;
                }
                if ((KtSimpleNameExpression)ktExpression2 != null) {
                    void $receiver2;
                    KtSimpleNameExpression it2 = (KtSimpleNameExpression)$receiver2;
                    bl = result2.add(new QualifierPart(it2.getReferencedNameAsName(), it2, null, 4, null));
                } else {
                    bl = null;
                }
                if (!((expression = ((KtQualifiedExpression)expression).getReceiverExpression()) instanceof KtSafeQualifiedExpression)) continue;
                trace.report(Errors.SAFE_CALL_IN_QUALIFIER.on(((KtSafeQualifiedExpression)expression).getOperationTokenNode().getPsi()));
                continue;
            }
            expression = null;
        }
        return kotlin.CollectionsKt.asReversedMutable((List)result2);
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarationDescriptor resolveToPackageOrClass(List<? extends QualifierPart> path, ModuleDescriptor moduleDescriptor, BindingTrace trace, DeclarationDescriptor shouldBeVisibleFrom, LexicalScope scopeForFirstPart, boolean inImport) {
        void currentDescriptor;
        Iterable $receiver;
        void currentIndex;
        Pair<DeclarationDescriptor, Integer> pair;
        ClassifierDescriptor firstDescriptor;
        ClassifierDescriptor classifierDescriptor;
        ClassifierDescriptor $receiver2;
        Object firstPart;
        DeclarationDescriptor $receiver3;
        if (path.isEmpty()) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.ROOT");
            return moduleDescriptor.getPackage(fqName2);
        }
        LexicalScope lexicalScope = scopeForFirstPart;
        if (lexicalScope != null) {
            ClassifierDescriptor classifierDescriptor2;
            LexicalScope lexicalScope2 = lexicalScope;
            LexicalScope it2 = (LexicalScope)((Object)$receiver3);
            firstPart = kotlin.CollectionsKt.first(path);
            ClassifierDescriptor classifierDescriptor3 = ScopeUtilsKt.getClassifier(it2, ((QualifierPart)firstPart).getName(), ((QualifierPart)firstPart).getLocation());
            if (classifierDescriptor3 != null) {
                ClassifierDescriptor classifierDescriptor4 = classifierDescriptor3;
                ClassifierDescriptor $receiver4 = $receiver2;
                QualifiedExpressionResolver.storeResult$default(this, trace, ((QualifierPart)firstPart).getExpression(), $receiver4, shouldBeVisibleFrom, inImport, false, 32);
                classifierDescriptor2 = $receiver2;
            } else {
                classifierDescriptor2 = null;
            }
            classifierDescriptor = classifierDescriptor2;
        } else {
            classifierDescriptor = null;
        }
        ClassifierDescriptor classifierDescriptor5 = firstDescriptor = classifierDescriptor;
        if (classifierDescriptor5 != null) {
            $receiver2 = classifierDescriptor5;
            ClassifierDescriptor it3 = $receiver2;
            pair = new Pair<ClassifierDescriptor, Integer>(it3, 1);
        } else {
            pair = this.quickResolveToPackage(moduleDescriptor, path, trace, inImport);
        }
        firstPart = pair;
        $receiver3 = (DeclarationDescriptor)((Pair)firstPart).component1();
        int it2 = ((Number)((Pair)firstPart).component2()).intValue();
        firstPart = null;
        firstPart = path;
        void var22_14 = currentIndex;
        List<? extends QualifierPart> list = path;
        int n = $receiver.size();
        $receiver = list.subList((int)var22_14, n);
        DeclarationDescriptor accumulator = currentDescriptor;
        for (Object element : $receiver) {
            DeclarationDescriptor declarationDescriptor;
            QualifierPart $i$f$let = (QualifierPart)element;
            DeclarationDescriptor descriptor2 = accumulator;
            if (descriptor2 == null) {
                declarationDescriptor = null;
            } else {
                DeclarationDescriptor declarationDescriptor2;
                void qualifierPart;
                DeclarationDescriptor declarationDescriptor3 = descriptor2;
                if (declarationDescriptor3 instanceof ClassDescriptor) {
                    declarationDescriptor2 = ((ClassDescriptor)descriptor2).getUnsubstitutedInnerClassesScope().getClassifier(qualifierPart.getName(), qualifierPart.getLocation());
                } else if (declarationDescriptor3 instanceof PackageViewDescriptor) {
                    PackageViewDescriptor packageView;
                    PackageViewDescriptor packageViewDescriptor;
                    if (qualifierPart.getTypeArguments() == null) {
                        FqName fqName3 = ((PackageViewDescriptor)descriptor2).getFqName().child(qualifierPart.getName());
                        Intrinsics.checkExpressionValueIsNotNull(fqName3, "descriptor.fqName.child(qualifierPart.name)");
                        packageViewDescriptor = moduleDescriptor.getPackage(fqName3);
                    } else {
                        packageViewDescriptor = packageView = (PackageViewDescriptor)null;
                    }
                    declarationDescriptor2 = packageView != null && !packageView.isEmpty() ? (DeclarationDescriptor)packageView : (DeclarationDescriptor)((PackageViewDescriptor)descriptor2).getMemberScope().getClassifier(qualifierPart.getName(), qualifierPart.getLocation());
                } else {
                    declarationDescriptor2 = null;
                }
                DeclarationDescriptor nextDescriptor = declarationDescriptor2;
                QualifiedExpressionResolver.storeResult$default(this, trace, qualifierPart.getExpression(), nextDescriptor, shouldBeVisibleFrom, inImport, false, 32);
                declarationDescriptor = nextDescriptor;
            }
            accumulator = declarationDescriptor;
        }
        return accumulator;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<PackageViewDescriptor, Integer> quickResolveToPackage(ModuleDescriptor $receiver, List<? extends QualifierPart> path, BindingTrace trace, boolean inImport) {
        void $receiver2;
        void initial;
        int n;
        int n2;
        block8: {
            int n3;
            void $receiver3;
            List<? extends QualifierPart> list = path;
            IntRange intRange = kotlin.CollectionsKt.getIndices((Collection)$receiver3);
            int n4 = ((Number)intRange.getStart()).intValue();
            if (n4 <= (n3 = ((Number)intRange.getEnd()).intValue())) {
                while (true) {
                    void index2;
                    QualifierPart it2;
                    if ((it2 = (QualifierPart)$receiver3.get((int)index2)).getTypeArguments() != null) {
                        n2 = index2;
                        break block8;
                    }
                    if (index2 == n3) break;
                    ++index2;
                }
            }
            n2 = -1;
        }
        int $receiver3 = n2;
        int it22 = $receiver3;
        if (it22 == -1) {
            void $receiver4;
            Collection collection = path;
            n = $receiver4.size();
        } else {
            n = it22 + 1;
        }
        int possiblePackagePrefixSize = n;
        Iterable it22 = path.subList(0, possiblePackagePrefixSize);
        FqName $receiver4 = FqName.ROOT;
        FqName accumulator = initial;
        for (Object element : $receiver2) {
            void qualifierPart;
            QualifierPart qualifierPart2 = (QualifierPart)element;
            FqName fqName2 = accumulator;
            accumulator = fqName2.child(qualifierPart.getName());
        }
        FqName fqName3 = accumulator;
        int prefixSize = possiblePackagePrefixSize;
        while (!fqName3.isRoot()) {
            FqName fqName4 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull(fqName4, "fqName");
            PackageViewDescriptor packageDescriptor = $receiver.getPackage(fqName4);
            if (!packageDescriptor.isEmpty()) {
                this.recordPackageViews(path.subList(0, prefixSize), packageDescriptor, trace, inImport);
                return new Pair<PackageViewDescriptor, Integer>(packageDescriptor, prefixSize);
            }
            fqName3 = fqName3.parent();
            --prefixSize;
        }
        FqName fqName5 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull(fqName5, "FqName.ROOT");
        return new Pair<PackageViewDescriptor, Integer>($receiver.getPackage(fqName5), 0);
    }

    /*
     * WARNING - void declaration
     */
    private final void recordPackageViews(List<? extends QualifierPart> path, PackageViewDescriptor packageView, BindingTrace trace, boolean inImport) {
        void $receiver;
        List<? extends QualifierPart> list = path;
        int index2 = kotlin.CollectionsKt.getLastIndex($receiver);
        PackageViewDescriptor accumulator = packageView;
        while (index2 >= 0) {
            void value2;
            void currentView;
            int n = index2--;
            PackageViewDescriptor packageViewDescriptor = accumulator;
            QualifierPart qualifierPart = (QualifierPart)$receiver.get(n);
            QualifiedExpressionResolver.storeResult$default(this, trace, qualifierPart.getExpression(), (DeclarationDescriptor)currentView, null, inImport, false, 32);
            PackageViewDescriptor parentView = currentView.getContainingDeclaration();
            boolean bl = parentView != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
                String message = "Containing Declaration must be not null for package with fqName: " + currentView.getFqName() + ", " + ("path: " + kotlin.CollectionsKt.joinToString$default(path, null, null, null, 0, null, null, 63) + ", packageView fqName: " + packageView.getFqName());
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            if (parentView != null) continue;
            Intrinsics.throwNpe();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void storeResult(BindingTrace trace, KtSimpleNameExpression referenceExpression, Collection<? extends DeclarationDescriptor> descriptors, DeclarationDescriptor shouldBeVisibleFrom, boolean inImport, boolean isQualifier) {
        void $receiver;
        Collection<? extends DeclarationDescriptor> collection = descriptors;
        if ($receiver.size() > 1) {
            Object descriptor2;
            void destination;
            void $receiver2;
            void $receiver3;
            Iterable $i$f$size = descriptors;
            void var9_9 = $receiver3;
            Collection collection2 = new ArrayList();
            for (Object element : $receiver2) {
                DeclarationDescriptor it2 = (DeclarationDescriptor)element;
                if (!this.isVisible(it2, shouldBeVisibleFrom, inImport)) continue;
                destination.add(element);
            }
            List visibleDescriptors = (List)destination;
            if (visibleDescriptors.isEmpty()) {
                Object t = kotlin.CollectionsKt.first((Iterable)descriptors);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility");
                }
                descriptor2 = (DeclarationDescriptorWithVisibility)t;
                trace.report(Errors.INVISIBLE_REFERENCE.on((KtSimpleNameExpression)((PsiElement)referenceExpression), (DeclarationDescriptor)descriptor2, descriptor2.getVisibility(), (DeclarationDescriptor)descriptor2));
            } else {
                descriptor2 = visibleDescriptors;
                if ($receiver3.size() > 1) {
                    trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression, visibleDescriptors);
                } else {
                    this.storeResult(trace, referenceExpression, (DeclarationDescriptor)kotlin.CollectionsKt.single(visibleDescriptors), (DeclarationDescriptor)null, inImport, isQualifier);
                }
            }
        } else {
            this.storeResult(trace, referenceExpression, (DeclarationDescriptor)kotlin.CollectionsKt.singleOrNull((Iterable)descriptors), shouldBeVisibleFrom, inImport, isQualifier);
        }
    }

    private final void storeResult(BindingTrace trace, KtSimpleNameExpression referenceExpression, DeclarationDescriptor descriptor2, DeclarationDescriptor shouldBeVisibleFrom, boolean inImport, boolean isQualifier) {
        if (descriptor2 == null) {
            trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)referenceExpression), referenceExpression));
            return;
        }
        trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, descriptor2);
        if (descriptor2 instanceof ClassifierDescriptor) {
            this.symbolUsageValidator.validateTypeUsage((ClassifierDescriptor)descriptor2, trace, referenceExpression);
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility && !this.isVisible(descriptor2, shouldBeVisibleFrom, inImport)) {
            trace.report(Errors.INVISIBLE_REFERENCE.on((KtSimpleNameExpression)((PsiElement)referenceExpression), descriptor2, ((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), descriptor2));
        }
        if (isQualifier) {
            this.storageQualifier(trace, referenceExpression, descriptor2);
        }
    }

    static /* synthetic */ void storeResult$default(QualifiedExpressionResolver qualifiedExpressionResolver, BindingTrace bindingTrace, KtSimpleNameExpression ktSimpleNameExpression, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl, boolean bl2, int n) {
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        qualifiedExpressionResolver.storeResult(bindingTrace, ktSimpleNameExpression, declarationDescriptor, declarationDescriptor2, bl, bl2);
    }

    private final void storageQualifier(BindingTrace trace, KtSimpleNameExpression referenceExpression, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof PackageViewDescriptor || descriptor2 instanceof ClassifierDescriptor) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (!(declarationDescriptor instanceof PackageViewDescriptor)) {
                declarationDescriptor = null;
            }
            PackageViewDescriptor packageViewDescriptor = (PackageViewDescriptor)declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            if (!(declarationDescriptor2 instanceof ClassifierDescriptor)) {
                declarationDescriptor2 = null;
            }
            QualifierReceiver qualifier2 = new QualifierReceiver(referenceExpression, packageViewDescriptor, (ClassifierDescriptor)declarationDescriptor2);
            trace.record(BindingContext.QUALIFIER, qualifier2.getExpression(), qualifier2);
        }
    }

    private final boolean isVisible(DeclarationDescriptor descriptor2, DeclarationDescriptor shouldBeVisibleFrom, boolean inImport) {
        if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility) || shouldBeVisibleFrom == null) {
            return true;
        }
        Visibility visibility = ((DeclarationDescriptorWithVisibility)descriptor2).getVisibility();
        if (inImport) {
            if (Visibilities.isPrivate(visibility)) {
                return false;
            }
            if (!visibility.mustCheckInImports()) {
                return true;
            }
        }
        return Visibilities.isVisible(ReceiverValue.IRRELEVANT_RECEIVER, (DeclarationDescriptorWithVisibility)descriptor2, shouldBeVisibleFrom);
    }

    @NotNull
    public final SymbolUsageValidator getSymbolUsageValidator() {
        return this.symbolUsageValidator;
    }

    public QualifiedExpressionResolver(@NotNull SymbolUsageValidator symbolUsageValidator) {
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        this.symbolUsageValidator = symbolUsageValidator;
    }

    public static final /* synthetic */ boolean access$getStartWithPackage$p(QualifiedExpressionResolver $this, KtUserType $receiver) {
        return $this.getStartWithPackage($receiver);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0005!Q\u0001B!\u0005\u0019\u0001I\u0012\u0001'\u0001\"\"%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011\"\u0002\u0003\u0002\u0011\ri!\u0001$\u0001\u0019\bE\u001b\u0011\u0001\u0003\u0003&\n\u0011\u0019u\u0001c\u0005\u000e\u0003a\rQ\u0015\u0002\u0003D\u000f!QQ\"\u0001M\u0003K\u0017!1i\u0002E\u000b\u001b\ta\t\u0001g\u0002&*\u0011\u00195\u0001C\u0006\u000e\u0003a\u0001\u0011\u0004\u0002\u0003\u0002\u0011\u0005i\u0011\u0001g\u0001\u001a\t\u0011\t\u0001BA\u0007\u00021\u000bIR\u0001B\u0001\t\u00075\u0011A\u0012\u0001M\u0004S)!1\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0005\u000b\u0001i!\u0001\"\u0003\t\u000b%RAa\u0011\u0005\t\f5\t\u0001DB)\u0004\t\u0015\u0001QB\u0001C\u0007\u0011\u001dI#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0010!A\u0011f\u0003\u0003D\u0011!\u0019QB\u0001G\u00011\u000f\t6\u0001B\u0003\u0001\u001b\t!\t\u0002C\u0005"}, strings={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "typeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "location", "Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "getLocation", "()Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getTypeArguments", "()Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "component1", "component2", "component3", "copy"}, moduleName="kotlin-compiler")
    private static final class QualifierPart {
        @NotNull
        private final KotlinLookupLocation location;
        @NotNull
        private final Name name;
        @NotNull
        private final KtSimpleNameExpression expression;
        @Nullable
        private final KtTypeArgumentList typeArguments;

        @NotNull
        public final KotlinLookupLocation getLocation() {
            return this.location;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @NotNull
        public final KtSimpleNameExpression getExpression() {
            return this.expression;
        }

        @Nullable
        public final KtTypeArgumentList getTypeArguments() {
            return this.typeArguments;
        }

        public QualifierPart(@NotNull Name name, @NotNull KtSimpleNameExpression expression, @Nullable KtTypeArgumentList typeArguments) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this.name = name;
            this.expression = expression;
            this.typeArguments = typeArguments;
            this.location = new KotlinLookupLocation(this.expression);
        }

        public /* synthetic */ QualifierPart(Name name, KtSimpleNameExpression ktSimpleNameExpression, KtTypeArgumentList ktTypeArgumentList, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                ktTypeArgumentList = null;
            }
            this(name, ktSimpleNameExpression, ktTypeArgumentList);
        }

        @NotNull
        public final Name component1() {
            return this.name;
        }

        @NotNull
        public final KtSimpleNameExpression component2() {
            return this.expression;
        }

        @Nullable
        public final KtTypeArgumentList component3() {
            return this.typeArguments;
        }

        @NotNull
        public final QualifierPart copy(@NotNull Name name, @NotNull KtSimpleNameExpression expression, @Nullable KtTypeArgumentList typeArguments) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            return new QualifierPart(name, expression, typeArguments);
        }

        @NotNull
        public static /* synthetic */ QualifierPart copy$default(QualifierPart qualifierPart, Name name, KtSimpleNameExpression ktSimpleNameExpression, KtTypeArgumentList ktTypeArgumentList, int n) {
            if ((n & 1) != 0) {
                name = qualifierPart.name;
            }
            if ((n & 2) != 0) {
                ktSimpleNameExpression = qualifierPart.expression;
            }
            if ((n & 4) != 0) {
                ktTypeArgumentList = qualifierPart.typeArguments;
            }
            return qualifierPart.copy(name, ktSimpleNameExpression, ktTypeArgumentList);
        }

        public String toString() {
            return "QualifierPart(name=" + this.name + ", expression=" + this.expression + ", typeArguments=" + this.typeArguments + ")";
        }

        public int hashCode() {
            Name name = this.name;
            KtSimpleNameExpression ktSimpleNameExpression = this.expression;
            KtTypeArgumentList ktTypeArgumentList = this.typeArguments;
            return ((name != null ? ((Object)name).hashCode() : 0) * 31 + (ktSimpleNameExpression != null ? ktSimpleNameExpression.hashCode() : 0)) * 31 + (ktTypeArgumentList != null ? ktTypeArgumentList.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QualifierPart)) break block3;
                    QualifierPart qualifierPart = (QualifierPart)object;
                    if (!Intrinsics.areEqual(this.name, qualifierPart.name) || !Intrinsics.areEqual(this.expression, qualifierPart.expression) || !Intrinsics.areEqual(this.typeArguments, qualifierPart.typeArguments)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

