/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElementImpl;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0001\u0019\u0001I\u0012\u0001'\u0001\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003K\rA)!D\u0001\u0019\u0007\u0015\u001a\u0001rA\u0007\u00021\u0011)3\u0001#\u0003\u000e\u0003a)Qe\u0001E\u0006\u001b\u0005Ab!\n\u0004\t\u000e5!\u0011BA\u0005\u00021\u0015Ar!\n\u0003\t\u00105\u0011A\u0012\u0001\r\u0001"}, strings={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "Lorg/jetbrains/kotlin/psi/KtElementImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "getContainingDoc", "Lorg/jetbrains/kotlin/kdoc/psi/api/KDoc;", "getContainingSection", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "getNameText", "", "getNameTextRange", "Lcom/intellij/openapi/util/TextRange;", "getQualifiedName", "", "getQualifier"}, moduleName="kotlin-compiler")
public final class KDocName
extends KtElementImpl {
    @NotNull
    public final KDoc getContainingDoc() {
        KDoc kdoc;
        KDocName $receiver = this;
        KDoc kDoc = kdoc = PsiTreeUtil.getParentOfType((PsiElement)$receiver, KDoc.class, true);
        if (kDoc == null) {
            throw (Throwable)new IllegalStateException("KDocName must be inside a KDoc");
        }
        return kDoc;
    }

    @NotNull
    public final KDocSection getContainingSection() {
        KDocSection kdoc;
        KDocName $receiver = this;
        KDocSection kDocSection = kdoc = PsiTreeUtil.getParentOfType((PsiElement)$receiver, KDocSection.class, true);
        if (kDocSection == null) {
            throw (Throwable)new IllegalStateException("KDocName must be inside a KDocSection");
        }
        return kDocSection;
    }

    @Nullable
    public final KDocName getQualifier() {
        KDocName $receiver = this;
        return PsiTreeUtil.getChildOfType($receiver, KDocName.class);
    }

    @NotNull
    public final TextRange getNameTextRange() {
        ASTNode dot = this.getNode().findChildByType(KtTokens.DOT);
        TextRange textRange = this.getTextRange();
        int nameStart = dot != null ? dot.getTextRange().getEndOffset() - textRange.getStartOffset() : 0;
        return new TextRange(nameStart, textRange.getLength());
    }

    @NotNull
    public final String getNameText() {
        String string = this.getNameTextRange().substring(this.getText());
        Intrinsics.checkExpressionValueIsNotNull(string, "getNameTextRange().substring(getText())");
        return string;
    }

    @NotNull
    public final List<String> getQualifiedName() {
        KDocName qualifier2 = this.getQualifier();
        List<String> nameAsList = CollectionsKt.listOf(this.getNameText());
        return qualifier2 != null ? CollectionsKt.plus((Collection)qualifier2.getQualifiedName(), (Iterable)nameAsList) : nameAsList;
    }

    public KDocName(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }
}

