/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compiler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\t\u001f\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u00015}\u0001\u0002A\u0007\u00021\u0003I2\u0001C\u0001\u000e\u0003a\u0005\u0011D\u0002E\u0002\u001b\u0011I!!C\u0001\u0019\u0006a\u0011AkA\u0002\u000e\"!\u001dQ\"\u0001M\u00013\rA\u0011!D\u0001\u0019\u0002e\u0019\u0001\u0002B\u0007\u00021\u0003I2\u0001#\u0003\u000e\u0003a\u0005AkA\u0002\u000e\u0014!)QB\u0001G\u00011\u0017I2\u0001\u0003\u0004\u000e\u0003a\u0005AkA\u0002"}, strings={"cliPluginUsageString", "", "pluginId", "options", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "CliOptionsKt", "getPluginOptionString", "key", "value", "parsePluginOption", "Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "argumentValue"}, moduleName="kotlin-compiler")
public final class CliOptionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cliPluginUsageString(@NotNull String pluginId, @NotNull Collection<? extends CliOption> options) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(pluginId, "pluginId");
        Intrinsics.checkParameterIsNotNull(options, "options");
        int LEFT_INDENT = 2;
        int MAX_OPTION_WIDTH = 26;
        Iterable iterable = options;
        void var6_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            CliOption cliOption = (CliOption)item;
            void var18_14 = destination;
            String name = it2.getName() + " " + it2.getValueDescription();
            String margin = CollectionsKt.length(name) > MAX_OPTION_WIDTH ? "\n" + StringsKt.repeat(" ", MAX_OPTION_WIDTH + LEFT_INDENT + 1) : StringsKt.repeat(" ", 1 + MAX_OPTION_WIDTH - CollectionsKt.length(name));
            List modifiers2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf(it2.getRequired() ? "required" : (String)null, it2.getAllowMultipleOccurrences() ? "multiple" : (String)null));
            String modifiersEnclosed = modifiers2.isEmpty() ? "" : " (" + CollectionsKt.joinToString$default(modifiers2, null, null, null, 0, null, null, 63) + ")";
            String string = StringsKt.repeat(" ", LEFT_INDENT) + name + margin + it2.getDescription() + modifiersEnclosed;
            var18_14.add(string);
        }
        List renderedOptions = (List)destination;
        return "Plugin " + "\"" + pluginId + "\"" + " usage:" + "\n" + CollectionsKt.joinToString$default(renderedOptions, "\n", null, "\n", 0, null, null, 58);
    }

    @Nullable
    public static final CliOptionValue parsePluginOption(@NotNull String argumentValue) {
        Intrinsics.checkParameterIsNotNull(argumentValue, "argumentValue");
        Pattern pattern = Pattern.compile("^plugin:([^:]*):([^=]*)=(.*)$");
        Matcher matcher = pattern.matcher(argumentValue);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull(string, "matcher.group(1)");
            String string2 = matcher.group(2);
            Intrinsics.checkExpressionValueIsNotNull(string2, "matcher.group(2)");
            String string3 = matcher.group(3);
            Intrinsics.checkExpressionValueIsNotNull(string3, "matcher.group(3)");
            return new CliOptionValue(string, string2, string3);
        }
        return null;
    }

    @NotNull
    public static final String getPluginOptionString(@NotNull String pluginId, @NotNull String key, @NotNull String value2) {
        Intrinsics.checkParameterIsNotNull(pluginId, "pluginId");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        return "plugin:" + pluginId + ":" + key + "=" + value2;
    }
}

