/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.org.objectweb.asm.Type;

public final class PsiCodegenPredictor {
    private PsiCodegenPredictor() {
    }

    public static boolean checkPredictedNameFromPsi(@NotNull DeclarationDescriptor descriptor2, @Nullable Type nameFromDescriptors, @NotNull JvmFileClassesProvider fileClassesManager) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        if (fileClassesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesManager", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element instanceof KtDeclaration) {
            String classNameFromPsi = PsiCodegenPredictor.getPredefinedJvmInternalName((KtDeclaration)element, fileClassesManager);
            assert (classNameFromPsi == null || Type.getObjectType(classNameFromPsi).equals(nameFromDescriptors)) : String.format("Invalid algorithm for getting qualified name from psi! Predicted: %s, actual %s\nElement: %s", classNameFromPsi, nameFromDescriptors, element.getText());
        }
        return true;
    }

    @Nullable
    public static String getPredefinedJvmInternalName(@NotNull KtDeclaration declaration, @NotNull JvmFileClassesProvider fileClassesProvider) {
        String parentInternalName;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmInternalName"));
        }
        if (fileClassesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesProvider", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmInternalName"));
        }
        KtDeclaration parentDeclaration = KtStubbedPsiUtil.getContainingDeclaration(declaration);
        if (parentDeclaration != null) {
            parentInternalName = PsiCodegenPredictor.getPredefinedJvmInternalName(parentDeclaration, fileClassesProvider);
            if (parentInternalName == null) {
                return null;
            }
        } else {
            KtFile containingFile = declaration.getContainingJetFile();
            if (declaration instanceof KtNamedFunction) {
                Name name = ((KtNamedFunction)declaration).getNameAsName();
                return name == null ? null : FileClasses.getFileClassInternalName(fileClassesProvider, containingFile) + "$" + name.asString();
            }
            parentInternalName = AsmUtil.internalNameByFqNameWithoutInnerClasses(containingFile.getPackageFqName());
        }
        if (!PsiTreeUtil.instanceOf(declaration, KtClass.class, KtObjectDeclaration.class, KtNamedFunction.class, KtProperty.class) || PsiCodegenPredictor.isEnumEntryWithoutBody(declaration)) {
            return null;
        }
        Name name = ((KtNamedDeclaration)declaration).getNameAsName();
        if (name == null) {
            return null;
        }
        if (declaration instanceof KtNamedFunction && !(parentDeclaration instanceof KtClass) && !(parentDeclaration instanceof KtObjectDeclaration)) {
            return null;
        }
        if (declaration instanceof KtProperty) {
            return parentInternalName + "$" + name.asString();
        }
        if (parentInternalName.isEmpty()) {
            return name.asString();
        }
        return parentInternalName + (parentDeclaration == null ? "/" : "$") + name.asString();
    }

    private static boolean isEnumEntryWithoutBody(KtDeclaration declaration) {
        if (!(declaration instanceof KtEnumEntry)) {
            return false;
        }
        KtClassBody body = ((KtEnumEntry)declaration).getBody();
        return body == null || body.getDeclarations().size() == 0;
    }
}

