/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.SetsKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedType;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.ConstraintContext;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.ConstraintSystemImpl;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBounds;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBoundsImpl;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBoundsKt;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.constraintPosition.CompoundConstraintPosition;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.ApproximationBounds;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.annotations.NotNull;

public final class ConstraintIncorporationKt {
    /*
     * WARNING - void declaration
     */
    public static final void incorporateBound(ConstraintSystemImpl $receiver, @NotNull TypeBounds.Bound newBound) {
        void $receiver2;
        KotlinType constrainingType;
        int n;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(newBound, "newBound");
        TypeParameterDescriptor typeVariable = newBound.getTypeVariable();
        TypeBoundsImpl typeBounds = $receiver.getTypeBounds(typeVariable);
        IntRange intRange = CollectionsKt.getIndices(typeBounds.getBounds());
        int n2 = ((Number)intRange.getStart()).intValue();
        int n3 = ((Number)intRange.getEnd()).intValue();
        if (n2 <= n3) {
            while (true) {
                void oldBoundIndex;
                TypeBounds.Bound bound = (TypeBounds.Bound)((ArrayList)typeBounds.getBounds()).get((int)oldBoundIndex);
                Intrinsics.checkExpressionValueIsNotNull(bound, "typeBounds.bounds[oldBoundIndex]");
                ConstraintIncorporationKt.addConstraintFromBounds($receiver, bound, newBound);
                if (oldBoundIndex == n3) break;
                ++oldBoundIndex;
            }
        }
        List<TypeBounds.Bound> boundsUsedIn = $receiver.getBoundsUsedIn(typeVariable);
        IntRange intRange2 = CollectionsKt.getIndices((Collection)boundsUsedIn);
        n3 = ((Number)intRange2.getStart()).intValue();
        if (n3 <= (n = ((Number)intRange2.getEnd()).intValue())) {
            while (true) {
                void index2;
                TypeBounds.Bound boundUsedIn = boundsUsedIn.get((int)index2);
                ConstraintIncorporationKt.generateNewBound($receiver, boundUsedIn, newBound);
                if (index2 == n) break;
                ++index2;
            }
        }
        if ($receiver.isMyTypeVariable(constrainingType = newBound.getConstrainingType())) {
            ConstraintContext context = new ConstraintContext(newBound.getPosition(), newBound.getDerivedFrom(), false, 4, null);
            TypeParameterDescriptor typeParameterDescriptor = $receiver.getMyTypeVariable(constrainingType);
            if (typeParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            $receiver.addBound(typeParameterDescriptor, $receiver.getCorrespondingType(typeVariable), TypeBoundsKt.reverse(newBound.getKind()), context);
            return;
        }
        Iterable context = ConstraintSystemImpl.getNestedTypeVariables$default($receiver, constrainingType, false, 1);
        for (Object element : $receiver2) {
            int n4;
            TypeParameterDescriptor it2 = (TypeParameterDescriptor)element;
            Collection boundsForNestedVariable = $receiver.getTypeBounds(it2).getBounds();
            IntRange intRange3 = CollectionsKt.getIndices(boundsForNestedVariable);
            int n5 = ((Number)intRange3.getStart()).intValue();
            if (n5 > (n4 = ((Number)intRange3.getEnd()).intValue())) continue;
            while (true) {
                void index3;
                TypeBounds.Bound bound = (TypeBounds.Bound)((ArrayList)boundsForNestedVariable).get((int)index3);
                Intrinsics.checkExpressionValueIsNotNull(bound, "boundsForNestedVariable[index]");
                ConstraintIncorporationKt.generateNewBound($receiver, newBound, bound);
                if (index3 == n4) break;
                ++index3;
            }
        }
    }

    private static final void addConstraintFromBounds(ConstraintSystemImpl $receiver, TypeBounds.Bound old, TypeBounds.Bound bound) {
        Enum $receiver2;
        if (Intrinsics.areEqual(old, bound)) {
            return;
        }
        KotlinType oldType = old.getConstrainingType();
        KotlinType newType = bound.getConstrainingType();
        ConstraintContext context = new ConstraintContext(new CompoundConstraintPosition(old.getPosition(), bound.getPosition()), SetsKt.plus(old.getDerivedFrom(), (Iterable)bound.getDerivedFrom()), false, 4, null);
        Enum enum_ = old.getKind();
        int n = $receiver2.ordinal();
        $receiver2 = bound.getKind();
        int n2 = n;
        int n3 = $receiver2.ordinal();
        if (n2 < n3) {
            $receiver.addConstraint(ConstraintSystemImpl.ConstraintKind.SUB_TYPE, oldType, newType, context);
        } else {
            $receiver2 = old.getKind();
            int n4 = $receiver2.ordinal();
            $receiver2 = bound.getKind();
            n2 = n4;
            n3 = $receiver2.ordinal();
            if (n2 > n3) {
                $receiver.addConstraint(ConstraintSystemImpl.ConstraintKind.SUB_TYPE, newType, oldType, context);
            } else if (Intrinsics.areEqual((Object)old.getKind(), (Object)bound.getKind()) && Intrinsics.areEqual((Object)old.getKind(), (Object)TypeBounds.BoundKind.EXACT_BOUND)) {
                $receiver.addConstraint(ConstraintSystemImpl.ConstraintKind.EQUAL, oldType, newType, context);
            }
        }
    }

    private static final void generateNewBound(ConstraintSystemImpl $receiver, TypeBounds.Bound bound, TypeBounds.Bound substitution) {
        KotlinType kotlinType;
        TypeBounds.BoundKind boundKind = substitution.getKind();
        if (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.EXACT_BOUND)) {
            kotlinType = substitution.getConstrainingType();
        } else if (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.UPPER_BOUND)) {
            kotlinType = new CapturedType(new TypeProjectionImpl(Variance.OUT_VARIANCE, substitution.getConstrainingType()));
        } else if (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.LOWER_BOUND)) {
            kotlinType = new CapturedType(new TypeProjectionImpl(Variance.IN_VARIANCE, substitution.getConstrainingType()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KotlinType substitutedType = kotlinType;
        TypeProjectionImpl newTypeProjection = new TypeProjectionImpl(substitutedType);
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(MapsKt.mapOf(TuplesKt.to(substitution.getTypeVariable().getTypeConstructor(), newTypeProjection)));
        KotlinType kotlinType2 = substitutor2.substitute(bound.getConstrainingType(), Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType type2 = kotlinType2;
        CompoundConstraintPosition position = new CompoundConstraintPosition(bound.getPosition(), substitution.getPosition());
        Function2<KotlinType, TypeBounds.BoundKind, Unit> addNewBound$ = new Function2<KotlinType, TypeBounds.BoundKind, Unit>($receiver, bound, substitution, position){
            final /* synthetic */ ConstraintSystemImpl receiver$0;
            final /* synthetic */ TypeBounds.Bound $bound;
            final /* synthetic */ TypeBounds.Bound $substitution;
            final /* synthetic */ CompoundConstraintPosition $position;

            public final void invoke(@NotNull KotlinType newConstrainingType, @NotNull TypeBounds.BoundKind newBoundKind) {
                Intrinsics.checkParameterIsNotNull(newConstrainingType, "newConstrainingType");
                Intrinsics.checkParameterIsNotNull((Object)((Object)newBoundKind), "newBoundKind");
                List<TypeParameterDescriptor> nestedTypeVariables = this.receiver$0.getNestedTypeVariables(newConstrainingType, false);
                if (nestedTypeVariables.contains(this.$bound.getTypeVariable())) {
                    return;
                }
                HashSet<TypeParameterDescriptor> derivedFrom = new HashSet<TypeParameterDescriptor>((Collection)SetsKt.plus(this.$bound.getDerivedFrom(), (Iterable)this.$substitution.getDerivedFrom()));
                if (derivedFrom.contains(this.$substitution.getTypeVariable())) {
                    return;
                }
                derivedFrom.add(this.$substitution.getTypeVariable());
                this.receiver$0.addBound(this.$bound.getTypeVariable(), newConstrainingType, newBoundKind, new ConstraintContext(this.$position, derivedFrom, false, 4, null));
            }
            {
                this.receiver$0 = constraintSystemImpl;
                this.$bound = bound;
                this.$substitution = bound2;
                this.$position = compoundConstraintPosition;
                super(2);
            }
        };
        if (Intrinsics.areEqual((Object)substitution.getKind(), (Object)TypeBounds.BoundKind.EXACT_BOUND)) {
            KotlinType kotlinType3 = type2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "type");
            addNewBound$.invoke(kotlinType3, bound.getKind());
            return;
        }
        KotlinType kotlinType4 = type2;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "type");
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType4);
        Function1<KotlinType, Boolean> containsConstrainingTypeWithoutProjection$ = new Function1<KotlinType, Boolean>(substitution){
            final /* synthetic */ TypeBounds.Bound $substitution;

            public final boolean invoke(KotlinType $receiver) {
                boolean bl;
                block1: {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    Iterable $receiver2 = TypeUtilsKt.getNestedArguments($receiver);
                    for (T element : $receiver2) {
                        TypeProjection it2 = (TypeProjection)element;
                        if (!(Intrinsics.areEqual(it2.getType().getConstructor(), this.$substitution.getConstrainingType().getConstructor()) && Intrinsics.areEqual((Object)((Object)it2.getProjectionKind()), (Object)((Object)Variance.INVARIANT)))) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$substitution = bound;
                super(1);
            }
        };
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getUpper()) && Intrinsics.areEqual((Object)bound.getKind(), (Object)TypeBounds.BoundKind.LOWER_BOUND) ^ true) {
            addNewBound$.invoke(approximationBounds.getUpper(), TypeBounds.BoundKind.UPPER_BOUND);
        }
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getLower()) && Intrinsics.areEqual((Object)bound.getKind(), (Object)TypeBounds.BoundKind.UPPER_BOUND) ^ true) {
            addNewBound$.invoke(approximationBounds.getLower(), TypeBounds.BoundKind.LOWER_BOUND);
        }
    }
}

