/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.NameCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.PropertyCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.ReferenceNameCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"/\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!AG\f\u0011\u0001iA!\u0003\u0002\n\u0003a\t\u0001\u0014A\r\u0004\u0011\u0007i\u0011\u0001\u0007\u0002U\u0007\u000biy\u0003C\u0002\u000e\t%\u0011\u0011\"\u0001S\u00041\u0003\tB\u0001\u0002\u0001\t\bU\t\u0001DA\r\u0007\u0011\u0011iA!\u0003\u0002\n\u0003\u0011\u001e\u0001\u0014B\r\u0004\u0011\u0007i\u0011\u0001\u0007\u0002U\u0007\u000bii\u0002C\u0003\u000e\u000f%\u0011\u0011\"\u0001\r\u0002\u0013\tI\u0011\u0001\u0007\u0004\u0019\fe\u0019\u00012A\u0007\u00021\t!6QAG\f\u0011\u001biA!\u0003\u0002\n\u0003a\t\u0001\u0014A\r\u0004\u0011\u001di\u0011\u0001g\u0004U\u0007\u000bii\u0002\u0003\u0005\u000e\u000f%\u0011\u0011\"\u0001\r\u0002\u0013\tI\u0011\u0001g\u0004\u0019\fe\u0019\u00012A\u0007\u00021\t!6QAG\f\u0011#iA!\u0003\u0002\n\u0003a\t\u0001\u0014A\r\u0004\u0011\u0007i\u0011\u0001\u0007\u0002U\u0007\u000b\u0001"}, strings={"collectFunctionReferencesInside", "", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "scope", "Lcom/google/dart/compiler/backend/js/ast/JsNode;", "CollectUtilsKt", "collectInstances", "T", "klass", "Ljava/lang/Class;", "collectJsProperties", "Ljava/util/IdentityHashMap;", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "collectLocalNames", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "collectNamedFunctions", "collectReferencesInside"}, moduleName="kotlin-compiler")
public final class CollectUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsName> collectFunctionReferencesInside(@NotNull JsNode scope2) {
        void var3_3;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Iterable $receiver2 = CollectUtilsKt.collectReferencesInside(scope2);
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            JsName it2 = (JsName)element;
            if (!(MetadataProperties.getStaticRef(it2) instanceof JsFunction)) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final List<JsName> collectReferencesInside(@NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        ReferenceNameCollector receiver = new ReferenceNameCollector();
        ReferenceNameCollector $receiver = receiver;
        $receiver.accept(scope2);
        return $receiver.getReferences();
    }

    @NotNull
    public static final List<JsName> collectLocalNames(@NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        JsFunctionScope functionScope = function.getScope();
        JsScope jsScope = functionScope;
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "functionScope");
        NameCollector receiver = new NameCollector(jsScope);
        NameCollector $receiver = receiver;
        $receiver.accept((JsNode)function.getBody());
        return CollectionsKt.toList((Iterable)CollectionsKt.mutableValues($receiver.getNames()));
    }

    @NotNull
    public static final IdentityHashMap<JsName, JsExpression> collectJsProperties(@NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        PropertyCollector collector2 = new PropertyCollector();
        collector2.accept(scope2);
        return collector2.getProperties();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IdentityHashMap<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        IdentityHashMap<JsName, JsFunction> namedFunctions = new IdentityHashMap<JsName, JsFunction>();
        Iterator iterator2 = MapsKt.iterator((Map)CollectUtilsKt.collectJsProperties(scope2));
        while (iterator2.hasNext()) {
            JsFunction function;
            JsFunction jsFunction;
            void $receiver;
            void $receiver2;
            Map.Entry entry;
            Map.Entry value2 = entry = iterator2.next();
            JsName name = (JsName)$receiver2.getKey();
            Map.Entry $i$f$component1 = entry;
            JsExpression jsExpression = (JsExpression)$receiver.getValue();
            JsExpression jsExpression2 = jsExpression;
            if (jsExpression2 instanceof JsFunction) {
                jsFunction = (JsFunction)jsExpression;
            } else {
                InlineMetadata inlineMetadata = InlineMetadata.Companion.INSTANCE.decompose(jsExpression);
                jsFunction = inlineMetadata != null ? inlineMetadata.getFunction() : null;
            }
            if ((function = jsFunction) == null) continue;
            MapsKt.set(namedFunctions, name, function);
        }
        return namedFunctions;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass, @NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        InstanceCollector<JsNode> receiver = new InstanceCollector<JsNode>(klass, false);
        InstanceCollector<JsNode> $receiver = receiver;
        $receiver.accept(scope2);
        return $receiver.getCollected();
    }
}

