/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentRegistry;
import org.jetbrains.kotlin.container.ComponentResolveContext;
import org.jetbrains.kotlin.container.ComponentStorageState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.DataStructuresKt;
import org.jetbrains.kotlin.container.ImplicitSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.InvalidCardinalityException;
import org.jetbrains.kotlin.container.MethodBinding;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;
import org.jetbrains.kotlin.container.ValueResolver;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0003\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u001f\u0015\tAAA\u0003\u0002\u0019\u0005)\u0001!B\u0001\t!\u0015\tA!A\u0003\u0002\u0011\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u001dQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\b\r\u0001e\t\u0001\u0014AQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&5\u0011\t\u0001RD\u0007\u00021=I2\u0001c\b\u000e\u0003a\u0001\u0012d\u0001E\u0011\u001b\u0005A:!\u0007\u0004\t#5!\u0011BA\u0005\u00021\u0013A\u001a#\u0007\u0004\t%5!\u0011BA\u0005\u00021\u000fAr!J\u0004\t&5\t\u0001dD\r\u0004\u0011?i\u0011\u0001\u0007\t&\u001f\u0011\t\u0001bE\u0007\u00021=I2\u0001c\b\u000e\u0003a\u0001\u0012D\u0002E\u0007\u001b\u0011I!!C\u0001\u0019\ba\u001dRe\u0001\u0005\u0015\u001b\u0005Ar\"J\u0004\t*5\t\u0001dD\r\u0004\u0011Ci\u0011\u0001g\u0002&\u000f!)R\"\u0001\r\u00103\rAY#D\u0001\u0019-\u00152\u0001RF\u0007\u0005\u0013\tI\u0011\u0001g\u0002\u0019/\u0015bA!\u0001E\u0018\u001b\u0005Ar\"G\u0002\t15\t\u0001\u0014G\r\u0004\u0011?i\u0011\u0001G\r&\u001f\u0011\t\u0001rF\u0007\u00021=I2\u0001c\b\u000e\u0003a\u0001\u0012D\u0002E\u001a\u001b\u0011I!!C\u0001\u0019\ba\u001dRE\u0005\u0003\u0002\u0011iiA!\u0003\u0002\n\u0003a\u001d\u0001dB\r\u0004\u0011?i\u0011\u0001\u0007\t\u001a\r!5Q\u0002B\u0005\u0003\u0013\u0005A:\u0001g\n&\u0019\u0011\t\u0001RG\u0007\u00021=I2\u0001C\u000e\u000e\u0003a%\u0011d\u0001E\u0010\u001b\u0005A\u0012$\n\b\t85\t\u0001dD\r\u0004\u0011?i\u0011\u0001\u0007\t\u001a\r!aR\u0002B\u0005\u0003\u0013\u0005A:\u0001G\f&\u001b\u0011Y\u0001\u0012H\u0007\u0003\u0019\u0003AR$G\u0002\t75\t\u0001\u0014B\r\u0004\u0011?i\u0011\u0001G\r&\u001d!mR\u0002B\u0005\u0003\u0013\u0005AR\u0004\u0007\u0010\u001a\u0007!YR\"\u0001M\u00053\rAy\"D\u0001\u00193%VBa\u0011\u0005\t\u00065\r\u0012BB\u0005\u0006!\u0011)\"\u0001$\u0001\u0019\ba\u001d\u0011BB\u0005\u0006!\u0011)\"\u0001$\u0001\u0019\na%\u0001dA)\u0004\u0003\u0011)\u0011k\u0001\u0003\u0006\u00015\u0011A1\u0002\u0005\u0007S5!1\t\u0003E\u0007\u001b\u0011I!!C\u0001\u0019\ba9\u0011k\u0001\u0003\u0006\u00015\u0011Aq\u0002\u0005\tS)!1\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001\"\u0005\t\u0013%RAa\u0011\u0005\t\u00145\t\u0001DC)\u0004\t\u0015\u0001QB\u0001C\u000b\u0011-IS\u0002B\"\u001d\u0011/i\u0011\u0001\u0007\u0007R\u0007\u001d)\u0001!\u0004\u0002\u0005\u001a!i\u0011C\u0001C\u000e\u00119\u0001"}, strings={"Lorg/jetbrains/kotlin/container/ComponentStorage;", "Lorg/jetbrains/kotlin/container/ValueResolver;", "myId", "", "(Ljava/lang/String;)V", "dependencies", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "kotlin.jvm.PlatformType", "Ljava/lang/reflect/Type;", "Lorg/jetbrains/annotations/NotNull;", "getDependencies", "()Lcom/intellij/util/containers/MultiMap;", "descriptors", "Ljava/util/LinkedHashSet;", "getDescriptors", "()Ljava/util/LinkedHashSet;", "getMyId", "()Ljava/lang/String;", "registry", "Lorg/jetbrains/kotlin/container/ComponentRegistry;", "getRegistry", "()Lorg/jetbrains/kotlin/container/ComponentRegistry;", "state", "Lorg/jetbrains/kotlin/container/ComponentStorageState;", "getState", "()Lorg/jetbrains/kotlin/container/ComponentStorageState;", "setState", "(Lorg/jetbrains/kotlin/container/ComponentStorageState;)V", "collectAdhocComponents", "", "context", "Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "descriptor", "visitedTypes", "Ljava/util/HashSet;", "adhocDescriptors", "compose", "composeDescriptors", "", "dispose", "disposeDescriptor", "dump", "printer", "Ljava/io/PrintStream;", "getDescriptorsInDisposeOrder", "", "injectProperties", "instance", "", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "components", "inspectDependenciesAndRegisterAdhoc", "registerDependency", "request", "registerDescriptors", "items", "resolve", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "resolveMultiple", ""}, moduleName="kotlin-compiler")
public final class ComponentStorage
implements ValueResolver {
    @NotNull
    private ComponentStorageState state;
    @NotNull
    private final ComponentRegistry registry;
    @NotNull
    private final LinkedHashSet<ComponentDescriptor> descriptors;
    @NotNull
    private final MultiMap<ComponentDescriptor, Type> dependencies;
    @NotNull
    private final String myId;

    @NotNull
    public final ComponentStorageState getState() {
        return this.state;
    }

    public final void setState(@NotNull ComponentStorageState componentStorageState) {
        Intrinsics.checkParameterIsNotNull((Object)componentStorageState, "<set-?>");
        this.state = componentStorageState;
    }

    @NotNull
    public final ComponentRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final LinkedHashSet<ComponentDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @NotNull
    public final MultiMap<ComponentDescriptor, Type> getDependencies() {
        return this.dependencies;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentStorageState.Initial)) {
            throw (Throwable)new ContainerConsistencyException("Container was not composed before resolving");
        }
        Collection<ComponentDescriptor> entry = this.registry.tryGetEntry(request);
        if (CollectionsKt.isNotEmpty(entry)) {
            void $receiver;
            this.registerDependency(request, context);
            Collection<ComponentDescriptor> collection = entry;
            if ($receiver.size() > 1) {
                throw (Throwable)new InvalidCardinalityException("Request " + request + " cannot be satisfied because there is more than one type registered", entry);
            }
            return (ValueDescriptor)CollectionsKt.singleOrNull((Iterable)entry);
        }
        return null;
    }

    private final void registerDependency(Type request, ValueResolveContext context) {
        ValueDescriptor descriptor2;
        if (context instanceof ComponentResolveContext && (descriptor2 = ((ComponentResolveContext)context).getRequestingDescriptor()) instanceof ComponentDescriptor) {
            this.dependencies.putValue((ComponentDescriptor)descriptor2, request);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dump(@NotNull PrintStream printer) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(printer, "printer");
        PrintStream $receiver2 = printer;
        String heading = "Container: " + this.getMyId();
        $receiver2.println(heading);
        $receiver2.println(StringsKt.repeat("=", CollectionsKt.length(heading)));
        $receiver2.println();
        Iterable iterable = this.getDescriptorsInDisposeOrder();
        for (Object element : $receiver) {
            void $receiver3;
            ComponentDescriptor descriptor2 = (ComponentDescriptor)element;
            $receiver2.println(descriptor2);
            Iterable iterable2 = this.getDependencies().get(descriptor2);
            for (Object element2 : $receiver3) {
                Type it2 = (Type)element2;
                $receiver2.print("   -> ");
                String typeName = it2.toString();
                $receiver2.print(StringsKt.substringBefore$default(typeName, " ", null, 2));
                $receiver2.print(" ");
                $receiver2.print(StringsKt.substringAfterLast$default(typeName, ".", null, 2));
                ComponentRegistry componentRegistry = this.getRegistry();
                Type type2 = it2;
                Intrinsics.checkExpressionValueIsNotNull(type2, "it");
                Collection<ComponentDescriptor> resolve2 = componentRegistry.tryGetEntry(type2);
                $receiver2.print(" as ");
                $receiver2.print(resolve2);
                $receiver2.println();
            }
            $receiver2.println();
        }
    }

    @NotNull
    public final Iterable<ValueDescriptor> resolveMultiple(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.registerDependency(request, context);
        return this.registry.tryGetEntry(request);
    }

    public final void registerDescriptors(@NotNull ComponentResolveContext context, @NotNull List<? extends ComponentDescriptor> items) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(items, "items");
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentStorageState.Disposed)) {
            throw (Throwable)new ContainerConsistencyException("Cannot register descriptors in " + (Object)((Object)this.state) + " state");
        }
        for (ComponentDescriptor componentDescriptor : items) {
            this.descriptors.add(componentDescriptor);
        }
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentStorageState.Initialized)) {
            this.composeDescriptors(context, (Collection<? extends ComponentDescriptor>)items);
        }
    }

    public final void compose(@NotNull ComponentResolveContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentStorageState.Initial) ^ true) {
            throw (Throwable)new ContainerConsistencyException("Container " + this.myId + " was already composed.");
        }
        this.state = ComponentStorageState.Initialized;
        this.composeDescriptors(context, (Collection<? extends ComponentDescriptor>)this.descriptors);
    }

    private final void composeDescriptors(ComponentResolveContext context, Collection<? extends ComponentDescriptor> descriptors) {
        if (descriptors.isEmpty()) {
            return;
        }
        this.registry.addAll(descriptors);
        LinkedHashSet<ComponentDescriptor> implicits = this.inspectDependenciesAndRegisterAdhoc(context, descriptors);
        this.injectProperties(context, (Collection<? extends ComponentDescriptor>)CollectionsKt.plus(descriptors, (Iterable)implicits));
    }

    private final void injectProperties(ComponentResolveContext context, Collection<? extends ComponentDescriptor> components2) {
        for (ComponentDescriptor componentDescriptor : components2) {
            if (!componentDescriptor.getShouldInjectProperties()) continue;
            this.injectProperties(componentDescriptor.getValue(), context.getContainer().createResolveContext(componentDescriptor));
        }
    }

    private final LinkedHashSet<ComponentDescriptor> inspectDependenciesAndRegisterAdhoc(ComponentResolveContext context, Collection<? extends ComponentDescriptor> descriptors) {
        LinkedHashSet<ComponentDescriptor> adhoc = new LinkedHashSet<ComponentDescriptor>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            this.collectAdhocComponents(context, componentDescriptor, visitedTypes, adhoc);
        }
        this.registry.addAll((Collection<? extends ComponentDescriptor>)adhoc);
        return adhoc;
    }

    private final void collectAdhocComponents(ComponentResolveContext context, ComponentDescriptor descriptor2, HashSet<Type> visitedTypes, LinkedHashSet<ComponentDescriptor> adhocDescriptors) {
        Collection<Type> dependencies = descriptor2.getDependencies(context);
        for (Type type2 : dependencies) {
            Class rawType;
            Class clazz;
            Collection<ComponentDescriptor> entry;
            if (!visitedTypes.add(type2) || !(entry = this.registry.tryGetEntry(type2)).isEmpty()) continue;
            Type type3 = type2;
            if (type3 instanceof Class) {
                clazz = (Class)type2;
            } else if (type3 instanceof ParameterizedType) {
                Type type4 = ((ParameterizedType)type2).getRawType();
                if (!(type4 instanceof Class)) {
                    type4 = null;
                }
                clazz = (Class)type4;
            } else {
                clazz = null;
            }
            if ((rawType = clazz) == null || Modifier.isAbstract(rawType.getModifiers()) || rawType.isPrimitive()) continue;
            ImplicitSingletonTypeComponentDescriptor implicitDescriptor = new ImplicitSingletonTypeComponentDescriptor(context.getContainer(), rawType);
            adhocDescriptors.add(implicitDescriptor);
            this.collectAdhocComponents(context, implicitDescriptor, visitedTypes, adhocDescriptors);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void injectProperties(Object instance, ValueResolveContext context) {
        void $receiver;
        ClassInfo classInfo = CacheKt.getInfo(instance.getClass());
        Iterable iterable = classInfo.getSetterInfos();
        for (Object element : $receiver) {
            SetterInfo setterInfo = (SetterInfo)element;
            MethodBinding methodBinding = ResolveKt.bindToMethod(setterInfo.getMethod(), context);
            methodBinding.invoke(instance);
        }
    }

    public final void dispose() {
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentStorageState.Initialized) ^ true) {
            if (Intrinsics.areEqual((Object)this.state, (Object)ComponentStorageState.Initial)) {
                return;
            }
            throw (Throwable)new ContainerConsistencyException("Component container cannot be disposed in the " + (Object)((Object)this.state) + " state.");
        }
        this.state = ComponentStorageState.Disposing;
        List<ComponentDescriptor> disposeList = this.getDescriptorsInDisposeOrder();
        for (ComponentDescriptor descriptor2 : disposeList) {
            this.disposeDescriptor(descriptor2);
        }
        this.state = ComponentStorageState.Disposed;
    }

    @NotNull
    public final List<ComponentDescriptor> getDescriptorsInDisposeOrder() {
        return DataStructuresKt.topologicalSort((Iterable)this.descriptors, (Function1)new Function1<ComponentDescriptor, ArrayList<ComponentDescriptor>>(this){
            final /* synthetic */ ComponentStorage this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ArrayList<ComponentDescriptor> invoke(@NotNull ComponentDescriptor it2) {
                void var2_2;
                Intrinsics.checkParameterIsNotNull(it2, "it");
                ArrayList<ComponentDescriptor> dependent = new ArrayList<ComponentDescriptor>();
                for (Type interfaceType : this.this$0.getDependencies().get(it2)) {
                    ComponentRegistry componentRegistry = this.this$0.getRegistry();
                    Type type2 = interfaceType;
                    Intrinsics.checkExpressionValueIsNotNull(type2, "interfaceType");
                    for (ComponentDescriptor dependency : componentRegistry.tryGetEntry(type2)) {
                        dependent.add(dependency);
                    }
                }
                return var2_2;
            }
            {
                this.this$0 = componentStorage;
                super(1);
            }
        });
    }

    public final void disposeDescriptor(@NotNull ComponentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2 instanceof Closeable) {
            ((Closeable)((Object)descriptor2)).close();
        }
    }

    @NotNull
    public final String getMyId() {
        return this.myId;
    }

    public ComponentStorage(@NotNull String myId) {
        Intrinsics.checkParameterIsNotNull(myId, "myId");
        this.myId = myId;
        this.state = ComponentStorageState.Initial;
        this.registry = new ComponentRegistry();
        this.descriptors = new LinkedHashSet();
        this.dependencies = MultiMap.createLinkedSet();
    }
}

