/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.Iterator;
import kotlin.CollectionsKt;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"a\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\t\u0001\u0002B\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\b\u0015\t\u00012B\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0005\b\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u000e\"!\u0001Q\"\u0001M\u00013\rA\u0011!D\u0001\u0019\u0004e\u0019\u0001BA\u0007\u00021\u000bI2\u0001C\u0002\u000e\u0003a\u001dAk\u0001\u0003\u000e\"!%Q\"\u0001M\u00013\rA\u0011!D\u0001\u0019\u0004e\u0019\u0001BA\u0007\u00021\u000bI2\u0001C\u0002\u000e\u0003a\u001dAk\u0001\u0003\u000e\u0012!)Q\"\u0001M\u00063\rAa!D\u0001\u0019\u000eQ\u001bA!$\u0007\t\u000f5\t\u0001\u0014A\r\u0004\u0011\u0005i\u0011\u0001g\u0001\u001a\u0007!=Q\"\u0001M\u0003)\u000e!Q\u0012\u0004\u0005\t\u001b\u0005A\n!G\u0002\t\u00035\t\u00014A\r\u0004\u0011\u001fi\u0011\u0001'\u0002U\u0007\u0011iy\u0003#\u0005\u000e\u0003a\u0005\u0011d\u0001\u0005\u0002\u001b\u0005A\u001a!G\u0002\t\u00105\t\u0001TA\r\u0004\u0011%i\u0011\u0001g\u0005\u001a\r!QQ\u0002B\u0005\u0003\u0013\u0005Aj\u0001'\u0006U\u0007\u0011i\t\u0003C\u0006\u000e\u0003a\u0005\u0011d\u0001\u0005\u0002\u001b\u0005A\u001a!G\u0002\t\u00055\t\u0001TA\r\u0004\u0011\ri\u0011\u0001g\u0002U\u0007\u0011i\t\u0004c\u0006\u000e\u0003a\u0005\u0011d\u0001\u0005\u0002\u001b\u0005A\u001a!G\u0002\t\u00195\t\u0001TA\r\u0004\u0011\ri\u0011\u0001g\u0002\u001a\u0007!eQ\"\u0001M\u00073\rAQ\"D\u0001\u0019\u0014Q\u001bA!$\u000b\t\u001c5\t\u0001\u0014A\r\u0004\u0011\u0005i\u0011\u0001g\u0001\u001a\u0007!aQ\"\u0001M\u00033\rA1!D\u0001\u0019\be\u0019\u0001BD\u0007\u00021;!6\u0001BG\u0017\t\r\u0003\u0002bD\u0007\u00021\u0003)\u0012\u0001g\b\u001a\u001c!\u0001RBC\u0005\u0003\u0013\u0005A\u0012#\u0003\u0002\n\u0003a\r\u0012BA\u0005\u00021\u0003A\n\u0003UB\u0001)\u000e!QR\u0006\u0003D!!\u0011R\"\u0001M\u0001+\u0005Az\"g\u0007\t!5Q\u0011BA\u0005\u00021KI!!C\u0001\u0019\u0006%\u0011\u0011\"\u0001M\u00011C\u00016\u0011\u0001+\u0004\t5\u0011\u0002BB\u0007\u0003\u0019\u0003!3#\u0005\u0003\u0005\u0001!\u0019R#\u0001M\u0014+\u0011I!!C\u0001%'aU\u0011kA\u0001\t)Q\u001bA!\u0004\u0007\t*5\t\u0001\u0014A\u000b\u00021\u0007IJ\u0001C\u000b\u000e\u0003aM\u0001k!\u0001U\u0007\u0011\u0001"}, strings={"generateLoadInstructions", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "location", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "savedStackDescriptor", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "StackTransformationUtilsKt", "generateStoreInstructions", "getPopInstruction", "Lorg/jetbrains/org/objectweb/asm/tree/InsnNode;", "top", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "removeAlwaysFalseIfeq", "node", "replaceAlwaysTrueIfeqWithGoto", "replaceMarkerWithPops", "expectedStackSize", "", "frame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "restoreStack", "restoreStackWithReturnValue", "nodeToReplace", "returnValue", "returnValueLocalVarIndex", "saveStack", "restoreImmediately", "", "forEachInlineMarker", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "block", "Lkotlin/Function2;", "", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "forEachPseudoInsn", "Lorg/jetbrains/kotlin/codegen/pseudoInsns/PseudoInsn;", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "updateMaxLocals", "newMaxLocals"}, moduleName="kotlin-compiler")
public final class StackTransformationUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final void forEachPseudoInsn(InsnList $receiver, @NotNull Function2<? super PseudoInsn, ? super AbstractInsnNode, ? extends Unit> block) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(block, "block");
        Sequence $receiver2 = new InsnSequence($receiver);
        Iterator iterator2 = $receiver2.iterator();
        while (iterator2.hasNext()) {
            Unit unit;
            Object element = iterator2.next();
            AbstractInsnNode insn = (AbstractInsnNode)element;
            if (PseudoInsnsKt.parsePseudoInsnOrNull(insn) != null) {
                void $receiver3;
                PseudoInsn it2 = (PseudoInsn)$receiver3;
                block.invoke(it2, insn);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
    }

    public static final void forEachInlineMarker(InsnList $receiver, @NotNull Function2<? super String, ? super MethodInsnNode, ? extends Unit> block) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(block, "block");
        Sequence $receiver2 = new InsnSequence($receiver);
        Iterator iterator2 = $receiver2.iterator();
        while (iterator2.hasNext()) {
            Object element = iterator2.next();
            AbstractInsnNode insn = (AbstractInsnNode)element;
            if (!InlineCodegenUtil.isInlineMarker(insn)) continue;
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MethodInsnNode");
            }
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            String string = methodInsnNode.name;
            Intrinsics.checkExpressionValueIsNotNull(string, "methodInsnNode.name");
            block.invoke(string, methodInsnNode);
        }
    }

    @Nullable
    public static final <V extends Value> V top(Frame<V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        int stackSize = $receiver.getStackSize();
        if (stackSize == 0) {
            return (V)((Value)null);
        }
        return $receiver.getStack(stackSize - 1);
    }

    public static final void updateMaxLocals(MethodNode $receiver, int newMaxLocals) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        $receiver.maxLocals = Math.max($receiver.maxLocals, newMaxLocals);
    }

    /*
     * WARNING - void declaration
     */
    public static final void saveStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor, boolean restoreImmediately) {
        void receiver;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(nodeToReplace, "nodeToReplace");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = (InsnList)receiver;
        StackTransformationUtilsKt.generateStoreInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        if (restoreImmediately) {
            StackTransformationUtilsKt.generateLoadInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        }
        $receiver.remove(nodeToReplace);
    }

    public static final void restoreStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        InsnList receiver = methodNode.instructions;
        InsnList $receiver = receiver;
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, location, savedStackDescriptor);
        $receiver.remove(location);
    }

    /*
     * WARNING - void declaration
     */
    public static final void restoreStackWithReturnValue(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor, @NotNull BasicValue returnValue, int returnValueLocalVarIndex) {
        void receiver;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(nodeToReplace, "nodeToReplace");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        Intrinsics.checkParameterIsNotNull(returnValue, "returnValue");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = (InsnList)receiver;
        $receiver.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getType().getOpcode(54), returnValueLocalVarIndex));
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        $receiver.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getType().getOpcode(21), returnValueLocalVarIndex));
        $receiver.remove(nodeToReplace);
    }

    public static final void generateLoadInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstLocalVarIndex();
        for (BasicValue value2 : savedStackDescriptor.getSavedValues()) {
            methodNode.instructions.insertBefore(location, new VarInsnNode(value2.getType().getOpcode(21), localVarIndex));
            localVarIndex += value2.getSize();
        }
    }

    public static final void generateStoreInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstUnusedLocalVarIndex();
        for (BasicValue value2 : CollectionsKt.asReversed(savedStackDescriptor.getSavedValues())) {
            methodNode.instructions.insertBefore(location, new VarInsnNode(value2.getType().getOpcode(54), localVarIndex -= value2.getSize()));
        }
    }

    @NotNull
    public static final InsnNode getPopInstruction(@NotNull BasicValue top) {
        int n;
        Intrinsics.checkParameterIsNotNull(top, "top");
        switch (top.getSize()) {
            case 1: {
                n = 87;
                break;
            }
            case 2: {
                n = 88;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)"Unexpected value type size"));
            }
        }
        return new InsnNode(n);
    }

    public static final void removeAlwaysFalseIfeq(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        InsnList receiver = methodNode.instructions;
        InsnList $receiver = receiver;
        $receiver.remove(node.getNext());
        $receiver.remove(node);
    }

    public static final void replaceAlwaysTrueIfeqWithGoto(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        InsnList receiver = methodNode.instructions;
        InsnList $receiver = receiver;
        AbstractInsnNode abstractInsnNode = node.getNext();
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        JumpInsnNode next = (JumpInsnNode)abstractInsnNode;
        $receiver.insertBefore(node, new JumpInsnNode(167, next.label));
        $receiver.remove(node);
        $receiver.remove(next);
    }

    /*
     * WARNING - void declaration
     */
    public static final void replaceMarkerWithPops(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node, int expectedStackSize, @NotNull Frame<BasicValue> frame) {
        void receiver;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(frame, "frame");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = (InsnList)receiver;
        while (frame.getStackSize() > expectedStackSize) {
            BasicValue top;
            BasicValue basicValue = top = frame.pop();
            Intrinsics.checkExpressionValueIsNotNull(basicValue, "top");
            $receiver.insertBefore(node, StackTransformationUtilsKt.getPopInstruction(basicValue));
        }
        $receiver.remove(node);
    }
}

