/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.KtScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.ApproximationBounds;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypeArgument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CapturedTypeApproximationKt {
    private static final TypeProjection toTypeProjection(TypeArgument $receiver) {
        boolean value2 = $receiver.isConsistent();
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Only consistent enhanced type propection can be converted to type projection";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Function1<Variance, Variance> removeProjectionIfRedundant$ = new Function1<Variance, Variance>($receiver){
            final /* synthetic */ TypeArgument receiver$0;

            @NotNull
            public final Variance invoke(@NotNull Variance variance) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)variance), "variance");
                return Intrinsics.areEqual((Object)((Object)variance), (Object)((Object)this.receiver$0.getTypeParameter().getVariance())) ? Variance.INVARIANT : variance;
            }
            {
                this.receiver$0 = typeArgument;
                super(1);
            }
        };
        return Intrinsics.areEqual($receiver.getInProjection(), $receiver.getOutProjection()) ? new TypeProjectionImpl($receiver.getInProjection()) : (KotlinBuiltIns.isNothing($receiver.getInProjection()) && Intrinsics.areEqual((Object)$receiver.getTypeParameter().getVariance(), (Object)Variance.IN_VARIANCE) ^ true ? new TypeProjectionImpl(removeProjectionIfRedundant$.invoke(Variance.OUT_VARIANCE), $receiver.getOutProjection()) : (KotlinBuiltIns.isNullableAny($receiver.getOutProjection()) ? new TypeProjectionImpl(removeProjectionIfRedundant$.invoke(Variance.IN_VARIANCE), $receiver.getInProjection()) : new TypeProjectionImpl(removeProjectionIfRedundant$.invoke(Variance.OUT_VARIANCE), $receiver.getOutProjection())));
    }

    private static final TypeArgument toTypeArgument(TypeProjection $receiver, TypeParameterDescriptor typeParameter) {
        TypeArgument typeArgument;
        switch (CapturedTypeApproximationKt$WhenMappings.$EnumSwitchMapping$0[TypeSubstitutor.combine(typeParameter.getVariance(), $receiver.getProjectionKind()).ordinal()]) {
            case 1: {
                KotlinType kotlinType = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getType()");
                KotlinType kotlinType2 = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "getType()");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType2);
                break;
            }
            case 2: {
                KotlinType kotlinType = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getType()");
                KotlinType kotlinType3 = DescriptorUtilsKt.getBuiltIns(typeParameter).getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "typeParameter.builtIns.nullableAnyType");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType3);
                break;
            }
            case 3: {
                KotlinType kotlinType = DescriptorUtilsKt.getBuiltIns(typeParameter).getNothingType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "typeParameter.builtIns.nothingType");
                KotlinType kotlinType4 = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "type");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeArgument;
    }

    @Nullable
    public static final TypeProjection approximateCapturedTypesIfNecessary(@Nullable TypeProjection typeProjection) {
        if (typeProjection == null) {
            return null;
        }
        if (typeProjection.isStarProjection()) {
            return typeProjection;
        }
        KotlinType type2 = typeProjection.getType();
        if (!TypeUtils.containsSpecialType(type2, approximateCapturedTypesIfNecessary.1.INSTANCE)) {
            return typeProjection;
        }
        Variance howThisTypeIsUsed = typeProjection.getProjectionKind();
        if (Intrinsics.areEqual((Object)howThisTypeIsUsed, (Object)Variance.OUT_VARIANCE)) {
            KotlinType kotlinType = type2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
            ApproximationBounds<KotlinType> approximation = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType);
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation.getUpper());
        }
        return CapturedTypeApproximationKt.substituteCapturedTypes(typeProjection);
    }

    private static final TypeProjection substituteCapturedTypes(TypeProjection typeProjection) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(){

            @Nullable
            public TypeProjection get(@NotNull TypeConstructor key) {
                Intrinsics.checkParameterIsNotNull(key, "key");
                TypeConstructor typeConstructor2 = key;
                if (!(typeConstructor2 instanceof CapturedTypeConstructor)) {
                    typeConstructor2 = null;
                }
                CapturedTypeConstructor capturedTypeConstructor = (CapturedTypeConstructor)typeConstructor2;
                return capturedTypeConstructor != null ? capturedTypeConstructor.getTypeProjection() : null;
            }
        });
        return typeSubstitutor2.substituteWithoutApproximation(typeProjection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApproximationBounds<KotlinType> approximateCapturedTypes(@NotNull KotlinType type2) {
        boolean bl;
        ArrayList<void> upperBoundArguments;
        ArrayList<void> lowerBoundArguments;
        block9: {
            void $receiver;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            TypeConstructor typeConstructor2 = type2.getConstructor();
            if (CapturedTypeConstructorKt.isCaptured(type2)) {
                ApproximationBounds<KotlinType> approximationBounds;
                TypeConstructor typeConstructor3 = typeConstructor2;
                if (typeConstructor3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor");
                }
                TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor3).getTypeProjection();
                Function1<KotlinType, KotlinType> makeNullableIfNeeded$ = new Function1<KotlinType, KotlinType>(type2){
                    final /* synthetic */ KotlinType $type;

                    @NotNull
                    public final KotlinType invoke(KotlinType $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        return TypeUtils.makeNullableIfNeeded($receiver, this.$type.isMarkedNullable());
                    }
                    {
                        this.$type = kotlinType;
                        super(1);
                    }
                };
                KotlinType bound = makeNullableIfNeeded$.invoke(typeProjection.getType());
                switch (CapturedTypeApproximationKt$WhenMappings.$EnumSwitchMapping$1[typeProjection.getProjectionKind().ordinal()]) {
                    case 1: {
                        KotlinType kotlinType = bound;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "bound");
                        KotlinType kotlinType2 = TypeUtilsKt.getBuiltIns(type2).getNullableAnyType();
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "type.builtIns.nullableAnyType");
                        approximationBounds = new ApproximationBounds<KotlinType>(kotlinType, kotlinType2);
                        break;
                    }
                    case 2: {
                        KotlinType kotlinType = makeNullableIfNeeded$.invoke(TypeUtilsKt.getBuiltIns(type2).getNothingType());
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type.builtIns.nothingType.makeNullableIfNeeded()");
                        KotlinType kotlinType3 = bound;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "bound");
                        approximationBounds = new ApproximationBounds<KotlinType>(kotlinType, kotlinType3);
                        break;
                    }
                    default: {
                        throw (Throwable)((Object)new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection)));
                    }
                }
                return approximationBounds;
            }
            if (type2.getArguments().isEmpty()) {
                return new ApproximationBounds<KotlinType>(type2, type2);
            }
            lowerBoundArguments = new ArrayList<void>();
            upperBoundArguments = new ArrayList<void>();
            Iterable iterable = type2.getArguments();
            Iterable iterable2 = typeConstructor2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(iterable2, "typeConstructor.getParameters()");
            for (Pair bound : CollectionsKt.zip(iterable, iterable2)) {
                void upper;
                void lower;
                TypeParameterDescriptor typeParameter;
                TypeProjection typeProjection = (TypeProjection)bound.component1();
                TypeParameterDescriptor typeParameterDescriptor = typeParameter = (TypeParameterDescriptor)bound.component2();
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                ApproximationBounds<TypeArgument> approximationBounds = CapturedTypeApproximationKt.approximateProjection(CapturedTypeApproximationKt.toTypeArgument(typeProjection, typeParameterDescriptor));
                TypeArgument typeArgument = approximationBounds.component1();
                TypeArgument typeArgument2 = approximationBounds.component2();
                approximationBounds = null;
                lowerBoundArguments.add(lower);
                upperBoundArguments.add(upper);
            }
            Iterable iterable3 = lowerBoundArguments;
            for (Object element : $receiver) {
                TypeArgument it2 = (TypeArgument)element;
                if (!(!it2.isConsistent())) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        boolean lowerBoundIsTrivial = bl;
        KotlinType kotlinType = lowerBoundIsTrivial ? TypeUtilsKt.getBuiltIns(type2).getNothingType() : CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<? extends TypeArgument>)lowerBoundArguments);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "if (lowerBoundIsTrivial)\u2026ents(lowerBoundArguments)");
        return new ApproximationBounds<KotlinType>(kotlinType, CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<? extends TypeArgument>)upperBoundArguments));
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinType replaceTypeArguments(KotlinType $receiver, List<? extends TypeArgument> newTypeArguments) {
        List list;
        void destination;
        void $receiver2;
        Collection $receiver3 = $receiver.getArguments();
        int n = $receiver3.size();
        $receiver3 = newTypeArguments;
        int n2 = n;
        int n3 = $receiver3.size();
        boolean value22 = n2 == n3;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value22) {
            String message = "Incorrect type arguments " + newTypeArguments;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Annotations annotations2 = $receiver.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "getAnnotations()");
        TypeConstructor typeConstructor2 = $receiver.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "getConstructor()");
        Iterable value22 = newTypeArguments;
        boolean bl = $receiver.isMarkedNullable();
        TypeConstructor typeConstructor3 = typeConstructor2;
        Annotations annotations3 = annotations2;
        KotlinTypeImpl.Companion companion = KotlinTypeImpl.Companion.INSTANCE;
        void $i$a$1 = $receiver;
        Collection message = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver, 10));
        for (Object item : $receiver2) {
            void it2;
            TypeArgument typeArgument = (TypeArgument)item;
            list = destination;
            TypeProjection typeProjection = CapturedTypeApproximationKt.toTypeProjection((TypeArgument)it2);
            list.add(typeProjection);
        }
        list = (List)destination;
        KtScope ktScope = $receiver.getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(ktScope, "getMemberScope()");
        return companion.create(annotations3, typeConstructor3, bl, list, ktScope);
    }

    /*
     * WARNING - void declaration
     */
    private static final ApproximationBounds<TypeArgument> approximateProjection(TypeArgument typeArgument) {
        void outUpper;
        void inLower;
        void outLower;
        void inUpper;
        Object object = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getInProjection());
        KotlinType kotlinType = ((ApproximationBounds)object).component1();
        KotlinType kotlinType2 = ((ApproximationBounds)object).component2();
        object = null;
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getOutProjection());
        object = approximationBounds.component1();
        KotlinType kotlinType3 = approximationBounds.component2();
        approximationBounds = null;
        return new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), (KotlinType)inUpper, (KotlinType)outLower), new TypeArgument(typeArgument.getTypeParameter(), (KotlinType)inLower, (KotlinType)outUpper));
    }
}

