/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.KtScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.KtScopeImpl;
import kotlin.reflect.jvm.internal.impl.utils.Printer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InnerClassesScopeWrapper
extends KtScopeImpl {
    @NotNull
    private final KtScope workerScope;

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.workerScope.getContainingDeclaration();
    }

    @Override
    @Nullable
    public ClassDescriptor getClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(location, "location");
        ClassifierDescriptor classifierDescriptor = this.workerScope.getClassifier(name, location);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ClassDescriptor> getDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(kindFilter, "kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, "nameFilter");
        DescriptorKindFilter descriptorKindFilter = kindFilter.restrictedToKindsOrNull(DescriptorKindFilter.Companion.INSTANCE.getCLASSIFIERS_MASK());
        if (descriptorKindFilter == null) {
            return CollectionsKt.listOf();
        }
        DescriptorKindFilter restrictedFilter = descriptorKindFilter;
        Iterable iterable = this.workerScope.getDescriptors(restrictedFilter, nameFilter);
        void var5_5 = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            if (!(element instanceof ClassDescriptor)) continue;
            destination.add(element);
        }
        return (List)destination;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        p.println("InnerClassesScopeWrapper for scope:");
        this.workerScope.printScopeStructure(p);
    }

    @NotNull
    public String toString() {
        return "Classes from " + this.workerScope;
    }

    @NotNull
    public final KtScope getWorkerScope() {
        return this.workerScope;
    }

    public InnerClassesScopeWrapper(@NotNull KtScope workerScope) {
        Intrinsics.checkParameterIsNotNull(workerScope, "workerScope");
        this.workerScope = workerScope;
    }
}

