/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.IndexedValue;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ScriptDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameBase;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.renderer.CustomFlexibleRendering;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$WhenMappings;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.NameShortness;
import kotlin.reflect.jvm.internal.impl.renderer.OverrideRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ParameterNameRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingFormat;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.LazyType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.MissingDependencyErrorClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    @NotNull
    private final DescriptorRendererOptionsImpl options;

    private final String renderKeyword(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<b>" + keyword + "</b>";
            }
        }
        return null;
    }

    private final String renderError(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$1[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<font color=red><b>" + keyword + "</b></font>";
            }
        }
        return null;
    }

    private final String escape(String string) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$2[this.getTextFormat().ordinal()]) {
            case 1: {
                return string;
            }
            case 2: {
                return StringsKt.replace$default(StringsKt.replace$default(string, "<", "&lt;", false, 4), ">", "&gt;", false, 4);
            }
        }
        return null;
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        String string;
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$3[this.getTextFormat().ordinal()]) {
            case 1: {
                string = this.escape("->");
                break;
            }
            case 2: {
                string = "&rarr;";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String renderMessage(String message) {
        String string;
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$4[this.getTextFormat().ordinal()]) {
            case 1: {
                string = message;
                break;
            }
            case 2: {
                string = "<i>" + message + "</i>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String renderName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.escape(RenderingUtilsKt.render(name));
    }

    private final void renderName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.getName()");
        builder.append(this.renderName(name));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                builder.append("companion object");
            }
            this.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration != null) {
                builder.append("of ");
                Name name = containingDeclaration.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "containingDeclaration.getName()");
                builder.append(this.renderName(name));
            }
        }
        if (this.getVerbose() || Intrinsics.areEqual(descriptor2.getName(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT) ^ true) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            Name name = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.getName()");
            builder.append(this.renderName(name));
        }
    }

    @Override
    @NotNull
    public String renderFqName(@NotNull FqNameBase fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        List<Name> list = fqName2.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, "fqName.pathSegments()");
        return this.renderFqName(list);
    }

    private final String renderFqName(List<? extends Name> pathSegments) {
        return this.escape(RenderingUtilsKt.renderFqName(pathSegments));
    }

    @Override
    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor klass) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        if (klass instanceof MissingDependencyErrorClass) {
            String string = ((MissingDependencyErrorClass)((Object)klass)).getFullFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "klass.fullFqName.asString()");
            return string;
        }
        if (ErrorUtils.isError(klass)) {
            return klass.getTypeConstructor().toString();
        }
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$5[this.getNameShortness().ordinal()]) {
            case 1: {
                ArrayList<Name> qualifiedNameElements = new ArrayList<Name>();
                DeclarationDescriptor current = klass;
                do {
                    DeclarationDescriptor declarationDescriptor = current;
                    if (declarationDescriptor == null) {
                        Intrinsics.throwNpe();
                    }
                    qualifiedNameElements.add(declarationDescriptor.getName());
                } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
                return this.renderFqName(CollectionsKt.asReversedMutable((List)qualifiedNameElements));
            }
            case 2: {
                FqNameBase fqNameBase = DescriptorUtils.getFqName(klass);
                Intrinsics.checkExpressionValueIsNotNull(fqNameBase, "DescriptorUtils.getFqName(klass)");
                return this.renderFqName(fqNameBase);
            }
            case 3: {
                return RenderingUtilsKt.qualifiedNameForSourceCode(klass);
            }
        }
        throw (Throwable)new IllegalArgumentException();
    }

    @Override
    @NotNull
    public String renderType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return this.renderNormalizedType(this.getTypeNormalizer().invoke(type2));
    }

    private final String renderNormalizedType(KotlinType type2) {
        if (type2 instanceof LazyType && this.getDebugMode()) {
            return type2.toString();
        }
        if (DynamicTypesKt.isDynamic(type2)) {
            return "dynamic";
        }
        if (FlexibleTypesKt.isFlexible(type2)) {
            if (this.getDebugMode()) {
                return this.renderFlexibleTypeWithBothBounds(FlexibleTypesKt.flexibility(type2).getLowerBound(), FlexibleTypesKt.flexibility(type2).getUpperBound());
            }
            if (this.getFlexibleTypesForCode()) {
                String prefix = Intrinsics.areEqual((Object)this.getNameShortness(), (Object)NameShortness.SHORT) ? "" : Flexibility.Companion.INSTANCE.getFLEXIBLE_TYPE_CLASSIFIER().getPackageFqName().asString() + ".";
                return prefix + Flexibility.Companion.INSTANCE.getFLEXIBLE_TYPE_CLASSIFIER().getRelativeClassName() + this.lt() + this.renderNormalizedType(FlexibleTypesKt.flexibility(type2).getLowerBound()) + ", " + this.renderNormalizedType(FlexibleTypesKt.flexibility(type2).getUpperBound()) + this.gt();
            }
            return this.renderFlexibleType(type2);
        }
        return this.renderInflexibleType(type2);
    }

    private final String renderFlexibleTypeWithBothBounds(KotlinType lower, KotlinType upper) {
        return this.renderFlexibleTypeWithBothBounds(this.renderNormalizedType(lower), this.renderNormalizedType(upper));
    }

    private final String renderFlexibleTypeWithBothBounds(String lower, String upper) {
        return "(" + lower + ".." + upper + ")";
    }

    /*
     * WARNING - void declaration
     */
    private final String renderInflexibleType(KotlinType type2) {
        String customResult;
        void $receiver;
        boolean value2 = !FlexibleTypesKt.isFlexible(type2);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Flexible types not allowed here: " + this.renderNormalizedType(type2);
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        KotlinType $i$a$1 = type2;
        CustomFlexibleRendering customFlexibleRendering = $receiver.getCapability(CustomFlexibleRendering.class);
        String string = customResult = customFlexibleRendering != null ? customFlexibleRendering.renderInflexible(type2, this) : null;
        if (customResult != null) {
            return customResult;
        }
        if (Intrinsics.areEqual(type2, TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(type2)) {
            return "???";
        }
        if (ErrorUtils.isUninferredParameter(type2)) {
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = type2.getConstructor();
                if (typeConstructor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.ErrorUtils.UninferredParameterTypeConstructor");
                }
                String string2 = ((ErrorUtils.UninferredParameterTypeConstructor)typeConstructor2).getTypeParameterDescriptor().getName().toString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "(type.getConstructor() a\u2026or().getName().toString()");
                return this.renderError(string2);
            }
            return "???";
        }
        if (type2.isError()) {
            return this.renderDefaultType(type2);
        }
        if (this.shouldRenderAsPrettyFunctionType(type2)) {
            return this.renderFunctionType(type2);
        }
        return this.renderDefaultType(type2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderAsPrettyFunctionType(KotlinType type2) {
        Object element;
        TypeProjection it2;
        if (!this.getPrettyFunctionTypes()) return false;
        if (!KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(type2)) return false;
        Iterable $receiver = type2.getArguments();
        Iterator iterator2 = $receiver.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (!(it2 = (TypeProjection)(element = iterator2.next())).isStarProjection());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final String renderFlexibleType(KotlinType type2) {
        void upperRendered;
        void lowerRendered;
        void $receiver;
        KotlinType lower = FlexibleTypesKt.flexibility(type2).getLowerBound();
        KotlinType upper = FlexibleTypesKt.flexibility(type2).getUpperBound();
        KotlinType kotlinType = type2;
        Object object = $receiver.getCapability(CustomFlexibleRendering.class);
        if (object == null || (object = object.renderBounds(FlexibleTypesKt.flexibility(type2), this)) == null) {
            object = new Pair<String, String>(this.renderInflexibleType(lower), this.renderInflexibleType(upper));
        }
        Pair<String, String> pair = object;
        String string = pair.component1();
        String string2 = pair.component2();
        pair = null;
        if (this.differsOnlyInNullability((String)lowerRendered, (String)upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, "(", false, 2)) {
                return "(" + (String)lowerRendered + ")!";
            }
            return (String)lowerRendered + "!";
        }
        String kotlinPrefix = Intrinsics.areEqual((Object)this.getNameShortness(), (Object)NameShortness.SHORT) ^ true ? "kotlin." : "";
        String mutablePrefix = "Mutable";
        String simpleCollection = this.replacePrefixes((String)lowerRendered, kotlinPrefix + mutablePrefix, (String)upperRendered, kotlinPrefix, kotlinPrefix + "(" + mutablePrefix + ")");
        if (simpleCollection != null) {
            return simpleCollection;
        }
        String mutableEntry = this.replacePrefixes((String)lowerRendered, kotlinPrefix + "MutableMap.MutableEntry", (String)upperRendered, kotlinPrefix + "Map.Entry", kotlinPrefix + "(Mutable)Map.(Mutable)Entry");
        if (mutableEntry != null) {
            return mutableEntry;
        }
        String array = this.replacePrefixes((String)lowerRendered, kotlinPrefix + this.escape("Array<"), (String)upperRendered, kotlinPrefix + this.escape("Array<out "), kotlinPrefix + this.escape("Array<(out) "));
        if (array != null) {
            return array;
        }
        return this.renderFlexibleTypeWithBothBounds((String)lowerRendered, (String)upperRendered);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderTypeArguments(@NotNull List<? extends TypeProjection> typeArguments) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(typeArguments, "typeArguments");
        if (typeArguments.isEmpty()) {
            return "";
        }
        StringBuilder $receiver = new StringBuilder();
        StringBuilder $receiver2 = $receiver;
        $receiver2.append(this.lt());
        this.appendTypeProjections(typeArguments, $receiver2);
        $receiver2.append(this.gt());
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026t())\n        }.toString()");
        return string;
    }

    private final String renderDefaultType(KotlinType type2) {
        StringBuilder sb = new StringBuilder();
        this.renderAnnotations(type2, sb, true);
        if (type2.isError()) {
            sb.append(type2.getConstructor().toString());
        } else {
            TypeConstructor typeConstructor2 = type2.getConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "type.getConstructor()");
            sb.append(this.renderTypeConstructor(typeConstructor2));
        }
        List<TypeProjection> list = type2.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list, "type.getArguments()");
        sb.append(this.renderTypeArguments(list));
        if (type2.isMarkedNullable()) {
            sb.append("?");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @Override
    @NotNull
    public String renderTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        String string;
        ClassifierDescriptor cd;
        Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
        ClassifierDescriptor classifierDescriptor = cd = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            Name name = ((TypeParameterDescriptor)cd).getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "cd.getName()");
            string = this.renderName(name);
        } else {
            string = classifierDescriptor instanceof ClassDescriptor ? this.renderClassifierName(cd) : (Intrinsics.areEqual(classifierDescriptor, null) ? typeConstructor2.toString() : (String)((Object)PreconditionsKt.error("Unexpected classifier: " + cd.getClass())));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderTypeProjection(@NotNull TypeProjection typeProjection) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        StringBuilder $receiver = new StringBuilder();
        StringBuilder $receiver2 = $receiver;
        this.appendTypeProjections(CollectionsKt.listOf(typeProjection), $receiver2);
        return ((StringBuilder)var2_2).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void appendTypeProjections(List<? extends TypeProjection> typeProjections, StringBuilder builder) {
        void destination;
        void $receiver;
        Iterable $receiver2 = typeProjections;
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            String string;
            void it2;
            TypeProjection typeProjection = (TypeProjection)item;
            void var9_9 = destination;
            if (it2.isStarProjection()) {
                string = "*";
            } else {
                KotlinType kotlinType = it2.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.getType()");
                String type2 = this.renderType(kotlinType);
                string = Intrinsics.areEqual((Object)it2.getProjectionKind(), (Object)Variance.INVARIANT) ? type2 : (Object)((Object)it2.getProjectionKind()) + " " + type2;
            }
            String string2 = string;
            var9_9.add(string2);
        }
        CollectionsKt.joinTo$default((List)destination, builder, ", ", null, null, 0, null, null, 124);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderFunctionType(KotlinType type2) {
        void var2_2;
        KotlinType receiverType;
        StringBuilder $receiver = new StringBuilder();
        StringBuilder $receiver2 = $receiver;
        boolean isNullable = type2.isMarkedNullable();
        if (isNullable) {
            $receiver2.append("(");
        }
        if ((receiverType = KotlinBuiltIns.getReceiverType(type2)) != null) {
            boolean surroundReceiver;
            boolean bl = surroundReceiver = this.shouldRenderAsPrettyFunctionType(receiverType) && !receiverType.isMarkedNullable();
            if (surroundReceiver) {
                $receiver2.append("(");
            }
            $receiver2.append(this.renderNormalizedType(receiverType));
            if (surroundReceiver) {
                $receiver2.append(")");
            }
            $receiver2.append(".");
        }
        $receiver2.append("(");
        List<TypeProjection> list = KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(type2);
        Intrinsics.checkExpressionValueIsNotNull(list, "KotlinBuiltIns.getParame\u2026onsFromFunctionType(type)");
        this.appendTypeProjections(list, $receiver2);
        $receiver2.append(") ").append(this.arrow()).append(" ");
        KotlinType kotlinType = KotlinBuiltIns.getReturnTypeFromFunctionType(type2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "KotlinBuiltIns.getReturnTypeFromFunctionType(type)");
        $receiver2.append(this.renderNormalizedType(kotlinType));
        if (isNullable) {
            $receiver2.append(")?");
        }
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026)?\")\n        }.toString()");
        return string;
    }

    private final void appendDefinedIn(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
            return;
        }
        if (descriptor2 instanceof ModuleDescriptor) {
            builder.append(" is a module");
            return;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration != null && !(containingDeclaration instanceof ModuleDescriptor)) {
            String string;
            builder.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqName2 = DescriptorUtils.getFqName(containingDeclaration);
            if (fqName2.isRoot()) {
                string = "root package";
            } else {
                FqNameBase fqNameBase = fqName2;
                Intrinsics.checkExpressionValueIsNotNull(fqNameBase, "fqName");
                string = this.renderFqName(fqNameBase);
            }
            builder.append(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderAnnotations(Annotated annotated, StringBuilder builder, boolean needBrackets) {
        void $receiver;
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS) ^ true) {
            return;
        }
        Set<FqName> excluded = annotated instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver2 = (StringBuilder)$receiver;
        List<AnnotationWithTarget> sortedAnnotations = annotated.getAnnotations().getAllAnnotations();
        for (AnnotationWithTarget annotationWithTarget : sortedAnnotations) {
            AnnotationDescriptor annotation2 = annotationWithTarget.component1();
            AnnotationUseSiteTarget target = annotationWithTarget.component2();
            ClassifierDescriptor classifierDescriptor = annotation2.getType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor annotationClass = (ClassDescriptor)classifierDescriptor;
            if (excluded.contains(DescriptorUtils.getFqNameSafe(annotationClass))) continue;
            $receiver2.append(this.renderAnnotation(annotation2, target)).append(" ");
        }
        StringBuilder annotationsBuilder = (StringBuilder)$receiver;
        builder.append((CharSequence)annotationsBuilder);
    }

    static /* synthetic */ void renderAnnotations$default(DescriptorRendererImpl descriptorRendererImpl, Annotated annotated, StringBuilder stringBuilder, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        descriptorRendererImpl.renderAnnotations(annotated, stringBuilder, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor annotation2, @Nullable AnnotationUseSiteTarget target) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        StringBuilder $receiver = new StringBuilder();
        StringBuilder $receiver2 = $receiver;
        $receiver2.append('@');
        if (target != null) {
            $receiver2.append(target.getRenderName() + ":");
        }
        KotlinType kotlinType = annotation2.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "annotation.getType()");
        $receiver2.append(this.renderType(kotlinType));
        if (this.getVerbose()) {
            CollectionsKt.joinTo$default(this.renderAndSortAnnotationArguments(annotation2), $receiver2, ", ", "(", ")", 0, null, null, 112);
        }
        String string = ((StringBuilder)var3_3).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026   }\n        }.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor descriptor2) {
        void destination;
        void $receiver;
        String string;
        Collection collection;
        Collection destination2;
        ValueParameterDescriptor it2;
        Object $receiver2;
        List list;
        Iterable destination3;
        Object element2;
        Iterable $receiver3;
        Map<ValueParameterDescriptor, ConstantValue<?>> allValueArguments2 = descriptor2.getAllValueArguments();
        ClassDescriptor classDescriptor = this.getRenderDefaultAnnotationArguments() ? TypeUtils.getClassDescriptor(descriptor2.getType()) : (ClassDescriptor)null;
        Object object = classDescriptor;
        if (object != null && (object = object.getUnsubstitutedPrimaryConstructor()) != null && (object = object.getValueParameters()) != null) {
            void $receiver4;
            Iterable iterable = (Iterable)object;
            void var5_5 = $receiver4;
            Collection collection2 = new ArrayList();
            for (Object element2 : $receiver3) {
                ValueParameterDescriptor it3 = (ValueParameterDescriptor)element2;
                if (!it3.declaresDefaultValue()) continue;
                destination3.add(element2);
            }
            list = (List)destination3;
        } else {
            list = CollectionsKt.emptyList();
        }
        List parameterDescriptorsWithDefaultValue = list;
        $receiver3 = parameterDescriptorsWithDefaultValue;
        destination3 = $receiver3;
        Collection collection3 = new ArrayList();
        element2 = $receiver2.iterator();
        while (element2.hasNext()) {
            Object element3 = element2.next();
            it2 = (ValueParameterDescriptor)element3;
            if (!(!allValueArguments2.containsKey(it2))) continue;
            destination2.add(element3);
        }
        $receiver3 = (List)destination2;
        $receiver2 = $receiver3;
        destination2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
        element2 = $receiver2.iterator();
        while (element2.hasNext()) {
            Object item = element2.next();
            it2 = (ValueParameterDescriptor)item;
            collection = destination2;
            string = it2.getName().asString() + " = ...";
            collection.add(string);
        }
        List defaultList = (List)destination2;
        $receiver2 = allValueArguments2;
        $receiver2 = $receiver2.entrySet();
        Object $i$f$entrySet = $receiver2;
        element2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            String string2;
            void entry;
            Map.Entry $i$a$2 = (Map.Entry)item;
            collection = destination;
            String name = ((ValueParameterDescriptor)entry.getKey()).getName().asString();
            if (!parameterDescriptorsWithDefaultValue.contains(entry.getKey())) {
                ConstantValue constantValue = (ConstantValue)entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull(constantValue, "entry.value");
                string2 = this.renderConstant(constantValue);
            } else {
                string2 = "...";
            }
            String value2 = string2;
            string = name + " = " + value2;
            collection.add(string);
        }
        List argumentList2 = (List)destination;
        return CollectionsKt.sorted(CollectionsKt.plus((Collection)defaultList, (Iterable)argumentList2));
    }

    /*
     * WARNING - void declaration
     */
    private final String renderConstant(ConstantValue<?> value2) {
        String string;
        ConstantValue<?> constantValue = value2;
        if (constantValue instanceof ArrayValue) {
            void destination;
            void $receiver;
            Iterable $receiver2 = (Iterable)((ArrayValue)value2).getValue();
            Iterable iterable = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
            for (Object item : $receiver) {
                void it2;
                ConstantValue constantValue2 = (ConstantValue)item;
                void var9_9 = destination;
                String string2 = this.renderConstant(it2);
                var9_9.add(string2);
            }
            string = CollectionsKt.joinToString$default((List)destination, ", ", "{", "}", 0, null, null, 56);
        } else {
            string = constantValue instanceof AnnotationValue ? StringsKt.removePrefix(DescriptorRenderer.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)value2).getValue(), null, 2), "@") : (constantValue instanceof KClassValue ? this.renderType(((KClassValue)value2).getValue()) + "::class" : value2.toString());
        }
        return string;
    }

    private final void renderVisibility(Visibility visibility, StringBuilder builder) {
        Visibility visibility2 = visibility;
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY) ^ true) {
            return;
        }
        if (this.getNormalizedVisibilities()) {
            visibility2 = visibility2.normalize();
        }
        if (!this.getShowInternalKeyword() && Intrinsics.areEqual(visibility2, Visibilities.DEFAULT_VISIBILITY)) {
            return;
        }
        builder.append(this.renderKeyword(visibility2.getDisplayName())).append(" ");
    }

    private final void renderModality(Modality modality, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY) ^ true) {
            return;
        }
        Enum $receiver = modality;
        String keyword = StringsKt.toLowerCase($receiver.name());
        builder.append(this.renderKeyword(keyword)).append(" ");
    }

    private final void renderInner(boolean isInner, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) ^ true) {
            return;
        }
        if (isInner) {
            builder.append(this.renderKeyword("inner")).append(" ");
        }
    }

    private final void renderData(boolean isData, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.DATA) ^ true || !isData) {
            return;
        }
        builder.append(this.renderKeyword("data")).append(" ");
    }

    private final void renderModalityForCallable(CallableMemberDescriptor callable, StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || Intrinsics.areEqual((Object)callable.getModality(), (Object)Modality.FINAL) ^ true) {
            if (this.overridesSomething(callable) && Intrinsics.areEqual((Object)this.getOverrideRenderingPolicy(), (Object)OverrideRenderingPolicy.RENDER_OVERRIDE) && Intrinsics.areEqual((Object)callable.getModality(), (Object)Modality.OPEN)) {
                return;
            }
            Modality modality = callable.getModality();
            Intrinsics.checkExpressionValueIsNotNull((Object)modality, "callable.getModality()");
            this.renderModality(modality, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderOverride(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE) ^ true) {
            return;
        }
        if (this.overridesSomething(callableMember) && Intrinsics.areEqual((Object)this.getOverrideRenderingPolicy(), (Object)OverrideRenderingPolicy.RENDER_OPEN) ^ true) {
            builder.append("override ");
            if (this.getVerbose()) {
                void $receiver;
                Collection<? extends CallableMemberDescriptor> collection = callableMember.getOverriddenDescriptors();
                StringBuilder stringBuilder = builder.append("/*");
                int n = $receiver.size();
                stringBuilder.append(n).append("*/ ");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND) ^ true) {
            return;
        }
        if (this.getVerbose() && Intrinsics.areEqual((Object)callableMember.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true) {
            void $receiver;
            Enum enum_ = callableMember.getKind();
            StringBuilder stringBuilder = builder.append("/*");
            String string = $receiver.name();
            stringBuilder.append(StringsKt.toLowerCase(string)).append("*/ ");
        }
    }

    private final void renderLateInit(PropertyDescriptor propertyDescriptor, StringBuilder builder) {
        if (propertyDescriptor.isLateInit()) {
            builder.append("lateinit ");
        }
    }

    private final void renderAdditionalModifiers(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        FunctionDescriptor it2;
        Iterable $receiver;
        if (functionDescriptor.isOperator()) {
            boolean bl;
            block9: {
                $receiver = functionDescriptor.getOverriddenDescriptors();
                for (Object element : $receiver) {
                    it2 = (FunctionDescriptor)element;
                    if (!it2.isOperator()) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
            if (bl) {
                builder.append("operator ");
            }
        }
        if (functionDescriptor.isInfix()) {
            boolean bl;
            block10: {
                $receiver = functionDescriptor.getOverriddenDescriptors();
                for (Object element : $receiver) {
                    it2 = (FunctionDescriptor)element;
                    if (!it2.isInfix()) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
            if (bl) {
                builder.append("infix ");
            }
        }
        if (functionDescriptor.isExternal()) {
            builder.append("external ");
        }
        if (functionDescriptor.isInline()) {
            builder.append("inline ");
        }
        if (functionDescriptor.isTailrec()) {
            builder.append("tailrec ");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(declarationDescriptor, "declarationDescriptor");
        StringBuilder $receiver = new StringBuilder();
        StringBuilder $receiver2 = $receiver;
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), $receiver2);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn(declarationDescriptor, $receiver2);
        }
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026   }\n        }.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeParameter(TypeParameterDescriptor typeParameter, StringBuilder builder, boolean topLevel) {
        void $receiver;
        String variance;
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.getVerbose()) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        if (typeParameter.isReified()) {
            builder.append(this.renderKeyword("reified")).append(" ");
        }
        if (!StringsKt.isEmpty(variance = typeParameter.getVariance().getLabel())) {
            builder.append(this.renderKeyword(variance)).append(" ");
        }
        this.renderName(typeParameter, builder);
        Collection collection = typeParameter.getUpperBounds();
        int upperBoundsCount = $receiver.size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            KotlinType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!KotlinBuiltIns.isDefaultBound(upperBound)) {
                StringBuilder stringBuilder = builder.append(" : ");
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                stringBuilder.append(this.renderType(kotlinType));
            }
        } else if (topLevel) {
            boolean first = true;
            for (KotlinType upperBound : typeParameter.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(upperBound)) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                builder.append(this.renderType(kotlinType));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder, boolean withSpace) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!typeParameters.isEmpty()) {
            builder.append(this.lt());
            Iterator<? extends TypeParameterDescriptor> iterator2 = typeParameters.iterator();
            while (iterator2.hasNext()) {
                TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
                this.renderTypeParameter(typeParameterDescriptor, builder, false);
                if (!iterator2.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(this.gt());
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private final void renderFunction(FunctionDescriptor function, StringBuilder builder) {
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, function, builder, false, 4);
            Visibility visibility = function.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "function.getVisibility()");
            this.renderVisibility(visibility, builder);
            this.renderModalityForCallable(function, builder);
            this.renderAdditionalModifiers(function, builder);
            this.renderOverride(function, builder);
            this.renderMemberKind(function, builder);
            builder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list = function.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "function.getTypeParameters()");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder);
        Collection collection = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection, "function.valueParameters");
        this.renderValueParameters(collection, function.hasSynthesizedParameterNames(), builder);
        this.renderReceiverAfterName(function, builder);
        KotlinType returnType2 = function.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && returnType2 != null && KotlinBuiltIns.isUnit(returnType2))) {
            builder.append(": ").append(returnType2 == null ? "[NULL]" : this.escape(this.renderType(returnType2)));
        }
        List<TypeParameterDescriptor> list = function.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "function.getTypeParameters()");
        this.renderWhereSuffix(list, builder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            StringBuilder stringBuilder = builder.append(" on ");
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiver.getType()");
            stringBuilder.append(this.escape(this.renderType(kotlinType)));
        }
    }

    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            KotlinType type2;
            KotlinType kotlinType = type2 = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
            String result2 = this.escape(this.renderType(kotlinType));
            KotlinType kotlinType2 = type2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "type");
            if (this.shouldRenderAsPrettyFunctionType(kotlinType2) && !TypeUtils.isNullableType(type2)) {
                result2 = "(" + result2 + ")";
            }
            builder.append(result2).append(".");
        }
    }

    private final void renderConstructor(ConstructorDescriptor constructor, StringBuilder builder) {
        DescriptorRendererImpl.renderAnnotations$default(this, constructor, builder, false, 4);
        Visibility visibility = constructor.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull(visibility, "constructor.getVisibility()");
        this.renderVisibility(visibility, builder);
        this.renderMemberKind(constructor, builder);
        builder.append(this.renderKeyword("constructor"));
        if (this.getSecondaryConstructorsAsPrimary()) {
            ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
            builder.append(" ");
            DeclarationDescriptor declarationDescriptor = classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "classDescriptor");
            this.renderName(declarationDescriptor, builder);
            List<TypeParameterDescriptor> list = classDescriptor.getTypeConstructor().getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "classDescriptor.getTypeC\u2026tructor().getParameters()");
            this.renderTypeParameters(list, builder, false);
        }
        Collection collection = constructor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection, "constructor.valueParameters");
        this.renderValueParameters(collection, constructor.hasSynthesizedParameterNames(), builder);
        if (this.getSecondaryConstructorsAsPrimary()) {
            List<TypeParameterDescriptor> list = constructor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "constructor.getTypeParameters()");
            this.renderWhereSuffix(list, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList upperBoundStrings = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            void $receiver;
            Iterable iterable = CollectionsKt.drop((Iterable)typeParameterDescriptor.getUpperBounds(), 1);
            for (Object item : $receiver) {
                void it2;
                KotlinType kotlinType = (KotlinType)item;
                Collection collection = upperBoundStrings;
                StringBuilder stringBuilder = new StringBuilder();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "typeParameter.getName()");
                StringBuilder stringBuilder2 = stringBuilder.append(this.renderName(name)).append(" : ");
                void v3 = it2;
                Intrinsics.checkExpressionValueIsNotNull(v3, "it");
                String string = stringBuilder2.append(this.escape(this.renderType((KotlinType)v3))).toString();
                collection.add(string);
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default(upperBoundStrings, builder, ", ", null, null, 0, null, null, 124);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderValueParameters(@NotNull Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        StringBuilder $receiver = new StringBuilder();
        StringBuilder $receiver2 = $receiver;
        this.renderValueParameters(parameters2, synthesizedParameterNames, $receiver2);
        String string = ((StringBuilder)var3_3).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder { renderVa\u2026Names, this) }.toString()");
        return string;
    }

    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames, StringBuilder builder) {
        boolean includeNames = this.shouldRenderParameterNames(synthesizedParameterNames);
        Collection<? extends ValueParameterDescriptor> object2 = parameters2;
        int parameterCount = object2.size();
        this.getValueParametersHandler().appendBeforeValueParameters(parameterCount, builder);
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)parameters2)) {
            int index2 = indexedValue.component1();
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)indexedValue.component2();
            this.getValueParametersHandler().appendBeforeValueParameter(parameter, index2, parameterCount, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.getValueParametersHandler().appendAfterValueParameter(parameter, index2, parameterCount, builder);
        }
        this.getValueParametersHandler().appendAfterValueParameters(parameterCount, builder);
    }

    private final boolean shouldRenderParameterNames(boolean synthesizedParameterNames) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$6[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return !synthesizedParameterNames;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    private final void renderValueParameter(ValueParameterDescriptor valueParameter, boolean includeName, StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        DescriptorRendererImpl.renderAnnotations$default(this, valueParameter, builder, false, 4);
        if (valueParameter.isCrossinline()) {
            builder.append("crossinline ");
        }
        if (valueParameter.isNoinline()) {
            builder.append("noinline ");
        }
        this.renderVariable(valueParameter, includeName, builder, topLevel);
        boolean bl = this.getRenderDefaultValues() && (this.getDebugMode() ? valueParameter.declaresDefaultValue() : DescriptorUtilsKt.hasDefaultValue(valueParameter)) ? true : (withDefaultValue = false);
        if (withDefaultValue) {
            builder.append(" = ...");
        }
    }

    private final void renderValVarPrefix(VariableDescriptor variable, StringBuilder builder) {
        builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
    }

    private final void renderVariable(VariableDescriptor variable, boolean includeName, StringBuilder builder, boolean topLevel) {
        KotlinType typeToRender;
        KotlinType realType = variable.getType();
        VariableDescriptor variableDescriptor = variable;
        if (!(variableDescriptor instanceof ValueParameterDescriptor)) {
            variableDescriptor = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)variableDescriptor;
        KotlinType varargElementType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        KotlinType kotlinType = varargElementType;
        if (kotlinType == null) {
            kotlinType = typeToRender = realType;
        }
        if (varargElementType != null) {
            builder.append(this.renderKeyword("vararg")).append(" ");
        }
        if (topLevel && !this.getStartFromName()) {
            this.renderValVarPrefix(variable, builder);
        }
        if (includeName) {
            this.renderName(variable, builder);
            builder.append(": ");
        }
        KotlinType kotlinType2 = typeToRender;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "typeToRender");
        builder.append(this.escape(this.renderType(kotlinType2)));
        this.renderInitializer(variable, builder);
        if (this.getVerbose() && varargElementType != null) {
            StringBuilder stringBuilder = builder.append(" /*");
            KotlinType kotlinType3 = realType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "realType");
            stringBuilder.append(this.escape(this.renderType(kotlinType3))).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor property, StringBuilder builder) {
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, property, builder, false, 4);
            Visibility visibility = property.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "property.getVisibility()");
            this.renderVisibility(visibility, builder);
            if (property.isConst()) {
                builder.append("const ");
            }
            this.renderModalityForCallable(property, builder);
            this.renderOverride(property, builder);
            this.renderLateInit(property, builder);
            this.renderMemberKind(property, builder);
            this.renderValVarPrefix(property, builder);
            List<TypeParameterDescriptor> list = property.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "property.getTypeParameters()");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(property, builder);
        }
        this.renderName(property, builder);
        StringBuilder stringBuilder = builder.append(": ");
        KotlinType kotlinType = property.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "property.getType()");
        stringBuilder.append(this.escape(this.renderType(kotlinType)));
        this.renderReceiverAfterName(property, builder);
        this.renderInitializer(property, builder);
        List<TypeParameterDescriptor> list = property.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "property.getTypeParameters()");
        this.renderWhereSuffix(list, builder);
    }

    private final void renderInitializer(VariableDescriptor variable, StringBuilder builder) {
        if (this.getIncludePropertyConstant()) {
            StringBuilder stringBuilder;
            ConstantValue<?> constantValue = variable.getCompileTimeInitializer();
            if (constantValue != null) {
                ConstantValue<?> $receiver = constantValue;
                ConstantValue<?> constant = $receiver;
                StringBuilder stringBuilder2 = builder.append(" = ");
                ConstantValue<?> constantValue2 = constant;
                Intrinsics.checkExpressionValueIsNotNull(constantValue2, "constant");
                stringBuilder = stringBuilder2.append(this.escape(this.renderConstant(constantValue2)));
            } else {
                stringBuilder = null;
            }
        }
    }

    private final void renderClass(ClassDescriptor klass, StringBuilder builder) {
        ConstructorDescriptor primaryConstructor2;
        List<TypeParameterDescriptor> typeParameters;
        boolean isEnumEntry = Intrinsics.areEqual((Object)klass.getKind(), (Object)ClassKind.ENUM_ENTRY);
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, klass, builder, false, 4);
            if (!isEnumEntry) {
                Visibility visibility = klass.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull(visibility, "klass.visibility");
                this.renderVisibility(visibility, builder);
            }
            if (!(Intrinsics.areEqual((Object)klass.getKind(), (Object)ClassKind.INTERFACE) && Intrinsics.areEqual((Object)klass.getModality(), (Object)Modality.ABSTRACT) || klass.getKind().isSingleton() && Intrinsics.areEqual((Object)klass.getModality(), (Object)Modality.FINAL))) {
                Modality modality = klass.getModality();
                Intrinsics.checkExpressionValueIsNotNull((Object)modality, "klass.modality");
                this.renderModality(modality, builder);
            }
            this.renderInner(klass.isInner(), builder);
            this.renderData(klass.isData(), builder);
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isCompanionObject(klass)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder);
        } else {
            this.renderCompanionObjectName(klass, builder);
        }
        if (isEnumEntry) {
            return;
        }
        List<TypeParameterDescriptor> list = typeParameters = klass.getTypeConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "typeParameters");
        this.renderTypeParameters(list, builder, false);
        if (!klass.getKind().isSingleton() && this.getClassWithPrimaryConstructor() && (primaryConstructor2 = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            builder.append(" ");
            this.renderAnnotations(primaryConstructor2, builder, true);
            Visibility visibility = primaryConstructor2.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "primaryConstructor.visibility");
            this.renderVisibility(visibility, builder);
            builder.append("constructor");
            Collection collection = primaryConstructor2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(collection, "primaryConstructor.valueParameters");
            this.renderValueParameters(collection, primaryConstructor2.hasSynthesizedParameterNames(), builder);
        }
        this.renderSuperTypes(klass, builder);
        List<TypeParameterDescriptor> list2 = typeParameters;
        Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameters");
        this.renderWhereSuffix(list2, builder);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSuperTypes(ClassDescriptor klass, StringBuilder builder) {
        void destination;
        void $receiver;
        Iterable $receiver2;
        Collection<KotlinType> supertypes2;
        block7: {
            block6: {
                if (this.getWithoutSuperTypes()) {
                    return;
                }
                if (KotlinBuiltIns.isNothing(klass.getDefaultType())) {
                    return;
                }
                supertypes2 = klass.getTypeConstructor().getSupertypes();
                if (supertypes2.isEmpty()) break block6;
                Collection<KotlinType> collection = supertypes2;
                if ($receiver2.size() != 1 || !KotlinBuiltIns.isAnyOrNullableAny(supertypes2.iterator().next())) break block7;
            }
            return;
        }
        this.renderSpaceIfNeeded(builder);
        builder.append(": ");
        $receiver2 = supertypes2;
        Iterable $i$f$size = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            KotlinType kotlinType = (KotlinType)item;
            void var10_10 = destination;
            void v0 = it2;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            String string = this.renderType((KotlinType)v0);
            var10_10.add(string);
        }
        CollectionsKt.joinTo$default((List)destination, builder, ", ", null, null, 0, null, null, 124);
    }

    private final void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        builder.append(this.renderKeyword(DescriptorRenderer.Companion.INSTANCE.getClassKindPrefix(klass)));
    }

    private final void renderModuleOrScript(DeclarationDescriptor moduleOrScript, StringBuilder builder) {
        this.renderName(moduleOrScript, builder);
    }

    private final void renderPackageView(PackageViewDescriptor packageView, StringBuilder builder) {
        builder.append(this.renderKeyword("package")).append(" ");
        builder.append(this.renderFqName(packageView.getFqName()));
        if (this.getDebugMode()) {
            builder.append(" in context of ");
            this.renderName(packageView.getModule(), builder);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor fragment, StringBuilder builder) {
        builder.append(this.renderKeyword("package-fragment")).append(" ");
        builder.append(this.renderFqName(fragment.getFqName()));
        if (this.getDebugMode()) {
            builder.append(" in ");
            this.renderName(fragment.getContainingDeclaration(), builder);
        }
    }

    private final void renderAccessorModifiers(PropertyAccessorDescriptor descriptor2, StringBuilder builder) {
        if (descriptor2.isExternal()) {
            builder.append("external ");
        }
    }

    private final void renderSpaceIfNeeded(StringBuilder builder) {
        int length = CollectionsKt.length(builder);
        if (length == 0 || CollectionsKt.charAt(builder, length - 1) != ' ') {
            builder.append(' ');
        }
    }

    private final String replacePrefixes(String lowerRendered, String lowerPrefix, String upperRendered, String upperPrefix, String foldedPrefix) {
        if (StringsKt.startsWith$default(lowerRendered, lowerPrefix, false, 2) && StringsKt.startsWith$default(upperRendered, upperPrefix, false, 2)) {
            String lowerWithoutPrefix = StringsKt.substring(lowerRendered, CollectionsKt.length(lowerPrefix));
            String upperWithoutPrefix = StringsKt.substring(upperRendered, CollectionsKt.length(upperPrefix));
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (this.differsOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + "!";
            }
        }
        return null;
    }

    private final boolean differsOnlyInNullability(String lower, String upper) {
        return Intrinsics.areEqual(lower, StringsKt.replace$default(upper, "?", "", false, 4)) || StringsKt.endsWith$default(upper, "?", false, 2) && Intrinsics.areEqual(lower + "?", upper) || Intrinsics.areEqual("(" + lower + ")?", upper);
    }

    private final boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    @NotNull
    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public DescriptorRendererImpl(@NotNull DescriptorRendererOptionsImpl options) {
        Intrinsics.checkParameterIsNotNull(options, "options");
        this.options = options;
        PreconditionsKt.assert(this.options.isLocked());
    }

    @Override
    public boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    @Override
    public void setClassWithPrimaryConstructor(boolean bl) {
        this.options.setClassWithPrimaryConstructor(bl);
    }

    @Override
    public boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    public void setExcludedAnnotationClasses(@NotNull Set<? extends FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setExcludedAnnotationClasses(set);
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public void setExcludedTypeAnnotationClasses(@NotNull Set<? extends FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    @Override
    public boolean getFlexibleTypesForCode() {
        return this.options.getFlexibleTypesForCode();
    }

    @Override
    public void setFlexibleTypesForCode(boolean bl) {
        this.options.setFlexibleTypesForCode(bl);
    }

    @Override
    public boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    @Override
    public void setIncludePropertyConstant(boolean bl) {
        this.options.setIncludePropertyConstant(bl);
    }

    @Override
    @NotNull
    public Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public void setModifiers(@NotNull Set<? extends DescriptorRendererModifier> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setModifiers(set);
    }

    @Override
    @NotNull
    public NameShortness getNameShortness() {
        return this.options.getNameShortness();
    }

    @Override
    public void setNameShortness(@NotNull NameShortness nameShortness2) {
        Intrinsics.checkParameterIsNotNull((Object)nameShortness2, "<set-?>");
        this.options.setNameShortness(nameShortness2);
    }

    @Override
    public boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    @Override
    public void setNormalizedVisibilities(boolean bl) {
        this.options.setNormalizedVisibilities(bl);
    }

    @Override
    @NotNull
    public OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    @Override
    public void setOverrideRenderingPolicy(@NotNull OverrideRenderingPolicy overrideRenderingPolicy2) {
        Intrinsics.checkParameterIsNotNull((Object)overrideRenderingPolicy2, "<set-?>");
        this.options.setOverrideRenderingPolicy(overrideRenderingPolicy2);
    }

    @Override
    @NotNull
    public ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public void setParameterNameRenderingPolicy(@NotNull ParameterNameRenderingPolicy parameterNameRenderingPolicy2) {
        Intrinsics.checkParameterIsNotNull((Object)parameterNameRenderingPolicy2, "<set-?>");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy2);
    }

    @Override
    public boolean getPrettyFunctionTypes() {
        return this.options.getPrettyFunctionTypes();
    }

    @Override
    public void setPrettyFunctionTypes(boolean bl) {
        this.options.setPrettyFunctionTypes(bl);
    }

    @Override
    public boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    @Override
    public boolean getRenderAccessors() {
        return this.options.getRenderAccessors();
    }

    @Override
    public void setRenderAccessors(boolean bl) {
        this.options.setRenderAccessors(bl);
    }

    @Override
    public boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    @Override
    public boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    @Override
    public void setRenderDefaultAnnotationArguments(boolean bl) {
        this.options.setRenderDefaultAnnotationArguments(bl);
    }

    @Override
    public boolean getRenderDefaultValues() {
        return this.options.getRenderDefaultValues();
    }

    @Override
    public void setRenderDefaultValues(boolean bl) {
        this.options.setRenderDefaultValues(bl);
    }

    @Override
    public boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    @Override
    public void setSecondaryConstructorsAsPrimary(boolean bl) {
        this.options.setSecondaryConstructorsAsPrimary(bl);
    }

    @Override
    public boolean getShowInternalKeyword() {
        return this.options.getShowInternalKeyword();
    }

    @Override
    public void setShowInternalKeyword(boolean bl) {
        this.options.setShowInternalKeyword(bl);
    }

    @Override
    public boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    @Override
    @NotNull
    public RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public void setTextFormat(@NotNull RenderingFormat renderingFormat) {
        Intrinsics.checkParameterIsNotNull((Object)renderingFormat, "<set-?>");
        this.options.setTextFormat(renderingFormat);
    }

    @Override
    @NotNull
    public Function1<KotlinType, KotlinType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    @Override
    public void setTypeNormalizer(@NotNull Function1<? super KotlinType, ? extends KotlinType> function1) {
        Intrinsics.checkParameterIsNotNull(function1, "<set-?>");
        this.options.setTypeNormalizer(function1);
    }

    @Override
    public boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    @Override
    public void setUninferredTypeParameterAsName(boolean bl) {
        this.options.setUninferredTypeParameterAsName(bl);
    }

    @Override
    public boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    @Override
    public void setUnitReturnType(boolean bl) {
        this.options.setUnitReturnType(bl);
    }

    @Override
    @NotNull
    public DescriptorRenderer.ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    @Override
    public void setValueParametersHandler(@NotNull DescriptorRenderer.ValueParametersHandler valueParametersHandler2) {
        Intrinsics.checkParameterIsNotNull(valueParametersHandler2, "<set-?>");
        this.options.setValueParametersHandler(valueParametersHandler2);
    }

    @Override
    public boolean getVerbose() {
        return this.options.getVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.options.setVerbose(bl);
    }

    @Override
    public boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    @Override
    public boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    @Override
    public void setWithoutReturnType(boolean bl) {
        this.options.setWithoutReturnType(bl);
    }

    @Override
    public boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    @Override
    public boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    private final class RenderDeclarationDescriptorVisitor
    implements DeclarationDescriptorVisitor<Unit, StringBuilder> {
        @Override
        public void visitValueParameterDescriptor(@NotNull ValueParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderValueParameter(descriptor2, true, builder, true);
        }

        @Override
        public void visitVariableDescriptor(@NotNull VariableDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderVariable(descriptor2, true, builder, true);
        }

        @Override
        public void visitPropertyDescriptor(@NotNull PropertyDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderProperty(descriptor2, builder);
        }

        @Override
        public void visitPropertyGetterDescriptor(@NotNull PropertyGetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                builder.append("getter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.getCorrespondingProperty()");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitPropertySetterDescriptor(@NotNull PropertySetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                builder.append("setter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.getCorrespondingProperty()");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderFunction(descriptor2, builder);
        }

        @Override
        public void visitReceiverParameterDescriptor(@NotNull ReceiverParameterDescriptor descriptor2, @NotNull StringBuilder data) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(data, "data");
            throw (Throwable)new UnsupportedOperationException("Don't render receiver parameters");
        }

        @Override
        public void visitConstructorDescriptor(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(constructorDescriptor, "constructorDescriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
        }

        @Override
        public void visitTypeParameterDescriptor(@NotNull TypeParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderTypeParameter(descriptor2, builder, true);
        }

        @Override
        public void visitPackageFragmentDescriptor(@NotNull PackageFragmentDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderPackageFragment(descriptor2, builder);
        }

        @Override
        public void visitPackageViewDescriptor(@NotNull PackageViewDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderPackageView(descriptor2, builder);
        }

        @Override
        public void visitModuleDeclaration(@NotNull ModuleDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderModuleOrScript(descriptor2, builder);
        }

        @Override
        public void visitScriptDescriptor(@NotNull ScriptDescriptor scriptDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderModuleOrScript(scriptDescriptor, builder);
        }

        @Override
        public void visitClassDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderClass(descriptor2, builder);
        }
    }
}

