/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;

public class GoToInstruction
extends BranchingInstruction {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.GoToInstruction");
    public final boolean isReturn;

    public GoToInstruction(int offset) {
        this(offset, BranchingInstruction.Role.END);
    }

    public GoToInstruction(int offset, BranchingInstruction.Role role) {
        this(offset, role, false);
    }

    public GoToInstruction(int offset, BranchingInstruction.Role role, boolean isReturn) {
        super(offset, role);
        this.isReturn = isReturn;
    }

    @Override
    public String toString() {
        String sRole = "[" + this.role.toString() + "]";
        return "GOTO " + sRole + " " + this.offset + (this.isReturn ? " RETURN" : "");
    }

    @Override
    public int nNext() {
        return 1;
    }

    @Override
    public int getNext(int index2, int no) {
        LOG.assertTrue(no == 0);
        return this.offset;
    }

    @Override
    public void accept(ControlFlowInstructionVisitor visitor2, int offset, int nextOffset) {
        visitor2.visitGoToInstruction(this, offset, nextOffset);
    }
}

