/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipHandler
extends ArchiveHandler {
    private volatile String myCanonicalPathToZip;
    private static final AtomicInteger myOpenRequests = new AtomicInteger();
    private static final AtomicLong myOpenTime = new AtomicLong();
    private static final AtomicLong myCloseTime = new AtomicLong();
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(10, 20){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ZipFile createAccessor(ZipHandler key) throws IOException {
            int requests = myOpenRequests.incrementAndGet();
            long started = System.nanoTime();
            try {
                ZipFile zipFile = new ZipFile(key.getCanonicalPathToZip());
                return zipFile;
            }
            finally {
                myOpenTime.addAndGet(System.nanoTime() - started);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void disposeAccessor(final ZipFile fileAccessor) {
            long started = System.nanoTime();
            try {
                this.disposeCloseable(new Closeable(){

                    @Override
                    public void close() throws IOException {
                        fileAccessor.close();
                    }
                });
            }
            finally {
                myCloseTime.addAndGet(System.nanoTime() - started);
            }
        }

        @Override
        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }
    };

    public ZipHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/ZipHandler", "<init>"));
        }
        super(path);
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value2 = this.myCanonicalPathToZip;
        if (value2 == null) {
            this.myCanonicalPathToZip = value2 = this.getFileToUse().getCanonicalPath();
        }
        String string = value2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getCanonicalPathToZip"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        FileAccessorCache.Handle<ZipFile> zipRef = ourZipFileFileAccessorCache.get(this);
        ZipFile zip2 = zipRef.get();
        ZipEntryMap map2 = new ZipEntryMap(zip2.size());
        map2.put("", this.createRootEntry());
        try {
            Enumeration<? extends ZipEntry> entries = zip2.entries();
            while (entries.hasMoreElements()) {
                this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map2, zip2);
            }
        }
        finally {
            zipRef.release();
        }
        ZipEntryMap zipEntryMap = map2;
        if (zipEntryMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "createEntriesMap"));
        }
        return zipEntryMap;
    }

    @NotNull
    protected File getFileToUse() {
        File file = this.getFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getFileToUse"));
        }
        return file;
    }

    @Override
    public void dispose() {
        super.dispose();
        ourZipFileFileAccessorCache.remove(this);
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip2) {
        ArchiveHandler.EntryInfo info;
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (zip2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar(entryName, '/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map2.get(entryName)) != null) {
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        Pair<String, String> path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip2);
        if (".".equals(path.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        ArchiveHandler.EntryInfo entryInfo = info = ZipHandler.store(map2, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), entry.getTime(), entryName);
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map2, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String string) {
        void entryName;
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        CharSequence sequence2 = shortName instanceof ByteArrayCharSequence ? shortName : ByteArrayCharSequence.convertToBytesIfAsciiString(shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence2, isDirectory, size, time, parentInfo);
        map2.put((String)entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip2) {
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (zip2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        ArchiveHandler.EntryInfo info = map2.get(entryName);
        if (info == null) {
            ZipEntry entry = zip2.getEntry(entryName + "/");
            if (entry != null) {
                ArchiveHandler.EntryInfo entryInfo = this.getOrCreate(entry, map2, zip2);
                if (entryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
                }
                return entryInfo;
            }
            Pair<String, String> path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip2);
            info = ZipHandler.store(map2, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(this.getClass()).info(zip2.getName() + ": " + entryName + " should be a directory");
            info = ZipHandler.store(map2, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block11: {
            byte[] byArray;
            InputStream stream;
            FileAccessorCache.Handle<ZipFile> zipRef;
            block12: {
                if (relativePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
                }
                try {
                    zipRef = ourZipFileFileAccessorCache.get(this);
                }
                catch (RuntimeException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw ex;
                }
                ZipFile zip2 = zipRef.get();
                ZipEntry entry = zip2.getEntry(relativePath);
                if (entry == null || (stream = zip2.getInputStream(entry)) == null) break block11;
                byArray = FileUtil.loadBytes(stream, (int)entry.getSize());
                stream.close();
                if (byArray != null) break block12;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
            }
            finally {
                zipRef.release();
            }
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }
}

