/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.common.collect.Maps;
import com.google.dart.compiler.backend.js.ast.AstPackage;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsObjectScope;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public final class StandardClasses {
    @NotNull
    private final JsObjectScope kotlinScope;
    @NotNull
    private final Map<FqNameUnsafe, JsName> standardObjects;
    @NotNull
    private final Map<FqNameUnsafe, JsObjectScope> scopeMap;

    @NotNull
    public static StandardClasses bindImplementations(@NotNull JsObjectScope kotlinObjectScope) {
        if (kotlinObjectScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinObjectScope", "org/jetbrains/k2js/translate/context/StandardClasses", "bindImplementations"));
        }
        StandardClasses standardClasses = new StandardClasses(kotlinObjectScope);
        StandardClasses.declareKotlinStandardClasses(standardClasses);
        StandardClasses standardClasses2 = standardClasses;
        if (standardClasses2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StandardClasses", "bindImplementations"));
        }
        return standardClasses2;
    }

    private static void declareKotlinStandardClasses(@NotNull StandardClasses standardClasses) {
        if (standardClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "standardClasses", "org/jetbrains/k2js/translate/context/StandardClasses", "declareKotlinStandardClasses"));
        }
        for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
            if (type2 == PrimitiveType.CHAR || type2 == PrimitiveType.LONG) continue;
            String typeName = type2.getTypeName().asString();
            standardClasses.declare().forFQ("kotlin." + typeName + "Range").kotlinClass("NumberRange").methods("iterator", "contains").properties("start", "end", "increment");
            standardClasses.declare().forFQ("kotlin." + typeName + "Progression").kotlinClass("NumberProgression").methods("iterator", "contains").properties("start", "end", "increment");
        }
        standardClasses.declare().forFQ("kotlin.LongRange").kotlinClass("LongRange").methods("iterator", "contains").properties("start", "end", "increment");
        standardClasses.declare().forFQ("kotlin.CharRange").kotlinClass("CharRange").methods("iterator", "contains").properties("start", "end", "increment");
        standardClasses.declare().forFQ("kotlin.LongProgression").kotlinClass("LongProgression").methods("iterator", "contains").properties("start", "end", "increment");
        standardClasses.declare().forFQ("kotlin.CharProgression").kotlinClass("CharProgression").methods("iterator", "contains").properties("start", "end", "increment");
        standardClasses.declare().forFQ("kotlin.Enum").kotlinClass("Enum");
        standardClasses.declare().forFQ("kotlin.Comparable").kotlinClass("Comparable");
    }

    private StandardClasses(@NotNull JsObjectScope kotlinScope) {
        if (kotlinScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinScope", "org/jetbrains/k2js/translate/context/StandardClasses", "<init>"));
        }
        this.standardObjects = Maps.newHashMap();
        this.scopeMap = Maps.newHashMap();
        this.kotlinScope = kotlinScope;
    }

    private void declareTopLevelObjectInScope(@NotNull JsObjectScope scope2, @NotNull Map<FqNameUnsafe, JsName> map, @NotNull FqNameUnsafe fullQualifiedName, @NotNull String name) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/k2js/translate/context/StandardClasses", "declareTopLevelObjectInScope"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/k2js/translate/context/StandardClasses", "declareTopLevelObjectInScope"));
        }
        if (fullQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullQualifiedName", "org/jetbrains/k2js/translate/context/StandardClasses", "declareTopLevelObjectInScope"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/k2js/translate/context/StandardClasses", "declareTopLevelObjectInScope"));
        }
        JsName declaredName = scope2.declareName(name);
        map.put(fullQualifiedName, declaredName);
        this.scopeMap.put(fullQualifiedName, AstPackage.JsObjectScope(scope2, "scope for " + name));
    }

    private void declareKotlinObject(@NotNull FqNameUnsafe fullQualifiedName, @NotNull String kotlinLibName) {
        if (fullQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullQualifiedName", "org/jetbrains/k2js/translate/context/StandardClasses", "declareKotlinObject"));
        }
        if (kotlinLibName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinLibName", "org/jetbrains/k2js/translate/context/StandardClasses", "declareKotlinObject"));
        }
        this.declareTopLevelObjectInScope(this.kotlinScope, this.standardObjects, fullQualifiedName, kotlinLibName);
    }

    private void declareInner(@NotNull FqNameUnsafe fullQualifiedClassName, @NotNull String shortMethodName, @NotNull String javascriptName) {
        if (fullQualifiedClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullQualifiedClassName", "org/jetbrains/k2js/translate/context/StandardClasses", "declareInner"));
        }
        if (shortMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortMethodName", "org/jetbrains/k2js/translate/context/StandardClasses", "declareInner"));
        }
        if (javascriptName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javascriptName", "org/jetbrains/k2js/translate/context/StandardClasses", "declareInner"));
        }
        JsObjectScope classScope = this.scopeMap.get(fullQualifiedClassName);
        assert (classScope != null);
        FqNameUnsafe fullQualifiedMethodName = fullQualifiedClassName.child(Name.guess(shortMethodName));
        this.standardObjects.put(fullQualifiedMethodName, classScope.declareName(javascriptName));
    }

    private void declareMethods(@NotNull FqNameUnsafe classFQName, String ... methodNames) {
        if (classFQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFQName", "org/jetbrains/k2js/translate/context/StandardClasses", "declareMethods"));
        }
        if (methodNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNames", "org/jetbrains/k2js/translate/context/StandardClasses", "declareMethods"));
        }
        for (String methodName : methodNames) {
            this.declareInner(classFQName, methodName, methodName);
        }
    }

    private void declareReadonlyProperties(@NotNull FqNameUnsafe classFQName, String ... propertyNames) {
        if (classFQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFQName", "org/jetbrains/k2js/translate/context/StandardClasses", "declareReadonlyProperties"));
        }
        if (propertyNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyNames", "org/jetbrains/k2js/translate/context/StandardClasses", "declareReadonlyProperties"));
        }
        for (String propertyName : propertyNames) {
            this.declareInner(classFQName, propertyName, propertyName);
        }
    }

    public boolean isStandardObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StandardClasses", "isStandardObject"));
        }
        return this.standardObjects.containsKey(DescriptorUtils.getFqName(descriptor));
    }

    @NotNull
    public JsName getStandardObjectName(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StandardClasses", "getStandardObjectName"));
        }
        JsName jsName = this.standardObjects.get(DescriptorUtils.getFqName(descriptor));
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StandardClasses", "getStandardObjectName"));
        }
        return jsName;
    }

    @NotNull
    private Builder declare() {
        Builder builder = new Builder();
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StandardClasses", "declare"));
        }
        return builder;
    }

    private final class Builder {
        @Nullable
        private FqNameUnsafe currentFQName = null;
        @Nullable
        private String currentObjectName = null;

        private Builder() {
        }

        @NotNull
        public Builder forFQ(@NotNull String classFQName) {
            if (classFQName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFQName", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "forFQ"));
            }
            this.currentFQName = new FqNameUnsafe(classFQName);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "forFQ"));
            }
            return builder;
        }

        @NotNull
        public Builder kotlinClass(@NotNull String kotlinName) {
            if (kotlinName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinName", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "kotlinClass"));
            }
            this.kotlinTopLevelObject(kotlinName);
            this.constructor();
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "kotlinClass"));
            }
            return builder;
        }

        private void kotlinTopLevelObject(@NotNull String kotlinName) {
            if (kotlinName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinName", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "kotlinTopLevelObject"));
            }
            assert (this.currentFQName != null);
            this.currentObjectName = kotlinName;
            StandardClasses.this.declareKotlinObject(this.currentFQName, kotlinName);
        }

        @NotNull
        private Builder constructor() {
            assert (this.currentFQName != null);
            assert (this.currentObjectName != null);
            StandardClasses.this.declareInner(this.currentFQName, "<init>", this.currentObjectName);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "constructor"));
            }
            return builder;
        }

        @NotNull
        public Builder methods(String ... methodNames) {
            if (methodNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNames", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "methods"));
            }
            assert (this.currentFQName != null);
            StandardClasses.this.declareMethods(this.currentFQName, methodNames);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "methods"));
            }
            return builder;
        }

        @NotNull
        public Builder properties(String ... propertyNames) {
            if (propertyNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyNames", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "properties"));
            }
            assert (this.currentFQName != null);
            StandardClasses.this.declareReadonlyProperties(this.currentFQName, propertyNames);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StandardClasses$Builder", "properties"));
            }
            return builder;
        }
    }
}

