/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.utils.LibraryUtils;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.config.EcmaVersion;

public class LibrarySourcesConfig
extends Config {
    @NotNull
    public static final Key<String> EXTERNAL_MODULE_NAME = Key.create("externalModule");
    @NotNull
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";
    @NotNull
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.k2js.config.LibrarySourcesConfig");
    public static final String STDLIB_JS_MODULE_NAME = "stdlib";
    public static final String BUILTINS_JS_MODULE_NAME = "builtins";
    public static final String BUILTINS_JS_FILE_NAME = "builtins.js";
    public static final String STDLIB_JS_FILE_NAME = "stdlib.js";
    @NotNull
    private final List<String> files;

    public LibrarySourcesConfig(@NotNull Project project, @NotNull String moduleId, @NotNull List<String> files, @NotNull EcmaVersion ecmaVersion, boolean sourcemap, boolean inlineEnabled) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/LibrarySourcesConfig", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/k2js/config/LibrarySourcesConfig", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/config/LibrarySourcesConfig", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/k2js/config/LibrarySourcesConfig", "<init>"));
        }
        super(project, moduleId, ecmaVersion, sourcemap, inlineEnabled);
        this.files = files;
    }

    @Override
    @NotNull
    protected List<JetFile> generateLibFiles() {
        if (this.files.isEmpty()) {
            List<JetFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/LibrarySourcesConfig", "generateLibFiles"));
            }
            return list;
        }
        ArrayList<JetFile> jetFiles = new ArrayList<JetFile>();
        String moduleName = UNKNOWN_EXTERNAL_MODULE_NAME;
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        VirtualFileSystem jarFileSystem = VirtualFileManager.getInstance().getFileSystem("jar");
        PsiManager psiManager = PsiManager.getInstance(this.getProject());
        for (String path : this.files) {
            VirtualFile file;
            if (path.charAt(0) == '@') {
                moduleName = path.substring(1);
                continue;
            }
            String actualModuleName = moduleName;
            if (path.endsWith(".jar") || path.endsWith(".zip")) {
                file = jarFileSystem.findFileByPath(path + "!/");
                if (LibraryUtils.isJsRuntimeLibrary(new File(path))) {
                    actualModuleName = STDLIB_JS_MODULE_NAME;
                }
            } else {
                file = fileSystem.findFileByPath(path);
            }
            if (file == null) {
                LOG.error("File '" + path + "' not found.'");
                continue;
            }
            JetFileCollector jetFileCollector = new JetFileCollector(jetFiles, actualModuleName, psiManager);
            VfsUtilCore.visitChildrenRecursively(file, jetFileCollector);
        }
        ArrayList<JetFile> arrayList = jetFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/LibrarySourcesConfig", "generateLibFiles"));
        }
        return arrayList;
    }

    protected JetFile getJetFileByVirtualFile(VirtualFile file, String moduleName, PsiManager psiManager) {
        PsiFile psiFile = psiManager.findFile(file);
        assert (psiFile != null);
        LibrarySourcesConfig.setupPsiFile(psiFile, moduleName);
        return (JetFile)psiFile;
    }

    protected static void setupPsiFile(PsiFile psiFile, String moduleName) {
        psiFile.putUserData(EXTERNAL_MODULE_NAME, moduleName);
    }

    private class JetFileCollector
    extends VirtualFileVisitor {
        private final List<JetFile> jetFiles;
        private final String moduleName;
        private final PsiManager psiManager;

        private JetFileCollector(List<JetFile> files, String name, PsiManager manager) {
            super(new VirtualFileVisitor.Option[0]);
            this.moduleName = name;
            this.psiManager = manager;
            this.jetFiles = files;
        }

        @Override
        public boolean visitFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/k2js/config/LibrarySourcesConfig$JetFileCollector", "visitFile"));
            }
            if (!file.isDirectory() && StringUtil.notNullize(file.getExtension()).equalsIgnoreCase("kt")) {
                this.jetFiles.add(LibrarySourcesConfig.this.getJetFileByVirtualFile(file, this.moduleName, this.psiManager));
            }
            return true;
        }
    }
}

