/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.BuiltinsPackageFragment;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public class KotlinBuiltIns {
    public static final Name BUILT_INS_PACKAGE_NAME = Name.identifier("kotlin");
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
    public static final int FUNCTION_TRAIT_COUNT = 23;
    private static volatile KotlinBuiltIns instance = null;
    private static volatile boolean initializing;
    private static Throwable initializationFailed;
    private final ModuleDescriptorImpl builtInsModule;
    private final BuiltinsPackageFragment builtinsPackageFragment;
    private final Set<ClassDescriptor> nonPhysicalClasses;
    private final Map<PrimitiveType, JetType> primitiveTypeToNullableJetType;
    private final Map<PrimitiveType, JetType> primitiveTypeToArrayJetType;
    private final Map<JetType, JetType> primitiveJetTypeToJetArrayType;
    private final Map<JetType, JetType> jetArrayTypeToPrimitiveJetType;
    private final FqNames fqNames = new FqNames();

    private static synchronized void initialize() {
        if (instance == null) {
            if (initializationFailed != null) {
                throw new RuntimeException("builtin library initialization failed previously: " + initializationFailed, initializationFailed);
            }
            if (initializing) {
                throw new IllegalStateException("builtin library initialization loop");
            }
            initializing = true;
            try {
                instance = new KotlinBuiltIns();
                instance.doInitialize();
            }
            catch (Throwable e) {
                initializationFailed = e;
                throw new RuntimeException("builtin library initialization failed: " + e, e);
            }
            finally {
                initializing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static KotlinBuiltIns getInstance() {
        if (initializing) {
            Class<KotlinBuiltIns> clazz = KotlinBuiltIns.class;
            synchronized (KotlinBuiltIns.class) {
                assert (instance != null) : "Built-ins are not initialized (note: We are under the same lock as initializing and instance)";
                KotlinBuiltIns kotlinBuiltIns = instance;
                // ** MonitorExit[var0] (shouldn't be in output)
                if (kotlinBuiltIns == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getInstance"));
                }
                return kotlinBuiltIns;
            }
        }
        if (instance == null) {
            KotlinBuiltIns.initialize();
        }
        KotlinBuiltIns kotlinBuiltIns = instance;
        if (kotlinBuiltIns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getInstance"));
        }
        return kotlinBuiltIns;
    }

    private KotlinBuiltIns() {
        this.builtInsModule = new ModuleDescriptorImpl(Name.special("<built-ins lazy module>"), Collections.emptyList(), PlatformToKotlinClassMap.EMPTY);
        this.builtinsPackageFragment = new BuiltinsPackageFragment(new LockBasedStorageManager(), this.builtInsModule);
        this.builtInsModule.initialize(this.builtinsPackageFragment.getProvider());
        this.builtInsModule.addDependencyOnModule(this.builtInsModule);
        this.builtInsModule.seal();
        this.primitiveTypeToNullableJetType = new EnumMap<PrimitiveType, JetType>(PrimitiveType.class);
        this.primitiveTypeToArrayJetType = new EnumMap<PrimitiveType, JetType>(PrimitiveType.class);
        this.primitiveJetTypeToJetArrayType = new HashMap<JetType, JetType>();
        this.jetArrayTypeToPrimitiveJetType = new HashMap<JetType, JetType>();
        this.nonPhysicalClasses = new HashSet<ClassDescriptor>();
    }

    private void doInitialize() {
        for (PrimitiveType primitive : PrimitiveType.values()) {
            this.makePrimitive(primitive);
        }
        this.computeNonPhysicalClasses();
    }

    private void makePrimitive(@NotNull PrimitiveType primitiveType) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "makePrimitive"));
        }
        JetType type2 = this.getBuiltInTypeByClassName(primitiveType.getTypeName().asString());
        JetType arrayType = this.getBuiltInTypeByClassName(primitiveType.getArrayTypeName().asString());
        this.primitiveTypeToNullableJetType.put(primitiveType, TypeUtils.makeNullable(type2));
        this.primitiveTypeToArrayJetType.put(primitiveType, arrayType);
        this.primitiveJetTypeToJetArrayType.put(type2, arrayType);
        this.jetArrayTypeToPrimitiveJetType.put(arrayType, type2);
    }

    @NotNull
    public ModuleDescriptorImpl getBuiltInsModule() {
        ModuleDescriptorImpl moduleDescriptorImpl = this.builtInsModule;
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInsModule"));
        }
        return moduleDescriptorImpl;
    }

    @NotNull
    public PackageFragmentDescriptor getBuiltInsPackageFragment() {
        BuiltinsPackageFragment builtinsPackageFragment = this.builtinsPackageFragment;
        if (builtinsPackageFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInsPackageFragment"));
        }
        return builtinsPackageFragment;
    }

    @NotNull
    public JetScope getBuiltInsPackageScope() {
        DeserializedPackageMemberScope deserializedPackageMemberScope = this.builtinsPackageFragment.getMemberScope();
        if (deserializedPackageMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInsPackageScope"));
        }
        return deserializedPackageMemberScope;
    }

    @NotNull
    public ClassDescriptor getBuiltInClassByName(@NotNull Name simpleName) {
        if (simpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        ClassifierDescriptor classifier2 = this.getBuiltInsPackageFragment().getMemberScope().getClassifier(simpleName);
        assert (classifier2 instanceof ClassDescriptor) : "Must be a class descriptor " + simpleName + ", but was " + classifier2;
        ClassDescriptor classDescriptor = (ClassDescriptor)classifier2;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        return classDescriptor;
    }

    @NotNull
    private ClassDescriptor getBuiltInClassByName(@NotNull String simpleName) {
        if (simpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(Name.identifier(simpleName));
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getAny() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Any");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAny"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getNothing() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Nothing");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNothing"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getPrimitiveClassDescriptor(@NotNull PrimitiveType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveClassDescriptor"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(type2.getTypeName().asString());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getByte() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.BYTE);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getByte"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getShort() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.SHORT);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getShort"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getInt() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.INT);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getInt"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getLong() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.LONG);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getLong"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getFloat() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.FLOAT);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFloat"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getDouble() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.DOUBLE);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDouble"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getChar() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.CHAR);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getChar"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getBoolean() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.BOOLEAN);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBoolean"));
        }
        return classDescriptor;
    }

    @NotNull
    public Set<DeclarationDescriptor> getIntegralRanges() {
        Set<DeclarationDescriptor> set = KotlinPackage.setOf(this.getBuiltInClassByName("ByteRange"), this.getBuiltInClassByName("ShortRange"), this.getBuiltInClassByName("CharRange"), this.getBuiltInClassByName("IntRange"));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getIntegralRanges"));
        }
        return set;
    }

    @NotNull
    public ClassDescriptor getArray() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Array");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArray"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getPrimitiveArrayClassDescriptor(@NotNull PrimitiveType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayClassDescriptor"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(type2.getArrayTypeName().asString());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getNumber() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Number");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNumber"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getUnit() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Unit");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getUnit"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getFunction(int parameterCount) {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Function" + parameterCount);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getExtensionFunction(int parameterCount) {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("ExtensionFunction" + parameterCount);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getExtensionFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getThrowable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Throwable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getThrowable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getCloneable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Cloneable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCloneable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getDataClassAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("data");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDataClassAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getNoinlineClassAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("noinline");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNoinlineClassAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getInlineClassAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("inline");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getInlineClassAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getInlineOptionsClassAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("inlineOptions");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getInlineOptionsClassAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getTailRecursiveAnnotationClass() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("tailRecursive");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getTailRecursiveAnnotationClass"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getDeprecatedAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("deprecated");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDeprecatedAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getString() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("String");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getString"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getCharSequence() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("CharSequence");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCharSequence"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getComparable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Comparable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getComparable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getEnum() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Enum");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getEnum"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Annotation");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Iterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getIterable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Iterable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getIterable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableIterable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableIterable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableIterable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableIterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getCollection() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Collection");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCollection"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableCollection() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableCollection");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableCollection"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getList() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("List");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getList"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableList() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableList");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableList"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getSet() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Set");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getSet"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableSet() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableSet");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableSet"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMap() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Map");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMap"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableMap() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableMap");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableMap"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getMap(), "Entry");
        assert (classDescriptor != null) : "Can't find Map.Entry";
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMapEntry"));
        }
        return classDescriptor2;
    }

    @NotNull
    public ClassDescriptor getMutableMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getMutableMap(), "MutableEntry");
        assert (classDescriptor != null) : "Can't find MutableMap.MutableEntry";
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableMapEntry"));
        }
        return classDescriptor2;
    }

    @NotNull
    public ClassDescriptor getListIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("ListIterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getListIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableListIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableListIterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableListIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public Set<ClassDescriptor> getNonPhysicalClasses() {
        Set<ClassDescriptor> set = Collections.unmodifiableSet(this.nonPhysicalClasses);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNonPhysicalClasses"));
        }
        return set;
    }

    private void computeNonPhysicalClasses() {
        this.nonPhysicalClasses.addAll(Arrays.asList(this.getAny(), this.getNothing(), this.getNumber(), this.getString(), this.getCharSequence(), this.getThrowable(), this.getIterator(), this.getIterable(), this.getCollection(), this.getList(), this.getListIterator(), this.getSet(), this.getMap(), this.getMapEntry(), this.getMutableIterator(), this.getMutableIterable(), this.getMutableCollection(), this.getMutableList(), this.getMutableListIterator(), this.getMutableSet(), this.getMutableMap(), this.getMutableMapEntry(), this.getDataClassAnnotation(), this.getAnnotation(), this.getComparable(), this.getEnum(), this.getArray()));
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            this.nonPhysicalClasses.add(this.getPrimitiveClassDescriptor(primitiveType));
            this.nonPhysicalClasses.add(this.getPrimitiveArrayClassDescriptor(primitiveType));
        }
    }

    @NotNull
    private JetType getBuiltInTypeByClassName(@NotNull String classSimpleName) {
        if (classSimpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classSimpleName", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInTypeByClassName"));
        }
        JetType jetType = this.getBuiltInClassByName(classSimpleName).getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInTypeByClassName"));
        }
        return jetType;
    }

    @NotNull
    public JetType getNothingType() {
        JetType jetType = this.getNothing().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNothingType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getNullableNothingType() {
        JetType jetType = TypeUtils.makeNullable(this.getNothingType());
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNullableNothingType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getAnyType() {
        JetType jetType = this.getAny().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAnyType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getNullableAnyType() {
        JetType jetType = TypeUtils.makeNullable(this.getAnyType());
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNullableAnyType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getPrimitiveJetType(@NotNull PrimitiveType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveJetType"));
        }
        JetType jetType = this.getPrimitiveClassDescriptor(type2).getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveJetType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getNullablePrimitiveJetType(@NotNull PrimitiveType primitiveType) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNullablePrimitiveJetType"));
        }
        JetType jetType = this.primitiveTypeToNullableJetType.get((Object)primitiveType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNullablePrimitiveJetType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getByteType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.BYTE);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getByteType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getShortType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.SHORT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getShortType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getIntType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.INT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getIntType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getLongType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.LONG);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getLongType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getFloatType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.FLOAT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFloatType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getDoubleType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.DOUBLE);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDoubleType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getCharType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.CHAR);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCharType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getBooleanType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.BOOLEAN);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBooleanType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getUnitType() {
        JetType jetType = this.getUnit().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getUnitType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getStringType() {
        JetType jetType = this.getString().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getStringType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getArrayElementType(@NotNull JetType arrayType) {
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayElementType"));
        }
        if (arrayType.getConstructor().getDeclarationDescriptor() == this.getArray()) {
            if (arrayType.getArguments().size() != 1) {
                throw new IllegalStateException();
            }
            JetType jetType = arrayType.getArguments().get(0).getType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayElementType"));
            }
            return jetType;
        }
        JetType primitiveType = this.jetArrayTypeToPrimitiveJetType.get(TypeUtils.makeNotNullable(arrayType));
        if (primitiveType == null) {
            throw new IllegalStateException("not array: " + arrayType);
        }
        JetType jetType = primitiveType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayElementType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getPrimitiveArrayJetType(@NotNull PrimitiveType primitiveType) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayJetType"));
        }
        JetType jetType = this.primitiveTypeToArrayJetType.get((Object)primitiveType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayJetType"));
        }
        return jetType;
    }

    @Nullable
    public JetType getPrimitiveArrayJetTypeByPrimitiveJetType(@NotNull JetType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayJetTypeByPrimitiveJetType"));
        }
        return this.primitiveJetTypeToJetArrayType.get(jetType);
    }

    @NotNull
    public JetType getArrayType(@NotNull Variance projectionType, @NotNull JetType argument) {
        if (projectionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        List<TypeProjectionImpl> types = Collections.singletonList(new TypeProjectionImpl(projectionType, argument));
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Annotations.EMPTY, this.getArray().getTypeConstructor(), false, types, this.getArray().getMemberScope(types));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public JetType getArrayType(@NotNull JetType argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        JetType jetType = this.getArrayType(Variance.INVARIANT, argument);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getEnumType(@NotNull JetType argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getEnumType"));
        }
        Variance projectionType = Variance.INVARIANT;
        List<TypeProjectionImpl> types = Collections.singletonList(new TypeProjectionImpl(projectionType, argument));
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Annotations.EMPTY, this.getEnum().getTypeConstructor(), false, types, this.getEnum().getMemberScope(types));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getEnumType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public JetType getAnnotationType() {
        JetType jetType = this.getAnnotation().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAnnotationType"));
        }
        return jetType;
    }

    @NotNull
    public ClassDescriptor getPropertyMetadata() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("PropertyMetadata");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPropertyMetadata"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getPropertyMetadataImpl() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("PropertyMetadataImpl");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPropertyMetadataImpl"));
        }
        return classDescriptor;
    }

    @NotNull
    public JetType getFunctionType(@NotNull Annotations annotations2, @Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionType"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionType"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionType"));
        }
        List<TypeProjection> arguments2 = KotlinBuiltIns.getFunctionTypeArgumentProjections(receiverType, parameterTypes, returnType);
        int size = parameterTypes.size();
        ClassDescriptor classDescriptor = receiverType == null ? this.getFunction(size) : this.getExtensionFunction(size);
        TypeConstructor constructor2 = classDescriptor.getTypeConstructor();
        JetTypeImpl jetTypeImpl = new JetTypeImpl(annotations2, constructor2, false, arguments2, classDescriptor.getMemberScope(arguments2));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public static List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionTypeArgumentProjections"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionTypeArgumentProjections"));
        }
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>();
        if (receiverType != null) {
            arguments2.add(KotlinBuiltIns.defaultProjection(receiverType));
        }
        for (JetType parameterType : parameterTypes) {
            arguments2.add(KotlinBuiltIns.defaultProjection(parameterType));
        }
        arguments2.add(KotlinBuiltIns.defaultProjection(returnType));
        ArrayList<TypeProjection> arrayList = arguments2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionTypeArgumentProjections"));
        }
        return arrayList;
    }

    private static TypeProjection defaultProjection(JetType returnType) {
        return new TypeProjectionImpl(Variance.INVARIANT, returnType);
    }

    public boolean isArray(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isArray"));
        }
        return this.getArray().equals(type2.getConstructor().getDeclarationDescriptor());
    }

    public boolean isPrimitiveArray(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isPrimitiveArray"));
        }
        return this.jetArrayTypeToPrimitiveJetType.containsKey(TypeUtils.makeNotNullable(type2));
    }

    public boolean isPrimitiveType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isPrimitiveType"));
        }
        return this.primitiveJetTypeToJetArrayType.containsKey(type2);
    }

    public boolean isFunctionOrExtensionFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isFunctionOrExtensionFunctionType"));
        }
        return this.isFunctionType(type2) || this.isExtensionFunctionType(type2);
    }

    public boolean isFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isFunctionType"));
        }
        if (this.isExactFunctionType(type2)) {
            return true;
        }
        for (JetType superType : type2.getConstructor().getSupertypes()) {
            if (!this.isFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isExtensionFunctionType"));
        }
        if (this.isExactExtensionFunctionType(type2)) {
            return true;
        }
        for (JetType superType : type2.getConstructor().getSupertypes()) {
            if (!this.isExtensionFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    public boolean isExactFunctionOrExtensionFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isExactFunctionOrExtensionFunctionType"));
        }
        return this.isExactFunctionType(type2) || this.isExactExtensionFunctionType(type2);
    }

    public boolean isExactFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isExactFunctionType"));
        }
        return KotlinBuiltIns.isTypeConstructorFqNameInSet(type2, this.fqNames.functionClasses);
    }

    public boolean isExactExtensionFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isExactExtensionFunctionType"));
        }
        return KotlinBuiltIns.isTypeConstructorFqNameInSet(type2, this.fqNames.extensionFunctionClasses);
    }

    private static boolean isTypeConstructorFqNameInSet(@NotNull JetType type2, @NotNull Set<FqNameUnsafe> classes2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isTypeConstructorFqNameInSet"));
        }
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isTypeConstructorFqNameInSet"));
        }
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor == null) {
            return false;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(declarationDescriptor);
        return classes2.contains(fqName2);
    }

    @Nullable
    public JetType getReceiverType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getReceiverType"));
        }
        assert (this.isFunctionOrExtensionFunctionType(type2)) : type2;
        if (this.isExtensionFunctionType(type2)) {
            return type2.getArguments().get(0).getType();
        }
        return null;
    }

    @NotNull
    public List<ValueParameterDescriptor> getValueParameters(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetType type2) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getValueParameters"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getValueParameters"));
        }
        assert (this.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> parameterTypes = this.getParameterTypeProjectionsFromFunctionType(type2);
        ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(parameterTypes.size());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeProjection parameterType = parameterTypes.get(i);
            ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, null, i, Annotations.EMPTY, Name.identifier("p" + (i + 1)), parameterType.getType(), false, null, SourceElement.NO_SOURCE);
            valueParameters.add(valueParameterDescriptor);
        }
        ArrayList<ValueParameterDescriptor> arrayList = valueParameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getValueParameters"));
        }
        return arrayList;
    }

    @NotNull
    public JetType getReturnTypeFromFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getReturnTypeFromFunctionType"));
        }
        assert (this.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> arguments2 = type2.getArguments();
        JetType jetType = arguments2.get(arguments2.size() - 1).getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getReturnTypeFromFunctionType"));
        }
        return jetType;
    }

    @NotNull
    public List<TypeProjection> getParameterTypeProjectionsFromFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getParameterTypeProjectionsFromFunctionType"));
        }
        assert (this.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> arguments2 = type2.getArguments();
        int first = this.isExtensionFunctionType(type2) ? 1 : 0;
        int last = arguments2.size() - 2;
        ArrayList<TypeProjection> parameterTypes = new ArrayList<TypeProjection>(last - first + 1);
        for (int i = first; i <= last; ++i) {
            parameterTypes.add(arguments2.get(i));
        }
        ArrayList<TypeProjection> arrayList = parameterTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getParameterTypeProjectionsFromFunctionType"));
        }
        return arrayList;
    }

    public boolean isSpecialClassWithNoSupertypes(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isSpecialClassWithNoSupertypes"));
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor);
        return this.fqNames.any.equals(fqName2) || this.fqNames.nothing.equals(fqName2);
    }

    public boolean isAny(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isAny"));
        }
        return this.fqNames.any.equals(DescriptorUtils.getFqName(descriptor));
    }

    public boolean isNothing(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isNothing"));
        }
        return this.isNothingOrNullableNothing(type2) && !type2.isNullable();
    }

    public boolean isNullableNothing(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isNullableNothing"));
        }
        return this.isNothingOrNullableNothing(type2) && type2.isNullable();
    }

    public boolean isNothingOrNullableNothing(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isNothingOrNullableNothing"));
        }
        return type2.getConstructor() == this.getNothing().getTypeConstructor();
    }

    public boolean isAnyOrNullableAny(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isAnyOrNullableAny"));
        }
        return type2.getConstructor() == this.getAny().getTypeConstructor();
    }

    public boolean isUnit(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isUnit"));
        }
        return ((Object)type2).equals(this.getUnitType());
    }

    public boolean isString(@Nullable JetType type2) {
        return ((Object)this.getStringType()).equals(type2);
    }

    public boolean isCloneable(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isCloneable"));
        }
        return this.fqNames.cloneable.equals(DescriptorUtils.getFqName(descriptor));
    }

    public boolean isData(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isData"));
        }
        return KotlinBuiltIns.containsAnnotation(classDescriptor, this.getDataClassAnnotation());
    }

    public boolean isDeprecated(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isDeprecated"));
        }
        return KotlinBuiltIns.containsAnnotation(declarationDescriptor, this.getDeprecatedAnnotation());
    }

    public boolean isTailRecursive(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isTailRecursive"));
        }
        return KotlinBuiltIns.containsAnnotation(declarationDescriptor, this.getTailRecursiveAnnotationClass());
    }

    public boolean isSuppressAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        if (annotationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isSuppressAnnotation"));
        }
        ClassifierDescriptor classifier2 = annotationDescriptor.getType().getConstructor().getDeclarationDescriptor();
        return classifier2 != null && this.fqNames.suppress.equals(DescriptorUtils.getFqName(classifier2));
    }

    static boolean containsAnnotation(DeclarationDescriptor descriptor, ClassDescriptor annotationClass) {
        FqName fqName2 = DescriptorUtils.getFqName(annotationClass).toSafe();
        return descriptor.getOriginal().getAnnotations().findAnnotation(fqName2) != null;
    }

    @NotNull
    public JetType getDefaultBound() {
        JetType jetType = this.getNullableAnyType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDefaultBound"));
        }
        return jetType;
    }

    @NotNull
    public FunctionDescriptor getIdentityEquals() {
        FunctionDescriptor functionDescriptor = KotlinPackage.first(this.getBuiltInsPackageFragment().getMemberScope().getFunctions(Name.identifier("identityEquals")));
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getIdentityEquals"));
        }
        return functionDescriptor;
    }

    private static class FqNames {
        public final FqNameUnsafe any = FqNames.fqName("Any");
        public final FqNameUnsafe nothing = FqNames.fqName("Nothing");
        public final FqNameUnsafe cloneable = FqNames.fqName("Cloneable");
        public final FqNameUnsafe suppress = FqNames.fqName("suppress");
        public final Set<FqNameUnsafe> functionClasses = FqNames.computeIndexedFqNames("Function", 23);
        public final Set<FqNameUnsafe> extensionFunctionClasses = FqNames.computeIndexedFqNames("ExtensionFunction", 23);

        private FqNames() {
        }

        @NotNull
        private static FqNameUnsafe fqName(@NotNull String simpleName) {
            if (simpleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns$FqNames", "fqName"));
            }
            FqNameUnsafe fqNameUnsafe = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName)).toUnsafe();
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns$FqNames", "fqName"));
            }
            return fqNameUnsafe;
        }

        @NotNull
        private static Set<FqNameUnsafe> computeIndexedFqNames(@NotNull String prefix, int count) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns$FqNames", "computeIndexedFqNames"));
            }
            HashSet<FqNameUnsafe> result2 = new HashSet<FqNameUnsafe>();
            for (int i = 0; i < count; ++i) {
                result2.add(FqNames.fqName(prefix + i));
            }
            HashSet<FqNameUnsafe> hashSet = result2;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns$FqNames", "computeIndexedFqNames"));
            }
            return hashSet;
        }
    }
}

