/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.SmartCastUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.types.Approximation;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.TypesPackage;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class DataFlowUtils {
    private DataFlowUtils() {
    }

    @NotNull
    public static DataFlowInfo extractDataFlowInfoFromCondition(@Nullable JetExpression condition, final boolean conditionValue, final ExpressionTypingContext context2) {
        if (condition == null) {
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "extractDataFlowInfoFromCondition"));
            }
            return dataFlowInfo;
        }
        final Ref<Object> result2 = new Ref<Object>(null);
        condition.accept(new JetVisitorVoid(){

            @Override
            public void visitIsExpression(@NotNull JetIsExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils$1", "visitIsExpression"));
                }
                if (conditionValue && !expression.isNegated() || !conditionValue && expression.isNegated()) {
                    result2.set(context2.trace.get(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression));
                }
            }

            @Override
            public void visitBinaryExpression(@NotNull JetBinaryExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils$1", "visitBinaryExpression"));
                }
                IElementType operationToken = expression.getOperationToken();
                if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken)) {
                    DataFlowInfo dataFlowInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expression.getLeft(), conditionValue, context2);
                    JetExpression expressionRight = expression.getRight();
                    if (expressionRight != null) {
                        DataFlowInfo rightInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expressionRight, conditionValue, context2);
                        boolean and = operationToken == JetTokens.ANDAND;
                        dataFlowInfo = and == conditionValue ? dataFlowInfo.and(rightInfo) : dataFlowInfo.or(rightInfo);
                    }
                    result2.set(dataFlowInfo);
                } else {
                    JetExpression left = expression.getLeft();
                    if (left == null) {
                        return;
                    }
                    JetExpression right = expression.getRight();
                    if (right == null) {
                        return;
                    }
                    JetType lhsType = context2.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, left);
                    if (lhsType == null) {
                        return;
                    }
                    JetType rhsType = context2.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, right);
                    if (rhsType == null) {
                        return;
                    }
                    BindingContext bindingContext = context2.trace.getBindingContext();
                    DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, lhsType, bindingContext);
                    DataFlowValue rightValue = DataFlowValueFactory.createDataFlowValue(right, rhsType, bindingContext);
                    Boolean equals = null;
                    if (operationToken == JetTokens.EQEQ || operationToken == JetTokens.EQEQEQ) {
                        equals = true;
                    } else if (operationToken == JetTokens.EXCLEQ || operationToken == JetTokens.EXCLEQEQEQ) {
                        equals = false;
                    }
                    if (equals != null) {
                        if (equals == conditionValue) {
                            result2.set(context2.dataFlowInfo.equate(leftValue, rightValue));
                        } else {
                            result2.set(context2.dataFlowInfo.disequate(leftValue, rightValue));
                        }
                    }
                }
            }

            @Override
            public void visitUnaryExpression(@NotNull JetUnaryExpression expression) {
                JetExpression baseExpression;
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils$1", "visitUnaryExpression"));
                }
                IElementType operationTokenType = expression.getOperationReference().getReferencedNameElementType();
                if (operationTokenType == JetTokens.EXCL && (baseExpression = expression.getBaseExpression()) != null) {
                    result2.set(DataFlowUtils.extractDataFlowInfoFromCondition(baseExpression, !conditionValue, context2));
                }
            }

            @Override
            public void visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils$1", "visitParenthesizedExpression"));
                }
                JetExpression body = expression.getExpression();
                if (body != null) {
                    body.accept(this);
                }
            }
        });
        if (result2.get() == null) {
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "extractDataFlowInfoFromCondition"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo.and(result2.get());
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "extractDataFlowInfoFromCondition"));
        }
        return dataFlowInfo;
    }

    @NotNull
    public static JetTypeInfo checkType(@Nullable JetType expressionType, @NotNull JetExpression expression, @NotNull ResolutionContext context2, @NotNull DataFlowInfo dataFlowInfo) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(DataFlowUtils.checkType(expressionType, expression, context2), dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public static JetTypeInfo checkType(@NotNull JetTypeInfo typeInfo, @NotNull JetExpression expression, @NotNull ResolutionContext context2) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        JetType type2 = DataFlowUtils.checkType(typeInfo.getType(), expression, context2);
        if (type2 == typeInfo.getType()) {
            JetTypeInfo jetTypeInfo = typeInfo;
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(type2, typeInfo.getDataFlowInfo());
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public static JetType checkType(@Nullable JetType expressionType, @NotNull JetExpression expression, @NotNull ResolutionContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        return DataFlowUtils.checkType(expressionType, expression, context2.expectedType, context2.dataFlowInfo, context2.trace);
    }

    @Nullable
    public static JetType checkType(@Nullable JetType expressionType, @NotNull JetExpression expressionToCheck, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        return DataFlowUtils.checkType(expressionType, expressionToCheck, expectedType, dataFlowInfo, trace, null);
    }

    @Nullable
    public static JetType checkType(final @Nullable JetType expressionType, @NotNull JetExpression expressionToCheck, @NotNull JetType expectedType, final @NotNull DataFlowInfo dataFlowInfo, final @NotNull BindingTrace trace, @Nullable Ref<Boolean> hasError) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkType"));
        }
        if (hasError != null) {
            hasError.set(false);
        }
        final JetExpression expression = JetPsiUtil.safeDeparenthesize(expressionToCheck, false);
        DataFlowUtils.recordExpectedType(trace, expression, expectedType);
        if (expressionType == null) {
            return null;
        }
        if (TypeUtils.noExpectedType(expectedType) || !expectedType.getConstructor().isDenotable() || JetTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType)) {
            Approximation.Info approximationInfo;
            if (!TypeUtils.noExpectedType(expectedType) && (approximationInfo = TypesPackage.getApproximationTo(expressionType, expectedType, new Approximation.DataFlowExtras(){

                private DataFlowValue getDataFlowValue() {
                    return DataFlowValueFactory.createDataFlowValue(expression, expressionType, trace.getBindingContext());
                }

                @Override
                public boolean getCanBeNull() {
                    return dataFlowInfo.getNullability(this.getDataFlowValue()).canBeNull();
                }

                @Override
                @NotNull
                public Set<JetType> getPossibleTypes() {
                    Set<JetType> set = dataFlowInfo.getPossibleTypes(this.getDataFlowValue());
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils$2", "getPossibleTypes"));
                    }
                    return set;
                }

                @Override
                @NotNull
                public String getPresentableText() {
                    String string = StringUtil.trimMiddle(expression.getText(), 50);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils$2", "getPresentableText"));
                    }
                    return string;
                }
            })) != null) {
                trace.record(BindingContext.EXPRESSION_RESULT_APPROXIMATION, expression, approximationInfo);
            }
            return expressionType;
        }
        if (expression instanceof JetConstantExpression) {
            CompileTimeConstant<? extends Object> value = ConstantExpressionEvaluator.OBJECT$.evaluate(expression, trace, expectedType);
            if (value instanceof IntegerValueTypeConstant) {
                value = EvaluatePackage.createCompileTimeConstantWithType((IntegerValueTypeConstant)value, expectedType);
            }
            boolean error = new CompileTimeConstantChecker(trace, true).checkConstantExpressionType(value, (JetConstantExpression)expression, expectedType);
            if (hasError != null) {
                hasError.set(error);
            }
            return expressionType;
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, expressionType, trace.getBindingContext());
        for (JetType possibleType : dataFlowInfo.getPossibleTypes(dataFlowValue)) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(possibleType, expectedType)) continue;
            SmartCastUtils.recordCastOrError(expression, possibleType, trace, dataFlowValue.isStableIdentifier(), false);
            return possibleType;
        }
        trace.report(Errors.TYPE_MISMATCH.on(expression, expectedType, expressionType));
        if (hasError != null) {
            hasError.set(true);
        }
        return expressionType;
    }

    public static void recordExpectedType(@NotNull BindingTrace trace, @NotNull JetExpression expression, @NotNull JetType expectedType) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "recordExpectedType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "recordExpectedType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "recordExpectedType"));
        }
        if (expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            JetType normalizeExpectedType = expectedType == TypeUtils.UNIT_EXPECTED_TYPE ? KotlinBuiltIns.getInstance().getUnitType() : expectedType;
            trace.record(BindingContext.EXPECTED_EXPRESSION_TYPE, expression, normalizeExpectedType);
        }
    }

    @NotNull
    public static JetTypeInfo checkStatementType(@NotNull JetExpression expression, @NotNull ResolutionContext context2, @NotNull DataFlowInfo dataFlowInfo) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkStatementType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkStatementType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkStatementType"));
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(DataFlowUtils.checkStatementType(expression, context2), dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkStatementType"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public static JetType checkStatementType(@NotNull JetExpression expression, @NotNull ResolutionContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkStatementType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkStatementType"));
        }
        if (!(TypeUtils.noExpectedType(context2.expectedType) || KotlinBuiltIns.getInstance().isUnit(context2.expectedType) || context2.expectedType.isError())) {
            context2.trace.report(Errors.EXPECTED_TYPE_MISMATCH.on(expression, context2.expectedType));
            return null;
        }
        return KotlinBuiltIns.getInstance().getUnitType();
    }

    @NotNull
    public static JetTypeInfo checkImplicitCast(@Nullable JetType expressionType, @NotNull JetExpression expression, @NotNull ExpressionTypingContext context2, boolean isStatement, DataFlowInfo dataFlowInfo) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(DataFlowUtils.checkImplicitCast(expressionType, expression, context2, isStatement), dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public static JetType checkImplicitCast(@Nullable JetType expressionType, @NotNull JetExpression expression, @NotNull ExpressionTypingContext context2, boolean isStatement) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "checkImplicitCast"));
        }
        if (expressionType != null && context2.expectedType == TypeUtils.NO_EXPECTED_TYPE && context2.contextDependency == ContextDependency.INDEPENDENT && !isStatement && (KotlinBuiltIns.getInstance().isUnit(expressionType) || KotlinBuiltIns.getInstance().isAnyOrNullableAny(expressionType))) {
            context2.trace.report(Errors.IMPLICIT_CAST_TO_UNIT_OR_ANY.on(expression, expressionType));
        }
        return expressionType;
    }

    @NotNull
    public static JetTypeInfo illegalStatementType(@NotNull JetExpression expression, @NotNull ExpressionTypingContext context2, @NotNull ExpressionTypingInternals facade) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "illegalStatementType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "illegalStatementType"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "illegalStatementType"));
        }
        facade.checkStatementType(expression, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        context2.trace.report(Errors.EXPRESSION_EXPECTED.on(expression, expression));
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "illegalStatementType"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public static Collection<JetType> getAllPossibleTypes(@NotNull JetExpression expression, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType type2, @NotNull BindingContext bindingContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, bindingContext);
        HashSet<JetType> possibleTypes = Sets.newHashSet(type2);
        if (dataFlowValue.isStableIdentifier()) {
            possibleTypes.addAll(dataFlowInfo.getPossibleTypes(dataFlowValue));
        }
        HashSet<JetType> hashSet = possibleTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/DataFlowUtils", "getAllPossibleTypes"));
        }
        return hashSet;
    }
}

