/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Function0;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.source.SourcePackage;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.LocalClassifierAnalyzer;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ClosureExpressionsTypingVisitor
extends ExpressionTypingVisitor {
    protected ClosureExpressionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @Override
    public JetTypeInfo visitObjectLiteralExpression(final @NotNull JetObjectLiteralExpression expression, final ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "visitObjectLiteralExpression"));
        }
        DelegatingBindingTrace delegatingBindingTrace = context2.trace.get(BindingContext.TRACE_DELTAS_CACHE, expression.getObjectDeclaration());
        if (delegatingBindingTrace != null) {
            delegatingBindingTrace.addAllMyDataTo(context2.trace);
            JetType type2 = context2.trace.get(BindingContext.EXPRESSION_TYPE, expression);
            return DataFlowUtils.checkType(type2, expression, context2, context2.dataFlowInfo);
        }
        final JetType[] result2 = new JetType[1];
        final TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve object literal expression", expression);
        ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor> handler = new ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<PsiElement, ClassDescriptor> slice, PsiElement declaration, final ClassDescriptor descriptor) {
                if (slice == BindingContext.CLASS && declaration == expression.getObjectDeclaration()) {
                    DeferredType defaultType = DeferredType.createRecursionIntolerant(ClosureExpressionsTypingVisitor.this.components.globalContext.getStorageManager(), context2.trace, new Function0<JetType>(){

                        @Override
                        public JetType invoke() {
                            return descriptor.getDefaultType();
                        }
                    });
                    result2[0] = defaultType;
                    if (!context2.trace.get(BindingContext.PROCESSED, expression).booleanValue()) {
                        temporaryTrace.record(BindingContext.EXPRESSION_TYPE, expression, defaultType);
                        temporaryTrace.record(BindingContext.PROCESSED, expression);
                    }
                }
            }
        };
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, handler);
        LocalClassifierAnalyzer.processClassOrObject(this.components.globalContext, null, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceBindingTrace(traceAdapter)).replaceContextDependency(ContextDependency.INDEPENDENT), context2.scope.getContainingDeclaration(), expression.getObjectDeclaration(), this.components.additionalCheckerProvider);
        DelegatingBindingTrace cloneDelta = new DelegatingBindingTrace(new BindingTraceContext().getBindingContext(), "cached delta trace for object literal expression resolve", expression);
        temporaryTrace.addAllMyDataTo(cloneDelta);
        context2.trace.record(BindingContext.TRACE_DELTAS_CACHE, expression.getObjectDeclaration(), cloneDelta);
        temporaryTrace.commit();
        return DataFlowUtils.checkType(result2[0], expression, context2, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "visitFunctionLiteralExpression"));
        }
        if (!expression.getFunctionLiteral().hasBody()) {
            return null;
        }
        JetType expectedType = context2.expectedType;
        boolean functionTypeExpected = !TypeUtils.noExpectedType(expectedType) && KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionDescriptor(expression, context2, functionTypeExpected);
        JetType safeReturnType = this.computeReturnType(expression, context2, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        JetType receiver = DescriptorUtils.getReceiverParameterType(functionDescriptor.getExtensionReceiverParameter());
        List<JetType> valueParametersTypes = ExpressionTypingUtils.getValueParametersTypes(functionDescriptor.getValueParameters());
        JetType resultType = KotlinBuiltIns.getInstance().getFunctionType(Annotations.EMPTY, receiver, valueParametersTypes, safeReturnType);
        if (!TypeUtils.noExpectedType(expectedType) && KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(expectedType)) {
            return JetTypeInfo.create(resultType, context2.dataFlowInfo);
        }
        return DataFlowUtils.checkType(resultType, expression, context2, context2.dataFlowInfo);
    }

    @NotNull
    private AnonymousFunctionDescriptor createFunctionDescriptor(@NotNull JetFunctionLiteralExpression expression, @NotNull ExpressionTypingContext context2, boolean functionTypeExpected) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createFunctionDescriptor"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createFunctionDescriptor"));
        }
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        JetTypeReference receiverTypeRef = functionLiteral.getReceiverTypeReference();
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(context2.scope.getContainingDeclaration(), Annotations.EMPTY, CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(functionLiteral));
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(context2, functionLiteral, functionDescriptor, functionTypeExpected);
        JetType effectiveReceiverType = receiverTypeRef == null ? (functionTypeExpected ? KotlinBuiltIns.getInstance().getReceiverType(context2.expectedType) : null) : this.components.expressionTypingServices.getTypeResolver().resolveType(context2.scope, receiverTypeRef, context2.trace, true);
        functionDescriptor.initialize(effectiveReceiverType, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Collections.emptyList(), (List)valueParameterDescriptors, (JetType)null, Modality.FINAL, Visibilities.LOCAL);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context2.trace, functionLiteral, functionDescriptor);
        AnonymousFunctionDescriptor anonymousFunctionDescriptor = functionDescriptor;
        if (anonymousFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createFunctionDescriptor"));
        }
        return anonymousFunctionDescriptor;
    }

    @NotNull
    private List<ValueParameterDescriptor> createValueParameterDescriptors(@NotNull ExpressionTypingContext context2, @NotNull JetFunctionLiteral functionLiteral, @NotNull FunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        boolean hasDeclaredValueParameters;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptors"));
        }
        if (functionLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteral", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptors"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptors"));
        }
        ArrayList<ValueParameterDescriptor> valueParameterDescriptors = Lists.newArrayList();
        List<JetParameter> declaredValueParameters = functionLiteral.getValueParameters();
        List<ValueParameterDescriptor> expectedValueParameters = functionTypeExpected ? KotlinBuiltIns.getInstance().getValueParameters(functionDescriptor, context2.expectedType) : null;
        JetParameterList valueParameterList = functionLiteral.getValueParameterList();
        boolean bl = hasDeclaredValueParameters = valueParameterList != null;
        if (functionTypeExpected && !hasDeclaredValueParameters && expectedValueParameters.size() == 1) {
            ValueParameterDescriptor valueParameterDescriptor = expectedValueParameters.get(0);
            ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(functionDescriptor, null, 0, Annotations.EMPTY, Name.identifier("it"), valueParameterDescriptor.getType(), valueParameterDescriptor.hasDefaultValue(), valueParameterDescriptor.getVarargElementType(), SourceElement.NO_SOURCE);
            valueParameterDescriptors.add(it);
            context2.trace.record(BindingContext.AUTO_CREATED_IT, it);
        } else {
            if (expectedValueParameters != null && declaredValueParameters.size() != expectedValueParameters.size()) {
                List<JetType> expectedParameterTypes = ExpressionTypingUtils.getValueParametersTypes(expectedValueParameters);
                context2.trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on(functionLiteral, expectedParameterTypes.size(), expectedParameterTypes));
            }
            for (int i = 0; i < declaredValueParameters.size(); ++i) {
                ValueParameterDescriptor valueParameterDescriptor = this.createValueParameterDescriptor(context2, functionDescriptor, declaredValueParameters, expectedValueParameters, i);
                valueParameterDescriptors.add(valueParameterDescriptor);
            }
        }
        ArrayList<ValueParameterDescriptor> arrayList = valueParameterDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    private ValueParameterDescriptor createValueParameterDescriptor(@NotNull ExpressionTypingContext context2, @NotNull FunctionDescriptorImpl functionDescriptor, @NotNull List<JetParameter> declaredValueParameters, @Nullable List<ValueParameterDescriptor> expectedValueParameters, int index2) {
        JetType type2;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptor"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptor"));
        }
        if (declaredValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaredValueParameters", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptor"));
        }
        JetParameter declaredParameter = declaredValueParameters.get(index2);
        JetTypeReference typeReference = declaredParameter.getTypeReference();
        JetType expectedType = expectedValueParameters != null && index2 < expectedValueParameters.size() ? expectedValueParameters.get(index2).getType() : null;
        if (typeReference != null) {
            type2 = this.components.expressionTypingServices.getTypeResolver().resolveType(context2.scope, typeReference, context2.trace, true);
            if (expectedType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(expectedType, type2)) {
                context2.trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on(declaredParameter, expectedType));
            }
        } else {
            boolean containsUninferredParameter = TypeUtils.containsSpecialType(expectedType, new Function1<JetType, Boolean>(){

                @Override
                public Boolean invoke(JetType type2) {
                    return TypeUtils.isDontCarePlaceholder(type2) || ErrorUtils.isUninferredParameter(type2);
                }
            });
            if (expectedType == null || containsUninferredParameter) {
                context2.trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on(declaredParameter));
            }
            type2 = expectedType != null ? expectedType : TypeUtils.CANT_INFER_LAMBDA_PARAM_TYPE;
        }
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = this.components.expressionTypingServices.getDescriptorResolver().resolveValueParameterDescriptorWithAnnotationArguments(context2.scope, functionDescriptor, declaredParameter, index2, type2, context2.trace);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private JetType computeReturnType(@NotNull JetFunctionLiteralExpression expression, @NotNull ExpressionTypingContext context2, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
        }
        JetType expectedReturnType = functionTypeExpected ? KotlinBuiltIns.getInstance().getReturnTypeFromFunctionType(context2.expectedType) : null;
        JetType returnType = this.computeUnsafeReturnType(expression, context2, functionDescriptor, expectedReturnType);
        if (!expression.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected && KotlinBuiltIns.getInstance().isUnit(expectedReturnType)) {
            JetType jetType = KotlinBuiltIns.getInstance().getUnitType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
            }
            return jetType;
        }
        JetType jetType = returnType == null ? TypeUtils.CANT_INFER_LAMBDA_PARAM_TYPE : returnType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
        }
        return jetType;
    }

    @Nullable
    private JetType computeUnsafeReturnType(@NotNull JetFunctionLiteralExpression expression, @NotNull ExpressionTypingContext context2, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @Nullable JetType expectedReturnType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeUnsafeReturnType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeUnsafeReturnType"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeUnsafeReturnType"));
        }
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        JetBlockExpression bodyExpression = functionLiteral.getBodyExpression();
        assert (bodyExpression != null);
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context2.scope, functionDescriptor, context2.trace);
        JetTypeReference returnTypeRef = functionLiteral.getTypeReference();
        JetType declaredReturnType = null;
        if (returnTypeRef != null) {
            declaredReturnType = this.components.expressionTypingServices.getTypeResolver().resolveType(context2.scope, returnTypeRef, context2.trace, true);
            functionDescriptor.setReturnType(declaredReturnType);
            if (expectedReturnType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(declaredReturnType, expectedReturnType)) {
                context2.trace.report(Errors.EXPECTED_RETURN_TYPE_MISMATCH.on(returnTypeRef, expectedReturnType));
            }
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(functionInnerScope)).replaceExpectedType(declaredReturnType != null ? declaredReturnType : (expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE));
        JetType typeOfBodyExpression = this.components.expressionTypingServices.getBlockReturnedType(bodyExpression, CoercionStrategy.COERCION_TO_UNIT, newContext).getType();
        ArrayList<JetType> returnedExpressionTypes = Lists.newArrayList(ClosureExpressionsTypingVisitor.getTypesOfLocallyReturnedExpressions(functionLiteral, context2.trace, ClosureExpressionsTypingVisitor.collectReturns(bodyExpression)));
        ContainerUtil.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
        if (declaredReturnType != null) {
            return declaredReturnType;
        }
        if (returnedExpressionTypes.isEmpty()) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    private static List<JetType> getTypesOfLocallyReturnedExpressions(final JetFunctionLiteral functionLiteral, final BindingTrace trace, Collection<JetReturnExpression> returnExpressions) {
        return ContainerUtil.mapNotNull(returnExpressions, new Function<JetReturnExpression, JetType>(){

            @Override
            public JetType fun(JetReturnExpression returnExpression) {
                JetSimpleNameExpression label = returnExpression.getTargetLabel();
                if (label == null) {
                    return null;
                }
                PsiElement labelTarget = trace.get(BindingContext.LABEL_TARGET, label);
                if (labelTarget != functionLiteral) {
                    return null;
                }
                JetExpression returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null) {
                    return KotlinBuiltIns.getInstance().getUnitType();
                }
                JetType returnedType = trace.get(BindingContext.EXPRESSION_TYPE, returnedExpression);
                assert (returnedType != null) : "No type for returned expression: " + returnedExpression + ",\n" + "the type should have been computed by getBlockReturnedType() above\n" + JetPsiUtil.getElementTextWithContext(returnedExpression);
                return returnedType;
            }
        });
    }

    public static Collection<JetReturnExpression> collectReturns(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "collectReturns"));
        }
        ArrayList<JetReturnExpression> result2 = Lists.newArrayList();
        expression.accept(new JetTreeVisitor<Collection<JetReturnExpression>>(){

            @Override
            public Void visitReturnExpression(@NotNull JetReturnExpression expression, Collection<JetReturnExpression> data2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor$4", "visitReturnExpression"));
                }
                data2.add(expression);
                return null;
            }
        }, result2);
        return result2;
    }
}

